/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.ExploringCompactionPolicy;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class FIFOCompactionPolicy
extends ExploringCompactionPolicy {
    private static final Log LOG = LogFactory.getLog(FIFOCompactionPolicy.class);

    public FIFOCompactionPolicy(Configuration conf, StoreConfigInformation storeConfigInfo) {
        super(conf, storeConfigInfo);
    }

    @Override
    public CompactionRequest selectCompaction(Collection<StoreFile> candidateFiles, List<StoreFile> filesCompacting, boolean isUserCompaction, boolean mayUseOffPeak, boolean forceMajor) throws IOException {
        boolean isAfterSplit;
        if (forceMajor) {
            LOG.warn((Object)"Major compaction is not supported for FIFO compaction policy. Ignore the flag.");
        }
        if (isAfterSplit = StoreUtils.hasReferences(candidateFiles)) {
            LOG.info((Object)"Split detected, delegate selection to the parent policy.");
            return super.selectCompaction(candidateFiles, filesCompacting, isUserCompaction, mayUseOffPeak, forceMajor);
        }
        Collection<StoreFile> toCompact = this.getExpiredStores(candidateFiles, filesCompacting);
        CompactionRequest result = new CompactionRequest(toCompact);
        return result;
    }

    @Override
    public boolean isMajorCompaction(Collection<StoreFile> filesToCompact) throws IOException {
        boolean isAfterSplit = StoreUtils.hasReferences(filesToCompact);
        if (isAfterSplit) {
            LOG.info((Object)"Split detected, delegate to the parent policy.");
            return super.isMajorCompaction(filesToCompact);
        }
        return false;
    }

    @Override
    public boolean needsCompaction(Collection<StoreFile> storeFiles, List<StoreFile> filesCompacting) {
        boolean isAfterSplit = StoreUtils.hasReferences(storeFiles);
        if (isAfterSplit) {
            LOG.info((Object)"Split detected, delegate to the parent policy.");
            return super.needsCompaction(storeFiles, filesCompacting);
        }
        return this.hasExpiredStores(storeFiles);
    }

    private boolean hasExpiredStores(Collection<StoreFile> files) {
        long currentTime = EnvironmentEdgeManager.currentTimeMillis();
        for (StoreFile sf : files) {
            Long maxTs = sf.getReader().getMaxTimestamp();
            long maxTtl = this.storeConfigInfo.getStoreFileTtl();
            if (maxTs == null || maxTtl == Long.MAX_VALUE || currentTime - maxTtl < maxTs) continue;
            return true;
        }
        return false;
    }

    private Collection<StoreFile> getExpiredStores(Collection<StoreFile> files, Collection<StoreFile> filesCompacting) {
        long currentTime = EnvironmentEdgeManager.currentTimeMillis();
        ArrayList<StoreFile> expiredStores = new ArrayList<StoreFile>();
        for (StoreFile sf : files) {
            Long maxTs = sf.getReader().getMaxTimestamp();
            long maxTtl = this.storeConfigInfo.getStoreFileTtl();
            if (maxTs == null || maxTtl == Long.MAX_VALUE || currentTime - maxTtl < maxTs || filesCompacting != null && filesCompacting.contains(sf)) continue;
            expiredStores.add(sf);
        }
        return expiredStores;
    }
}

