/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ZKServerTool {
    public static ServerName[] readZKNodes(Configuration conf) {
        LinkedList<ServerName> hosts = new LinkedList<ServerName>();
        Properties zkProps = ZKConfig.makeZKProps((Configuration)conf);
        for (Map.Entry<Object, Object> entry : zkProps.entrySet()) {
            String key = entry.getKey().toString().trim();
            String value = entry.getValue().toString().trim();
            if (!key.startsWith("server.")) continue;
            String[] parts = value.split(":");
            String host = parts[0];
            int port = 2181;
            if (parts.length > 1) {
                port = Integer.parseInt(parts[1]);
            }
            hosts.add(ServerName.valueOf((String)host, (int)port, (long)-1L));
        }
        return hosts.toArray(new ServerName[hosts.size()]);
    }

    public static void main(String[] args) {
        for (ServerName server : ZKServerTool.readZKNodes(HBaseConfiguration.create())) {
            System.out.println("ZK host: " + server.getHostname());
        }
    }
}

