/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.DefaultStoreEngine;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFlushContext;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestStore {
    public static final Log LOG = LogFactory.getLog(TestStore.class);
    @Rule
    public TestName name = new TestName();
    HStore store;
    byte[] table = Bytes.toBytes((String)"table");
    byte[] family = Bytes.toBytes((String)"family");
    byte[] row = Bytes.toBytes((String)"row");
    byte[] row2 = Bytes.toBytes((String)"row2");
    byte[] qf1 = Bytes.toBytes((String)"qf1");
    byte[] qf2 = Bytes.toBytes((String)"qf2");
    byte[] qf3 = Bytes.toBytes((String)"qf3");
    byte[] qf4 = Bytes.toBytes((String)"qf4");
    byte[] qf5 = Bytes.toBytes((String)"qf5");
    byte[] qf6 = Bytes.toBytes((String)"qf6");
    NavigableSet<byte[]> qualifiers = new ConcurrentSkipListSet<byte[]>(Bytes.BYTES_COMPARATOR);
    List<Cell> expected = new ArrayList<Cell>();
    List<Cell> result = new ArrayList<Cell>();
    long id = System.currentTimeMillis();
    Get get = new Get(this.row);
    private HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final String DIR = this.TEST_UTIL.getDataTestDir("TestStore").toString();
    private static final int BLOCKSIZE_SMALL = 8192;

    @Before
    public void setUp() throws IOException {
        this.qualifiers.add(this.qf1);
        this.qualifiers.add(this.qf3);
        this.qualifiers.add(this.qf5);
        for (byte[] next : this.qualifiers) {
            this.expected.add((Cell)new KeyValue(this.row, this.family, next, 1L, (byte[])null));
            this.get.addColumn(this.family, next);
        }
    }

    private void init(String methodName) throws IOException {
        this.init(methodName, HBaseConfiguration.create());
    }

    private void init(String methodName, Configuration conf) throws IOException {
        HColumnDescriptor hcd = new HColumnDescriptor(this.family);
        hcd.setMaxVersions(4);
        this.init(methodName, conf, hcd);
    }

    private void init(String methodName, Configuration conf, HColumnDescriptor hcd) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])this.table));
        this.init(methodName, conf, htd, hcd);
    }

    private Store init(String methodName, Configuration conf, HTableDescriptor htd, HColumnDescriptor hcd) throws IOException {
        Path basedir = new Path(this.DIR + methodName);
        Path tableDir = FSUtils.getTableDir((Path)basedir, (TableName)htd.getTableName());
        String logName = "logs";
        Path logdir = new Path(basedir, logName);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(logdir, true);
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        HLog hlog = HLogFactory.createHLog((FileSystem)fs, (Path)basedir, (String)logName, (Configuration)conf);
        HRegion region = new HRegion(tableDir, hlog, fs, conf, info, htd, null);
        this.store = new HStore(region, hcd, conf);
        return this.store;
    }

    @Test
    public void testFlushSizeAccounting() throws Exception {
        LOG.info((Object)("Setting up a faulty file system that cannot write in " + this.name.getMethodName()));
        final Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.hstore.flush.retries.number", 1);
        User user = User.createUserForTesting((Configuration)conf, (String)this.name.getMethodName(), (String[])new String[]{"foo"});
        conf.setClass("fs.file.impl", FaultyFileSystem.class, FileSystem.class);
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                FileSystem fs = FileSystem.get((Configuration)conf);
                Assert.assertEquals(FaultyFileSystem.class, fs.getClass());
                FaultyFileSystem ffs = (FaultyFileSystem)fs;
                TestStore.this.init(TestStore.this.name.getMethodName(), conf);
                long size = TestStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((long)0L, (long)size);
                LOG.info((Object)"Adding some data");
                long kvSize = TestStore.this.store.add(new KeyValue(TestStore.this.row, TestStore.this.family, TestStore.this.qf1, 1L, (byte[])null));
                size = TestStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((long)kvSize, (long)size);
                try {
                    LOG.info((Object)"Flushing");
                    TestStore.flushStore(TestStore.this.store, TestStore.this.id++);
                    Assert.fail((String)"Didn't bubble up IOE!");
                }
                catch (IOException ioe) {
                    Assert.assertTrue((boolean)ioe.getMessage().contains("Fault injected"));
                }
                size = TestStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((long)kvSize, (long)size);
                TestStore.this.store.add(new KeyValue(TestStore.this.row, TestStore.this.family, TestStore.this.qf2, 2L, (byte[])null));
                Assert.assertEquals((long)kvSize, (long)size);
                ffs.fault.set(false);
                TestStore.flushStore(TestStore.this.store, TestStore.this.id++);
                size = TestStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((long)kvSize, (long)size);
                TestStore.flushStore(TestStore.this.store, TestStore.this.id++);
                size = TestStore.this.store.memstore.getFlushableSize();
                Assert.assertEquals((long)0L, (long)size);
                return null;
            }
        });
    }

    @Test
    public void testCreateWriter() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)conf);
        HColumnDescriptor hcd = new HColumnDescriptor(this.family);
        hcd.setCompressionType(Compression.Algorithm.GZ);
        hcd.setDataBlockEncoding(DataBlockEncoding.DIFF);
        this.init(this.name.getMethodName(), conf, hcd);
        StoreFile.Writer writer = this.store.createWriterInTmp(4L, hcd.getCompression(), false, true, false);
        Path path = writer.getPath();
        writer.append(new KeyValue(this.row, this.family, this.qf1, Bytes.toBytes((int)1)));
        writer.append(new KeyValue(this.row, this.family, this.qf2, Bytes.toBytes((int)2)));
        writer.append(new KeyValue(this.row2, this.family, this.qf1, Bytes.toBytes((int)3)));
        writer.append(new KeyValue(this.row2, this.family, this.qf2, Bytes.toBytes((int)4)));
        writer.close();
        HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)path, (CacheConfig)new CacheConfig(conf), (Configuration)conf);
        Assert.assertEquals((Object)hcd.getCompressionType(), (Object)reader.getCompressionAlgorithm());
        Assert.assertEquals((Object)hcd.getDataBlockEncoding(), (Object)reader.getDataBlockEncoding());
        reader.close();
    }

    @Test
    public void testDeleteExpiredStoreFiles() throws Exception {
        int i;
        int storeFileNum = 4;
        int ttl = 4;
        IncrementingEnvironmentEdge edge = new IncrementingEnvironmentEdge();
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)edge);
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.store.delete.expired.storefile", true);
        HColumnDescriptor hcd = new HColumnDescriptor(this.family);
        hcd.setTimeToLive(ttl);
        this.init(this.name.getMethodName(), conf, hcd);
        long sleepTime = this.store.getScanInfo().getTtl() / (long)storeFileNum;
        for (i = 1; i <= storeFileNum; ++i) {
            LOG.info((Object)("Adding some data for the store file #" + i));
            long timeStamp = EnvironmentEdgeManager.currentTimeMillis();
            this.store.add(new KeyValue(this.row, this.family, this.qf1, timeStamp, (byte[])null));
            this.store.add(new KeyValue(this.row, this.family, this.qf2, timeStamp, (byte[])null));
            this.store.add(new KeyValue(this.row, this.family, this.qf3, timeStamp, (byte[])null));
            this.flush(i);
            edge.incrementTime(sleepTime);
        }
        Assert.assertEquals((long)storeFileNum, (long)this.store.getStorefiles().size());
        for (i = 1; i <= storeFileNum; ++i) {
            CompactionContext compaction = this.store.requestCompaction();
            CompactionRequest cr = compaction.getRequest();
            ArrayList files = new ArrayList(cr.getFiles());
            Assert.assertEquals((long)Math.min(i, 2), (long)cr.getFiles().size());
            for (int j = 0; j < files.size(); ++j) {
                Assert.assertTrue((((StoreFile)files.get(j)).getReader().getMaxTimestamp() < edge.currentTimeMillis() - this.store.getScanInfo().getTtl() ? 1 : 0) != 0);
            }
            StoreFile compactedFile = (StoreFile)this.store.compact(compaction).get(0);
            Assert.assertEquals((long)0L, (long)compactedFile.getReader().getEntries());
            edge.incrementTime(sleepTime);
        }
    }

    @Test
    public void testLowestModificationTime() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)conf);
        this.init(this.name.getMethodName(), conf);
        int storeFileNum = 4;
        for (int i = 1; i <= storeFileNum; ++i) {
            LOG.info((Object)("Adding some data for the store file #" + i));
            this.store.add(new KeyValue(this.row, this.family, this.qf1, (long)i, (byte[])null));
            this.store.add(new KeyValue(this.row, this.family, this.qf2, (long)i, (byte[])null));
            this.store.add(new KeyValue(this.row, this.family, this.qf3, (long)i, (byte[])null));
            this.flush(i);
        }
        long lowestTimeStampFromManager = StoreUtils.getLowestTimestamp((Collection)this.store.getStorefiles());
        long lowestTimeStampFromFS = TestStore.getLowestTimeStampFromFS(fs, this.store.getStorefiles());
        Assert.assertEquals((long)lowestTimeStampFromManager, (long)lowestTimeStampFromFS);
        this.store.compact(this.store.requestCompaction());
        lowestTimeStampFromManager = StoreUtils.getLowestTimestamp((Collection)this.store.getStorefiles());
        lowestTimeStampFromFS = TestStore.getLowestTimeStampFromFS(fs, this.store.getStorefiles());
        Assert.assertEquals((long)lowestTimeStampFromManager, (long)lowestTimeStampFromFS);
    }

    private static long getLowestTimeStampFromFS(FileSystem fs, Collection<StoreFile> candidates) throws IOException {
        long minTs = Long.MAX_VALUE;
        if (candidates.isEmpty()) {
            return minTs;
        }
        Path[] p = new Path[candidates.size()];
        int i = 0;
        for (StoreFile sf : candidates) {
            p[i] = sf.getPath();
            ++i;
        }
        FileStatus[] stats = fs.listStatus(p);
        if (stats == null || stats.length == 0) {
            return minTs;
        }
        for (FileStatus s : stats) {
            minTs = Math.min(minTs, s.getModificationTime());
        }
        return minTs;
    }

    @Test
    public void testEmptyStoreFile() throws IOException {
        this.init(this.name.getMethodName());
        this.store.add(new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null));
        this.flush(1);
        StoreFile f = (StoreFile)this.store.getStorefiles().iterator().next();
        Path storedir = f.getPath().getParent();
        long seqid = f.getMaxSequenceId();
        Configuration c = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)c);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFile.Writer w = new StoreFile.WriterBuilder(c, new CacheConfig(c), fs).withOutputDir(storedir).withFileContext(meta).build();
        w.appendMetadata(seqid + 1L, false);
        w.close();
        this.store.close();
        this.store = new HStore(this.store.getHRegion(), this.store.getFamily(), c);
        Assert.assertEquals((long)2L, (long)this.store.getStorefilesCount());
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        Assert.assertEquals((long)1L, (long)this.result.size());
    }

    @Test
    public void testGet_FromMemStoreOnly() throws IOException {
        this.init(this.name.getMethodName());
        this.store.add(new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf3, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf4, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf5, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf6, 1L, (byte[])null));
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        this.assertCheck();
    }

    @Test
    public void testGet_FromFilesOnly() throws IOException {
        this.init(this.name.getMethodName());
        this.store.add(new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null));
        this.flush(1);
        this.store.add(new KeyValue(this.row, this.family, this.qf3, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf4, 1L, (byte[])null));
        this.flush(2);
        this.store.add(new KeyValue(this.row, this.family, this.qf5, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf6, 1L, (byte[])null));
        this.flush(3);
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        Collections.sort(this.result, KeyValue.COMPARATOR);
        this.assertCheck();
    }

    @Test
    public void testGet_FromMemStoreAndFiles() throws IOException {
        this.init(this.name.getMethodName());
        this.store.add(new KeyValue(this.row, this.family, this.qf1, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf2, 1L, (byte[])null));
        this.flush(1);
        this.store.add(new KeyValue(this.row, this.family, this.qf3, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf4, 1L, (byte[])null));
        this.flush(2);
        this.store.add(new KeyValue(this.row, this.family, this.qf5, 1L, (byte[])null));
        this.store.add(new KeyValue(this.row, this.family, this.qf6, 1L, (byte[])null));
        this.result = HBaseTestingUtility.getFromStoreFile(this.store, this.get.getRow(), this.qualifiers);
        Collections.sort(this.result, KeyValue.COMPARATOR);
        this.assertCheck();
    }

    private void flush(int storeFilessize) throws IOException {
        this.store.snapshot();
        TestStore.flushStore(this.store, this.id++);
        Assert.assertEquals((long)storeFilessize, (long)this.store.getStorefiles().size());
        Assert.assertEquals((long)0L, (long)this.store.memstore.kvset.size());
    }

    private void assertCheck() {
        Assert.assertEquals((long)this.expected.size(), (long)this.result.size());
        for (int i = 0; i < this.expected.size(); ++i) {
            Assert.assertEquals((Object)this.expected.get(i), (Object)this.result.get(i));
        }
    }

    @Test
    public void testIncrementColumnValue_ICVDuringFlush() throws IOException, InterruptedException {
        this.init(this.name.getMethodName());
        long oldValue = 1L;
        long newValue = 3L;
        this.store.add(new KeyValue(this.row, this.family, this.qf1, System.currentTimeMillis(), Bytes.toBytes((long)oldValue)));
        this.store.snapshot();
        this.store.add(new KeyValue(this.row, this.family, this.qf2, System.currentTimeMillis(), Bytes.toBytes((long)oldValue)));
        long ret = this.store.updateColumnValue(this.row, this.family, this.qf1, newValue);
        Assert.assertTrue((ret > 0L ? 1 : 0) != 0);
        TestStore.flushStore(this.store, this.id++);
        Assert.assertEquals((long)1L, (long)this.store.getStorefiles().size());
        Assert.assertEquals((long)2L, (long)this.store.memstore.kvset.size());
        Get get = new Get(this.row);
        get.addColumn(this.family, this.qf1);
        get.setMaxVersions();
        List<Object> results = new ArrayList();
        results = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertEquals((long)2L, (long)results.size());
        long ts1 = ((Cell)results.get(0)).getTimestamp();
        long ts2 = ((Cell)results.get(1)).getTimestamp();
        Assert.assertTrue((ts1 > ts2 ? 1 : 0) != 0);
        Assert.assertEquals((long)newValue, (long)Bytes.toLong((byte[])CellUtil.cloneValue((Cell)((Cell)results.get(0)))));
        Assert.assertEquals((long)oldValue, (long)Bytes.toLong((byte[])CellUtil.cloneValue((Cell)((Cell)results.get(1)))));
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentEdgeManagerTestHelper.reset();
    }

    @Test
    public void testICV_negMemstoreSize() throws IOException {
        this.init(this.name.getMethodName());
        long time = 100L;
        ManualEnvironmentEdge ee = new ManualEnvironmentEdge();
        ee.setValue(time);
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)ee);
        long newValue = 3L;
        long size = 0L;
        size += this.store.add(new KeyValue(Bytes.toBytes((String)"200909091000"), this.family, this.qf1, System.currentTimeMillis(), Bytes.toBytes((long)newValue)));
        size += this.store.add(new KeyValue(Bytes.toBytes((String)"200909091200"), this.family, this.qf1, System.currentTimeMillis(), Bytes.toBytes((long)newValue)));
        size += this.store.add(new KeyValue(Bytes.toBytes((String)"200909091300"), this.family, this.qf1, System.currentTimeMillis(), Bytes.toBytes((long)newValue)));
        size += this.store.add(new KeyValue(Bytes.toBytes((String)"200909091400"), this.family, this.qf1, System.currentTimeMillis(), Bytes.toBytes((long)newValue)));
        size += this.store.add(new KeyValue(Bytes.toBytes((String)"200909091500"), this.family, this.qf1, System.currentTimeMillis(), Bytes.toBytes((long)newValue)));
        for (int i = 0; i < 10000; ++i) {
            long ret = this.store.updateColumnValue(this.row, this.family, this.qf1, ++newValue);
            long ret2 = this.store.updateColumnValue(this.row2, this.family, this.qf1, newValue);
            if (ret != 0L) {
                System.out.println("ret: " + ret);
            }
            if (ret2 != 0L) {
                System.out.println("ret2: " + ret2);
            }
            Assert.assertTrue((String)("ret: " + ret), (ret >= 0L ? 1 : 0) != 0);
            size += ret;
            Assert.assertTrue((String)("ret2: " + ret2), (ret2 >= 0L ? 1 : 0) != 0);
            size += ret2;
            if (i % 1000 != 0) continue;
            ee.setValue(++time);
        }
        long computedSize = 0L;
        for (KeyValue kv : this.store.memstore.kvset) {
            long kvsize = MemStore.heapSizeChange((KeyValue)kv, (boolean)true);
            computedSize += kvsize;
        }
        Assert.assertEquals((long)computedSize, (long)size);
    }

    @Test
    public void testIncrementColumnValue_SnapshotFlushCombo() throws Exception {
        ManualEnvironmentEdge mee = new ManualEnvironmentEdge();
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)mee);
        this.init(this.name.getMethodName());
        long oldValue = 1L;
        long newValue = 3L;
        this.store.add(new KeyValue(this.row, this.family, this.qf1, EnvironmentEdgeManager.currentTimeMillis(), Bytes.toBytes((long)oldValue)));
        this.store.snapshot();
        long ret = this.store.updateColumnValue(this.row, this.family, this.qf1, newValue);
        Assert.assertTrue((ret > 0L ? 1 : 0) != 0);
        TestStore.flushStore(this.store, this.id++);
        Assert.assertEquals((long)1L, (long)this.store.getStorefiles().size());
        Assert.assertEquals((long)1L, (long)this.store.memstore.kvset.size());
        this.store.updateColumnValue(this.row, this.family, this.qf1, ++newValue);
        this.store.updateColumnValue(this.row, this.family, this.qf1, ++newValue);
        Get get = new Get(this.row);
        get.addColumn(this.family, this.qf1);
        get.setMaxVersions();
        List<Object> results = new ArrayList();
        results = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertEquals((long)2L, (long)results.size());
        long ts1 = ((Cell)results.get(0)).getTimestamp();
        long ts2 = ((Cell)results.get(1)).getTimestamp();
        Assert.assertTrue((ts1 > ts2 ? 1 : 0) != 0);
        Assert.assertEquals((long)newValue, (long)Bytes.toLong((byte[])CellUtil.cloneValue((Cell)((Cell)results.get(0)))));
        Assert.assertEquals((long)oldValue, (long)Bytes.toLong((byte[])CellUtil.cloneValue((Cell)((Cell)results.get(1)))));
        mee.setValue(2L);
        this.store.updateColumnValue(this.row, this.family, this.qf1, ++newValue);
        results = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertEquals((long)2L, (long)results.size());
        ts1 = ((Cell)results.get(0)).getTimestamp();
        ts2 = ((Cell)results.get(1)).getTimestamp();
        Assert.assertTrue((ts1 > ts2 ? 1 : 0) != 0);
        Assert.assertEquals((long)newValue, (long)Bytes.toLong((byte[])CellUtil.cloneValue((Cell)((Cell)results.get(0)))));
        Assert.assertEquals((long)oldValue, (long)Bytes.toLong((byte[])CellUtil.cloneValue((Cell)((Cell)results.get(1)))));
    }

    @Test
    public void testHandleErrorsInFlush() throws Exception {
        LOG.info((Object)"Setting up a faulty file system that cannot write");
        final Configuration conf = HBaseConfiguration.create();
        User user = User.createUserForTesting((Configuration)conf, (String)"testhandleerrorsinflush", (String[])new String[]{"foo"});
        conf.setClass("fs.file.impl", FaultyFileSystem.class, FileSystem.class);
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                FileSystem fs = FileSystem.get((Configuration)conf);
                Assert.assertEquals(FaultyFileSystem.class, fs.getClass());
                TestStore.this.init(TestStore.this.name.getMethodName(), conf);
                LOG.info((Object)"Adding some data");
                TestStore.this.store.add(new KeyValue(TestStore.this.row, TestStore.this.family, TestStore.this.qf1, 1L, (byte[])null));
                TestStore.this.store.add(new KeyValue(TestStore.this.row, TestStore.this.family, TestStore.this.qf2, 1L, (byte[])null));
                TestStore.this.store.add(new KeyValue(TestStore.this.row, TestStore.this.family, TestStore.this.qf3, 1L, (byte[])null));
                LOG.info((Object)"Before flush, we should have no files");
                Collection files = TestStore.this.store.getRegionFileSystem().getStoreFiles(TestStore.this.store.getColumnFamilyName());
                Assert.assertEquals((long)0L, (long)(files != null ? (long)files.size() : 0L));
                try {
                    LOG.info((Object)"Flushing");
                    TestStore.this.flush(1);
                    Assert.fail((String)"Didn't bubble up IOE!");
                }
                catch (IOException ioe) {
                    Assert.assertTrue((boolean)ioe.getMessage().contains("Fault injected"));
                }
                LOG.info((Object)"After failed flush, we should still have no files!");
                files = TestStore.this.store.getRegionFileSystem().getStoreFiles(TestStore.this.store.getColumnFamilyName());
                Assert.assertEquals((long)0L, (long)(files != null ? (long)files.size() : 0L));
                TestStore.this.store.getHRegion().getLog().closeAndDelete();
                return null;
            }
        });
        FileSystem.closeAllForUGI((UserGroupInformation)user.getUGI());
    }

    private static void flushStore(HStore store, long id) throws IOException {
        StoreFlushContext storeFlushCtx = store.createFlushContext(id);
        storeFlushCtx.prepare();
        storeFlushCtx.flushCache((MonitoredTask)Mockito.mock(MonitoredTask.class));
        storeFlushCtx.commit((MonitoredTask)Mockito.mock(MonitoredTask.class));
    }

    List<Cell> getKeyValueSet(long[] timestamps, int numRows, byte[] qualifier, byte[] family) {
        ArrayList<Cell> kvList = new ArrayList<Cell>();
        for (int i = 1; i <= numRows; ++i) {
            byte[] b = Bytes.toBytes((int)i);
            for (long timestamp : timestamps) {
                kvList.add((Cell)new KeyValue(b, family, qualifier, timestamp, b));
            }
        }
        return kvList;
    }

    @Test
    public void testMultipleTimestamps() throws IOException {
        int numRows = 1;
        long[] timestamps1 = new long[]{1L, 5L, 10L, 20L};
        long[] timestamps2 = new long[]{30L, 80L};
        this.init(this.name.getMethodName());
        List<Cell> kvList1 = this.getKeyValueSet(timestamps1, numRows, this.qf1, this.family);
        for (Cell kv : kvList1) {
            this.store.add(KeyValueUtil.ensureKeyValue((Cell)kv));
        }
        this.store.snapshot();
        TestStore.flushStore(this.store, this.id++);
        List<Cell> kvList2 = this.getKeyValueSet(timestamps2, numRows, this.qf1, this.family);
        for (Cell kv : kvList2) {
            this.store.add(KeyValueUtil.ensureKeyValue((Cell)kv));
        }
        Get get = new Get(Bytes.toBytes((int)1));
        get.addColumn(this.family, this.qf1);
        get.setTimeRange(0L, 15L);
        List<Cell> result = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(40L, 90L);
        result = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(10L, 45L);
        result = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(80L, 145L);
        result = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(1L, 2L);
        result = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        get.setTimeRange(90L, 200L);
        result = HBaseTestingUtility.getFromStoreFile(this.store, get);
        Assert.assertTrue((result.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSplitWithEmptyColFam() throws IOException {
        this.init(this.name.getMethodName());
        Assert.assertNull((Object)this.store.getSplitPoint());
        this.store.getHRegion().forceSplit(null);
        Assert.assertNull((Object)this.store.getSplitPoint());
        this.store.getHRegion().clearSplit_TESTS_ONLY();
    }

    @Test
    public void testStoreUsesConfigurationFromHcdAndHtd() throws Exception {
        String CONFIG_KEY = "hbase.regionserver.thread.compaction.throttle";
        long anyValue = 10L;
        Configuration conf = HBaseConfiguration.create();
        conf.setLong("hbase.regionserver.thread.compaction.throttle", anyValue);
        this.init(this.name.getMethodName() + "-xml", conf);
        Assert.assertTrue((boolean)this.store.throttleCompaction(anyValue + 1L));
        Assert.assertFalse((boolean)this.store.throttleCompaction(anyValue));
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])this.table));
        HColumnDescriptor hcd = new HColumnDescriptor(this.family);
        htd.setConfiguration("hbase.regionserver.thread.compaction.throttle", Long.toString(--anyValue));
        this.init(this.name.getMethodName() + "-htd", conf, htd, hcd);
        Assert.assertTrue((boolean)this.store.throttleCompaction(anyValue + 1L));
        Assert.assertFalse((boolean)this.store.throttleCompaction(anyValue));
        hcd.setConfiguration("hbase.regionserver.thread.compaction.throttle", Long.toString(--anyValue));
        this.init(this.name.getMethodName() + "-hcd", conf, htd, hcd);
        Assert.assertTrue((boolean)this.store.throttleCompaction(anyValue + 1L));
        Assert.assertFalse((boolean)this.store.throttleCompaction(anyValue));
    }

    @Test
    public void testStoreUsesSearchEngineOverride() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.hstore.engine.class", DummyStoreEngine.class.getName());
        this.init(this.name.getMethodName(), conf);
        Assert.assertEquals((Object)DummyStoreEngine.lastCreatedCompactor, (Object)this.store.storeEngine.getCompactor());
    }

    public static class DummyStoreEngine
    extends DefaultStoreEngine {
        public static DefaultCompactor lastCreatedCompactor = null;

        protected void createComponents(Configuration conf, Store store, KeyValue.KVComparator comparator) throws IOException {
            super.createComponents(conf, store, comparator);
            lastCreatedCompactor = (DefaultCompactor)this.compactor;
        }
    }

    static class FaultyOutputStream
    extends FSDataOutputStream {
        volatile long faultPos = Long.MAX_VALUE;
        private final AtomicBoolean fault;

        public FaultyOutputStream(FSDataOutputStream out, long faultPos, AtomicBoolean fault) throws IOException {
            super((OutputStream)out, null);
            this.faultPos = faultPos;
            this.fault = fault;
        }

        public void write(byte[] buf, int offset, int length) throws IOException {
            System.err.println("faulty stream write at pos " + this.getPos());
            this.injectFault();
            super.write(buf, offset, length);
        }

        private void injectFault() throws IOException {
            if (this.fault.get() && this.getPos() >= this.faultPos) {
                throw new IOException("Fault injected");
            }
        }
    }

    static class FaultyFileSystem
    extends FilterFileSystem {
        List<SoftReference<FaultyOutputStream>> outStreams = new ArrayList<SoftReference<FaultyOutputStream>>();
        private long faultPos = 200L;
        AtomicBoolean fault = new AtomicBoolean(true);

        public FaultyFileSystem() {
            super((FileSystem)new LocalFileSystem());
            System.err.println("Creating faulty!");
        }

        public FSDataOutputStream create(Path p) throws IOException {
            return new FaultyOutputStream(super.create(p), this.faultPos, this.fault);
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return new FaultyOutputStream(super.create(f, permission, overwrite, bufferSize, replication, blockSize, progress), this.faultPos, this.fault);
        }

        public FSDataOutputStream createNonRecursive(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return this.create(f, overwrite, bufferSize, replication, blockSize, progress);
        }
    }
}

