/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionConfiguration;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.compactions.ConstantSizeFileListGenerator;
import org.apache.hadoop.hbase.regionserver.compactions.EverythingPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.ExplicitFileListGenerator;
import org.apache.hadoop.hbase.regionserver.compactions.ExploringCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.GaussianFileListGenerator;
import org.apache.hadoop.hbase.regionserver.compactions.MockStoreFileGenerator;
import org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.SemiConstantSizeFileListGenerator;
import org.apache.hadoop.hbase.regionserver.compactions.SinusoidalFileListGenerator;
import org.apache.hadoop.hbase.regionserver.compactions.SpikyFileListGenerator;
import org.apache.hadoop.hbase.regionserver.compactions.StoreFileListGenerator;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
@RunWith(value=Parameterized.class)
public class PerfTestCompactionPolicies
extends MockStoreFileGenerator {
    private static final Log LOG = LogFactory.getLog(PerfTestCompactionPolicies.class);
    private final RatioBasedCompactionPolicy cp;
    private final StoreFileListGenerator generator;
    private final HStore store;
    private Class<? extends StoreFileListGenerator> fileGenClass;
    private final int max;
    private final int min;
    private final float ratio;
    private long written = 0L;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Class[] policyClasses = new Class[]{EverythingPolicy.class, RatioBasedCompactionPolicy.class, ExploringCompactionPolicy.class};
        Class[] fileListGenClasses = new Class[]{ExplicitFileListGenerator.class, ConstantSizeFileListGenerator.class, SemiConstantSizeFileListGenerator.class, GaussianFileListGenerator.class, SinusoidalFileListGenerator.class, SpikyFileListGenerator.class};
        int[] maxFileValues = new int[]{10};
        int[] minFilesValues = new int[]{3};
        float[] ratioValues = new float[]{1.2f};
        ArrayList<Object[]> params = new ArrayList<Object[]>(maxFileValues.length * minFilesValues.length * fileListGenClasses.length * policyClasses.length);
        for (Class policyClass : policyClasses) {
            for (Class genClass : fileListGenClasses) {
                for (int maxFile : maxFileValues) {
                    for (int minFile : minFilesValues) {
                        for (float ratio : ratioValues) {
                            params.add(new Object[]{policyClass, genClass, maxFile, minFile, Float.valueOf(ratio)});
                        }
                    }
                }
            }
        }
        return params;
    }

    public PerfTestCompactionPolicies(Class<? extends CompactionPolicy> cpClass, Class<? extends StoreFileListGenerator> fileGenClass, int inMmax, int inMin, float inRatio) throws IllegalAccessException, InstantiationException {
        super(PerfTestCompactionPolicies.class);
        this.fileGenClass = fileGenClass;
        this.max = inMmax;
        this.min = inMin;
        this.ratio = inRatio;
        Logger.getLogger(CompactionConfiguration.class).setLevel(Level.ERROR);
        Logger.getLogger(RatioBasedCompactionPolicy.class).setLevel(Level.ERROR);
        Logger.getLogger(cpClass).setLevel(Level.ERROR);
        Configuration configuration = HBaseConfiguration.create();
        configuration.setInt("hbase.hstore.compaction.max", this.max);
        configuration.setInt("hbase.hstore.compaction.min", this.min);
        configuration.setFloat("hbase.hstore.compaction.ratio", this.ratio);
        this.store = this.createMockStore();
        this.cp = (RatioBasedCompactionPolicy)ReflectionUtils.instantiateWithCustomCtor((String)cpClass.getName(), (Class[])new Class[]{Configuration.class, StoreConfigInformation.class}, (Object[])new Object[]{configuration, this.store});
        this.generator = fileGenClass.newInstance();
    }

    @Test
    public final void testSelection() throws Exception {
        long fileDiff = 0L;
        for (List storeFileList : this.generator) {
            List<StoreFile> currentFiles = new ArrayList<StoreFile>(18);
            for (StoreFile file : storeFileList) {
                currentFiles.add(file);
                currentFiles = this.runIteration(currentFiles);
            }
            fileDiff += (long)(storeFileList.size() - currentFiles.size());
        }
        System.out.println(this.cp.getClass().getSimpleName() + "\t" + this.fileGenClass.getSimpleName() + "\t" + this.max + "\t" + this.min + "\t" + this.ratio + "\t" + this.written + "\t" + fileDiff);
    }

    private List<StoreFile> runIteration(List<StoreFile> startingStoreFiles) throws IOException {
        ArrayList<StoreFile> storeFiles = new ArrayList<StoreFile>(startingStoreFiles);
        CompactionRequest req = this.cp.selectCompaction(storeFiles, new ArrayList(), false, false, false);
        long newFileSize = 0L;
        Collection filesToCompact = req.getFiles();
        if (!filesToCompact.isEmpty()) {
            storeFiles = new ArrayList<StoreFile>(storeFiles);
            storeFiles.removeAll(filesToCompact);
            for (StoreFile storeFile : filesToCompact) {
                newFileSize += storeFile.getReader().length();
            }
            storeFiles.add(this.createMockStoreFileBytes(newFileSize));
        }
        this.written += newFileSize;
        return storeFiles;
    }

    private HStore createMockStore() {
        HStore s = (HStore)Mockito.mock(HStore.class);
        Mockito.when((Object)s.getStoreFileTtl()).thenReturn((Object)Long.MAX_VALUE);
        Mockito.when((Object)s.getBlockingFileCount()).thenReturn((Object)7L);
        return s;
    }
}

