/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.handler.CloseRegionHandler;
import org.apache.hadoop.hbase.regionserver.handler.OpenRegionHandler;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MockServer;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestCloseRegionHandler {
    static final Log LOG = LogFactory.getLog(TestCloseRegionHandler.class);
    private static final HBaseTestingUtility HTU = HBaseTestingUtility.createLocalHTU();
    private static final HTableDescriptor TEST_HTD = new HTableDescriptor(TableName.valueOf((String)"TestCloseRegionHandler"));
    private HRegionInfo TEST_HRI;
    private int testIndex = 0;

    @BeforeClass
    public static void before() throws Exception {
        HTU.startMiniZKCluster();
    }

    @AfterClass
    public static void after() throws IOException {
        HTU.shutdownMiniZKCluster();
    }

    @Before
    public void setupHRI() {
        this.TEST_HRI = new HRegionInfo(TEST_HTD.getTableName(), Bytes.toBytes((int)this.testIndex), Bytes.toBytes((int)(this.testIndex + 1)));
        ++this.testIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedFlushAborts() throws IOException, KeeperException.NodeExistsException, KeeperException {
        block8: {
            MockServer server = new MockServer(HTU, false);
            RegionServerServices rss = HTU.createMockRegionServerService();
            HTableDescriptor htd = TEST_HTD;
            HRegionInfo hri = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_END_ROW, HConstants.EMPTY_END_ROW);
            HRegion region = HTU.createLocalHRegion(hri, htd);
            try {
                Assert.assertNotNull((Object)region);
                HRegion spy = (HRegion)Mockito.spy((Object)region);
                boolean abort = false;
                Mockito.when((Object)spy.close(false)).thenThrow(new Throwable[]{new RuntimeException("Mocked failed close!")});
                rss.addToOnlineRegions(spy);
                Assert.assertFalse((boolean)server.isStopped());
                CloseRegionHandler handler = new CloseRegionHandler((Server)server, rss, hri, false, false, -1);
                boolean throwable = false;
                try {
                    handler.process();
                }
                catch (Throwable t) {
                    try {
                        throwable = true;
                        break block8;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        Assert.assertTrue((boolean)throwable);
                        Assert.assertTrue((boolean)server.isStopped());
                    }
                }
                Assert.assertTrue((boolean)throwable);
                Assert.assertTrue((boolean)server.isStopped());
            }
            finally {
                HRegion.closeHRegion((HRegion)region);
            }
        }
    }

    @Test
    public void testZKClosingNodeVersionMismatch() throws IOException, KeeperException.NodeExistsException, KeeperException, DeserializationException {
        MockServer server = new MockServer(HTU);
        RegionServerServices rss = HTU.createMockRegionServerService();
        HTableDescriptor htd = TEST_HTD;
        HRegionInfo hri = this.TEST_HRI;
        this.OpenRegion(server, rss, htd, hri);
        int versionOfClosingNode = ZKAssign.createNodeClosing((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)hri, (ServerName)server.getServerName());
        CloseRegionHandler handler = new CloseRegionHandler((Server)server, rss, hri, false, true, versionOfClosingNode + 1);
        handler.process();
        RegionTransition rt = RegionTransition.parseFrom((byte[])ZKAssign.getData((ZooKeeperWatcher)server.getZooKeeper(), (String)hri.getEncodedName()));
        Assert.assertTrue((boolean)rt.getEventType().equals((Object)EventType.M_ZK_REGION_CLOSING));
    }

    @Test
    public void testCloseRegion() throws IOException, KeeperException.NodeExistsException, KeeperException, DeserializationException {
        MockServer server = new MockServer(HTU);
        RegionServerServices rss = HTU.createMockRegionServerService();
        HTableDescriptor htd = TEST_HTD;
        HRegionInfo hri = this.TEST_HRI;
        this.OpenRegion(server, rss, htd, hri);
        int versionOfClosingNode = ZKAssign.createNodeClosing((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)hri, (ServerName)server.getServerName());
        CloseRegionHandler handler = new CloseRegionHandler((Server)server, rss, hri, false, true, versionOfClosingNode);
        handler.process();
        RegionTransition rt = RegionTransition.parseFrom((byte[])ZKAssign.getData((ZooKeeperWatcher)server.getZooKeeper(), (String)hri.getEncodedName()));
        Assert.assertTrue((boolean)rt.getEventType().equals((Object)EventType.RS_ZK_REGION_CLOSED));
    }

    private void OpenRegion(Server server, RegionServerServices rss, HTableDescriptor htd, HRegionInfo hri) throws IOException, KeeperException.NodeExistsException, KeeperException, DeserializationException {
        ZKAssign.createNodeOffline((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)hri, (ServerName)server.getServerName());
        OpenRegionHandler openHandler = new OpenRegionHandler(server, rss, hri, htd);
        rss.getRegionsInTransitionInRS().put(hri.getEncodedNameAsBytes(), Boolean.TRUE);
        openHandler.process();
        RegionTransition.parseFrom((byte[])ZKAssign.getData((ZooKeeperWatcher)server.getZooKeeper(), (String)hri.getEncodedName()));
        ZKAssign.deleteNode((ZooKeeperWatcher)server.getZooKeeper(), (String)hri.getEncodedName(), (EventType)EventType.RS_ZK_REGION_OPENED, (ServerName)server.getServerName());
    }
}

