/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.SecureProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.SecureProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSecureHLog {
    static final Log LOG = LogFactory.getLog(TestSecureHLog.class);
    static final HBaseTestingUtility TEST_UTIL;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        conf.set("hbase.crypto.master.key.name", "hbase");
        conf.setClass("hbase.regionserver.hlog.reader.impl", SecureProtobufLogReader.class, HLog.Reader.class);
        conf.setClass("hbase.regionserver.hlog.writer.impl", SecureProtobufLogWriter.class, HLog.Writer.class);
        conf.setBoolean("hbase.regionserver.wal.encryption", true);
    }

    @Test
    public void testSecureHLog() throws Exception {
        TableName tableName = TableName.valueOf((String)"TestSecureHLog");
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(tableName.getName()));
        HRegionInfo regioninfo = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false);
        int total = 10;
        byte[] row = Bytes.toBytes((String)"row");
        byte[] family = Bytes.toBytes((String)"family");
        byte[] value = Bytes.toBytes((String)"Test value");
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path logDir = TEST_UTIL.getDataTestDir("log");
        AtomicLong sequenceId = new AtomicLong(1L);
        FSHLog wal = new FSHLog(fs, TEST_UTIL.getDataTestDir(), logDir.toString(), TEST_UTIL.getConfiguration());
        for (int i = 0; i < 10; ++i) {
            WALEdit kvs = new WALEdit();
            kvs.add(new KeyValue(row, family, Bytes.toBytes((int)i), value));
            wal.append(regioninfo, tableName, kvs, System.currentTimeMillis(), htd, sequenceId);
        }
        Path walPath = wal.computeFilename();
        wal.close();
        long length = fs.getFileStatus(walPath).getLen();
        FSDataInputStream in = fs.open(walPath);
        byte[] fileData = new byte[(int)length];
        IOUtils.readFully((InputStream)in, (byte[])fileData);
        in.close();
        Assert.assertFalse((String)"Cells appear to be plaintext", (boolean)Bytes.contains((byte[])fileData, (byte[])value));
        HLog.Reader reader = HLogFactory.createReader((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)walPath, (Configuration)TEST_UTIL.getConfiguration());
        int count = 0;
        HLog.Entry entry = new HLog.Entry();
        while (reader.next(entry) != null) {
            ++count;
            ArrayList kvs = entry.getEdit().getKeyValues();
            Assert.assertTrue((String)"Should be one KV per WALEdit", (kvs.size() == 1 ? 1 : 0) != 0);
            for (KeyValue kv : kvs) {
                byte[] thisRow = kv.getRow();
                Assert.assertTrue((String)"Incorrect row", (boolean)Bytes.equals((byte[])thisRow, (byte[])row));
                byte[] thisFamily = kv.getFamily();
                Assert.assertTrue((String)"Incorrect family", (boolean)Bytes.equals((byte[])thisFamily, (byte[])family));
                byte[] thisValue = kv.getValue();
                Assert.assertTrue((String)"Incorrect value", (boolean)Bytes.equals((byte[])thisValue, (byte[])value));
            }
        }
        Assert.assertEquals((String)"Should have read back as many KVs as written", (long)10L, (long)count);
        reader.close();
    }

    static {
        ((Log4JLogger)LogFactory.getLog((String)"org.apache.hadoop.hbase.regionserver.wal")).getLogger().setLevel(Level.ALL);
        TEST_UTIL = new HBaseTestingUtility();
    }
}

