/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.ColumnSchemaModel;
import org.apache.hadoop.hbase.rest.model.TableSchemaModel;
import org.apache.hadoop.hbase.rest.model.TestTableSchemaModel;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSchemaResource {
    private static String TABLE1 = "TestSchemaResource1";
    private static String TABLE2 = "TestSchemaResource2";
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    private static Client client;
    private static JAXBContext context;
    private static Configuration conf;
    private static TestTableSchemaModel testTableSchemaModel;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniCluster();
        REST_TEST_UTIL.startServletContainer(conf);
        client = new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort()));
        testTableSchemaModel = new TestTableSchemaModel();
        context = JAXBContext.newInstance((Class[])new Class[]{ColumnSchemaModel.class, TableSchemaModel.class});
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    private static byte[] toXML(TableSchemaModel model) throws JAXBException {
        StringWriter writer = new StringWriter();
        context.createMarshaller().marshal((Object)model, (Writer)writer);
        return Bytes.toBytes((String)writer.toString());
    }

    private static TableSchemaModel fromXML(byte[] content) throws JAXBException {
        return (TableSchemaModel)context.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(content));
    }

    @Test
    public void testTableCreateAndDeleteXML() throws IOException, JAXBException {
        String schemaPath = "/" + TABLE1 + "/schema";
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        Assert.assertFalse((boolean)admin.tableExists(TABLE1));
        TableSchemaModel model = testTableSchemaModel.buildTestModel(TABLE1);
        testTableSchemaModel.checkModel(model, TABLE1);
        Response response = client.put(schemaPath, "text/xml", TestSchemaResource.toXML(model));
        Assert.assertEquals((long)response.getCode(), (long)201L);
        conf.set("hbase.rest.readonly", "true");
        response = client.put(schemaPath, "text/xml", TestSchemaResource.toXML(model));
        Assert.assertEquals((long)response.getCode(), (long)403L);
        response = client.get(schemaPath, "text/xml");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        model = TestSchemaResource.fromXML(response.getBody());
        testTableSchemaModel.checkModel(model, TABLE1);
        response = client.get(schemaPath, "application/json");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
        model = (TableSchemaModel)testTableSchemaModel.fromJSON(Bytes.toString((byte[])response.getBody()));
        testTableSchemaModel.checkModel(model, TABLE1);
        response = client.delete(schemaPath);
        Assert.assertEquals((long)response.getCode(), (long)403L);
        conf.set("hbase.rest.readonly", "false");
        response = client.delete(schemaPath);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertFalse((boolean)admin.tableExists(TABLE1));
    }

    @Test
    public void testTableCreateAndDeletePB() throws IOException, JAXBException {
        String schemaPath = "/" + TABLE2 + "/schema";
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        Assert.assertFalse((boolean)admin.tableExists(TABLE2));
        TableSchemaModel model = testTableSchemaModel.buildTestModel(TABLE2);
        testTableSchemaModel.checkModel(model, TABLE2);
        Response response = client.put(schemaPath, "application/x-protobuf", model.createProtobufOutput());
        Assert.assertEquals((long)response.getCode(), (long)201L);
        conf.set("hbase.rest.readonly", "true");
        response = client.put(schemaPath, "application/x-protobuf", model.createProtobufOutput());
        Assert.assertEquals((long)response.getCode(), (long)403L);
        response = client.get(schemaPath, "application/x-protobuf");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"application/x-protobuf", (Object)response.getHeader("content-type"));
        model = new TableSchemaModel();
        model.getObjectFromMessage(response.getBody());
        testTableSchemaModel.checkModel(model, TABLE2);
        response = client.get(schemaPath, "application/protobuf");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"application/protobuf", (Object)response.getHeader("content-type"));
        model = new TableSchemaModel();
        model.getObjectFromMessage(response.getBody());
        testTableSchemaModel.checkModel(model, TABLE2);
        response = client.delete(schemaPath);
        Assert.assertEquals((long)response.getCode(), (long)403L);
        conf.set("hbase.rest.readonly", "false");
        response = client.delete(schemaPath);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertFalse((boolean)admin.tableExists(TABLE2));
    }
}

