/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.RpcExecutor;
import org.apache.hadoop.hbase.util.ReflectionUtils;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
@InterfaceStability.Evolving
public class BalancedQueueRpcExecutor
extends RpcExecutor {
    protected final List<BlockingQueue<CallRunner>> queues;
    private QueueBalancer balancer;
    private static QueueBalancer ONE_QUEUE = new QueueBalancer(){

        @Override
        public int getNextQueue() {
            return 0;
        }
    };

    public BalancedQueueRpcExecutor(String name, int handlerCount, int numQueues, int maxQueueLength) {
        this(name, handlerCount, numQueues, LinkedBlockingQueue.class, maxQueueLength);
    }

    public BalancedQueueRpcExecutor(String name, int handlerCount, int numQueues, Class<? extends BlockingQueue> queueClass, Object ... initargs) {
        super(name, Math.max(handlerCount, numQueues));
        this.queues = new ArrayList<BlockingQueue<CallRunner>>(numQueues);
        this.balancer = BalancedQueueRpcExecutor.getBalancer(numQueues);
        this.initializeQueues(numQueues, queueClass, initargs);
    }

    protected void initializeQueues(int numQueues, Class<? extends BlockingQueue> queueClass, Object ... initargs) {
        for (int i = 0; i < numQueues; ++i) {
            this.queues.add((BlockingQueue)ReflectionUtils.newInstance(queueClass, (Object[])initargs));
        }
    }

    @Override
    public void dispatch(CallRunner callTask) throws InterruptedException {
        int queueIndex = this.balancer.getNextQueue();
        this.queues.get(queueIndex).put(callTask);
    }

    @Override
    public int getQueueLength() {
        int length = 0;
        for (BlockingQueue<CallRunner> queue : this.queues) {
            length += queue.size();
        }
        return length;
    }

    @Override
    public List<BlockingQueue<CallRunner>> getQueues() {
        return this.queues;
    }

    public static QueueBalancer getBalancer(int queueSize) {
        Preconditions.checkArgument((queueSize > 0 ? 1 : 0) != 0, (Object)"Queue size is <= 0, must be at least 1");
        if (queueSize == 1) {
            return ONE_QUEUE;
        }
        return new RandomQueueBalancer(queueSize);
    }

    private static class RandomQueueBalancer
    extends QueueBalancer {
        private int queueSize;
        private Random random;

        public RandomQueueBalancer(int queueSize) {
            this.queueSize = queueSize;
            this.random = new Random();
        }

        @Override
        public int getNextQueue() {
            return this.random.nextInt(this.queueSize);
        }
    }

    private static abstract class QueueBalancer {
        private QueueBalancer() {
        }

        public abstract int getNextQueue();
    }
}

