/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

public class TokenUtil {
    private static Log LOG = LogFactory.getLog(TokenUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Token<AuthenticationTokenIdentifier> obtainToken(Configuration conf) throws IOException {
        HTable meta = null;
        try {
            meta = new HTable(conf, TableName.META_TABLE_NAME);
            CoprocessorRpcChannel rpcChannel = meta.coprocessorService(HConstants.EMPTY_START_ROW);
            AuthenticationProtos.AuthenticationService.BlockingInterface service = AuthenticationProtos.AuthenticationService.newBlockingStub((BlockingRpcChannel)rpcChannel);
            AuthenticationProtos.GetAuthenticationTokenResponse response = service.getAuthenticationToken(null, AuthenticationProtos.GetAuthenticationTokenRequest.getDefaultInstance());
            Token token = ProtobufUtil.toToken((AuthenticationProtos.Token)response.getToken());
            return token;
        }
        catch (ServiceException se) {
            ProtobufUtil.toIOException((ServiceException)se);
        }
        finally {
            if (meta != null) {
                meta.close();
            }
        }
        return null;
    }

    private static Text getClusterId(Token<AuthenticationTokenIdentifier> token) throws IOException {
        return token.getService() != null ? token.getService() : new Text("default");
    }

    public static void obtainAndCacheToken(final Configuration conf, UserGroupInformation user) throws IOException, InterruptedException {
        try {
            Token token = (Token)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Token<AuthenticationTokenIdentifier>>(){

                @Override
                public Token<AuthenticationTokenIdentifier> run() throws Exception {
                    return TokenUtil.obtainToken(conf);
                }
            });
            if (token == null) {
                throw new IOException("No token returned for user " + user.getUserName());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Obtained token " + token.getKind().toString() + " for user " + user.getUserName()));
            }
            user.addToken(token);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e, "Unexpected exception obtaining token for user " + user.getUserName());
        }
    }

    public static void obtainTokenForJob(final Configuration conf, UserGroupInformation user, Job job) throws IOException, InterruptedException {
        try {
            Token token = (Token)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Token<AuthenticationTokenIdentifier>>(){

                @Override
                public Token<AuthenticationTokenIdentifier> run() throws Exception {
                    return TokenUtil.obtainToken(conf);
                }
            });
            if (token == null) {
                throw new IOException("No token returned for user " + user.getUserName());
            }
            Text clusterId = TokenUtil.getClusterId((Token<AuthenticationTokenIdentifier>)token);
            LOG.info((Object)("Obtained token " + token.getKind().toString() + " for user " + user.getUserName() + " on cluster " + clusterId.toString()));
            job.getCredentials().addToken(clusterId, token);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e, "Unexpected exception obtaining token for user " + user.getUserName());
        }
    }

    public static void obtainTokenForJob(final JobConf job, UserGroupInformation user) throws IOException, InterruptedException {
        try {
            Token token = (Token)user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Token<AuthenticationTokenIdentifier>>(){

                @Override
                public Token<AuthenticationTokenIdentifier> run() throws Exception {
                    return TokenUtil.obtainToken((Configuration)job);
                }
            });
            if (token == null) {
                throw new IOException("No token returned for user " + user.getUserName());
            }
            Text clusterId = TokenUtil.getClusterId((Token<AuthenticationTokenIdentifier>)token);
            LOG.info((Object)("Obtained token " + token.getKind().toString() + " for user " + user.getUserName() + " on cluster " + clusterId.toString()));
            job.getCredentials().addToken(clusterId, token);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e, "Unexpected exception obtaining token for user " + user.getUserName());
        }
    }
}

