/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;

public class SnapshotDescriptionUtils {
    private static final Log LOG = LogFactory.getLog(SnapshotDescriptionUtils.class);
    public static final int SNAPSHOT_LAYOUT_VERSION = 0;
    public static final String SNAPSHOTINFO_FILE = ".snapshotinfo";
    public static final String SNAPSHOT_TMP_DIR_NAME = ".tmp";
    public static final long NO_SNAPSHOT_START_TIME_SPECIFIED = 0L;
    public static final String MASTER_SNAPSHOT_TIMEOUT_MILLIS = "hbase.snapshot.master.timeout.millis";
    public static final long DEFAULT_MAX_WAIT_TIME = 60000L;

    private SnapshotDescriptionUtils() {
    }

    public static long getMaxMasterTimeout(Configuration conf, HBaseProtos.SnapshotDescription.Type type, long defaultMaxWaitTime) {
        switch (type) {
            default: 
        }
        String confKey = MASTER_SNAPSHOT_TIMEOUT_MILLIS;
        return conf.getLong(confKey, defaultMaxWaitTime);
    }

    public static Path getSnapshotRootDir(Path rootDir) {
        return new Path(rootDir, ".hbase-snapshot");
    }

    public static Path getCompletedSnapshotDir(HBaseProtos.SnapshotDescription snapshot, Path rootDir) {
        return SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshot.getName(), rootDir);
    }

    public static Path getCompletedSnapshotDir(String snapshotName, Path rootDir) {
        return SnapshotDescriptionUtils.getCompletedSnapshotDir(SnapshotDescriptionUtils.getSnapshotsDir(rootDir), snapshotName);
    }

    public static Path getWorkingSnapshotDir(Path rootDir) {
        return new Path(SnapshotDescriptionUtils.getSnapshotsDir(rootDir), SNAPSHOT_TMP_DIR_NAME);
    }

    public static Path getWorkingSnapshotDir(HBaseProtos.SnapshotDescription snapshot, Path rootDir) {
        return SnapshotDescriptionUtils.getCompletedSnapshotDir(SnapshotDescriptionUtils.getWorkingSnapshotDir(rootDir), snapshot.getName());
    }

    public static Path getWorkingSnapshotDir(String snapshotName, Path rootDir) {
        return SnapshotDescriptionUtils.getCompletedSnapshotDir(SnapshotDescriptionUtils.getWorkingSnapshotDir(rootDir), snapshotName);
    }

    private static final Path getCompletedSnapshotDir(Path snapshotsDir, String snapshotName) {
        return new Path(snapshotsDir, snapshotName);
    }

    public static final Path getSnapshotsDir(Path rootDir) {
        return new Path(rootDir, ".hbase-snapshot");
    }

    public static HBaseProtos.SnapshotDescription validate(HBaseProtos.SnapshotDescription snapshot, Configuration conf) throws IllegalArgumentException {
        if (!snapshot.hasTable()) {
            throw new IllegalArgumentException("Descriptor doesn't apply to a table, so we can't build it.");
        }
        long time = snapshot.getCreationTime();
        if (time == 0L) {
            time = EnvironmentEdgeManager.currentTimeMillis();
            LOG.debug((Object)("Creation time not specified, setting to:" + time + " (current time:" + EnvironmentEdgeManager.currentTimeMillis() + ")."));
            HBaseProtos.SnapshotDescription.Builder builder = snapshot.toBuilder();
            builder.setCreationTime(time);
            snapshot = builder.build();
        }
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSnapshotInfo(HBaseProtos.SnapshotDescription snapshot, Path workingDir, FileSystem fs) throws IOException {
        block5: {
            FsPermission perms = FSUtils.getFilePermissions(fs, fs.getConf(), "hbase.data.umask");
            Path snapshotInfo = new Path(workingDir, SNAPSHOTINFO_FILE);
            try {
                FSDataOutputStream out = FSUtils.create(fs, snapshotInfo, perms, true);
                try {
                    snapshot.writeTo((OutputStream)out);
                }
                finally {
                    out.close();
                }
            }
            catch (IOException e) {
                if (fs.delete(snapshotInfo, false)) break block5;
                String msg = "Couldn't delete snapshot info file: " + snapshotInfo;
                LOG.error((Object)msg);
                throw new IOException(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HBaseProtos.SnapshotDescription readSnapshotInfo(FileSystem fs, Path snapshotDir) throws CorruptedSnapshotException {
        HBaseProtos.SnapshotDescription snapshotDescription;
        block6: {
            Path snapshotInfo = new Path(snapshotDir, SNAPSHOTINFO_FILE);
            FSDataInputStream in = null;
            try {
                HBaseProtos.SnapshotDescription desc;
                in = fs.open(snapshotInfo);
                snapshotDescription = desc = HBaseProtos.SnapshotDescription.parseFrom((InputStream)in);
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CorruptedSnapshotException("Couldn't read snapshot info from:" + snapshotInfo, (Exception)e);
                }
            }
            in.close();
        }
        return snapshotDescription;
    }

    public static void completeSnapshot(HBaseProtos.SnapshotDescription snapshot, Path rootdir, Path workingDir, FileSystem fs) throws SnapshotCreationException, IOException {
        Path finishedDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshot, rootdir);
        LOG.debug((Object)("Snapshot is done, just moving the snapshot from " + workingDir + " to " + finishedDir));
        if (!fs.rename(workingDir, finishedDir)) {
            throw new SnapshotCreationException("Failed to move working directory(" + workingDir + ") to completed directory(" + finishedDir + ").", snapshot);
        }
    }

    public static class CompletedSnaphotDirectoriesFilter
    extends FSUtils.BlackListDirFilter {
        public CompletedSnaphotDirectoriesFilter(FileSystem fs) {
            super(fs, Collections.singletonList(SnapshotDescriptionUtils.SNAPSHOT_TMP_DIR_NAME));
        }
    }
}

