/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class SortedCopyOnWriteSet<E>
implements SortedSet<E> {
    private volatile SortedSet<E> internalSet;

    public SortedCopyOnWriteSet() {
        this.internalSet = new TreeSet();
    }

    public SortedCopyOnWriteSet(Collection<? extends E> c) {
        this.internalSet = new TreeSet<E>(c);
    }

    public SortedCopyOnWriteSet(Comparator<? super E> comparator) {
        this.internalSet = new TreeSet<E>(comparator);
    }

    @Override
    public int size() {
        return this.internalSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.internalSet.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.internalSet.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.internalSet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.internalSet.toArray(a);
    }

    @Override
    public synchronized boolean add(E e) {
        TreeSet<E> newSet = new TreeSet<E>(this.internalSet);
        boolean added = newSet.add(e);
        this.internalSet = newSet;
        return added;
    }

    @Override
    public synchronized boolean remove(Object o) {
        TreeSet<E> newSet = new TreeSet<E>(this.internalSet);
        boolean removed = newSet.remove(o);
        this.internalSet = newSet;
        return removed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.internalSet.containsAll(c);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        TreeSet<? extends E> newSet = new TreeSet<E>(this.internalSet);
        boolean changed = newSet.addAll(c);
        this.internalSet = newSet;
        return changed;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        TreeSet<E> newSet = new TreeSet<E>(this.internalSet);
        boolean changed = newSet.retainAll(c);
        this.internalSet = newSet;
        return changed;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        TreeSet<E> newSet = new TreeSet<E>(this.internalSet);
        boolean changed = newSet.removeAll(c);
        this.internalSet = newSet;
        return changed;
    }

    @Override
    public synchronized void clear() {
        Comparator<E> comparator = this.internalSet.comparator();
        this.internalSet = comparator != null ? new TreeSet<E>(comparator) : new TreeSet();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.internalSet.comparator();
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.internalSet.subSet(fromElement, toElement);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.internalSet.headSet(toElement);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.internalSet.tailSet(fromElement);
    }

    @Override
    public E first() {
        return this.internalSet.first();
    }

    @Override
    public E last() {
        return this.internalSet.last();
    }
}

