/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.HLogSplitter;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.SecureProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.SecureProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHLogReaderOnSecureHLog {
    static final Log LOG = LogFactory.getLog(TestHLogReaderOnSecureHLog.class);
    static final HBaseTestingUtility TEST_UTIL;
    final byte[] value = Bytes.toBytes((String)"Test value");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        conf.set("hbase.crypto.master.key.name", "hbase");
        conf.setBoolean("hbase.hlog.split.skip.errors", true);
        conf.setBoolean("hbase.regionserver.wal.encryption", true);
    }

    private Path writeWAL(String tblName) throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        TableName tableName = TableName.valueOf((String)tblName);
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(tableName.getName()));
        HRegionInfo regioninfo = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false);
        int total = 10;
        byte[] row = Bytes.toBytes((String)"row");
        byte[] family = Bytes.toBytes((String)"family");
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path logDir = TEST_UTIL.getDataTestDir(tblName);
        AtomicLong sequenceId = new AtomicLong(1L);
        FSHLog wal = new FSHLog(fs, TEST_UTIL.getDataTestDir(), logDir.toString(), conf);
        for (int i = 0; i < 10; ++i) {
            WALEdit kvs = new WALEdit();
            kvs.add(new KeyValue(row, family, Bytes.toBytes((int)i), this.value));
            wal.append(regioninfo, tableName, kvs, System.currentTimeMillis(), htd, sequenceId);
        }
        Path walPath = wal.computeFilename();
        wal.close();
        return walPath;
    }

    @Test
    public void testHLogReaderOnSecureHLog() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        HLogFactory.resetLogReaderClass();
        HLogFactory.resetLogWriterClass();
        conf.setClass("hbase.regionserver.hlog.reader.impl", ProtobufLogReader.class, HLog.Reader.class);
        conf.setClass("hbase.regionserver.hlog.writer.impl", SecureProtobufLogWriter.class, HLog.Writer.class);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path walPath = this.writeWAL("testHLogReaderOnSecureHLog");
        long length = fs.getFileStatus(walPath).getLen();
        FSDataInputStream in = fs.open(walPath);
        byte[] fileData = new byte[(int)length];
        IOUtils.readFully((InputStream)in, (byte[])fileData);
        in.close();
        Assert.assertFalse((String)"Cells appear to be plaintext", (boolean)Bytes.contains((byte[])fileData, (byte[])this.value));
        try {
            HLog.Reader reader = HLogFactory.createReader((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)walPath, (Configuration)conf);
            Assert.assertFalse((boolean)true);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        FileStatus[] listStatus = fs.listStatus(walPath.getParent());
        ZooKeeperProtos.SplitLogTask.RecoveryMode mode = conf.getBoolean("hbase.master.distributed.log.replay", false) ? ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY : ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_SPLITTING;
        Path rootdir = FSUtils.getRootDir((Configuration)conf);
        try {
            HLogSplitter s = new HLogSplitter(conf, rootdir, fs, null, null, mode);
            s.splitLogFile(listStatus[0], null);
            Path file = new Path(ZKSplitLog.getSplitLogDir((Path)rootdir, (String)listStatus[0].getPath().getName()), "corrupt");
            Assert.assertTrue((boolean)fs.exists(file));
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)"WAL should have been sidelined", (boolean)false);
        }
    }

    @Test
    public void testSecureHLogReaderOnHLog() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        HLogFactory.resetLogReaderClass();
        HLogFactory.resetLogWriterClass();
        conf.setClass("hbase.regionserver.hlog.reader.impl", SecureProtobufLogReader.class, HLog.Reader.class);
        conf.setClass("hbase.regionserver.hlog.writer.impl", ProtobufLogWriter.class, HLog.Writer.class);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path walPath = this.writeWAL("testSecureHLogReaderOnHLog");
        long length = fs.getFileStatus(walPath).getLen();
        FSDataInputStream in = fs.open(walPath);
        byte[] fileData = new byte[(int)length];
        IOUtils.readFully((InputStream)in, (byte[])fileData);
        in.close();
        Assert.assertTrue((String)"Cells should be plaintext", (boolean)Bytes.contains((byte[])fileData, (byte[])this.value));
        try {
            HLog.Reader reader = HLogFactory.createReader((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)walPath, (Configuration)conf);
        }
        catch (IOException ioe) {
            Assert.assertFalse((boolean)true);
        }
        FileStatus[] listStatus = fs.listStatus(walPath.getParent());
        ZooKeeperProtos.SplitLogTask.RecoveryMode mode = conf.getBoolean("hbase.master.distributed.log.replay", false) ? ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY : ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_SPLITTING;
        Path rootdir = FSUtils.getRootDir((Configuration)conf);
        try {
            HLogSplitter s = new HLogSplitter(conf, rootdir, fs, null, null, mode);
            s.splitLogFile(listStatus[0], null);
            Path file = new Path(ZKSplitLog.getSplitLogDir((Path)rootdir, (String)listStatus[0].getPath().getName()), "corrupt");
            Assert.assertTrue((!fs.exists(file) ? 1 : 0) != 0);
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)"WAL should have been processed", (boolean)false);
        }
    }

    static {
        ((Log4JLogger)LogFactory.getLog((String)"org.apache.hadoop.hbase.regionserver.wal")).getLogger().setLevel(Level.ALL);
        TEST_UTIL = new HBaseTestingUtility();
    }
}

