/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.Header;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.hbase.rest.RowResourceBase;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestGetAndPutResource
extends RowResourceBase {
    private static final MetricsAssertHelper METRICS_ASSERT = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);

    @Test
    public void testForbidden() throws IOException, JAXBException {
        conf.set("hbase.rest.readonly", "true");
        Response response = TestGetAndPutResource.putValueXML("TestRowResource", "testrow1", "a:1", "testvalue1");
        Assert.assertEquals((long)response.getCode(), (long)403L);
        response = TestGetAndPutResource.putValuePB("TestRowResource", "testrow1", "a:1", "testvalue1");
        Assert.assertEquals((long)response.getCode(), (long)403L);
        response = TestGetAndPutResource.checkAndPutValueXML("TestRowResource", "testrow1", "a:1", "testvalue1", "testvalue2");
        Assert.assertEquals((long)response.getCode(), (long)403L);
        response = TestGetAndPutResource.checkAndPutValuePB("TestRowResource", "testrow1", "a:1", "testvalue1", "testvalue2");
        Assert.assertEquals((long)response.getCode(), (long)403L);
        response = TestGetAndPutResource.deleteValue("TestRowResource", "testrow1", "a:1");
        Assert.assertEquals((long)response.getCode(), (long)403L);
        response = TestGetAndPutResource.checkAndDeletePB("TestRowResource", "testrow1", "a:1", "testvalue1");
        Assert.assertEquals((long)response.getCode(), (long)403L);
        response = TestGetAndPutResource.deleteRow("TestRowResource", "testrow1");
        Assert.assertEquals((long)response.getCode(), (long)403L);
        conf.set("hbase.rest.readonly", "false");
        response = TestGetAndPutResource.putValueXML("TestRowResource", "testrow1", "a:1", "testvalue1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestGetAndPutResource.putValuePB("TestRowResource", "testrow1", "a:1", "testvalue1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestGetAndPutResource.checkAndPutValueXML("TestRowResource", "testrow1", "a:1", "testvalue1", "testvalue2");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestGetAndPutResource.checkAndPutValuePB("TestRowResource", "testrow1", "a:1", "testvalue2", "testvalue3");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestGetAndPutResource.deleteValue("TestRowResource", "testrow1", "a:1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestGetAndPutResource.deleteRow("TestRowResource", "testrow1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testSingleCellGetPutXML() throws IOException, JAXBException {
        Response response = TestGetAndPutResource.getValueXML("TestRowResource", "testrow1", "a:1");
        Assert.assertEquals((long)response.getCode(), (long)404L);
        response = TestGetAndPutResource.putValueXML("TestRowResource", "testrow1", "a:1", "testvalue1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        TestGetAndPutResource.checkValueXML("TestRowResource", "testrow1", "a:1", "testvalue1");
        response = TestGetAndPutResource.putValueXML("TestRowResource", "testrow1", "a:1", "testvalue2");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        TestGetAndPutResource.checkValueXML("TestRowResource", "testrow1", "a:1", "testvalue2");
        response = TestGetAndPutResource.checkAndPutValueXML("TestRowResource", "testrow1", "a:1", "testvalue2", "testvalue3");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        TestGetAndPutResource.checkValueXML("TestRowResource", "testrow1", "a:1", "testvalue3");
        response = TestGetAndPutResource.checkAndDeleteXML("TestRowResource", "testrow1", "a:1", "testvalue3");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestGetAndPutResource.deleteRow("TestRowResource", "testrow1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testSingleCellGetPutPB() throws IOException, JAXBException {
        Response response = TestGetAndPutResource.getValuePB("TestRowResource", "testrow1", "a:1");
        Assert.assertEquals((long)response.getCode(), (long)404L);
        response = TestGetAndPutResource.putValuePB("TestRowResource", "testrow1", "a:1", "testvalue1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        TestGetAndPutResource.checkValuePB("TestRowResource", "testrow1", "a:1", "testvalue1");
        response = TestGetAndPutResource.putValueXML("TestRowResource", "testrow1", "a:1", "testvalue2");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        TestGetAndPutResource.checkValuePB("TestRowResource", "testrow1", "a:1", "testvalue2");
        response = TestGetAndPutResource.checkAndPutValuePB("TestRowResource", "testrow1", "a:1", "testvalue2", "testvalue3");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        TestGetAndPutResource.checkValuePB("TestRowResource", "testrow1", "a:1", "testvalue3");
        response = TestGetAndPutResource.checkAndPutValueXML("TestRowResource", "testrow1", "a:1", "testvalue3", "testvalue4");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        TestGetAndPutResource.checkValuePB("TestRowResource", "testrow1", "a:1", "testvalue4");
        response = TestGetAndPutResource.deleteRow("TestRowResource", "testrow1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testSingleCellGetPutBinary() throws IOException {
        String path = "/TestRowResource/testrow3/a:1";
        byte[] body = Bytes.toBytes((String)"testvalue3");
        Response response = client.put("/TestRowResource/testrow3/a:1", "application/octet-stream", body);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Thread.yield();
        response = client.get("/TestRowResource/testrow3/a:1", "application/octet-stream");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"application/octet-stream", (Object)response.getHeader("content-type"));
        Assert.assertTrue((boolean)Bytes.equals((byte[])response.getBody(), (byte[])body));
        boolean foundTimestampHeader = false;
        for (Header header : response.getHeaders()) {
            if (!header.getName().equals("X-Timestamp")) continue;
            foundTimestampHeader = true;
            break;
        }
        Assert.assertTrue((boolean)foundTimestampHeader);
        response = TestGetAndPutResource.deleteRow("TestRowResource", "testrow3");
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testSingleCellGetJSON() throws IOException, JAXBException {
        String path = "/TestRowResource/testrow4/a:1";
        Response response = client.put("/TestRowResource/testrow4/a:1", "application/octet-stream", Bytes.toBytes((String)"testvalue4"));
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Thread.yield();
        response = client.get("/TestRowResource/testrow4/a:1", "application/json");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
        response = TestGetAndPutResource.deleteRow("TestRowResource", "testrow4");
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testLatestCellGetJSON() throws IOException, JAXBException {
        String path = "/TestRowResource/testrow4/a:1";
        CellSetModel cellSetModel = new CellSetModel();
        RowModel rowModel = new RowModel("testrow4");
        CellModel cellOne = new CellModel(Bytes.toBytes((String)"a:1"), 1L, Bytes.toBytes((String)"testvalue1"));
        CellModel cellTwo = new CellModel(Bytes.toBytes((String)"a:1"), 2L, Bytes.toBytes((String)"testvalue2"));
        rowModel.addCell(cellOne);
        rowModel.addCell(cellTwo);
        cellSetModel.addRow(rowModel);
        String jsonString = jsonMapper.writeValueAsString((Object)cellSetModel);
        Response response = client.put("/TestRowResource/testrow4/a:1", "application/json", Bytes.toBytes((String)jsonString));
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Thread.yield();
        response = client.get("/TestRowResource/testrow4/a:1", "application/json");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
        CellSetModel cellSet = (CellSetModel)jsonMapper.readValue(response.getBody(), CellSetModel.class);
        Assert.assertTrue((cellSet.getRows().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((RowModel)cellSet.getRows().get(0)).getCells().size() == 1 ? 1 : 0) != 0);
        CellModel cell = (CellModel)((RowModel)cellSet.getRows().get(0)).getCells().get(0);
        Assert.assertEquals((Object)"testvalue2", (Object)Bytes.toString((byte[])cell.getValue()));
        Assert.assertEquals((long)2L, (long)cell.getTimestamp());
        response = TestGetAndPutResource.deleteRow("TestRowResource", "testrow4");
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testURLEncodedKey() throws IOException, JAXBException {
        String urlKey = "http://example.com/foo";
        StringBuilder path = new StringBuilder();
        path.append('/');
        path.append("TestRowResource");
        path.append('/');
        path.append(URLEncoder.encode(urlKey, "UTF-8"));
        path.append('/');
        path.append("a:1");
        Response response = TestGetAndPutResource.putValueXML(path.toString(), "TestRowResource", urlKey, "a:1", "testvalue1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        TestGetAndPutResource.checkValueXML(path.toString(), "TestRowResource", urlKey, "a:1", "testvalue1");
    }

    @Test
    public void testNoSuchCF() throws IOException, JAXBException {
        String goodPath = "/TestRowResource/testrow1/a:";
        String badPath = "/TestRowResource/testrow1/BAD";
        Response response = client.post("/TestRowResource/testrow1/a:", "application/octet-stream", Bytes.toBytes((String)"testvalue1"));
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((long)client.get("/TestRowResource/testrow1/a:", "application/octet-stream").getCode(), (long)200L);
        Assert.assertEquals((long)client.get("/TestRowResource/testrow1/BAD", "application/octet-stream").getCode(), (long)404L);
        Assert.assertEquals((long)client.get("/TestRowResource/testrow1/a:", "application/octet-stream").getCode(), (long)200L);
    }

    @Test
    public void testMultiCellGetPutXML() throws IOException, JAXBException {
        String path = "/TestRowResource/fakerow";
        CellSetModel cellSetModel = new CellSetModel();
        RowModel rowModel = new RowModel("testrow1");
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"a:1"), Bytes.toBytes((String)"testvalue1")));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"b:2"), Bytes.toBytes((String)"testvalue2")));
        cellSetModel.addRow(rowModel);
        rowModel = new RowModel("testrow2");
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"a:1"), Bytes.toBytes((String)"testvalue3")));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"b:2"), Bytes.toBytes((String)"testvalue4")));
        cellSetModel.addRow(rowModel);
        StringWriter writer = new StringWriter();
        xmlMarshaller.marshal((Object)cellSetModel, (Writer)writer);
        Response response = client.put(path, "text/xml", Bytes.toBytes((String)writer.toString()));
        Thread.yield();
        response = client.get(path, "text/xml");
        Assert.assertEquals((long)response.getCode(), (long)404L);
        TestGetAndPutResource.checkValueXML("TestRowResource", "testrow1", "a:1", "testvalue1");
        TestGetAndPutResource.checkValueXML("TestRowResource", "testrow1", "b:2", "testvalue2");
        TestGetAndPutResource.checkValueXML("TestRowResource", "testrow2", "a:1", "testvalue3");
        TestGetAndPutResource.checkValueXML("TestRowResource", "testrow2", "b:2", "testvalue4");
        response = TestGetAndPutResource.deleteRow("TestRowResource", "testrow1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestGetAndPutResource.deleteRow("TestRowResource", "testrow2");
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testMultiCellGetPutPB() throws IOException {
        String path = "/TestRowResource/fakerow";
        CellSetModel cellSetModel = new CellSetModel();
        RowModel rowModel = new RowModel("testrow1");
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"a:1"), Bytes.toBytes((String)"testvalue1")));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"b:2"), Bytes.toBytes((String)"testvalue2")));
        cellSetModel.addRow(rowModel);
        rowModel = new RowModel("testrow2");
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"a:1"), Bytes.toBytes((String)"testvalue3")));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"b:2"), Bytes.toBytes((String)"testvalue4")));
        cellSetModel.addRow(rowModel);
        Response response = client.put(path, "application/x-protobuf", cellSetModel.createProtobufOutput());
        Thread.yield();
        response = client.get(path, "application/x-protobuf");
        Assert.assertEquals((long)response.getCode(), (long)404L);
        TestGetAndPutResource.checkValuePB("TestRowResource", "testrow1", "a:1", "testvalue1");
        TestGetAndPutResource.checkValuePB("TestRowResource", "testrow1", "b:2", "testvalue2");
        TestGetAndPutResource.checkValuePB("TestRowResource", "testrow2", "a:1", "testvalue3");
        TestGetAndPutResource.checkValuePB("TestRowResource", "testrow2", "b:2", "testvalue4");
        response = TestGetAndPutResource.deleteRow("TestRowResource", "testrow1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestGetAndPutResource.deleteRow("TestRowResource", "testrow2");
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testStartEndRowGetPutXML() throws IOException, JAXBException {
        String[] rows = new String[]{"testrow1", "testrow2", "testrow3"};
        String[] values = new String[]{"testvalue1", "testvalue2", "testvalue3"};
        Response response = null;
        for (int i = 0; i < rows.length; ++i) {
            response = TestGetAndPutResource.putValueXML("TestRowResource", rows[i], "a:1", values[i]);
            Assert.assertEquals((long)200L, (long)response.getCode());
            TestGetAndPutResource.checkValueXML("TestRowResource", rows[i], "a:1", values[i]);
        }
        response = TestGetAndPutResource.getValueXML("TestRowResource", rows[0], rows[2], "a:1");
        Assert.assertEquals((long)200L, (long)response.getCode());
        CellSetModel cellSet = (CellSetModel)xmlUnmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        Assert.assertEquals((long)2L, (long)cellSet.getRows().size());
        for (int i = 0; i < cellSet.getRows().size() - 1; ++i) {
            RowModel rowModel = (RowModel)cellSet.getRows().get(i);
            for (CellModel cell : rowModel.getCells()) {
                Assert.assertEquals((Object)"a:1", (Object)Bytes.toString((byte[])cell.getColumn()));
                Assert.assertEquals((Object)values[i], (Object)Bytes.toString((byte[])cell.getValue()));
            }
        }
        for (String row : rows) {
            response = TestGetAndPutResource.deleteRow("TestRowResource", row);
            Assert.assertEquals((long)200L, (long)response.getCode());
        }
    }

    @Test
    public void testInvalidCheckParam() throws IOException, JAXBException {
        CellSetModel cellSetModel = new CellSetModel();
        RowModel rowModel = new RowModel("testrow1");
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"a:1"), Bytes.toBytes((String)"testvalue1")));
        cellSetModel.addRow(rowModel);
        StringWriter writer = new StringWriter();
        xmlMarshaller.marshal((Object)cellSetModel, (Writer)writer);
        String path = "/TestRowResource/testrow1/a:1?check=blah";
        Response response = client.put("/TestRowResource/testrow1/a:1?check=blah", "text/xml", Bytes.toBytes((String)writer.toString()));
        Assert.assertEquals((long)response.getCode(), (long)400L);
    }

    @Test
    public void testInvalidColumnPut() throws IOException, JAXBException {
        String dummyColumn = "doesnot:exist";
        CellSetModel cellSetModel = new CellSetModel();
        RowModel rowModel = new RowModel("testrow1");
        rowModel.addCell(new CellModel(Bytes.toBytes((String)dummyColumn), Bytes.toBytes((String)"testvalue1")));
        cellSetModel.addRow(rowModel);
        StringWriter writer = new StringWriter();
        xmlMarshaller.marshal((Object)cellSetModel, (Writer)writer);
        String path = "/TestRowResource/testrow1/" + dummyColumn;
        Response response = client.put(path, "text/xml", Bytes.toBytes((String)writer.toString()));
        Assert.assertEquals((long)response.getCode(), (long)404L);
    }

    @Test
    public void testMultiCellGetJson() throws IOException, JAXBException {
        String path = "/TestRowResource/fakerow";
        CellSetModel cellSetModel = new CellSetModel();
        RowModel rowModel = new RowModel("testrow1");
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"a:1"), Bytes.toBytes((String)"testvalue1")));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"b:2"), Bytes.toBytes((String)"testvalue2")));
        cellSetModel.addRow(rowModel);
        rowModel = new RowModel("testrow2");
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"a:1"), Bytes.toBytes((String)"testvalue3")));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"b:2"), Bytes.toBytes((String)"testvalue4")));
        cellSetModel.addRow(rowModel);
        String jsonString = jsonMapper.writeValueAsString((Object)cellSetModel);
        Response response = client.put(path, "application/json", Bytes.toBytes((String)jsonString));
        Thread.yield();
        response = client.get(path, "application/json");
        Assert.assertEquals((long)response.getCode(), (long)404L);
        TestGetAndPutResource.checkValueJSON("TestRowResource", "testrow1", "a:1", "testvalue1");
        TestGetAndPutResource.checkValueJSON("TestRowResource", "testrow1", "b:2", "testvalue2");
        TestGetAndPutResource.checkValueJSON("TestRowResource", "testrow2", "a:1", "testvalue3");
        TestGetAndPutResource.checkValueJSON("TestRowResource", "testrow2", "b:2", "testvalue4");
        response = TestGetAndPutResource.deleteRow("TestRowResource", "testrow1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestGetAndPutResource.deleteRow("TestRowResource", "testrow2");
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testMetrics() throws IOException, JAXBException {
        String path = "/TestRowResource/testrow4/a:1";
        Response response = client.put("/TestRowResource/testrow4/a:1", "application/octet-stream", Bytes.toBytes((String)"testvalue4"));
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Thread.yield();
        response = client.get("/TestRowResource/testrow4/a:1", "application/json");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"application/json", (Object)response.getHeader("content-type"));
        response = TestGetAndPutResource.deleteRow("TestRowResource", "testrow4");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        UserProvider userProvider = UserProvider.instantiate((Configuration)conf);
        METRICS_ASSERT.assertCounterGt("requests", 2L, (BaseSource)RESTServlet.getInstance((Configuration)conf, (UserProvider)userProvider).getMetrics().getSource());
        METRICS_ASSERT.assertCounterGt("successfulGet", 0L, (BaseSource)RESTServlet.getInstance((Configuration)conf, (UserProvider)userProvider).getMetrics().getSource());
        METRICS_ASSERT.assertCounterGt("successfulPut", 0L, (BaseSource)RESTServlet.getInstance((Configuration)conf, (UserProvider)userProvider).getMetrics().getSource());
        METRICS_ASSERT.assertCounterGt("successfulDelete", 0L, (BaseSource)RESTServlet.getInstance((Configuration)conf, (UserProvider)userProvider).getMetrics().getSource());
    }

    @Test
    public void testMultiColumnGetXML() throws Exception {
        String path = "/TestRowResource/fakerow";
        CellSetModel cellSetModel = new CellSetModel();
        RowModel rowModel = new RowModel("testrow1");
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"a:1"), Bytes.toBytes((String)"testvalue1")));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"b:2"), Bytes.toBytes((String)"testvalue2")));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"a:"), Bytes.toBytes((String)"testvalue2")));
        cellSetModel.addRow(rowModel);
        StringWriter writer = new StringWriter();
        xmlMarshaller.marshal((Object)cellSetModel, (Writer)writer);
        Response response = client.put(path, "text/xml", Bytes.toBytes((String)writer.toString()));
        Thread.yield();
        response = client.get(path, "text/xml");
        Assert.assertEquals((long)response.getCode(), (long)404L);
        path = "/TestRowResource/testrow1/a:1,b:2,a:";
        response = client.get(path, "text/xml");
        Assert.assertEquals((long)200L, (long)response.getCode());
        CellSetModel cellSet = (CellSetModel)xmlUnmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        Assert.assertTrue((cellSet.getRows().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((RowModel)cellSet.getRows().get(0)).getCells().size() == 3 ? 1 : 0) != 0);
        List cells = ((RowModel)cellSet.getRows().get(0)).getCells();
        Assert.assertTrue((boolean)this.containsCellModel(cells, "a:1", "testvalue1"));
        Assert.assertTrue((boolean)this.containsCellModel(cells, "b:2", "testvalue2"));
        Assert.assertTrue((boolean)this.containsCellModel(cells, "a:", "testvalue2"));
        response = TestGetAndPutResource.deleteRow("TestRowResource", "testrow1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    private boolean containsCellModel(List<CellModel> cells, String column, String value) {
        boolean contains = false;
        for (CellModel cell : cells) {
            if (!Bytes.toString((byte[])cell.getColumn()).equals(column) || !Bytes.toString((byte[])cell.getValue()).equals(value)) continue;
            contains = true;
            return contains;
        }
        return contains;
    }

    @Test
    public void testSuffixGlobbingXMLWithNewScanner() throws IOException, JAXBException {
        String path = "/TestRowResource/fakerow";
        CellSetModel cellSetModel = new CellSetModel();
        RowModel rowModel = new RowModel("testrow1");
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"a:1"), Bytes.toBytes((String)"testvalue1")));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"b:2"), Bytes.toBytes((String)"testvalue2")));
        cellSetModel.addRow(rowModel);
        rowModel = new RowModel("testrow2");
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"a:1"), Bytes.toBytes((String)"testvalue3")));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"b:2"), Bytes.toBytes((String)"testvalue4")));
        cellSetModel.addRow(rowModel);
        StringWriter writer = new StringWriter();
        xmlMarshaller.marshal((Object)cellSetModel, (Writer)writer);
        Response response = client.put(path, "text/xml", Bytes.toBytes((String)writer.toString()));
        Thread.yield();
        response = client.get(path, "text/xml");
        Assert.assertEquals((long)response.getCode(), (long)404L);
        StringBuilder query = new StringBuilder();
        query.append('/');
        query.append("TestRowResource");
        query.append('/');
        query.append("testrow*");
        response = client.get(query.toString(), "text/xml");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        CellSetModel cellSet = (CellSetModel)xmlUnmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        Assert.assertTrue((cellSet.getRows().size() == 2 ? 1 : 0) != 0);
        response = TestGetAndPutResource.deleteRow("TestRowResource", "testrow1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestGetAndPutResource.deleteRow("TestRowResource", "testrow2");
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    @Test
    public void testSuffixGlobbingXML() throws IOException, JAXBException {
        String path = "/TestRowResource/fakerow";
        CellSetModel cellSetModel = new CellSetModel();
        RowModel rowModel = new RowModel("testrow1");
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"a:1"), Bytes.toBytes((String)"testvalue1")));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"b:2"), Bytes.toBytes((String)"testvalue2")));
        cellSetModel.addRow(rowModel);
        rowModel = new RowModel("testrow2");
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"a:1"), Bytes.toBytes((String)"testvalue3")));
        rowModel.addCell(new CellModel(Bytes.toBytes((String)"b:2"), Bytes.toBytes((String)"testvalue4")));
        cellSetModel.addRow(rowModel);
        StringWriter writer = new StringWriter();
        xmlMarshaller.marshal((Object)cellSetModel, (Writer)writer);
        Response response = client.put(path, "text/xml", Bytes.toBytes((String)writer.toString()));
        Thread.yield();
        response = client.get(path, "text/xml");
        Assert.assertEquals((long)response.getCode(), (long)404L);
        StringBuilder query = new StringBuilder();
        query.append('/');
        query.append("TestRowResource");
        query.append('/');
        query.append("testrow*");
        query.append('/');
        query.append("a:1");
        response = client.get(query.toString(), "text/xml");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        CellSetModel cellSet = (CellSetModel)xmlUnmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        List rows = cellSet.getRows();
        Assert.assertTrue((rows.size() == 2 ? 1 : 0) != 0);
        for (RowModel row : rows) {
            Assert.assertTrue((row.getCells().size() == 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"a:1", (Object)Bytes.toString((byte[])((CellModel)row.getCells().get(0)).getColumn()));
        }
        response = TestGetAndPutResource.deleteRow("TestRowResource", "testrow1");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        response = TestGetAndPutResource.deleteRow("TestRowResource", "testrow2");
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }
}

