/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.SimpleScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityController;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestVisibilityWithCheckAuths {
    private static final String TOPSECRET = "TOPSECRET";
    private static final String PUBLIC = "PUBLIC";
    public static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] row1 = Bytes.toBytes((String)"row1");
    private static final byte[] fam = Bytes.toBytes((String)"info");
    private static final byte[] qual = Bytes.toBytes((String)"qual");
    private static final byte[] value = Bytes.toBytes((String)"value");
    public static Configuration conf;
    @Rule
    public final TestName TEST_NAME = new TestName();
    public static User SUPERUSER;
    public static User USER;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.master.distributed.log.replay", false);
        conf.setInt("hfile.format.version", 3);
        conf.set("hbase.coprocessor.master.classes", VisibilityController.class.getName());
        conf.set("hbase.coprocessor.region.classes", VisibilityController.class.getName());
        conf.setBoolean("hbase.security.visibility.mutations.checkauths", true);
        conf.setClass("hbase.regionserver.scan.visibility.label.generator.class", SimpleScanLabelGenerator.class, ScanLabelGenerator.class);
        conf.set("hbase.superuser", "admin");
        TEST_UTIL.startMiniCluster(2);
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        USER = User.createUserForTesting((Configuration)conf, (String)"user", (String[])new String[0]);
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        TestVisibilityWithCheckAuths.addLabels();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    public static void addLabels() throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                String[] labels = new String[]{TestVisibilityWithCheckAuths.TOPSECRET};
                try {
                    VisibilityClient.addLabels((Configuration)conf, (String[])labels);
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
                return null;
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
    }

    @Test
    public void testVerifyAccessDeniedForInvalidUserAuths() throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try {
                    return VisibilityClient.setAuths((Configuration)conf, (String[])new String[]{TestVisibilityWithCheckAuths.TOPSECRET}, (String)USER.getShortName());
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HBaseAdmin hBaseAdmin = TEST_UTIL.getHBaseAdmin();
        HColumnDescriptor colDesc = new HColumnDescriptor(fam);
        colDesc.setMaxVersions(5);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(colDesc);
        hBaseAdmin.createTable(desc);
        Object table = null;
        try {
            TEST_UTIL.getHBaseAdmin().flush(tableName.getNameAsString());
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    HTable table = null;
                    try {
                        table = new HTable(conf, TestVisibilityWithCheckAuths.this.TEST_NAME.getMethodName());
                        Put p = new Put(row1);
                        p.setCellVisibility(new CellVisibility("PUBLIC&TOPSECRET"));
                        p.add(fam, qual, 125L, value);
                        table.put(p);
                        Assert.fail((String)"Testcase should fail with AccesDeniedException");
                    }
                    catch (Throwable t) {
                        Assert.assertTrue((boolean)t.getMessage().contains("AccessDeniedException"));
                    }
                    finally {
                        table.close();
                    }
                    return null;
                }
            };
            USER.runAs((PrivilegedExceptionAction)actiona);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLabelsWithAppend() throws Throwable {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try {
                    return VisibilityClient.setAuths((Configuration)conf, (String[])new String[]{TestVisibilityWithCheckAuths.TOPSECRET}, (String)USER.getShortName());
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        };
        SUPERUSER.runAs((PrivilegedExceptionAction)action);
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        HTable table = null;
        try {
            table = TEST_UTIL.createTable(tableName, fam);
            final byte[] row1 = Bytes.toBytes((String)"row1");
            final byte[] val = Bytes.toBytes((String)"a");
            PrivilegedExceptionAction<Void> actiona = new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    HTable table = null;
                    try {
                        table = new HTable(conf, TestVisibilityWithCheckAuths.this.TEST_NAME.getMethodName());
                        Put put = new Put(row1);
                        put.add(fam, qual, Long.MAX_VALUE, val);
                        put.setCellVisibility(new CellVisibility(TestVisibilityWithCheckAuths.TOPSECRET));
                        table.put(put);
                    }
                    finally {
                        table.close();
                    }
                    return null;
                }
            };
            USER.runAs((PrivilegedExceptionAction)actiona);
            actiona = new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    HTable table = null;
                    try {
                        table = new HTable(conf, TestVisibilityWithCheckAuths.this.TEST_NAME.getMethodName());
                        Append append = new Append(row1);
                        append.add(fam, qual, Bytes.toBytes((String)"b"));
                        table.append(append);
                    }
                    finally {
                        table.close();
                    }
                    return null;
                }
            };
            USER.runAs((PrivilegedExceptionAction)actiona);
            actiona = new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    HTable table = null;
                    try {
                        table = new HTable(conf, TestVisibilityWithCheckAuths.this.TEST_NAME.getMethodName());
                        Append append = new Append(row1);
                        append.add(fam, qual, Bytes.toBytes((String)"c"));
                        append.setCellVisibility(new CellVisibility(TestVisibilityWithCheckAuths.PUBLIC));
                        table.append(append);
                        Assert.fail((String)"Testcase should fail with AccesDeniedException");
                    }
                    catch (Throwable t) {
                        Assert.assertTrue((boolean)t.getMessage().contains("AccessDeniedException"));
                    }
                    finally {
                        table.close();
                    }
                    return null;
                }
            };
            USER.runAs((PrivilegedExceptionAction)actiona);
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }
}

