/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RegionSizeCalculator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestRegionSizeCalculator {
    private Configuration configuration = new Configuration();
    private final long megabyte = 0x100000L;

    @Test
    public void testSimpleTestCase() throws Exception {
        HTable table = this.mockTable("region1", "region2", "region3");
        HBaseAdmin admin = this.mockAdmin(this.mockServer(this.mockRegion("region1", 123), this.mockRegion("region3", 1232)), this.mockServer(this.mockRegion("region2", 54321), this.mockRegion("otherTableRegion", 110)));
        RegionSizeCalculator calculator = new RegionSizeCalculator(table, admin);
        Assert.assertEquals((long)0x7B00000L, (long)calculator.getRegionSize("region1".getBytes()));
        Assert.assertEquals((long)56959696896L, (long)calculator.getRegionSize("region2".getBytes()));
        Assert.assertEquals((long)0x4D000000L, (long)calculator.getRegionSize("region3".getBytes()));
        Assert.assertEquals((long)0L, (long)calculator.getRegionSize("otherTableRegion".getBytes()));
        Assert.assertEquals((long)3L, (long)calculator.getRegionSizeMap().size());
    }

    @Test
    public void testLargeRegion() throws Exception {
        HTable table = this.mockTable("largeRegion");
        HBaseAdmin admin = this.mockAdmin(this.mockServer(this.mockRegion("largeRegion", Integer.MAX_VALUE)));
        RegionSizeCalculator calculator = new RegionSizeCalculator(table, admin);
        Assert.assertEquals((long)0x7FFFFFFF00000L, (long)calculator.getRegionSize("largeRegion".getBytes()));
    }

    @Test
    public void testDisabled() throws Exception {
        String regionName = "cz.goout:/index.html";
        HTable table = this.mockTable(regionName);
        HBaseAdmin admin = this.mockAdmin(this.mockServer(this.mockRegion(regionName, 999)));
        RegionSizeCalculator calculator = new RegionSizeCalculator(table, admin);
        Assert.assertEquals((long)1047527424L, (long)calculator.getRegionSize(regionName.getBytes()));
        this.configuration.setBoolean("hbase.regionsizecalculator.enable", false);
        RegionSizeCalculator disabledCalculator = new RegionSizeCalculator(table, admin);
        Assert.assertEquals((long)0L, (long)disabledCalculator.getRegionSize(regionName.getBytes()));
        Assert.assertEquals((long)0L, (long)disabledCalculator.getRegionSizeMap().size());
    }

    private HTable mockTable(String ... regionNames) throws IOException {
        HTable mockedTable = (HTable)Mockito.mock(HTable.class);
        Mockito.when((Object)mockedTable.getConfiguration()).thenReturn((Object)this.configuration);
        Mockito.when((Object)mockedTable.getTableName()).thenReturn((Object)"sizeTestTable".getBytes());
        TreeMap<HRegionInfo, Object> regionLocations = new TreeMap<HRegionInfo, Object>();
        Mockito.when((Object)mockedTable.getRegionLocations()).thenReturn(regionLocations);
        for (String regionName : regionNames) {
            HRegionInfo info = (HRegionInfo)Mockito.mock(HRegionInfo.class);
            Mockito.when((Object)info.getRegionName()).thenReturn((Object)regionName.getBytes());
            regionLocations.put(info, null);
        }
        return mockedTable;
    }

    private HBaseAdmin mockAdmin(ServerLoad ... servers) throws Exception {
        HBaseAdmin mockAdmin = (HBaseAdmin)Mockito.mock(HBaseAdmin.class);
        ClusterStatus clusterStatus = this.mockCluster(servers);
        Mockito.when((Object)mockAdmin.getClusterStatus()).thenReturn((Object)clusterStatus);
        return mockAdmin;
    }

    private RegionLoad mockRegion(String regionName, int fileSizeMb) {
        RegionLoad region = (RegionLoad)Mockito.mock(RegionLoad.class);
        Mockito.when((Object)region.getName()).thenReturn((Object)regionName.getBytes());
        Mockito.when((Object)region.getNameAsString()).thenReturn((Object)regionName);
        Mockito.when((Object)region.getStorefileSizeMB()).thenReturn((Object)fileSizeMb);
        return region;
    }

    private ClusterStatus mockCluster(ServerLoad[] servers) {
        ArrayList<ServerName> serverNames = new ArrayList<ServerName>();
        ClusterStatus clusterStatus = (ClusterStatus)Mockito.mock(ClusterStatus.class);
        Mockito.when((Object)clusterStatus.getServers()).thenReturn(serverNames);
        int serverCounter = 0;
        for (ServerLoad server : servers) {
            ServerName serverName = (ServerName)Mockito.mock(ServerName.class);
            Mockito.when((Object)serverName.getServerName()).thenReturn((Object)("server" + serverCounter++));
            serverNames.add(serverName);
            Mockito.when((Object)clusterStatus.getLoad(serverName)).thenReturn((Object)server);
        }
        return clusterStatus;
    }

    private ServerLoad mockServer(RegionLoad ... regions) {
        ServerLoad serverLoad = (ServerLoad)Mockito.mock(ServerLoad.class);
        TreeMap<byte[], RegionLoad> regionMap = new TreeMap<byte[], RegionLoad>(Bytes.BYTES_COMPARATOR);
        for (RegionLoad regionName : regions) {
            regionMap.put(regionName.getName(), regionName);
        }
        Mockito.when((Object)serverLoad.getRegionsLoad()).thenReturn(regionMap);
        return serverLoad;
    }
}

