/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.zookeeper.TestZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZKTable;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestZKTable {
    private static final Log LOG = LogFactory.getLog(TestZooKeeperNodeTracker.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testTableStates() throws ZooKeeperConnectionException, IOException, KeeperException {
        TableName name = TableName.valueOf((String)"testDisabled");
        Abortable abortable = new Abortable(){

            public void abort(String why, Throwable e) {
                LOG.info((Object)why, e);
            }

            public boolean isAborted() {
                return false;
            }
        };
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), name.getNameAsString(), abortable, true);
        ZKTable zkt = new ZKTable(zkw);
        Assert.assertFalse((boolean)zkt.isEnabledTable(name));
        Assert.assertFalse((boolean)zkt.isDisablingTable(name));
        Assert.assertFalse((boolean)zkt.isDisabledTable(name));
        Assert.assertFalse((boolean)zkt.isEnablingTable(name));
        Assert.assertFalse((boolean)zkt.isDisablingOrDisabledTable(name));
        Assert.assertFalse((boolean)zkt.isDisabledOrEnablingTable(name));
        Assert.assertFalse((boolean)zkt.isTablePresent(name));
        zkt.setDisablingTable(name);
        Assert.assertTrue((boolean)zkt.isDisablingTable(name));
        Assert.assertTrue((boolean)zkt.isDisablingOrDisabledTable(name));
        Assert.assertFalse((boolean)zkt.getDisabledTables().contains(name));
        Assert.assertTrue((boolean)zkt.isTablePresent(name));
        zkt.setDisabledTable(name);
        Assert.assertTrue((boolean)zkt.isDisabledTable(name));
        Assert.assertTrue((boolean)zkt.isDisablingOrDisabledTable(name));
        Assert.assertFalse((boolean)zkt.isDisablingTable(name));
        Assert.assertTrue((boolean)zkt.getDisabledTables().contains(name));
        Assert.assertTrue((boolean)zkt.isTablePresent(name));
        zkt.setEnablingTable(name);
        Assert.assertTrue((boolean)zkt.isEnablingTable(name));
        Assert.assertTrue((boolean)zkt.isDisabledOrEnablingTable(name));
        Assert.assertFalse((boolean)zkt.isDisabledTable(name));
        Assert.assertFalse((boolean)zkt.getDisabledTables().contains(name));
        Assert.assertTrue((boolean)zkt.isTablePresent(name));
        zkt.setEnabledTable(name);
        Assert.assertTrue((boolean)zkt.isEnabledTable(name));
        Assert.assertFalse((boolean)zkt.isEnablingTable(name));
        Assert.assertTrue((boolean)zkt.isTablePresent(name));
        zkt.setDeletedTable(name);
        Assert.assertFalse((boolean)zkt.isEnabledTable(name));
        Assert.assertFalse((boolean)zkt.isDisablingTable(name));
        Assert.assertFalse((boolean)zkt.isDisabledTable(name));
        Assert.assertFalse((boolean)zkt.isEnablingTable(name));
        Assert.assertFalse((boolean)zkt.isDisablingOrDisabledTable(name));
        Assert.assertFalse((boolean)zkt.isDisabledOrEnablingTable(name));
        Assert.assertFalse((boolean)zkt.isTablePresent(name));
    }
}

