/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializerIdManager;
import org.apache.hadoop.hbase.io.hfile.ChecksumUtil;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
public class HFileBlock
implements Cacheable {
    static final int CHECKSUM_VERIFICATION_NUM_IO_THRESHOLD = 3;
    public static final boolean FILL_HEADER = true;
    public static final boolean DONT_FILL_HEADER = false;
    public static final int ENCODED_HEADER_SIZE = 35;
    static final byte[] DUMMY_HEADER_NO_CHECKSUM = new byte[24];
    public static final int BYTE_BUFFER_HEAP_SIZE = (int)ClassSize.estimateBase(ByteBuffer.wrap(new byte[0], 0, 0).getClass(), (boolean)false);
    public static final int EXTRA_SERIALIZATION_SPACE = 13;
    static final int CHECKSUM_SIZE = 4;
    private static final CacheableDeserializer<Cacheable> blockDeserializer = new CacheableDeserializer<Cacheable>(){

        @Override
        public HFileBlock deserialize(ByteBuffer buf, boolean reuse) throws IOException {
            ByteBuffer newByteBuffer;
            buf.limit(buf.limit() - 13).rewind();
            if (reuse) {
                newByteBuffer = buf.slice();
            } else {
                newByteBuffer = ByteBuffer.allocate(buf.limit());
                newByteBuffer.put(buf);
            }
            buf.position(buf.limit());
            buf.limit(buf.limit() + 13);
            boolean usesChecksum = buf.get() == 1;
            HFileBlock ourBuffer = new HFileBlock(newByteBuffer, usesChecksum);
            ourBuffer.offset = buf.getLong();
            ourBuffer.nextBlockOnDiskSizeWithHeader = buf.getInt();
            return ourBuffer;
        }

        @Override
        public int getDeserialiserIdentifier() {
            return deserializerIdentifier;
        }

        @Override
        public HFileBlock deserialize(ByteBuffer b) throws IOException {
            return this.deserialize(b, false);
        }
    };
    private static final int deserializerIdentifier = CacheableDeserializerIdManager.registerDeserializer(blockDeserializer);
    private BlockType blockType;
    private int onDiskSizeWithoutHeader;
    private final int uncompressedSizeWithoutHeader;
    private final long prevBlockOffset;
    private final int onDiskDataSizeWithHeader;
    private ByteBuffer buf;
    private HFileContext fileContext;
    private long offset = -1L;
    private int nextBlockOnDiskSizeWithHeader = -1;

    HFileBlock(BlockType blockType, int onDiskSizeWithoutHeader, int uncompressedSizeWithoutHeader, long prevBlockOffset, ByteBuffer buf, boolean fillHeader, long offset, int onDiskDataSizeWithHeader, HFileContext fileContext) {
        this.blockType = blockType;
        this.onDiskSizeWithoutHeader = onDiskSizeWithoutHeader;
        this.uncompressedSizeWithoutHeader = uncompressedSizeWithoutHeader;
        this.prevBlockOffset = prevBlockOffset;
        this.buf = buf;
        if (fillHeader) {
            this.overwriteHeader();
        }
        this.offset = offset;
        this.onDiskDataSizeWithHeader = onDiskDataSizeWithHeader;
        this.fileContext = fileContext;
    }

    HFileBlock(ByteBuffer b, boolean usesHBaseChecksum) throws IOException {
        b.rewind();
        this.blockType = BlockType.read((ByteBuffer)b);
        this.onDiskSizeWithoutHeader = b.getInt();
        this.uncompressedSizeWithoutHeader = b.getInt();
        this.prevBlockOffset = b.getLong();
        HFileContextBuilder contextBuilder = new HFileContextBuilder();
        contextBuilder.withHBaseCheckSum(usesHBaseChecksum);
        if (usesHBaseChecksum) {
            contextBuilder.withChecksumType(ChecksumType.codeToType((byte)b.get()));
            contextBuilder.withBytesPerCheckSum(b.getInt());
            this.onDiskDataSizeWithHeader = b.getInt();
        } else {
            contextBuilder.withChecksumType(ChecksumType.NULL);
            contextBuilder.withBytesPerCheckSum(0);
            this.onDiskDataSizeWithHeader = this.onDiskSizeWithoutHeader + 24;
        }
        this.fileContext = contextBuilder.build();
        this.buf = b;
        this.buf.rewind();
    }

    @Override
    public BlockType getBlockType() {
        return this.blockType;
    }

    public short getDataBlockEncodingId() {
        if (this.blockType != BlockType.ENCODED_DATA) {
            throw new IllegalArgumentException("Querying encoder ID of a block of type other than " + BlockType.ENCODED_DATA + ": " + this.blockType);
        }
        return this.buf.getShort(this.headerSize());
    }

    public int getOnDiskSizeWithHeader() {
        return this.onDiskSizeWithoutHeader + this.headerSize();
    }

    public int getOnDiskSizeWithoutHeader() {
        return this.onDiskSizeWithoutHeader;
    }

    public int getUncompressedSizeWithoutHeader() {
        return this.uncompressedSizeWithoutHeader;
    }

    public long getPrevBlockOffset() {
        return this.prevBlockOffset;
    }

    private void overwriteHeader() {
        this.buf.rewind();
        this.blockType.write(this.buf);
        this.buf.putInt(this.onDiskSizeWithoutHeader);
        this.buf.putInt(this.uncompressedSizeWithoutHeader);
        this.buf.putLong(this.prevBlockOffset);
    }

    public ByteBuffer getBufferWithoutHeader() {
        return ByteBuffer.wrap(this.buf.array(), this.buf.arrayOffset() + this.headerSize(), this.buf.limit() - this.headerSize() - this.totalChecksumBytes()).slice();
    }

    public ByteBuffer getBufferReadOnly() {
        return ByteBuffer.wrap(this.buf.array(), this.buf.arrayOffset(), this.buf.limit() - this.totalChecksumBytes()).slice();
    }

    public ByteBuffer getBufferReadOnlyWithHeader() {
        return ByteBuffer.wrap(this.buf.array(), this.buf.arrayOffset(), this.buf.limit()).slice();
    }

    ByteBuffer getBufferWithHeader() {
        ByteBuffer dupBuf = this.buf.duplicate();
        dupBuf.rewind();
        return dupBuf;
    }

    private void sanityCheckAssertion(long valueFromBuf, long valueFromField, String fieldName) throws IOException {
        if (valueFromBuf != valueFromField) {
            throw new AssertionError((Object)(fieldName + " in the buffer (" + valueFromBuf + ") is different from that in the field (" + valueFromField + ")"));
        }
    }

    void sanityCheck() throws IOException {
        this.buf.rewind();
        BlockType blockTypeFromBuf = BlockType.read((ByteBuffer)this.buf);
        if (blockTypeFromBuf != this.blockType) {
            throw new IOException("Block type stored in the buffer: " + blockTypeFromBuf + ", block type field: " + this.blockType);
        }
        this.sanityCheckAssertion(this.buf.getInt(), this.onDiskSizeWithoutHeader, "onDiskSizeWithoutHeader");
        this.sanityCheckAssertion(this.buf.getInt(), this.uncompressedSizeWithoutHeader, "uncompressedSizeWithoutHeader");
        this.sanityCheckAssertion(this.buf.getLong(), this.prevBlockOffset, "prevBlocKOffset");
        if (this.fileContext.isUseHBaseChecksum()) {
            this.sanityCheckAssertion(this.buf.get(), this.fileContext.getChecksumType().getCode(), "checksumType");
            this.sanityCheckAssertion(this.buf.getInt(), this.fileContext.getBytesPerChecksum(), "bytesPerChecksum");
            this.sanityCheckAssertion(this.buf.getInt(), this.onDiskDataSizeWithHeader, "onDiskDataSizeWithHeader");
        }
        int cksumBytes = this.totalChecksumBytes();
        int hdrSize = this.headerSize();
        int expectedBufLimit = this.uncompressedSizeWithoutHeader + this.headerSize() + cksumBytes;
        if (this.buf.limit() != expectedBufLimit) {
            throw new AssertionError((Object)("Expected buffer limit " + expectedBufLimit + ", got " + this.buf.limit()));
        }
        int size = this.uncompressedSizeWithoutHeader + hdrSize + cksumBytes;
        if (this.buf.capacity() != size && this.buf.capacity() != size + hdrSize) {
            throw new AssertionError((Object)("Invalid buffer capacity: " + this.buf.capacity() + ", expected " + size + " or " + (size + hdrSize)));
        }
    }

    public String toString() {
        return "blockType=" + this.blockType + ", onDiskSizeWithoutHeader=" + this.onDiskSizeWithoutHeader + ", uncompressedSizeWithoutHeader=" + this.uncompressedSizeWithoutHeader + ", prevBlockOffset=" + this.prevBlockOffset + ", dataBeginsWith=" + Bytes.toStringBinary((byte[])this.buf.array(), (int)(this.buf.arrayOffset() + this.headerSize()), (int)Math.min(32, this.buf.limit() - this.buf.arrayOffset() - this.headerSize())) + ", fileOffset=" + this.offset;
    }

    private void validateOnDiskSizeWithoutHeader(int expectedOnDiskSizeWithoutHeader) throws IOException {
        if (this.onDiskSizeWithoutHeader != expectedOnDiskSizeWithoutHeader) {
            String blockInfoMsg = "Block offset: " + this.offset + ", data starts with: " + Bytes.toStringBinary((byte[])this.buf.array(), (int)this.buf.arrayOffset(), (int)(this.buf.arrayOffset() + Math.min(32, this.buf.limit())));
            throw new IOException("On-disk size without header provided is " + expectedOnDiskSizeWithoutHeader + ", but block " + "header contains " + this.onDiskSizeWithoutHeader + ". " + blockInfoMsg);
        }
    }

    private void allocateBuffer(boolean extraBytes) {
        int cksumBytes = this.totalChecksumBytes();
        int capacityNeeded = this.headerSize() + this.uncompressedSizeWithoutHeader + cksumBytes + (extraBytes ? this.headerSize() : 0);
        ByteBuffer newBuf = ByteBuffer.allocate(capacityNeeded);
        System.arraycopy(this.buf.array(), this.buf.arrayOffset(), newBuf.array(), newBuf.arrayOffset(), this.headerSize());
        this.buf = newBuf;
        this.buf.limit(this.headerSize() + this.uncompressedSizeWithoutHeader + cksumBytes);
    }

    public void assumeUncompressed() throws IOException {
        if (this.onDiskSizeWithoutHeader != this.uncompressedSizeWithoutHeader + this.totalChecksumBytes()) {
            throw new IOException("Using no compression but onDiskSizeWithoutHeader=" + this.onDiskSizeWithoutHeader + ", " + "uncompressedSizeWithoutHeader=" + this.uncompressedSizeWithoutHeader + ", numChecksumbytes=" + this.totalChecksumBytes());
        }
    }

    public void expectType(BlockType expectedType) throws IOException {
        if (this.blockType != expectedType) {
            throw new IOException("Invalid block type: expected=" + expectedType + ", actual=" + this.blockType);
        }
    }

    public long getOffset() {
        if (this.offset < 0L) {
            throw new IllegalStateException("HFile block offset not initialized properly");
        }
        return this.offset;
    }

    public DataInputStream getByteStream() {
        return new DataInputStream(new ByteArrayInputStream(this.buf.array(), this.buf.arrayOffset() + this.headerSize(), this.buf.limit() - this.headerSize()));
    }

    public long heapSize() {
        long size = ClassSize.align((long)((long)(ClassSize.OBJECT + 3 * ClassSize.REFERENCE + 16 + 16) + this.fileContext.heapSize()));
        if (this.buf != null) {
            size += (long)ClassSize.align((int)(this.buf.capacity() + BYTE_BUFFER_HEAP_SIZE));
        }
        return ClassSize.align((long)size);
    }

    public static boolean readWithExtra(InputStream in, byte[] buf, int bufOffset, int necessaryLen, int extraLen) throws IOException {
        int bytesRemaining;
        int ret;
        for (bytesRemaining = necessaryLen + extraLen; bytesRemaining > 0 && ((ret = in.read(buf, bufOffset, bytesRemaining)) != -1 || bytesRemaining > extraLen); bytesRemaining -= ret) {
            if (ret < 0) {
                throw new IOException("Premature EOF from inputStream (read returned " + ret + ", was trying to read " + necessaryLen + " necessary bytes and " + extraLen + " extra bytes, " + "successfully read " + (necessaryLen + extraLen - bytesRemaining));
            }
            bufOffset += ret;
        }
        return bytesRemaining <= 0;
    }

    public int getNextBlockOnDiskSizeWithHeader() {
        return this.nextBlockOnDiskSizeWithHeader;
    }

    @Override
    public int getSerializedLength() {
        if (this.buf != null) {
            return this.buf.limit() + 13;
        }
        return 0;
    }

    @Override
    public void serialize(ByteBuffer destination) {
        ByteBuffer dupBuf = this.buf.duplicate();
        dupBuf.rewind();
        destination.put(dupBuf);
        this.serializeExtraInfo(destination);
    }

    public void serializeExtraInfo(ByteBuffer destination) {
        destination.put(this.fileContext.isUseHBaseChecksum() ? (byte)1 : 0);
        destination.putLong(this.offset);
        destination.putInt(this.nextBlockOnDiskSizeWithHeader);
        destination.rewind();
    }

    @Override
    public CacheableDeserializer<Cacheable> getDeserializer() {
        return blockDeserializer;
    }

    public boolean equals(Object comparison) {
        if (this == comparison) {
            return true;
        }
        if (comparison == null) {
            return false;
        }
        if (comparison.getClass() != this.getClass()) {
            return false;
        }
        HFileBlock castedComparison = (HFileBlock)comparison;
        if (castedComparison.blockType != this.blockType) {
            return false;
        }
        if (castedComparison.nextBlockOnDiskSizeWithHeader != this.nextBlockOnDiskSizeWithHeader) {
            return false;
        }
        if (castedComparison.offset != this.offset) {
            return false;
        }
        if (castedComparison.onDiskSizeWithoutHeader != this.onDiskSizeWithoutHeader) {
            return false;
        }
        if (castedComparison.prevBlockOffset != this.prevBlockOffset) {
            return false;
        }
        if (castedComparison.uncompressedSizeWithoutHeader != this.uncompressedSizeWithoutHeader) {
            return false;
        }
        if (this.buf.compareTo(castedComparison.buf) != 0) {
            return false;
        }
        if (this.buf.position() != castedComparison.buf.position()) {
            return false;
        }
        return this.buf.limit() == castedComparison.buf.limit();
    }

    public DataBlockEncoding getDataBlockEncoding() {
        if (this.blockType == BlockType.ENCODED_DATA) {
            return DataBlockEncoding.getEncodingById((short)this.getDataBlockEncodingId());
        }
        return DataBlockEncoding.NONE;
    }

    byte getChecksumType() {
        return this.fileContext.getChecksumType().getCode();
    }

    int getBytesPerChecksum() {
        return this.fileContext.getBytesPerChecksum();
    }

    int getOnDiskDataSizeWithHeader() {
        return this.onDiskDataSizeWithHeader;
    }

    int totalChecksumBytes() {
        if (!this.fileContext.isUseHBaseChecksum() || this.fileContext.getBytesPerChecksum() == 0) {
            return 0;
        }
        return (int)ChecksumUtil.numBytes(this.onDiskDataSizeWithHeader, this.fileContext.getBytesPerChecksum());
    }

    public int headerSize() {
        return HFileBlock.headerSize(this.fileContext.isUseHBaseChecksum());
    }

    public static int headerSize(boolean usesHBaseChecksum) {
        if (usesHBaseChecksum) {
            return 33;
        }
        return 24;
    }

    public byte[] getDummyHeaderForVersion() {
        return HFileBlock.getDummyHeaderForVersion(this.fileContext.isUseHBaseChecksum());
    }

    private static byte[] getDummyHeaderForVersion(boolean usesHBaseChecksum) {
        if (usesHBaseChecksum) {
            return HConstants.HFILEBLOCK_DUMMY_HEADER;
        }
        return DUMMY_HEADER_NO_CHECKSUM;
    }

    public HFileContext getHFileContext() {
        return this.fileContext;
    }

    static String toStringHeader(ByteBuffer buf) throws IOException {
        int offset = buf.arrayOffset();
        byte[] b = buf.array();
        long magic = Bytes.toLong((byte[])b, (int)offset);
        BlockType bt = BlockType.read((ByteBuffer)buf);
        int compressedBlockSizeNoHeader = Bytes.toInt((byte[])b, (int)(offset += 8));
        int uncompressedBlockSizeNoHeader = Bytes.toInt((byte[])b, (int)(offset += 4));
        long prevBlockOffset = Bytes.toLong((byte[])b, (int)(offset += 4));
        byte cksumtype = b[offset += 8];
        long bytesPerChecksum = Bytes.toInt((byte[])b, (int)(++offset));
        long onDiskDataSizeWithHeader = Bytes.toInt((byte[])b, (int)(offset += 4));
        offset += 4;
        return " Header dump: magic: " + magic + " blockType " + bt + " compressedBlockSizeNoHeader " + compressedBlockSizeNoHeader + " uncompressedBlockSizeNoHeader " + uncompressedBlockSizeNoHeader + " prevBlockOffset " + prevBlockOffset + " checksumType " + ChecksumType.codeToType((byte)cksumtype) + " bytesPerChecksum " + bytesPerChecksum + " onDiskDataSizeWithHeader " + onDiskDataSizeWithHeader;
    }

    static class FSReaderV2
    extends AbstractFSReader {
        protected FSDataInputStreamWrapper streamWrapper;
        private HFileBlockDecodingContext encodedBlockDecodingCtx;
        private HFileBlockDefaultDecodingContext defaultDecodingCtx;
        private ThreadLocal<PrefetchedHeader> prefetchedHeaderForThread = new ThreadLocal<PrefetchedHeader>(){

            @Override
            public PrefetchedHeader initialValue() {
                return new PrefetchedHeader();
            }
        };

        public FSReaderV2(FSDataInputStreamWrapper stream, long fileSize, HFileSystem hfs, Path path, HFileContext fileContext) throws IOException {
            super(fileSize, hfs, path, fileContext);
            this.streamWrapper = stream;
            this.streamWrapper.prepareForBlockReader(!fileContext.isUseHBaseChecksum());
            this.defaultDecodingCtx = new HFileBlockDefaultDecodingContext(fileContext);
            this.encodedBlockDecodingCtx = new HFileBlockDefaultDecodingContext(fileContext);
        }

        FSReaderV2(FSDataInputStream istream, long fileSize, HFileContext fileContext) throws IOException {
            this(new FSDataInputStreamWrapper(istream), fileSize, null, null, fileContext);
        }

        @Override
        public HFileBlock readBlockData(long offset, long onDiskSizeWithHeaderL, int uncompressedSize, boolean pread) throws IOException {
            boolean doVerificationThruHBaseChecksum = this.streamWrapper.shouldUseHBaseChecksum();
            FSDataInputStream is = this.streamWrapper.getStream(doVerificationThruHBaseChecksum);
            HFileBlock blk = this.readBlockDataInternal(is, offset, onDiskSizeWithHeaderL, uncompressedSize, pread, doVerificationThruHBaseChecksum);
            if (blk == null) {
                HFile.LOG.warn((Object)("HBase checksum verification failed for file " + this.path + " at offset " + offset + " filesize " + this.fileSize + ". Retrying read with HDFS checksums turned on..."));
                if (!doVerificationThruHBaseChecksum) {
                    String msg = "HBase checksum verification failed for file " + this.path + " at offset " + offset + " filesize " + this.fileSize + " but this cannot happen because doVerify is " + doVerificationThruHBaseChecksum;
                    HFile.LOG.warn((Object)msg);
                    throw new IOException(msg);
                }
                HFile.checksumFailures.incrementAndGet();
                is = this.streamWrapper.fallbackToFsChecksum(3);
                doVerificationThruHBaseChecksum = false;
                blk = this.readBlockDataInternal(is, offset, onDiskSizeWithHeaderL, uncompressedSize, pread, doVerificationThruHBaseChecksum);
                if (blk != null) {
                    HFile.LOG.warn((Object)("HDFS checksum verification suceeded for file " + this.path + " at offset " + offset + " filesize " + this.fileSize));
                }
            }
            if (blk == null && !doVerificationThruHBaseChecksum) {
                String msg = "readBlockData failed, possibly due to checksum verification failed for file " + this.path + " at offset " + offset + " filesize " + this.fileSize;
                HFile.LOG.warn((Object)msg);
                throw new IOException(msg);
            }
            this.streamWrapper.checksumOk();
            return blk;
        }

        private HFileBlock readBlockDataInternal(FSDataInputStream is, long offset, long onDiskSizeWithHeaderL, int uncompressedSize, boolean pread, boolean verifyChecksum) throws IOException {
            boolean isEncrypted;
            if (offset < 0L) {
                throw new IOException("Invalid offset=" + offset + " trying to read " + "block (onDiskSize=" + onDiskSizeWithHeaderL + ", uncompressedSize=" + uncompressedSize + ")");
            }
            if (uncompressedSize != -1) {
                throw new IOException("Version 2 block reader API does not need the uncompressed size parameter");
            }
            if (onDiskSizeWithHeaderL < (long)this.hdrSize && onDiskSizeWithHeaderL != -1L || onDiskSizeWithHeaderL >= Integer.MAX_VALUE) {
                throw new IOException("Invalid onDisksize=" + onDiskSizeWithHeaderL + ": expected to be at least " + this.hdrSize + " and at most " + Integer.MAX_VALUE + ", or -1 (offset=" + offset + ", uncompressedSize=" + uncompressedSize + ")");
            }
            int onDiskSizeWithHeader = (int)onDiskSizeWithHeaderL;
            PrefetchedHeader prefetchedHeader = this.prefetchedHeaderForThread.get();
            ByteBuffer headerBuf = prefetchedHeader.offset == offset ? prefetchedHeader.buf : null;
            int nextBlockOnDiskSize = 0;
            byte[] onDiskBlock = null;
            HFileBlock b = null;
            if (onDiskSizeWithHeader > 0) {
                int preReadHeaderSize = headerBuf == null ? 0 : this.hdrSize;
                onDiskBlock = new byte[onDiskSizeWithHeader + this.hdrSize];
                nextBlockOnDiskSize = this.readAtOffset(is, onDiskBlock, preReadHeaderSize, onDiskSizeWithHeader - preReadHeaderSize, true, offset + (long)preReadHeaderSize, pread);
                if (headerBuf != null) {
                    System.arraycopy(headerBuf.array(), headerBuf.arrayOffset(), onDiskBlock, 0, this.hdrSize);
                } else {
                    headerBuf = ByteBuffer.wrap(onDiskBlock, 0, this.hdrSize);
                }
                try {
                    b = new HFileBlock(headerBuf, this.fileContext.isUseHBaseChecksum());
                }
                catch (IOException ex) {
                    throw new IOException("Failed to read compressed block at " + offset + ", onDiskSizeWithoutHeader=" + onDiskSizeWithHeader + ", preReadHeaderSize=" + this.hdrSize + ", header.length=" + prefetchedHeader.header.length + ", header bytes: " + Bytes.toStringBinary((byte[])prefetchedHeader.header, (int)0, (int)this.hdrSize), ex);
                }
                int onDiskSizeWithoutHeader = onDiskSizeWithHeader - this.hdrSize;
                assert (onDiskSizeWithoutHeader >= 0);
                b.validateOnDiskSizeWithoutHeader(onDiskSizeWithoutHeader);
            } else {
                if (headerBuf == null) {
                    headerBuf = ByteBuffer.allocate(this.hdrSize);
                    this.readAtOffset(is, headerBuf.array(), headerBuf.arrayOffset(), this.hdrSize, false, offset, pread);
                }
                b = new HFileBlock(headerBuf, this.fileContext.isUseHBaseChecksum());
                onDiskBlock = new byte[b.getOnDiskSizeWithHeader() + this.hdrSize];
                System.arraycopy(headerBuf.array(), headerBuf.arrayOffset(), onDiskBlock, 0, this.hdrSize);
                nextBlockOnDiskSize = this.readAtOffset(is, onDiskBlock, this.hdrSize, b.getOnDiskSizeWithHeader() - this.hdrSize, true, offset + (long)this.hdrSize, pread);
                onDiskSizeWithHeader = b.onDiskSizeWithoutHeader + this.hdrSize;
            }
            Compression.Algorithm compressAlgo = this.fileContext.getCompression();
            boolean isCompressed = compressAlgo != null && compressAlgo != Compression.Algorithm.NONE;
            Encryption.Context cryptoContext = this.fileContext.getEncryptionContext();
            boolean bl = isEncrypted = cryptoContext != null && cryptoContext != Encryption.Context.NONE;
            if (!isCompressed && !isEncrypted) {
                b.assumeUncompressed();
            }
            if (verifyChecksum && !this.validateBlockChecksum(b, onDiskBlock, this.hdrSize)) {
                return null;
            }
            if (isCompressed || isEncrypted) {
                b.allocateBuffer(nextBlockOnDiskSize > 0);
                if (b.blockType == BlockType.ENCODED_DATA) {
                    this.encodedBlockDecodingCtx.prepareDecoding(b.getOnDiskSizeWithoutHeader(), b.getUncompressedSizeWithoutHeader(), b.getBufferWithoutHeader(), onDiskBlock, this.hdrSize);
                } else {
                    this.defaultDecodingCtx.prepareDecoding(b.getOnDiskSizeWithoutHeader(), b.getUncompressedSizeWithoutHeader(), b.getBufferWithoutHeader(), onDiskBlock, this.hdrSize);
                }
                if (nextBlockOnDiskSize > 0) {
                    System.arraycopy(onDiskBlock, onDiskSizeWithHeader, b.buf.array(), b.buf.arrayOffset() + this.hdrSize + b.uncompressedSizeWithoutHeader + b.totalChecksumBytes(), this.hdrSize);
                }
            } else {
                b = new HFileBlock(ByteBuffer.wrap(onDiskBlock, 0, onDiskSizeWithHeader), this.fileContext.isUseHBaseChecksum());
            }
            b.nextBlockOnDiskSizeWithHeader = nextBlockOnDiskSize;
            if (b.nextBlockOnDiskSizeWithHeader > 0) {
                prefetchedHeader.offset = offset + (long)b.getOnDiskSizeWithHeader();
                System.arraycopy(onDiskBlock, onDiskSizeWithHeader, prefetchedHeader.header, 0, this.hdrSize);
            }
            b.offset = offset;
            b.fileContext.setIncludesTags(this.fileContext.isIncludesTags());
            b.fileContext.setIncludesMvcc(this.fileContext.isIncludesMvcc());
            return b;
        }

        void setIncludesMemstoreTS(boolean includesMemstoreTS) {
            this.fileContext.setIncludesMvcc(includesMemstoreTS);
        }

        void setDataBlockEncoder(HFileDataBlockEncoder encoder) {
            this.encodedBlockDecodingCtx = encoder.newDataBlockDecodingContext(this.fileContext);
        }

        protected boolean validateBlockChecksum(HFileBlock block, byte[] data, int hdrSize) throws IOException {
            return ChecksumUtil.validateBlockChecksum(this.path, block, data, hdrSize);
        }

        @Override
        public void closeStreams() throws IOException {
            this.streamWrapper.close();
        }
    }

    private static class PrefetchedHeader {
        long offset = -1L;
        byte[] header = new byte[33];
        ByteBuffer buf = ByteBuffer.wrap(this.header, 0, 33);

        private PrefetchedHeader() {
        }
    }

    private static abstract class AbstractFSReader
    implements FSReader {
        protected long fileSize;
        protected final int hdrSize;
        protected HFileSystem hfs;
        protected Path path;
        private final Lock streamLock = new ReentrantLock();
        public static final int DEFAULT_BUFFER_SIZE = 0x100000;
        protected HFileContext fileContext;

        public AbstractFSReader(long fileSize, HFileSystem hfs, Path path, HFileContext fileContext) throws IOException {
            this.fileSize = fileSize;
            this.hfs = hfs;
            this.path = path;
            this.fileContext = fileContext;
            this.hdrSize = HFileBlock.headerSize(fileContext.isUseHBaseChecksum());
        }

        @Override
        public BlockIterator blockRange(final long startOffset, final long endOffset) {
            return new BlockIterator(){
                private long offset;
                {
                    this.offset = startOffset;
                }

                @Override
                public HFileBlock nextBlock() throws IOException {
                    if (this.offset >= endOffset) {
                        return null;
                    }
                    HFileBlock b = AbstractFSReader.this.readBlockData(this.offset, -1L, -1, false);
                    this.offset += (long)b.getOnDiskSizeWithHeader();
                    return b;
                }

                @Override
                public HFileBlock nextBlockWithBlockType(BlockType blockType) throws IOException {
                    HFileBlock blk = this.nextBlock();
                    if (blk.getBlockType() != blockType) {
                        throw new IOException("Expected block of type " + blockType + " but found " + blk.getBlockType());
                    }
                    return blk;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int readAtOffset(FSDataInputStream istream, byte[] dest, int destOffset, int size, boolean peekIntoNextBlock, long fileOffset, boolean pread) throws IOException {
            block12: {
                if (peekIntoNextBlock && destOffset + size + this.hdrSize > dest.length) {
                    throw new IOException("Attempted to read " + size + " bytes and " + this.hdrSize + " bytes of next header into a " + dest.length + "-byte array at offset " + destOffset);
                }
                if (!pread && this.streamLock.tryLock()) {
                    try {
                        istream.seek(fileOffset);
                        long realOffset = istream.getPos();
                        if (realOffset != fileOffset) {
                            throw new IOException("Tried to seek to " + fileOffset + " to " + "read " + size + " bytes, but pos=" + realOffset + " after seek");
                        }
                        if (!peekIntoNextBlock) {
                            IOUtils.readFully((InputStream)istream, (byte[])dest, (int)destOffset, (int)size);
                            int n = -1;
                            return n;
                        }
                        if (!HFileBlock.readWithExtra((InputStream)istream, dest, destOffset, size, this.hdrSize)) {
                            int n = -1;
                            return n;
                        }
                        break block12;
                    }
                    finally {
                        this.streamLock.unlock();
                    }
                }
                int extraSize = peekIntoNextBlock ? this.hdrSize : 0;
                int ret = istream.read(fileOffset, dest, destOffset, size + extraSize);
                if (ret < size) {
                    throw new IOException("Positional read of " + size + " bytes " + "failed at offset " + fileOffset + " (returned " + ret + ")");
                }
                if (ret == size || ret < size + extraSize) {
                    return -1;
                }
            }
            assert (peekIntoNextBlock);
            return Bytes.toInt((byte[])dest, (int)(destOffset + size + 8)) + this.hdrSize;
        }
    }

    public static interface FSReader {
        public HFileBlock readBlockData(long var1, long var3, int var5, boolean var6) throws IOException;

        public BlockIterator blockRange(long var1, long var3);

        public void closeStreams() throws IOException;
    }

    public static interface BlockIterator {
        public HFileBlock nextBlock() throws IOException;

        public HFileBlock nextBlockWithBlockType(BlockType var1) throws IOException;
    }

    public static interface BlockWritable {
        public BlockType getBlockType();

        public void writeToBlock(DataOutput var1) throws IOException;
    }

    public static class Writer {
        private State state = State.INIT;
        private final HFileDataBlockEncoder dataBlockEncoder;
        private HFileBlockEncodingContext dataBlockEncodingCtx;
        private HFileBlockDefaultEncodingContext defaultBlockEncodingCtx;
        private ByteArrayOutputStream baosInMemory;
        private BlockType blockType;
        private DataOutputStream userDataStream;
        private byte[] onDiskBytesWithHeader;
        private byte[] onDiskChecksum;
        private byte[] uncompressedBytesWithHeader;
        private long startOffset;
        private long[] prevOffsetByType;
        private long prevOffset;
        private HFileContext fileContext;

        public Writer(HFileDataBlockEncoder dataBlockEncoder, HFileContext fileContext) {
            this.dataBlockEncoder = dataBlockEncoder != null ? dataBlockEncoder : NoOpDataBlockEncoder.INSTANCE;
            this.defaultBlockEncodingCtx = new HFileBlockDefaultEncodingContext(null, HConstants.HFILEBLOCK_DUMMY_HEADER, fileContext);
            this.dataBlockEncodingCtx = this.dataBlockEncoder.newDataBlockEncodingContext(HConstants.HFILEBLOCK_DUMMY_HEADER, fileContext);
            if (fileContext.getBytesPerChecksum() < 33) {
                throw new RuntimeException("Unsupported value of bytesPerChecksum.  Minimum is 33 but the configured value is " + fileContext.getBytesPerChecksum());
            }
            this.baosInMemory = new ByteArrayOutputStream();
            this.prevOffsetByType = new long[BlockType.values().length];
            for (int i = 0; i < this.prevOffsetByType.length; ++i) {
                this.prevOffsetByType[i] = -1L;
            }
            this.fileContext = fileContext;
        }

        public DataOutputStream startWriting(BlockType newBlockType) throws IOException {
            if (this.state == State.BLOCK_READY && this.startOffset != -1L) {
                this.prevOffsetByType[this.blockType.getId()] = this.startOffset;
            }
            this.startOffset = -1L;
            this.blockType = newBlockType;
            this.baosInMemory.reset();
            this.baosInMemory.write(HConstants.HFILEBLOCK_DUMMY_HEADER);
            this.state = State.WRITING;
            this.userDataStream = new DataOutputStream(this.baosInMemory);
            return this.userDataStream;
        }

        DataOutputStream getUserDataStream() {
            this.expectState(State.WRITING);
            return this.userDataStream;
        }

        private void ensureBlockReady() throws IOException {
            Preconditions.checkState((this.state != State.INIT ? 1 : 0) != 0, (Object)("Unexpected state: " + (Object)((Object)this.state)));
            if (this.state == State.BLOCK_READY) {
                return;
            }
            this.finishBlock();
        }

        private void finishBlock() throws IOException {
            this.userDataStream.flush();
            this.uncompressedBytesWithHeader = this.baosInMemory.toByteArray();
            this.prevOffset = this.prevOffsetByType[this.blockType.getId()];
            this.state = State.BLOCK_READY;
            if (this.blockType == BlockType.DATA) {
                this.encodeDataBlockForDisk();
            } else {
                this.defaultBlockEncodingCtx.compressAfterEncodingWithBlockType(this.uncompressedBytesWithHeader, this.blockType);
                this.onDiskBytesWithHeader = this.defaultBlockEncodingCtx.getOnDiskBytesWithHeader();
            }
            int numBytes = (int)ChecksumUtil.numBytes(this.onDiskBytesWithHeader.length, this.fileContext.getBytesPerChecksum());
            this.putHeader(this.onDiskBytesWithHeader, 0, this.onDiskBytesWithHeader.length + numBytes, this.uncompressedBytesWithHeader.length, this.onDiskBytesWithHeader.length);
            this.putHeader(this.uncompressedBytesWithHeader, 0, this.onDiskBytesWithHeader.length + numBytes, this.uncompressedBytesWithHeader.length, this.onDiskBytesWithHeader.length);
            this.onDiskChecksum = new byte[numBytes];
            ChecksumUtil.generateChecksums(this.onDiskBytesWithHeader, 0, this.onDiskBytesWithHeader.length, this.onDiskChecksum, 0, this.fileContext.getChecksumType(), this.fileContext.getBytesPerChecksum());
        }

        private void encodeDataBlockForDisk() throws IOException {
            ByteBuffer rawKeyValues = ByteBuffer.wrap(this.uncompressedBytesWithHeader, 33, this.uncompressedBytesWithHeader.length - 33).slice();
            this.dataBlockEncoder.beforeWriteToDisk(rawKeyValues, this.dataBlockEncodingCtx, this.blockType);
            this.uncompressedBytesWithHeader = this.dataBlockEncodingCtx.getUncompressedBytesWithHeader();
            this.onDiskBytesWithHeader = this.dataBlockEncodingCtx.getOnDiskBytesWithHeader();
            this.blockType = this.dataBlockEncodingCtx.getBlockType();
        }

        private void putHeader(byte[] dest, int offset, int onDiskSize, int uncompressedSize, int onDiskDataSize) {
            offset = this.blockType.put(dest, offset);
            offset = Bytes.putInt((byte[])dest, (int)offset, (int)(onDiskSize - 33));
            offset = Bytes.putInt((byte[])dest, (int)offset, (int)(uncompressedSize - 33));
            offset = Bytes.putLong((byte[])dest, (int)offset, (long)this.prevOffset);
            offset = Bytes.putByte((byte[])dest, (int)offset, (byte)this.fileContext.getChecksumType().getCode());
            offset = Bytes.putInt((byte[])dest, (int)offset, (int)this.fileContext.getBytesPerChecksum());
            Bytes.putInt((byte[])dest, (int)offset, (int)onDiskDataSize);
        }

        public void writeHeaderAndData(FSDataOutputStream out) throws IOException {
            long offset = out.getPos();
            if (this.startOffset != -1L && offset != this.startOffset) {
                throw new IOException("A " + this.blockType + " block written to a " + "stream twice, first at offset " + this.startOffset + ", then at " + offset);
            }
            this.startOffset = offset;
            this.finishBlockAndWriteHeaderAndData((DataOutputStream)out);
        }

        private void finishBlockAndWriteHeaderAndData(DataOutputStream out) throws IOException {
            this.ensureBlockReady();
            out.write(this.onDiskBytesWithHeader);
            out.write(this.onDiskChecksum);
        }

        byte[] getHeaderAndDataForTest() throws IOException {
            this.ensureBlockReady();
            byte[] output = new byte[this.onDiskBytesWithHeader.length + this.onDiskChecksum.length];
            System.arraycopy(this.onDiskBytesWithHeader, 0, output, 0, this.onDiskBytesWithHeader.length);
            System.arraycopy(this.onDiskChecksum, 0, output, this.onDiskBytesWithHeader.length, this.onDiskChecksum.length);
            return output;
        }

        public void release() {
            if (this.dataBlockEncodingCtx != null) {
                this.dataBlockEncodingCtx.close();
                this.dataBlockEncodingCtx = null;
            }
            if (this.defaultBlockEncodingCtx != null) {
                this.defaultBlockEncodingCtx.close();
                this.defaultBlockEncodingCtx = null;
            }
        }

        int getOnDiskSizeWithoutHeader() {
            this.expectState(State.BLOCK_READY);
            return this.onDiskBytesWithHeader.length + this.onDiskChecksum.length - 33;
        }

        int getOnDiskSizeWithHeader() {
            this.expectState(State.BLOCK_READY);
            return this.onDiskBytesWithHeader.length + this.onDiskChecksum.length;
        }

        int getUncompressedSizeWithoutHeader() {
            this.expectState(State.BLOCK_READY);
            return this.uncompressedBytesWithHeader.length - 33;
        }

        int getUncompressedSizeWithHeader() {
            this.expectState(State.BLOCK_READY);
            return this.uncompressedBytesWithHeader.length;
        }

        public boolean isWriting() {
            return this.state == State.WRITING;
        }

        public int blockSizeWritten() {
            if (this.state != State.WRITING) {
                return 0;
            }
            return this.userDataStream.size();
        }

        ByteBuffer getUncompressedBufferWithHeader() {
            this.expectState(State.BLOCK_READY);
            return ByteBuffer.wrap(this.uncompressedBytesWithHeader);
        }

        private void expectState(State expectedState) {
            if (this.state != expectedState) {
                throw new IllegalStateException("Expected state: " + (Object)((Object)expectedState) + ", actual state: " + (Object)((Object)this.state));
            }
        }

        public void writeBlock(BlockWritable bw, FSDataOutputStream out) throws IOException {
            bw.writeToBlock(this.startWriting(bw.getBlockType()));
            this.writeHeaderAndData(out);
        }

        public HFileBlock getBlockForCaching() {
            HFileContext newContext = new HFileContextBuilder().withBlockSize(this.fileContext.getBlocksize()).withBytesPerCheckSum(0).withChecksumType(ChecksumType.NULL).withCompression(this.fileContext.getCompression()).withDataBlockEncoding(this.fileContext.getDataBlockEncoding()).withHBaseCheckSum(this.fileContext.isUseHBaseChecksum()).withCompressTags(this.fileContext.isCompressTags()).withIncludesMvcc(this.fileContext.isIncludesMvcc()).withIncludesTags(this.fileContext.isIncludesTags()).build();
            return new HFileBlock(this.blockType, this.getOnDiskSizeWithoutHeader(), this.getUncompressedSizeWithoutHeader(), this.prevOffset, this.getUncompressedBufferWithHeader(), false, this.startOffset, this.onDiskBytesWithHeader.length + this.onDiskChecksum.length, newContext);
        }

        private static enum State {
            INIT,
            WRITING,
            BLOCK_READY;

        }
    }
}

