/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.Key;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileWriterV2;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
public class HFileWriterV3
extends HFileWriterV2 {
    private static final Log LOG = LogFactory.getLog(HFileWriterV3.class);
    private int maxTagsLength = 0;

    public HFileWriterV3(Configuration conf, CacheConfig cacheConf, FileSystem fs, Path path, FSDataOutputStream ostream, KeyValue.KVComparator comparator, HFileContext fileContext) throws IOException {
        super(conf, cacheConf, fs, path, ostream, comparator, fileContext);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Writer" + (path != null ? " for " + path : "") + " initialized with cacheConf: " + cacheConf + " comparator: " + comparator.getClass().getSimpleName() + " fileContext: " + fileContext));
        }
    }

    @Override
    public void append(KeyValue kv) throws IOException {
        this.append(kv.getMvccVersion(), kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength(), kv.getBuffer(), kv.getValueOffset(), kv.getValueLength(), kv.getBuffer(), kv.getTagsOffset(), kv.getTagsLengthUnsigned());
        this.maxMemstoreTS = Math.max(this.maxMemstoreTS, kv.getMvccVersion());
    }

    @Override
    public void append(byte[] key, byte[] value) throws IOException {
        this.append(key, value, HConstants.EMPTY_BYTE_ARRAY);
    }

    @Override
    public void append(byte[] key, byte[] value, byte[] tag) throws IOException {
        this.append(0L, key, 0, key.length, value, 0, value.length, tag, 0, tag.length);
    }

    private void append(long memstoreTS, byte[] key, int koffset, int klength, byte[] value, int voffset, int vlength, byte[] tag, int tagsOffset, int tagsLength) throws IOException {
        boolean dupKey = this.checkKey(key, koffset, klength);
        this.checkValue(value, voffset, vlength);
        if (!dupKey) {
            this.checkBlockBoundary();
        }
        if (!this.fsBlockWriter.isWriting()) {
            this.newBlock();
        }
        DataOutputStream out = this.fsBlockWriter.getUserDataStream();
        out.writeInt(klength);
        this.totalKeyLength += (long)klength;
        out.writeInt(vlength);
        this.totalValueLength += (long)vlength;
        out.write(key, koffset, klength);
        out.write(value, voffset, vlength);
        if (this.hFileContext.isIncludesTags()) {
            out.writeShort(tagsLength);
            if (tagsLength > 0) {
                out.write(tag, tagsOffset, tagsLength);
                if (tagsLength > this.maxTagsLength) {
                    this.maxTagsLength = tagsLength;
                }
            }
        }
        if (this.hFileContext.isIncludesMvcc()) {
            WritableUtils.writeVLong((DataOutput)out, (long)memstoreTS);
        }
        if (this.firstKeyInBlock == null) {
            this.firstKeyInBlock = new byte[klength];
            System.arraycopy(key, koffset, this.firstKeyInBlock, 0, klength);
        }
        this.lastKeyBuffer = key;
        this.lastKeyOffset = koffset;
        this.lastKeyLength = klength;
        ++this.entryCount;
    }

    @Override
    protected void finishFileInfo() throws IOException {
        super.finishFileInfo();
        if (this.hFileContext.getDataBlockEncoding() == DataBlockEncoding.PREFIX_TREE) {
            this.fileInfo.append(HFile.FileInfo.MAX_TAGS_LEN, Bytes.toBytes((int)this.maxTagsLength), false);
        } else if (this.hFileContext.isIncludesTags()) {
            this.fileInfo.append(HFile.FileInfo.MAX_TAGS_LEN, Bytes.toBytes((int)this.maxTagsLength), false);
            boolean tagsCompressed = this.hFileContext.getDataBlockEncoding() != DataBlockEncoding.NONE && this.hFileContext.isCompressTags();
            this.fileInfo.append(HFile.FileInfo.TAGS_COMPRESSED, Bytes.toBytes((boolean)tagsCompressed), false);
        }
    }

    @Override
    protected int getMajorVersion() {
        return 3;
    }

    @Override
    protected int getMinorVersion() {
        return 0;
    }

    @Override
    protected void finishClose(FixedFileTrailer trailer) throws IOException {
        Encryption.Context cryptoContext = this.hFileContext.getEncryptionContext();
        if (cryptoContext != Encryption.Context.NONE) {
            trailer.setEncryptionKey(EncryptionUtil.wrapKey((Configuration)cryptoContext.getConf(), (String)cryptoContext.getConf().get("hbase.crypto.master.key.name", User.getCurrent().getShortName()), (Key)cryptoContext.getKey()));
        }
        super.finishClose(trailer);
    }

    static class WriterFactoryV3
    extends HFile.WriterFactory {
        WriterFactoryV3(Configuration conf, CacheConfig cacheConf) {
            super(conf, cacheConf);
        }

        @Override
        public HFile.Writer createWriter(FileSystem fs, Path path, FSDataOutputStream ostream, KeyValue.KVComparator comparator, HFileContext fileContext) throws IOException {
            return new HFileWriterV3(this.conf, this.cacheConf, fs, path, ostream, comparator, fileContext);
        }
    }
}

