/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;

@InterfaceAudience.Private
public class ParallelSeekHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(ParallelSeekHandler.class);
    private KeyValueScanner scanner;
    private KeyValue keyValue;
    private long readPoint;
    private CountDownLatch latch;
    private Throwable err = null;

    public ParallelSeekHandler(KeyValueScanner scanner, KeyValue keyValue, long readPoint, CountDownLatch latch) {
        super(null, EventType.RS_PARALLEL_SEEK);
        this.scanner = scanner;
        this.keyValue = keyValue;
        this.readPoint = readPoint;
        this.latch = latch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        try {
            this.scanner.seek(this.keyValue);
        }
        catch (IOException e) {
            LOG.error((Object)"", (Throwable)e);
            this.setErr(e);
        }
        finally {
            this.latch.countDown();
        }
    }

    public Throwable getErr() {
        return this.err;
    }

    public void setErr(Throwable err) {
        this.err = err;
    }
}

