/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.SimpleByteRange;

@InterfaceAudience.Private
class AccessControlFilter
extends FilterBase {
    private TableAuthManager authManager;
    private TableName table;
    private User user;
    private boolean isSystemTable;
    private Strategy strategy;
    private Map<ByteRange, Integer> cfVsMaxVersions;
    private int familyMaxVersions;
    private int currentVersions;
    private ByteRange prevFam;
    private ByteRange prevQual;

    AccessControlFilter() {
    }

    AccessControlFilter(TableAuthManager mgr, User ugi, TableName tableName, Strategy strategy, Map<ByteRange, Integer> cfVsMaxVersions) {
        this.authManager = mgr;
        this.table = tableName;
        this.user = ugi;
        this.isSystemTable = tableName.isSystemTable();
        this.strategy = strategy;
        this.cfVsMaxVersions = cfVsMaxVersions;
        this.prevFam = new SimpleByteRange();
        this.prevQual = new SimpleByteRange();
    }

    public Filter.ReturnCode filterKeyValue(Cell cell) {
        if (this.isSystemTable) {
            return Filter.ReturnCode.INCLUDE;
        }
        if (this.prevFam.getBytes() == null || Bytes.compareTo((byte[])this.prevFam.getBytes(), (int)this.prevFam.getOffset(), (int)this.prevFam.getLength(), (byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength()) != 0) {
            this.prevFam.set(cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength());
            this.familyMaxVersions = this.cfVsMaxVersions.get(this.prevFam);
            this.prevQual.unset();
        }
        if (this.prevQual.getBytes() == null || Bytes.compareTo((byte[])this.prevQual.getBytes(), (int)this.prevQual.getOffset(), (int)this.prevQual.getLength(), (byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()) != 0) {
            this.prevQual.set(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
            this.currentVersions = 0;
        }
        ++this.currentVersions;
        if (this.currentVersions > this.familyMaxVersions) {
            return Filter.ReturnCode.SKIP;
        }
        byte[] family = CellUtil.cloneFamily((Cell)cell);
        byte[] qualifier = CellUtil.cloneQualifier((Cell)cell);
        switch (this.strategy) {
            case CHECK_TABLE_AND_CF_ONLY: {
                if (!this.authManager.authorize(this.user, this.table, family, qualifier, Permission.Action.READ)) break;
                return Filter.ReturnCode.INCLUDE;
            }
            case CHECK_CELL_DEFAULT: {
                if (!this.authManager.authorize(this.user, this.table, family, qualifier, Permission.Action.READ) && !this.authManager.authorize(this.user, this.table, cell, Permission.Action.READ)) break;
                return Filter.ReturnCode.INCLUDE;
            }
            default: {
                throw new RuntimeException("Unhandled strategy " + (Object)((Object)this.strategy));
            }
        }
        return Filter.ReturnCode.SKIP;
    }

    public void reset() throws IOException {
        this.prevFam.unset();
        this.prevQual.unset();
        this.familyMaxVersions = 0;
        this.currentVersions = 0;
    }

    public byte[] toByteArray() {
        throw new UnsupportedOperationException("Serialization not supported.  Intended for server-side use only.");
    }

    public static AccessControlFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        throw new UnsupportedOperationException("Serialization not supported.  Intended for server-side use only.");
    }

    public static enum Strategy {
        CHECK_TABLE_AND_CF_ONLY,
        CHECK_CELL_DEFAULT;

    }
}

