/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestStoreFileInfo
extends HBaseTestCase {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    public void testStoreFileNames() {
        String[] illegalHFileLink;
        String[] legalHFileLink;
        for (String name : legalHFileLink = new String[]{"MyTable_02=abc012-def345", "MyTable_02.300=abc012-def345", "MyTable_02-400=abc012-def345", "MyTable_02-400.200=abc012-def345", "MyTable_02=abc012-def345_SeqId_1_", "MyTable_02=abc012-def345_SeqId_20_"}) {
            TestStoreFileInfo.assertTrue((String)("should be a valid link: " + name), (boolean)HFileLink.isHFileLink((String)name));
            TestStoreFileInfo.assertTrue((String)("should be a valid StoreFile" + name), (boolean)StoreFileInfo.validateStoreFileName((String)name));
            TestStoreFileInfo.assertFalse((String)("should not be a valid reference: " + name), (boolean)StoreFileInfo.isReference((String)name));
            String refName = name + ".6789";
            TestStoreFileInfo.assertTrue((String)("should be a valid link reference: " + refName), (boolean)StoreFileInfo.isReference((String)refName));
            TestStoreFileInfo.assertTrue((String)("should be a valid StoreFile" + refName), (boolean)StoreFileInfo.validateStoreFileName((String)refName));
        }
        for (String name : illegalHFileLink = new String[]{".MyTable_02=abc012-def345", "-MyTable_02.300=abc012-def345", "MyTable_02-400=abc0_12-def345", "MyTable_02-400.200=abc012-def345...."}) {
            TestStoreFileInfo.assertFalse((String)("should not be a valid link: " + name), (boolean)HFileLink.isHFileLink((String)name));
        }
    }
}

