/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.httpclient.Header;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.RemoteHTable;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRemoteTable {
    private static final String TABLE = "TestRemoteTable";
    private static final byte[] ROW_1 = Bytes.toBytes((String)"testrow1");
    private static final byte[] ROW_2 = Bytes.toBytes((String)"testrow2");
    private static final byte[] ROW_3 = Bytes.toBytes((String)"testrow3");
    private static final byte[] ROW_4 = Bytes.toBytes((String)"testrow4");
    private static final byte[] COLUMN_1 = Bytes.toBytes((String)"a");
    private static final byte[] COLUMN_2 = Bytes.toBytes((String)"b");
    private static final byte[] COLUMN_3 = Bytes.toBytes((String)"c");
    private static final byte[] QUALIFIER_1 = Bytes.toBytes((String)"1");
    private static final byte[] QUALIFIER_2 = Bytes.toBytes((String)"2");
    private static final byte[] VALUE_1 = Bytes.toBytes((String)"testvalue1");
    private static final byte[] VALUE_2 = Bytes.toBytes((String)"testvalue2");
    private static final long ONE_HOUR = 3600000L;
    private static final long TS_2 = System.currentTimeMillis();
    private static final long TS_1 = TS_2 - 3600000L;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    private RemoteHTable remoteTable;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
        REST_TEST_UTIL.startServletContainer(TEST_UTIL.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void before() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (admin.tableExists(TABLE)) {
            if (admin.isTableEnabled(TABLE)) {
                admin.disableTable(TABLE);
            }
            admin.deleteTable(TABLE);
        }
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)TABLE));
        htd.addFamily(new HColumnDescriptor(COLUMN_1).setMaxVersions(3));
        htd.addFamily(new HColumnDescriptor(COLUMN_2).setMaxVersions(3));
        htd.addFamily(new HColumnDescriptor(COLUMN_3).setMaxVersions(3));
        admin.createTable(htd);
        HTable table = null;
        try {
            table = new HTable(TEST_UTIL.getConfiguration(), TABLE);
            Put put = new Put(ROW_1);
            put.add(COLUMN_1, QUALIFIER_1, TS_2, VALUE_1);
            table.put(put);
            put = new Put(ROW_2);
            put.add(COLUMN_1, QUALIFIER_1, TS_1, VALUE_1);
            put.add(COLUMN_1, QUALIFIER_1, TS_2, VALUE_2);
            put.add(COLUMN_2, QUALIFIER_2, TS_2, VALUE_2);
            table.put(put);
            table.flushCommits();
        }
        finally {
            if (null != table) {
                table.close();
            }
        }
        this.remoteTable = new RemoteHTable(new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort())), TEST_UTIL.getConfiguration(), TABLE);
    }

    @After
    public void after() throws Exception {
        this.remoteTable.close();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTableDescriptor() throws IOException {
        HTable table = null;
        try {
            table = new HTable(TEST_UTIL.getConfiguration(), TABLE);
            HTableDescriptor local = table.getTableDescriptor();
            Assert.assertEquals((Object)this.remoteTable.getTableDescriptor(), (Object)local);
        }
        finally {
            if (null != table) {
                table.close();
            }
        }
    }

    @Test
    public void testGet() throws IOException {
        Get get = new Get(ROW_1);
        Result result = this.remoteTable.get(get);
        byte[] value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        byte[] value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
        Assert.assertNull((Object)value2);
        get = new Get(ROW_1);
        get.addFamily(COLUMN_3);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNull((Object)value1);
        Assert.assertNull((Object)value2);
        get = new Get(ROW_1);
        get.addColumn(COLUMN_1, QUALIFIER_1);
        get.addColumn(COLUMN_2, QUALIFIER_2);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
        Assert.assertNull((Object)value2);
        get = new Get(ROW_2);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value1));
        Assert.assertNotNull((Object)value2);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value2));
        get = new Get(ROW_2);
        get.addFamily(COLUMN_1);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value1));
        Assert.assertNull((Object)value2);
        get = new Get(ROW_2);
        get.addColumn(COLUMN_1, QUALIFIER_1);
        get.addColumn(COLUMN_2, QUALIFIER_2);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value1));
        Assert.assertNotNull((Object)value2);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value2));
        get = new Get(ROW_2);
        get.addFamily(COLUMN_1);
        get.addFamily(COLUMN_2);
        get.setTimeStamp(TS_1);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
        Assert.assertNull((Object)value2);
        get = new Get(ROW_2);
        get.addFamily(COLUMN_1);
        get.addFamily(COLUMN_2);
        get.setTimeRange(0L, TS_1 + 1L);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
        Assert.assertNull((Object)value2);
        get = new Get(ROW_2);
        get.addFamily(COLUMN_1);
        get.setMaxVersions(2);
        result = this.remoteTable.get(get);
        int count = 0;
        for (Cell kv : result.listCells()) {
            if (CellUtil.matchingFamily((Cell)kv, (byte[])COLUMN_1) && TS_1 == kv.getTimestamp()) {
                Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)kv, (byte[])VALUE_1));
                ++count;
            }
            if (!CellUtil.matchingFamily((Cell)kv, (byte[])COLUMN_1) || TS_2 != kv.getTimestamp()) continue;
            Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)kv, (byte[])VALUE_2));
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testMultiGet() throws Exception {
        ArrayList<Get> gets = new ArrayList<Get>();
        gets.add(new Get(ROW_1));
        gets.add(new Get(ROW_2));
        Result[] results = this.remoteTable.get(gets);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)2L, (long)results.length);
        Assert.assertEquals((long)1L, (long)results[0].size());
        Assert.assertEquals((long)2L, (long)results[1].size());
        gets = new ArrayList();
        Get g = new Get(ROW_1);
        g.setMaxVersions(3);
        gets.add(g);
        gets.add(new Get(ROW_2));
        results = this.remoteTable.get(gets);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)2L, (long)results.length);
        Assert.assertEquals((long)1L, (long)results[0].size());
        Assert.assertEquals((long)3L, (long)results[1].size());
        gets = new ArrayList();
        gets.add(new Get(Bytes.toBytes((String)"RESALLYREALLYNOTTHERE")));
        results = this.remoteTable.get(gets);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)0L, (long)results.length);
        gets = new ArrayList();
        gets.add(new Get(Bytes.toBytes((String)"RESALLYREALLYNOTTHERE")));
        gets.add(new Get(ROW_1));
        gets.add(new Get(ROW_2));
        results = this.remoteTable.get(gets);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)2L, (long)results.length);
    }

    @Test
    public void testPut() throws IOException {
        Put put = new Put(ROW_3);
        put.add(COLUMN_1, QUALIFIER_1, VALUE_1);
        this.remoteTable.put(put);
        Get get = new Get(ROW_3);
        get.addFamily(COLUMN_1);
        Result result = this.remoteTable.get(get);
        byte[] value = result.getValue(COLUMN_1, QUALIFIER_1);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value));
        ArrayList<Put> puts = new ArrayList<Put>();
        put = new Put(ROW_3);
        put.add(COLUMN_2, QUALIFIER_2, VALUE_2);
        puts.add(put);
        put = new Put(ROW_4);
        put.add(COLUMN_1, QUALIFIER_1, VALUE_1);
        puts.add(put);
        put = new Put(ROW_4);
        put.add(COLUMN_2, QUALIFIER_2, VALUE_2);
        puts.add(put);
        this.remoteTable.put(puts);
        get = new Get(ROW_3);
        get.addFamily(COLUMN_2);
        result = this.remoteTable.get(get);
        value = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value));
        get = new Get(ROW_4);
        result = this.remoteTable.get(get);
        value = result.getValue(COLUMN_1, QUALIFIER_1);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value));
        value = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value));
        Assert.assertTrue((boolean)Bytes.equals((byte[])Bytes.toBytes((String)TABLE), (byte[])this.remoteTable.getTableName()));
    }

    @Test
    public void testDelete() throws IOException {
        Put put = new Put(ROW_3);
        put.add(COLUMN_1, QUALIFIER_1, VALUE_1);
        put.add(COLUMN_2, QUALIFIER_2, VALUE_2);
        this.remoteTable.put(put);
        Get get = new Get(ROW_3);
        get.addFamily(COLUMN_1);
        get.addFamily(COLUMN_2);
        Result result = this.remoteTable.get(get);
        byte[] value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        byte[] value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
        Assert.assertNotNull((Object)value2);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_2, (byte[])value2));
        Delete delete = new Delete(ROW_3);
        delete.deleteColumn(COLUMN_2, QUALIFIER_2);
        this.remoteTable.delete(delete);
        get = new Get(ROW_3);
        get.addFamily(COLUMN_1);
        get.addFamily(COLUMN_2);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
        Assert.assertNull((Object)value2);
        delete = new Delete(ROW_3);
        delete.setTimestamp(1L);
        this.remoteTable.delete(delete);
        get = new Get(ROW_3);
        get.addFamily(COLUMN_1);
        get.addFamily(COLUMN_2);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
        Assert.assertNull((Object)value2);
        delete = new Delete(ROW_3);
        this.remoteTable.delete(delete);
        get = new Get(ROW_3);
        get.addFamily(COLUMN_1);
        get.addFamily(COLUMN_2);
        result = this.remoteTable.get(get);
        value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNull((Object)value1);
        Assert.assertNull((Object)value2);
    }

    @Test
    public void testScanner() throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        Put put = new Put(ROW_1);
        put.add(COLUMN_1, QUALIFIER_1, VALUE_1);
        puts.add(put);
        put = new Put(ROW_2);
        put.add(COLUMN_1, QUALIFIER_1, VALUE_1);
        puts.add(put);
        put = new Put(ROW_3);
        put.add(COLUMN_1, QUALIFIER_1, VALUE_1);
        puts.add(put);
        put = new Put(ROW_4);
        put.add(COLUMN_1, QUALIFIER_1, VALUE_1);
        puts.add(put);
        this.remoteTable.put(puts);
        ResultScanner scanner = this.remoteTable.getScanner(new Scan());
        Result[] results = scanner.next(1);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.length);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_1, (byte[])results[0].getRow()));
        Result result = scanner.next();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_2, (byte[])result.getRow()));
        results = scanner.next(2);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)2L, (long)results.length);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_3, (byte[])results[0].getRow()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_4, (byte[])results[1].getRow()));
        results = scanner.next(1);
        Assert.assertNull((Object)results);
        scanner.close();
        scanner = this.remoteTable.getScanner(COLUMN_1);
        results = scanner.next(4);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)4L, (long)results.length);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_1, (byte[])results[0].getRow()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_2, (byte[])results[1].getRow()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_3, (byte[])results[2].getRow()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_4, (byte[])results[3].getRow()));
        scanner.close();
        scanner = this.remoteTable.getScanner(COLUMN_1, QUALIFIER_1);
        results = scanner.next(4);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)4L, (long)results.length);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_1, (byte[])results[0].getRow()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_2, (byte[])results[1].getRow()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_3, (byte[])results[2].getRow()));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ROW_4, (byte[])results[3].getRow()));
        scanner.close();
        Assert.assertTrue((boolean)this.remoteTable.isAutoFlush());
    }

    @Test
    public void testCheckAndDelete() throws IOException {
        Get get = new Get(ROW_1);
        Result result = this.remoteTable.get(get);
        byte[] value1 = result.getValue(COLUMN_1, QUALIFIER_1);
        byte[] value2 = result.getValue(COLUMN_2, QUALIFIER_2);
        Assert.assertNotNull((Object)value1);
        Assert.assertTrue((boolean)Bytes.equals((byte[])VALUE_1, (byte[])value1));
        Assert.assertNull((Object)value2);
        Assert.assertTrue((boolean)this.remoteTable.exists(get));
        Assert.assertEquals((long)1L, (long)this.remoteTable.exists(Collections.singletonList(get)).length);
        Delete delete = new Delete(ROW_1);
        this.remoteTable.checkAndDelete(ROW_1, COLUMN_1, QUALIFIER_1, VALUE_1, delete);
        Assert.assertFalse((boolean)this.remoteTable.exists(get));
        Put put = new Put(ROW_1);
        put.add(COLUMN_1, QUALIFIER_1, VALUE_1);
        this.remoteTable.put(put);
        Assert.assertTrue((boolean)this.remoteTable.checkAndPut(ROW_1, COLUMN_1, QUALIFIER_1, VALUE_1, put));
        Assert.assertFalse((boolean)this.remoteTable.checkAndPut(ROW_1, COLUMN_1, QUALIFIER_1, VALUE_2, put));
    }

    @Test
    public void testIteratorScaner() throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        Put put = new Put(ROW_1);
        put.add(COLUMN_1, QUALIFIER_1, VALUE_1);
        puts.add(put);
        put = new Put(ROW_2);
        put.add(COLUMN_1, QUALIFIER_1, VALUE_1);
        puts.add(put);
        put = new Put(ROW_3);
        put.add(COLUMN_1, QUALIFIER_1, VALUE_1);
        puts.add(put);
        put = new Put(ROW_4);
        put.add(COLUMN_1, QUALIFIER_1, VALUE_1);
        puts.add(put);
        this.remoteTable.put(puts);
        ResultScanner scanner = this.remoteTable.getScanner(new Scan());
        Iterator iterator = scanner.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        int counter = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++counter;
        }
        Assert.assertEquals((long)4L, (long)counter);
    }

    @Test
    public void testResponse() {
        Response response = new Response(200);
        Assert.assertEquals((long)200L, (long)response.getCode());
        Header[] headers = new Header[]{new Header("header1", "value1"), new Header("header2", "value2")};
        response = new Response(200, headers);
        Assert.assertEquals((Object)"value1", (Object)response.getHeader("header1"));
        Assert.assertFalse((boolean)response.hasBody());
        response.setCode(404);
        Assert.assertEquals((long)404L, (long)response.getCode());
        headers = new Header[]{new Header("header1", "value1.1"), new Header("header2", "value2")};
        response.setHeaders(headers);
        Assert.assertEquals((Object)"value1.1", (Object)response.getHeader("header1"));
        response.setBody(Bytes.toBytes((String)"body"));
        Assert.assertTrue((boolean)response.hasBody());
    }
}

