/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LoadTestTool;
import org.apache.hadoop.hbase.util.MultiThreadedReader;
import org.apache.hadoop.hbase.util.test.LoadTestDataGenerator;
import org.apache.hadoop.security.UserGroupInformation;

public class MultiThreadedReaderWithACL
extends MultiThreadedReader {
    private static final Log LOG = LogFactory.getLog(MultiThreadedReaderWithACL.class);
    private static final String COMMA = ",";
    private Map<String, HTable> userVsTable = new HashMap<String, HTable>();
    private Map<String, User> users = new HashMap<String, User>();
    private String[] userNames;

    public MultiThreadedReaderWithACL(LoadTestDataGenerator dataGen, Configuration conf, TableName tableName, double verifyPercent, String userNames) {
        super(dataGen, conf, tableName, verifyPercent);
        this.userNames = userNames.split(COMMA);
    }

    @Override
    protected void addReaderThreads(int numThreads) throws IOException {
        for (int i = 0; i < numThreads; ++i) {
            HBaseReaderThreadWithACL reader = new HBaseReaderThreadWithACL(i);
            this.readers.add(reader);
        }
    }

    public class HBaseReaderThreadWithACL
    extends MultiThreadedReader.HBaseReaderThread {
        public HBaseReaderThreadWithACL(int readerId) throws IOException {
            super(readerId);
        }

        @Override
        protected HTable createTable() throws IOException {
            return null;
        }

        @Override
        protected void closeTable() {
            for (HTable table : MultiThreadedReaderWithACL.this.userVsTable.values()) {
                try {
                    table.close();
                }
                catch (Exception e) {
                    LOG.error((Object)("Error while closing the table " + table.getName()), (Throwable)e);
                }
            }
        }

        @Override
        public void queryKey(final Get get, final boolean verify, final long keyToRead) throws IOException {
            final String rowKey = Bytes.toString((byte[])get.getRow());
            final long start = System.currentTimeMillis();
            PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    HTable localTable = null;
                    try {
                        Result result = null;
                        int specialPermCellInsertionFactor = Integer.parseInt(MultiThreadedReaderWithACL.this.dataGenerator.getArgs()[2]);
                        int mod = (int)keyToRead % MultiThreadedReaderWithACL.this.userNames.length;
                        if (MultiThreadedReaderWithACL.this.userVsTable.get(MultiThreadedReaderWithACL.this.userNames[mod]) == null) {
                            localTable = new HTable(MultiThreadedReaderWithACL.this.conf, MultiThreadedReaderWithACL.this.tableName);
                            MultiThreadedReaderWithACL.this.userVsTable.put(MultiThreadedReaderWithACL.this.userNames[mod], localTable);
                            result = localTable.get(get);
                        } else {
                            localTable = (HTable)MultiThreadedReaderWithACL.this.userVsTable.get(MultiThreadedReaderWithACL.this.userNames[mod]);
                            result = localTable.get(get);
                        }
                        boolean isNullExpected = (int)keyToRead % specialPermCellInsertionFactor == 0;
                        HBaseReaderThreadWithACL.this.getResultMetricUpdation(verify, rowKey, start, result, localTable, isNullExpected);
                    }
                    catch (IOException e) {
                        HBaseReaderThreadWithACL.this.recordFailure(keyToRead);
                    }
                    return null;
                }
            };
            if (MultiThreadedReaderWithACL.this.userNames != null && MultiThreadedReaderWithACL.this.userNames.length > 0) {
                User user;
                int mod = (int)keyToRead % MultiThreadedReaderWithACL.this.userNames.length;
                if (!MultiThreadedReaderWithACL.this.users.containsKey(MultiThreadedReaderWithACL.this.userNames[mod])) {
                    UserGroupInformation realUserUgi = User.isHBaseSecurityEnabled((Configuration)MultiThreadedReaderWithACL.this.conf) ? LoadTestTool.loginAndReturnUGI(MultiThreadedReaderWithACL.this.conf, MultiThreadedReaderWithACL.this.userNames[mod]) : UserGroupInformation.createRemoteUser((String)MultiThreadedReaderWithACL.this.userNames[mod]);
                    user = User.create((UserGroupInformation)realUserUgi);
                    MultiThreadedReaderWithACL.this.users.put(MultiThreadedReaderWithACL.this.userNames[mod], user);
                } else {
                    user = (User)MultiThreadedReaderWithACL.this.users.get(MultiThreadedReaderWithACL.this.userNames[mod]);
                }
                try {
                    user.runAs((PrivilegedExceptionAction)action);
                }
                catch (Exception e) {
                    this.recordFailure(keyToRead);
                }
            }
        }

        private void recordFailure(long keyToRead) {
            MultiThreadedReaderWithACL.this.numReadFailures.addAndGet(1L);
            LOG.debug((Object)("[" + this.readerId + "] FAILED read, key = " + keyToRead + "" + ", " + "time from start: " + (System.currentTimeMillis() - this.startTimeMs) + " ms"));
        }
    }
}

