/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.protobuf.ByteString;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.coprocessor.BaseMasterAndRegionObserver;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.exceptions.FailedSanityCheckException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.ipc.RequestContext;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.InvalidLabelException;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityControllerNotReadyException;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelService;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelServiceManager;
import org.apache.hadoop.hbase.security.visibility.VisibilityScanDeleteTracker;
import org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class VisibilityController
extends BaseMasterAndRegionObserver
implements VisibilityLabelsProtos.VisibilityLabelsService.Interface,
CoprocessorService {
    private static final Log LOG = LogFactory.getLog(VisibilityController.class);
    private boolean labelsRegion = false;
    private boolean acOn = false;
    private Configuration conf;
    private volatile boolean initialized = false;
    private boolean checkAuths = false;
    private Map<InternalScanner, String> scannerOwners = new MapMaker().weakKeys().makeMap();
    List<String> superUsers;
    private VisibilityLabelService visibilityLabelService;
    private static ArrayList<Byte> RESERVED_VIS_TAG_TYPES = new ArrayList();

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        this.conf = env.getConfiguration();
        if (HFile.getFormatVersion(this.conf) < 3) {
            throw new RuntimeException("A minimum HFile version of 3 is required to persist visibility labels. Consider setting hfile.format.version accordingly.");
        }
        if (env instanceof RegionServerCoprocessorEnvironment) {
            throw new RuntimeException("Visibility controller should not be configured as 'hbase.coprocessor.regionserver.classes'.");
        }
        if (env instanceof RegionCoprocessorEnvironment) {
            this.visibilityLabelService = VisibilityLabelServiceManager.getInstance().getVisibilityLabelService(this.conf);
        }
        this.superUsers = this.getSystemAndSuperUsers();
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    @Override
    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        MasterServices master = ctx.getEnvironment().getMasterServices();
        if (!MetaReader.tableExists((CatalogTracker)master.getCatalogTracker(), (TableName)VisibilityConstants.LABELS_TABLE_NAME)) {
            HTableDescriptor labelsTable = new HTableDescriptor(VisibilityConstants.LABELS_TABLE_NAME);
            HColumnDescriptor labelsColumn = new HColumnDescriptor(VisibilityConstants.LABELS_TABLE_FAMILY);
            labelsColumn.setBloomFilterType(BloomType.NONE);
            labelsColumn.setBlockCacheEnabled(false);
            labelsTable.addFamily(labelsColumn);
            labelsTable.setValue("SPLIT_POLICY", DisabledRegionSplitPolicy.class.getName());
            labelsTable.setValue(Bytes.toBytes((String)"hbase.regionserver.disallow.writes.when.recovering"), Bytes.toBytes((boolean)true));
            master.createTable(labelsTable, null);
        }
    }

    @Override
    public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HTableDescriptor htd) throws IOException {
        if (VisibilityConstants.LABELS_TABLE_NAME.equals((Object)tableName)) {
            throw new ConstraintException("Cannot alter " + VisibilityConstants.LABELS_TABLE_NAME);
        }
    }

    @Override
    public void preAddColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor column) throws IOException {
        if (VisibilityConstants.LABELS_TABLE_NAME.equals((Object)tableName)) {
            throw new ConstraintException("Cannot alter " + VisibilityConstants.LABELS_TABLE_NAME);
        }
    }

    @Override
    public void preModifyColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor descriptor) throws IOException {
        if (VisibilityConstants.LABELS_TABLE_NAME.equals((Object)tableName)) {
            throw new ConstraintException("Cannot alter " + VisibilityConstants.LABELS_TABLE_NAME);
        }
    }

    @Override
    public void preDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, byte[] c) throws IOException {
        if (VisibilityConstants.LABELS_TABLE_NAME.equals((Object)tableName)) {
            throw new ConstraintException("Cannot alter " + VisibilityConstants.LABELS_TABLE_NAME);
        }
    }

    @Override
    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (VisibilityConstants.LABELS_TABLE_NAME.equals((Object)tableName)) {
            throw new ConstraintException("Cannot disable " + VisibilityConstants.LABELS_TABLE_NAME);
        }
    }

    @Override
    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> e) {
        if (e.getEnvironment().getRegion().getRegionInfo().getTable().equals((Object)VisibilityConstants.LABELS_TABLE_NAME)) {
            this.labelsRegion = true;
            this.acOn = CoprocessorHost.getLoadedCoprocessors().contains(AccessController.class.getName());
            if (!e.getEnvironment().getRegion().isRecovering()) {
                this.initVisibilityLabelService(e.getEnvironment());
            }
        } else {
            this.checkAuths = e.getEnvironment().getConfiguration().getBoolean("hbase.security.visibility.mutations.checkauths", false);
            this.initVisibilityLabelService(e.getEnvironment());
        }
    }

    @Override
    public void postLogReplay(ObserverContext<RegionCoprocessorEnvironment> e) {
        if (this.labelsRegion) {
            this.initVisibilityLabelService(e.getEnvironment());
            LOG.debug((Object)"post labels region log replay");
        }
    }

    private void initVisibilityLabelService(RegionCoprocessorEnvironment env) {
        try {
            this.visibilityLabelService.init(env);
            this.initialized = true;
        }
        catch (IOException ioe) {
            LOG.error((Object)"Error while initializing VisibilityLabelService..", (Throwable)ioe);
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (c.getEnvironment().getRegion().getRegionInfo().getTable().isSystemTable()) {
            return;
        }
        HashMap<String, List<Tag>> labelCache = new HashMap<String, List<Tag>>();
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Mutation m = miniBatchOp.getOperation(i);
            CellVisibility cellVisibility = null;
            try {
                cellVisibility = m.getCellVisibility();
            }
            catch (DeserializationException de) {
                miniBatchOp.setOperationStatus(i, new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, de.getMessage()));
                continue;
            }
            boolean sanityFailure = false;
            CellScanner cellScanner = m.cellScanner();
            while (cellScanner.advance()) {
                if (this.checkForReservedVisibilityTagPresence(cellScanner.current())) continue;
                miniBatchOp.setOperationStatus(i, new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, "Mutation contains cell with reserved type tag"));
                sanityFailure = true;
                break;
            }
            if (sanityFailure || cellVisibility == null) continue;
            String labelsExp = cellVisibility.getExpression();
            List<Tag> visibilityTags = (List<Tag>)labelCache.get(labelsExp);
            if (visibilityTags == null) {
                boolean authCheck = this.checkAuths && !this.isSystemOrSuperUser();
                try {
                    visibilityTags = this.visibilityLabelService.createVisibilityExpTags(labelsExp, true, authCheck);
                }
                catch (InvalidLabelException e) {
                    miniBatchOp.setOperationStatus(i, new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, e.getMessage()));
                }
                if (visibilityTags != null) {
                    labelCache.put(labelsExp, visibilityTags);
                }
            }
            if (visibilityTags == null) continue;
            ArrayList<KeyValue> updatedCells = new ArrayList<KeyValue>();
            CellScanner cellScanner2 = m.cellScanner();
            while (cellScanner2.advance()) {
                Cell cell = cellScanner2.current();
                List tags = Tag.asList((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLengthUnsigned());
                tags.addAll(visibilityTags);
                KeyValue updatedCell = new KeyValue(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), cell.getTimestamp(), KeyValue.Type.codeToType((byte)cell.getTypeByte()), cell.getValueArray(), cell.getValueOffset(), cell.getValueLength(), tags);
                updatedCells.add(updatedCell);
            }
            m.getFamilyCellMap().clear();
            for (Cell cell : updatedCells) {
                if (m instanceof Put) {
                    Put p = (Put)m;
                    p.add(cell);
                    continue;
                }
                if (!(m instanceof Delete)) continue;
                Delete d = (Delete)m;
                d.addDeleteMarker(cell);
            }
        }
    }

    @Override
    public void prePrepareTimeStampForDeleteVersion(ObserverContext<RegionCoprocessorEnvironment> ctx, Mutation delete, Cell cell, byte[] byteNow, Get get) throws IOException {
        KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
        CellVisibility cellVisibility = null;
        try {
            cellVisibility = delete.getCellVisibility();
        }
        catch (DeserializationException de) {
            throw new IOException("Invalid cell visibility specified " + delete, de);
        }
        List<Tag> visibilityTags = new ArrayList<Tag>();
        if (cellVisibility != null) {
            String labelsExp = cellVisibility.getExpression();
            try {
                visibilityTags = this.visibilityLabelService.createVisibilityExpTags(labelsExp, false, false);
            }
            catch (InvalidLabelException e) {
                throw new IOException("Invalid cell visibility specified " + labelsExp, e);
            }
        }
        get.setFilter((Filter)new DeleteVersionVisibilityExpressionFilter(visibilityTags, (byte)1));
        List<Cell> result = ctx.getEnvironment().getRegion().get(get, false);
        if (result.size() < get.getMaxVersions()) {
            kv.updateLatestStamp(Bytes.toBytes((long)Long.MIN_VALUE));
            return;
        }
        if (result.size() > get.getMaxVersions()) {
            throw new RuntimeException("Unexpected size: " + result.size() + ". Results more than the max versions obtained.");
        }
        KeyValue getkv = KeyValueUtil.ensureKeyValue((Cell)result.get(get.getMaxVersions() - 1));
        Bytes.putBytes((byte[])kv.getBuffer(), (int)kv.getTimestampOffset(), (byte[])getkv.getBuffer(), (int)getkv.getTimestampOffset(), (int)8);
        ctx.bypass();
    }

    private boolean checkForReservedVisibilityTagPresence(Cell cell) throws IOException {
        if (this.isSystemOrSuperUser()) {
            return true;
        }
        if (cell.getTagsLengthUnsigned() > 0) {
            Iterator tagsItr = CellUtil.tagsIterator((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLengthUnsigned());
            while (tagsItr.hasNext()) {
                if (!RESERVED_VIS_TAG_TYPES.contains(((Tag)tagsItr.next()).getType())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan, RegionScanner s) throws IOException {
        TableName table;
        if (!this.initialized) {
            throw new VisibilityControllerNotReadyException("VisibilityController not yet initialized!");
        }
        HRegion region = e.getEnvironment().getRegion();
        Authorizations authorizations = null;
        try {
            authorizations = scan.getAuthorizations();
        }
        catch (DeserializationException de) {
            throw new IOException(de);
        }
        if (authorizations == null && (table = region.getRegionInfo().getTable()).isSystemTable() && !table.equals((Object)VisibilityConstants.LABELS_TABLE_NAME)) {
            return s;
        }
        Filter visibilityLabelFilter = VisibilityUtils.createVisibilityLabelFilter(region, authorizations);
        if (visibilityLabelFilter != null) {
            Filter filter = scan.getFilter();
            if (filter != null) {
                scan.setFilter((Filter)new FilterList(new Filter[]{filter, visibilityLabelFilter}));
            } else {
                scan.setFilter(visibilityLabelFilter);
            }
        }
        return s;
    }

    @Override
    public DeleteTracker postInstantiateDeleteTracker(ObserverContext<RegionCoprocessorEnvironment> ctx, DeleteTracker delTracker) throws IOException {
        HRegion region = ctx.getEnvironment().getRegion();
        TableName table = region.getRegionInfo().getTable();
        if (table.isSystemTable()) {
            return delTracker;
        }
        return new VisibilityScanDeleteTracker();
    }

    @Override
    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        User user = VisibilityUtils.getActiveUser();
        if (user != null && user.getShortName() != null) {
            this.scannerOwners.put(s, user.getShortName());
        }
        return s;
    }

    @Override
    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
        this.requireScannerOwner(s);
        return hasNext;
    }

    @Override
    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.requireScannerOwner(s);
    }

    @Override
    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.scannerOwners.remove(s);
    }

    private void requireScannerOwner(InternalScanner s) throws AccessDeniedException {
        if (RequestContext.isInRequestContext()) {
            String requestUName = RequestContext.getRequestUserName();
            String owner = this.scannerOwners.get(s);
            if (owner != null && !owner.equals(requestUName)) {
                throw new AccessDeniedException("User '" + requestUName + "' is not the scanner owner!");
            }
        }
    }

    @Override
    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
        TableName table;
        if (!this.initialized) {
            throw new VisibilityControllerNotReadyException("VisibilityController not yet initialized!");
        }
        HRegion region = e.getEnvironment().getRegion();
        Authorizations authorizations = null;
        try {
            authorizations = get.getAuthorizations();
        }
        catch (DeserializationException de) {
            throw new IOException(de);
        }
        if (authorizations == null && (table = region.getRegionInfo().getTable()).isSystemTable() && !table.equals((Object)VisibilityConstants.LABELS_TABLE_NAME)) {
            return;
        }
        Filter visibilityLabelFilter = VisibilityUtils.createVisibilityLabelFilter(e.getEnvironment().getRegion(), authorizations);
        if (visibilityLabelFilter != null) {
            Filter filter = get.getFilter();
            if (filter != null) {
                get.setFilter((Filter)new FilterList(new Filter[]{filter, visibilityLabelFilter}));
            } else {
                get.setFilter(visibilityLabelFilter);
            }
        }
    }

    private List<String> getSystemAndSuperUsers() throws IOException {
        User user = User.getCurrent();
        if (user == null) {
            throw new IOException("Unable to obtain the current user, authorization checks for internal operations will not work correctly!");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Current user name is " + user.getShortName()));
        }
        String currentUser = user.getShortName();
        List superUsers = Lists.asList((Object)currentUser, (Object[])this.conf.getStrings("hbase.superuser", new String[0]));
        return superUsers;
    }

    private boolean isSystemOrSuperUser() throws IOException {
        User activeUser = VisibilityUtils.getActiveUser();
        return this.superUsers.contains(activeUser.getShortName());
    }

    @Override
    public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> e, Append append) throws IOException {
        CellScanner cellScanner = append.cellScanner();
        while (cellScanner.advance()) {
            if (this.checkForReservedVisibilityTagPresence(cellScanner.current())) continue;
            throw new FailedSanityCheckException("Append contains cell with reserved type tag");
        }
        return null;
    }

    @Override
    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> e, Increment increment) throws IOException {
        CellScanner cellScanner = increment.cellScanner();
        while (cellScanner.advance()) {
            if (this.checkForReservedVisibilityTagPresence(cellScanner.current())) continue;
            throw new FailedSanityCheckException("Increment contains cell with reserved type tag");
        }
        return null;
    }

    @Override
    public Cell postMutationBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, RegionObserver.MutationType opType, Mutation mutation, Cell oldCell, Cell newCell) throws IOException {
        ArrayList tags = Lists.newArrayList();
        CellVisibility cellVisibility = null;
        try {
            cellVisibility = mutation.getCellVisibility();
        }
        catch (DeserializationException e) {
            throw new IOException(e);
        }
        if (cellVisibility == null) {
            return newCell;
        }
        boolean authCheck = this.checkAuths && !this.isSystemOrSuperUser();
        tags.addAll(this.visibilityLabelService.createVisibilityExpTags(cellVisibility.getExpression(), true, authCheck));
        if (newCell.getTagsLengthUnsigned() > 0) {
            Iterator tagsItr = CellUtil.tagsIterator((byte[])newCell.getTagsArray(), (int)newCell.getTagsOffset(), (int)newCell.getTagsLengthUnsigned());
            while (tagsItr.hasNext()) {
                Tag tag = (Tag)tagsItr.next();
                if (tag.getType() == 2 || tag.getType() == 4) continue;
                tags.add(tag);
            }
        }
        KeyValue rewriteKv = new KeyValue(newCell.getRowArray(), newCell.getRowOffset(), (int)newCell.getRowLength(), newCell.getFamilyArray(), newCell.getFamilyOffset(), (int)newCell.getFamilyLength(), newCell.getQualifierArray(), newCell.getQualifierOffset(), newCell.getQualifierLength(), newCell.getTimestamp(), KeyValue.Type.codeToType((byte)newCell.getTypeByte()), newCell.getValueArray(), newCell.getValueOffset(), newCell.getValueLength(), (List)tags);
        rewriteKv.setMvccVersion(newCell.getMvccVersion());
        return rewriteKv;
    }

    @Override
    public Service getService() {
        return VisibilityLabelsProtos.VisibilityLabelsService.newReflectiveService((VisibilityLabelsProtos.VisibilityLabelsService.Interface)this);
    }

    public synchronized void addLabels(RpcController controller, VisibilityLabelsProtos.VisibilityLabelsRequest request, RpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> done) {
        VisibilityLabelsProtos.VisibilityLabelsResponse.Builder response = VisibilityLabelsProtos.VisibilityLabelsResponse.newBuilder();
        List visLabels = request.getVisLabelList();
        if (!this.initialized) {
            this.setExceptionResults(visLabels.size(), (IOException)new VisibilityControllerNotReadyException("VisibilityController not yet initialized!"), response);
        } else {
            try {
                this.checkCallingUserAuth();
                ArrayList<byte[]> labels = new ArrayList<byte[]>(visLabels.size());
                ClientProtos.RegionActionResult successResult = ClientProtos.RegionActionResult.newBuilder().build();
                for (VisibilityLabelsProtos.VisibilityLabel visLabel : visLabels) {
                    byte[] label = visLabel.getLabel().toByteArray();
                    labels.add(label);
                    response.addResult(successResult);
                }
                if (!labels.isEmpty()) {
                    OperationStatus[] opStatus = this.visibilityLabelService.addLabels(labels);
                    int i = 0;
                    for (OperationStatus status : opStatus) {
                        while (response.getResult(i) != successResult) {
                            ++i;
                        }
                        if (status.getOperationStatusCode() != HConstants.OperationStatusCode.SUCCESS) {
                            ClientProtos.RegionActionResult.Builder failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
                            failureResultBuilder.setException(ResponseConverter.buildException((Throwable)new DoNotRetryIOException(status.getExceptionMsg())));
                            response.setResult(i, failureResultBuilder.build());
                        }
                        ++i;
                    }
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
                this.setExceptionResults(visLabels.size(), e, response);
            }
        }
        done.run((Object)response.build());
    }

    private void setExceptionResults(int size, IOException e, VisibilityLabelsProtos.VisibilityLabelsResponse.Builder response) {
        ClientProtos.RegionActionResult.Builder failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
        failureResultBuilder.setException(ResponseConverter.buildException((Throwable)e));
        ClientProtos.RegionActionResult failureResult = failureResultBuilder.build();
        for (int i = 0; i < size; ++i) {
            response.addResult(i, failureResult);
        }
    }

    public synchronized void setAuths(RpcController controller, VisibilityLabelsProtos.SetAuthsRequest request, RpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> done) {
        VisibilityLabelsProtos.VisibilityLabelsResponse.Builder response = VisibilityLabelsProtos.VisibilityLabelsResponse.newBuilder();
        List auths = request.getAuthList();
        if (!this.initialized) {
            this.setExceptionResults(auths.size(), (IOException)new VisibilityControllerNotReadyException("VisibilityController not yet initialized!"), response);
        } else {
            try {
                this.checkCallingUserAuth();
                ArrayList<byte[]> labelAuths = new ArrayList<byte[]>(auths.size());
                for (ByteString authBS : auths) {
                    labelAuths.add(authBS.toByteArray());
                }
                OperationStatus[] opStatus = this.visibilityLabelService.setAuths(request.getUser().toByteArray(), labelAuths);
                ClientProtos.RegionActionResult successResult = ClientProtos.RegionActionResult.newBuilder().build();
                for (OperationStatus status : opStatus) {
                    if (status.getOperationStatusCode() == HConstants.OperationStatusCode.SUCCESS) {
                        response.addResult(successResult);
                        continue;
                    }
                    ClientProtos.RegionActionResult.Builder failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
                    failureResultBuilder.setException(ResponseConverter.buildException((Throwable)new DoNotRetryIOException(status.getExceptionMsg())));
                    response.addResult(failureResultBuilder.build());
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
                this.setExceptionResults(auths.size(), e, response);
            }
        }
        done.run((Object)response.build());
    }

    public synchronized void getAuths(RpcController controller, VisibilityLabelsProtos.GetAuthsRequest request, RpcCallback<VisibilityLabelsProtos.GetAuthsResponse> done) {
        VisibilityLabelsProtos.GetAuthsResponse.Builder response = VisibilityLabelsProtos.GetAuthsResponse.newBuilder();
        if (!this.initialized) {
            controller.setFailed("VisibilityController not yet initialized");
        } else {
            byte[] user = request.getUser().toByteArray();
            List<String> labels = null;
            try {
                if (this.acOn && !this.isSystemOrSuperUser()) {
                    User requestingUser = VisibilityUtils.getActiveUser();
                    throw new AccessDeniedException("User '" + (requestingUser != null ? requestingUser.getShortName() : "null") + " is not authorized to perform this action.");
                }
                labels = this.visibilityLabelService.getAuths(user, false);
            }
            catch (IOException e) {
                ResponseConverter.setControllerException((RpcController)controller, (IOException)e);
            }
            response.setUser(request.getUser());
            if (labels != null) {
                for (String label : labels) {
                    response.addAuth(ByteStringer.wrap((byte[])Bytes.toBytes((String)label)));
                }
            }
        }
        done.run((Object)response.build());
    }

    public synchronized void clearAuths(RpcController controller, VisibilityLabelsProtos.SetAuthsRequest request, RpcCallback<VisibilityLabelsProtos.VisibilityLabelsResponse> done) {
        VisibilityLabelsProtos.VisibilityLabelsResponse.Builder response = VisibilityLabelsProtos.VisibilityLabelsResponse.newBuilder();
        List auths = request.getAuthList();
        if (!this.initialized) {
            this.setExceptionResults(auths.size(), (IOException)new CoprocessorException("VisibilityController not yet initialized"), response);
        } else {
            try {
                if (this.acOn && !this.isSystemOrSuperUser()) {
                    User user = VisibilityUtils.getActiveUser();
                    throw new AccessDeniedException("User '" + (user != null ? user.getShortName() : "null") + " is not authorized to perform this action.");
                }
                this.checkCallingUserAuth();
                ArrayList<byte[]> labelAuths = new ArrayList<byte[]>(auths.size());
                for (ByteString authBS : auths) {
                    labelAuths.add(authBS.toByteArray());
                }
                OperationStatus[] opStatus = this.visibilityLabelService.clearAuths(request.getUser().toByteArray(), labelAuths);
                ClientProtos.RegionActionResult successResult = ClientProtos.RegionActionResult.newBuilder().build();
                for (OperationStatus status : opStatus) {
                    if (status.getOperationStatusCode() == HConstants.OperationStatusCode.SUCCESS) {
                        response.addResult(successResult);
                        continue;
                    }
                    ClientProtos.RegionActionResult.Builder failureResultBuilder = ClientProtos.RegionActionResult.newBuilder();
                    failureResultBuilder.setException(ResponseConverter.buildException((Throwable)new DoNotRetryIOException(status.getExceptionMsg())));
                    response.addResult(failureResultBuilder.build());
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
                this.setExceptionResults(auths.size(), e, response);
            }
        }
        done.run((Object)response.build());
    }

    private void checkCallingUserAuth() throws IOException {
        if (!this.acOn) {
            User user = VisibilityUtils.getActiveUser();
            if (user == null) {
                throw new IOException("Unable to retrieve calling user");
            }
            if (!this.visibilityLabelService.havingSystemAuth(Bytes.toBytes((String)user.getShortName()))) {
                throw new AccessDeniedException("User '" + user.getShortName() + "' is not authorized to perform this action.");
            }
        }
    }

    static {
        RESERVED_VIS_TAG_TYPES.add((byte)2);
        RESERVED_VIS_TAG_TYPES.add((byte)4);
    }

    private static class DeleteVersionVisibilityExpressionFilter
    extends FilterBase {
        private List<Tag> deleteCellVisTags;
        private Byte deleteCellVisTagsFormat;

        public DeleteVersionVisibilityExpressionFilter(List<Tag> deleteCellVisTags, Byte deleteCellVisTagsFormat) {
            this.deleteCellVisTags = deleteCellVisTags;
            this.deleteCellVisTagsFormat = deleteCellVisTagsFormat;
        }

        public Filter.ReturnCode filterKeyValue(Cell cell) throws IOException {
            ArrayList<Tag> putVisTags = new ArrayList<Tag>();
            Byte putCellVisTagsFormat = VisibilityUtils.extractVisibilityTags(cell, putVisTags);
            boolean matchFound = VisibilityLabelServiceManager.getInstance().getVisibilityLabelService().matchVisibility(putVisTags, putCellVisTagsFormat, this.deleteCellVisTags, this.deleteCellVisTagsFormat);
            return matchFound ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.SKIP;
        }
    }
}

