/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterAllFilter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Hash;
import org.apache.hadoop.hbase.util.MurmurHash;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.NLineInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.lib.reduce.LongSumReducer;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class PerformanceEvaluation
extends Configured
implements Tool {
    protected static final Log LOG = LogFactory.getLog((String)PerformanceEvaluation.class.getName());
    public static final String TABLE_NAME = "TestTable";
    public static final byte[] FAMILY_NAME = Bytes.toBytes((String)"info");
    public static final byte[] QUALIFIER_NAME = Bytes.toBytes((String)"data");
    public static final int VALUE_LENGTH = 1000;
    public static final int ROW_LENGTH = 26;
    private static final int ONE_GB = 1048576000;
    private static final int ROWS_PER_GB = 0x100000;
    private static final int TAG_LENGTH = 256;
    private static final DecimalFormat FMT = new DecimalFormat("0.##");
    private static final MathContext CXT = MathContext.DECIMAL64;
    private static final BigDecimal MS_PER_SEC = BigDecimal.valueOf(1000L);
    private static final BigDecimal BYTES_PER_MB = BigDecimal.valueOf(0x100000L);
    private static final TestOptions DEFAULT_OPTS = new TestOptions();
    protected Map<String, CmdDescriptor> commands = new TreeMap<String, CmdDescriptor>();
    private static final Path PERF_EVAL_DIR = new Path("performance_evaluation");

    public PerformanceEvaluation(Configuration conf) {
        super(conf);
        this.addCommandDescriptor(RandomReadTest.class, "randomRead", "Run random read test");
        this.addCommandDescriptor(RandomSeekScanTest.class, "randomSeekScan", "Run random seek and scan 100 test");
        this.addCommandDescriptor(RandomScanWithRange10Test.class, "scanRange10", "Run random seek scan with both start and stop row (max 10 rows)");
        this.addCommandDescriptor(RandomScanWithRange100Test.class, "scanRange100", "Run random seek scan with both start and stop row (max 100 rows)");
        this.addCommandDescriptor(RandomScanWithRange1000Test.class, "scanRange1000", "Run random seek scan with both start and stop row (max 1000 rows)");
        this.addCommandDescriptor(RandomScanWithRange10000Test.class, "scanRange10000", "Run random seek scan with both start and stop row (max 10000 rows)");
        this.addCommandDescriptor(RandomWriteTest.class, "randomWrite", "Run random write test");
        this.addCommandDescriptor(SequentialReadTest.class, "sequentialRead", "Run sequential read test");
        this.addCommandDescriptor(SequentialWriteTest.class, "sequentialWrite", "Run sequential write test");
        this.addCommandDescriptor(ScanTest.class, "scan", "Run scan test (read every row)");
        this.addCommandDescriptor(FilteredScanTest.class, "filterScan", "Run scan test using a filter to find a specific row based on it's value (make sure to use --rows=20)");
    }

    protected void addCommandDescriptor(Class<? extends Test> cmdClass, String name, String description) {
        CmdDescriptor cmdDescriptor = new CmdDescriptor(cmdClass, name, description);
        this.commands.put(name, cmdDescriptor);
    }

    private static boolean checkTable(HBaseAdmin admin, TestOptions opts) throws IOException {
        HTableDescriptor tableDescriptor = PerformanceEvaluation.getTableDescriptor(opts);
        if (opts.presplitRegions > 0) {
            if (admin.tableExists(tableDescriptor.getTableName())) {
                admin.disableTable(tableDescriptor.getTableName());
                admin.deleteTable(tableDescriptor.getTableName());
            }
            byte[][] splits = PerformanceEvaluation.getSplits(opts);
            for (int i = 0; i < splits.length; ++i) {
                LOG.debug((Object)(" split " + i + ": " + Bytes.toStringBinary((byte[])splits[i])));
            }
            admin.createTable(tableDescriptor, splits);
            LOG.info((Object)("Table created with " + opts.presplitRegions + " splits"));
        } else {
            boolean tableExists = admin.tableExists(tableDescriptor.getTableName());
            if (!tableExists) {
                admin.createTable(tableDescriptor);
                LOG.info((Object)("Table " + tableDescriptor + " created"));
            }
        }
        return admin.tableExists(tableDescriptor.getTableName());
    }

    protected static HTableDescriptor getTableDescriptor(TestOptions opts) {
        HTableDescriptor desc = new HTableDescriptor(opts.tableName);
        HColumnDescriptor family = new HColumnDescriptor(FAMILY_NAME);
        family.setDataBlockEncoding(opts.blockEncoding);
        family.setCompressionType(opts.compression);
        family.setBloomFilterType(opts.bloomType);
        if (opts.inMemoryCF) {
            family.setInMemory(true);
        }
        desc.addFamily(family);
        return desc;
    }

    protected static byte[][] getSplits(TestOptions opts) {
        if (opts.presplitRegions == 0) {
            return new byte[0][];
        }
        int numSplitPoints = opts.presplitRegions - 1;
        byte[][] splits = new byte[numSplitPoints][];
        int jump = opts.totalRows / opts.presplitRegions;
        for (int i = 0; i < numSplitPoints; ++i) {
            int rowkey = jump * (1 + i);
            splits[i] = PerformanceEvaluation.format(rowkey);
        }
        return splits;
    }

    private void doLocalClients(final Class<? extends Test> cmd, final TestOptions opts) throws IOException, InterruptedException {
        int i;
        Future[] threads = new Future[opts.numClientThreads];
        long[] timings = new long[opts.numClientThreads];
        ExecutorService pool = Executors.newFixedThreadPool(opts.numClientThreads, new ThreadFactoryBuilder().setNameFormat("TestClient-%s").build());
        for (i = 0; i < threads.length; ++i) {
            final int index = i;
            threads[i] = pool.submit(new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    TestOptions threadOpts = new TestOptions(opts);
                    threadOpts.startRow = index * threadOpts.perClientRunRows;
                    long elapsedTime = PerformanceEvaluation.runOneClient(cmd, PerformanceEvaluation.this.getConf(), threadOpts, new Status(){

                        @Override
                        public void setStatus(String msg) throws IOException {
                            LOG.info((Object)("client-" + Thread.currentThread().getName() + " " + msg));
                        }
                    });
                    LOG.info((Object)("Finished " + Thread.currentThread().getName() + " in " + elapsedTime + "ms over " + threadOpts.perClientRunRows + " rows"));
                    return elapsedTime;
                }
            });
        }
        pool.shutdown();
        for (i = 0; i < threads.length; ++i) {
            try {
                timings[i] = (Long)threads[i].get();
                continue;
            }
            catch (ExecutionException e) {
                throw new IOException(e.getCause());
            }
        }
        String test = cmd.getSimpleName();
        LOG.info((Object)("[" + test + "] Summary of timings (ms): " + Arrays.toString(timings)));
        Arrays.sort(timings);
        long total = 0L;
        for (int i2 = 0; i2 < timings.length; ++i2) {
            total += timings[i2];
        }
        LOG.info((Object)("[" + test + "]" + "\tMin: " + timings[0] + "ms" + "\tMax: " + timings[timings.length - 1] + "ms" + "\tAvg: " + total / (long)timings.length + "ms"));
    }

    private void doMapReduce(Class<? extends Test> cmd, TestOptions opts) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = this.getConf();
        Path inputDir = this.writeInputFile(conf, opts);
        conf.set("EvaluationMapTask.command", cmd.getName());
        conf.set("EvaluationMapTask.performanceEvalImpl", ((Object)((Object)this)).getClass().getName());
        Job job = new Job(conf);
        job.setJarByClass(PerformanceEvaluation.class);
        job.setJobName("HBase Performance Evaluation");
        job.setInputFormatClass(NLineInputFormat.class);
        NLineInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputDir});
        NLineInputFormat.setNumLinesPerSplit((Job)job, (int)1);
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(LongWritable.class);
        job.setMapperClass(EvaluationMapTask.class);
        job.setReducerClass(LongSumReducer.class);
        job.setNumReduceTasks(1);
        job.setOutputFormatClass(TextOutputFormat.class);
        TextOutputFormat.setOutputPath((Job)job, (Path)new Path(inputDir.getParent(), "outputs"));
        TableMapReduceUtil.addDependencyJars((Job)job);
        TableMapReduceUtil.addDependencyJars((Configuration)job.getConfiguration(), (Class[])new Class[]{DescriptiveStatistics.class, ObjectMapper.class});
        TableMapReduceUtil.initCredentials((Job)job);
        job.waitForCompletion(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path writeInputFile(Configuration c, TestOptions opts) throws IOException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        Path jobdir = new Path(PERF_EVAL_DIR, formatter.format(new Date()));
        Path inputDir = new Path(jobdir, "inputs");
        FileSystem fs = FileSystem.get((Configuration)c);
        fs.mkdirs(inputDir);
        Path inputFile = new Path(inputDir, "input.txt");
        PrintStream out = new PrintStream((OutputStream)fs.create(inputFile));
        TreeMap<Integer, String> m = new TreeMap<Integer, String>();
        Hash h = MurmurHash.getInstance();
        int perClientRows = opts.totalRows / opts.numClientThreads;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.SORT_PROPERTIES_ALPHABETICALLY, true);
        try {
            for (int i = 0; i < 10; ++i) {
                for (int j = 0; j < opts.numClientThreads; ++j) {
                    TestOptions next = new TestOptions(opts);
                    next.startRow = j * perClientRows + i * (perClientRows / 10);
                    next.perClientRunRows = perClientRows / 10;
                    String s = mapper.writeValueAsString((Object)next);
                    int hash = h.hash(Bytes.toBytes((String)s));
                    m.put(hash, s);
                }
            }
            for (Map.Entry e : m.entrySet()) {
                out.println((String)e.getValue());
            }
        }
        finally {
            out.close();
        }
        return inputDir;
    }

    private static String calculateMbps(int rows, long timeMs) {
        BigDecimal rowSize = BigDecimal.valueOf(1026 + FAMILY_NAME.length + QUALIFIER_NAME.length);
        BigDecimal mbps = BigDecimal.valueOf(rows).multiply(rowSize, CXT).divide(BigDecimal.valueOf(timeMs), CXT).multiply(MS_PER_SEC, CXT).divide(BYTES_PER_MB, CXT);
        return FMT.format(mbps) + " MB/s";
    }

    public static byte[] format(int number) {
        byte[] b = new byte[26];
        int d = Math.abs(number);
        for (int i = b.length - 1; i >= 0; --i) {
            b[i] = (byte)(d % 10 + 48);
            d /= 10;
        }
        return b;
    }

    public static byte[] generateData(Random r, int length) {
        byte[] b = new byte[length];
        int i = 0;
        for (i = 0; i < length - 8; i += 8) {
            b[i] = (byte)(65 + r.nextInt(26));
            b[i + 1] = b[i];
            b[i + 2] = b[i];
            b[i + 3] = b[i];
            b[i + 4] = b[i];
            b[i + 5] = b[i];
            b[i + 6] = b[i];
            b[i + 7] = b[i];
        }
        byte a = (byte)(65 + r.nextInt(26));
        while (i < length) {
            b[i] = a;
            ++i;
        }
        return b;
    }

    @Deprecated
    public static byte[] generateValue(Random r) {
        return PerformanceEvaluation.generateData(r, 1000);
    }

    static byte[] getRandomRow(Random random, int totalRows) {
        return PerformanceEvaluation.format(random.nextInt(Integer.MAX_VALUE) % totalRows);
    }

    static long runOneClient(Class<? extends Test> cmd, Configuration conf, TestOptions opts, Status status) throws IOException {
        Test t;
        status.setStatus("Start " + cmd + " at offset " + opts.startRow + " for " + opts.perClientRunRows + " rows");
        long totalElapsedTime = 0L;
        try {
            Constructor<? extends Test> constructor = cmd.getDeclaredConstructor(Configuration.class, TestOptions.class, Status.class);
            t = constructor.newInstance(conf, opts, status);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Invalid command class: " + cmd.getName() + ".  It does not provide a constructor as described by " + "the javadoc comment.  Available constructors are: " + Arrays.toString(cmd.getConstructors()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to construct command class", e);
        }
        totalElapsedTime = t.test();
        status.setStatus("Finished " + cmd + " in " + totalElapsedTime + "ms at offset " + opts.startRow + " for " + opts.perClientRunRows + " rows" + " (" + PerformanceEvaluation.calculateMbps((int)((float)opts.perClientRunRows * opts.sampleRate), totalElapsedTime) + ")");
        return totalElapsedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(Class<? extends Test> cmd, TestOptions opts) throws IOException, InterruptedException, ClassNotFoundException {
        HBaseAdmin admin = null;
        try {
            admin = new HBaseAdmin(this.getConf());
            PerformanceEvaluation.checkTable(admin, opts);
        }
        finally {
            if (admin != null) {
                admin.close();
            }
        }
        if (opts.nomapred) {
            this.doLocalClients(cmd, opts);
        } else {
            this.doMapReduce(cmd, opts);
        }
    }

    protected void printUsage() {
        this.printUsage(null);
    }

    protected void printUsage(String message) {
        if (message != null && message.length() > 0) {
            System.err.println(message);
        }
        System.err.println("Usage: java " + ((Object)((Object)this)).getClass().getName() + " \\");
        System.err.println("  [--nomapred] [--rows=ROWS] [--table=NAME] \\");
        System.err.println("  [--compress=TYPE] [--blockEncoding=TYPE] [-D<property=value>]* <command> <nclients>");
        System.err.println();
        System.err.println("Options:");
        System.err.println(" nomapred        Run multiple clients using threads (rather than use mapreduce)");
        System.err.println(" rows            Rows each client runs. Default: One million");
        System.err.println(" sampleRate      Execute test on a sample of total rows. Only supported by randomRead. Default: 1.0");
        System.err.println(" table           Alternate table name. Default: 'TestTable'");
        System.err.println(" compress        Compression type to use (GZ, LZO, ...). Default: 'NONE'");
        System.err.println(" flushCommits    Used to determine if the test should flush the table. Default: false");
        System.err.println(" writeToWAL      Set writeToWAL on puts. Default: True");
        System.err.println(" presplit        Create presplit table. Recommended for accurate perf analysis (see guide).  Default: disabled");
        System.err.println(" inmemory        Tries to keep the HFiles of the CF inmemory as far as possible. Not guaranteed that reads are always served from memory.  Default: false");
        System.err.println(" usetags         Writes tags along with KVs. Use with HFile V3. Default: false");
        System.err.println(" numoftags       Specify the no of tags that would be needed. This works only if usetags is true.");
        System.err.println(" filterAll       Helps to filter out all the rows on the server side there by not returning any thing back to the client.  Helps to check the server side performance.  Uses FilterAllFilter internally. ");
        System.err.println(" latency         Set to report operation latencies. Currently only supported by randomRead test. Default: False");
        System.err.println(" bloomFilter      Bloom filter type, one of " + Arrays.toString(BloomType.values()));
        System.err.println();
        System.err.println(" Note: -D properties will be applied to the conf used. ");
        System.err.println("  For example: ");
        System.err.println("   -Dmapred.output.compress=true");
        System.err.println("   -Dmapreduce.task.timeout=60000");
        System.err.println();
        System.err.println("Command:");
        for (CmdDescriptor command : this.commands.values()) {
            System.err.println(String.format(" %-15s %s", command.getName(), command.getDescription()));
        }
        System.err.println();
        System.err.println("Args:");
        System.err.println(" nclients        Integer. Required. Total number of clients (and HRegionServers)");
        System.err.println("                 running: 1 <= value <= 500");
        System.err.println("Examples:");
        System.err.println(" To run a single evaluation client:");
        System.err.println(" $ bin/hbase " + ((Object)((Object)this)).getClass().getName() + " sequentialWrite 1");
    }

    private static int getNumClients(int start, String[] args) {
        if (start + 1 > args.length) {
            throw new IllegalArgumentException("must supply the number of clients");
        }
        int N = Integer.parseInt(args[start]);
        if (N < 1) {
            throw new IllegalArgumentException("Number of clients must be > 1");
        }
        return N;
    }

    public int run(String[] args) throws Exception {
        int errCode = -1;
        if (args.length < 1) {
            this.printUsage();
            return errCode;
        }
        try {
            TestOptions opts = new TestOptions();
            for (int i = 0; i < args.length; ++i) {
                String cmd = args[i];
                if (cmd.equals("-h") || cmd.startsWith("--h")) {
                    this.printUsage();
                    errCode = 0;
                } else {
                    String nmr = "--nomapred";
                    if (cmd.startsWith("--nomapred")) {
                        opts.nomapred = true;
                        continue;
                    }
                    String rows = "--rows=";
                    if (cmd.startsWith("--rows=")) {
                        opts.perClientRunRows = Integer.parseInt(cmd.substring("--rows=".length()));
                        continue;
                    }
                    String sampleRate = "--sampleRate=";
                    if (cmd.startsWith("--sampleRate=")) {
                        opts.sampleRate = Float.parseFloat(cmd.substring("--sampleRate=".length()));
                        continue;
                    }
                    String table = "--table=";
                    if (cmd.startsWith("--table=")) {
                        opts.tableName = cmd.substring("--table=".length());
                        continue;
                    }
                    String compress = "--compress=";
                    if (cmd.startsWith("--compress=")) {
                        opts.compression = Compression.Algorithm.valueOf((String)cmd.substring("--compress=".length()));
                        continue;
                    }
                    String blockEncoding = "--blockEncoding=";
                    if (cmd.startsWith("--blockEncoding=")) {
                        opts.blockEncoding = DataBlockEncoding.valueOf((String)cmd.substring("--blockEncoding=".length()));
                        continue;
                    }
                    String flushCommits = "--flushCommits=";
                    if (cmd.startsWith("--flushCommits=")) {
                        opts.flushCommits = Boolean.parseBoolean(cmd.substring("--flushCommits=".length()));
                        continue;
                    }
                    String writeToWAL = "--writeToWAL=";
                    if (cmd.startsWith("--writeToWAL=")) {
                        opts.writeToWAL = Boolean.parseBoolean(cmd.substring("--writeToWAL=".length()));
                        continue;
                    }
                    String presplit = "--presplit=";
                    if (cmd.startsWith("--presplit=")) {
                        opts.presplitRegions = Integer.parseInt(cmd.substring("--presplit=".length()));
                        continue;
                    }
                    String inMemory = "--inmemory=";
                    if (cmd.startsWith("--inmemory=")) {
                        opts.inMemoryCF = Boolean.parseBoolean(cmd.substring("--inmemory=".length()));
                        continue;
                    }
                    String latency = "--latency";
                    if (cmd.startsWith("--latency")) {
                        opts.reportLatency = true;
                        continue;
                    }
                    String multiGet = "--multiGet=";
                    if (cmd.startsWith("--multiGet=")) {
                        opts.multiGet = Integer.parseInt(cmd.substring("--multiGet=".length()));
                        continue;
                    }
                    String useTags = "--usetags=";
                    if (cmd.startsWith("--usetags=")) {
                        opts.useTags = Boolean.parseBoolean(cmd.substring("--usetags=".length()));
                        continue;
                    }
                    String noOfTags = "--nooftags=";
                    if (cmd.startsWith("--nooftags=")) {
                        opts.noOfTags = Integer.parseInt(cmd.substring("--nooftags=".length()));
                        continue;
                    }
                    String filterOutAll = "--filterAll";
                    if (cmd.startsWith("--filterAll")) {
                        opts.filterAll = true;
                        continue;
                    }
                    String bloomFilter = "--bloomFilter";
                    if (cmd.startsWith("--bloomFilter")) {
                        opts.bloomType = BloomType.valueOf((String)cmd.substring("--bloomFilter".length()));
                        continue;
                    }
                    Class<? extends Test> cmdClass = this.determineCommandClass(cmd);
                    if (cmdClass != null) {
                        opts.numClientThreads = PerformanceEvaluation.getNumClients(i + 1, args);
                        opts.totalRows = opts.perClientRunRows * opts.numClientThreads;
                        this.runTest(cmdClass, opts);
                        errCode = 0;
                    } else {
                        this.printUsage();
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errCode;
    }

    private Class<? extends Test> determineCommandClass(String cmd) {
        CmdDescriptor descriptor = this.commands.get(cmd);
        return descriptor != null ? descriptor.getCmdClass() : null;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Tool)new PerformanceEvaluation(HBaseConfiguration.create()), (String[])args);
        System.exit(res);
    }

    static class FilteredScanTest
    extends Test {
        protected static final Log LOG = LogFactory.getLog((String)FilteredScanTest.class.getName());

        FilteredScanTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void testRow(int i) throws IOException {
            byte[] value = PerformanceEvaluation.generateData(this.rand, 1000);
            Scan scan = this.constructScan(value);
            ResultScanner scanner = null;
            try {
                scanner = this.table.getScanner(scan);
                while (scanner.next() != null) {
                }
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }

        protected Scan constructScan(byte[] valuePrefix) throws IOException {
            FilterList list = new FilterList(new Filter[0]);
            SingleColumnValueFilter filter = new SingleColumnValueFilter(FAMILY_NAME, QUALIFIER_NAME, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(valuePrefix));
            list.addFilter((Filter)filter);
            if (this.opts.filterAll) {
                list.addFilter((Filter)new FilterAllFilter());
            }
            Scan scan = new Scan();
            scan.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            scan.setFilter((Filter)list);
            return scan;
        }
    }

    static class SequentialWriteTest
    extends Test {
        SequentialWriteTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            byte[] row = PerformanceEvaluation.format(i);
            Put put = new Put(row);
            byte[] value = PerformanceEvaluation.generateData(this.rand, 1000);
            if (this.opts.useTags) {
                byte[] tag = PerformanceEvaluation.generateData(this.rand, 256);
                Tag[] tags = new Tag[this.opts.noOfTags];
                for (int n = 0; n < this.opts.noOfTags; ++n) {
                    Tag t;
                    tags[n] = t = new Tag((byte)n, tag);
                }
                KeyValue kv = new KeyValue(row, FAMILY_NAME, QUALIFIER_NAME, Long.MAX_VALUE, value, tags);
                put.add((Cell)kv);
            } else {
                put.add(FAMILY_NAME, QUALIFIER_NAME, value);
            }
            put.setDurability(this.opts.writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
            this.table.put(put);
        }
    }

    static class SequentialReadTest
    extends Test {
        SequentialReadTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            Get get = new Get(PerformanceEvaluation.format(i));
            get.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            if (this.opts.filterAll) {
                get.setFilter((Filter)new FilterAllFilter());
            }
            this.table.get(get);
        }
    }

    static class ScanTest
    extends Test {
        private ResultScanner testScanner;

        ScanTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        void testTakedown() throws IOException {
            if (this.testScanner != null) {
                this.testScanner.close();
            }
            super.testTakedown();
        }

        @Override
        void testRow(int i) throws IOException {
            if (this.testScanner == null) {
                Scan scan = new Scan(PerformanceEvaluation.format(this.opts.startRow));
                scan.setCaching(30);
                scan.addColumn(FAMILY_NAME, QUALIFIER_NAME);
                if (this.opts.filterAll) {
                    scan.setFilter((Filter)new FilterAllFilter());
                }
                this.testScanner = this.table.getScanner(scan);
            }
            this.testScanner.next();
        }
    }

    static class RandomWriteTest
    extends Test {
        RandomWriteTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            byte[] row = PerformanceEvaluation.getRandomRow(this.rand, this.opts.totalRows);
            Put put = new Put(row);
            byte[] value = PerformanceEvaluation.generateData(this.rand, 1000);
            if (this.opts.useTags) {
                byte[] tag = PerformanceEvaluation.generateData(this.rand, 256);
                Tag[] tags = new Tag[this.opts.noOfTags];
                for (int n = 0; n < this.opts.noOfTags; ++n) {
                    Tag t;
                    tags[n] = t = new Tag((byte)n, tag);
                }
                KeyValue kv = new KeyValue(row, FAMILY_NAME, QUALIFIER_NAME, Long.MAX_VALUE, value, tags);
                put.add((Cell)kv);
            } else {
                put.add(FAMILY_NAME, QUALIFIER_NAME, value);
            }
            put.setDurability(this.opts.writeToWAL ? Durability.SYNC_WAL : Durability.SKIP_WAL);
            this.table.put(put);
        }
    }

    static class RandomReadTest
    extends Test {
        private final int everyN;
        private final double[] times;
        private ArrayList<Get> gets;
        int idx = 0;

        RandomReadTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
            this.everyN = (int)((float)this.opts.totalRows / ((float)this.opts.totalRows * this.opts.sampleRate));
            LOG.info((Object)("Sampling 1 every " + this.everyN + " out of " + this.opts.perClientRunRows + " total rows."));
            if (this.opts.multiGet > 0) {
                LOG.info((Object)("MultiGet enabled. Sending GETs in batches of " + this.opts.multiGet + "."));
                this.gets = new ArrayList(this.opts.multiGet);
            }
            this.times = (double[])(this.opts.reportLatency ? new double[(int)Math.ceil((float)this.opts.perClientRunRows * this.opts.sampleRate / (float)Math.max(1, this.opts.multiGet))] : null);
        }

        @Override
        void testRow(int i) throws IOException {
            if (i % this.everyN == 0) {
                Get get = new Get(PerformanceEvaluation.getRandomRow(this.rand, this.opts.totalRows));
                get.addColumn(FAMILY_NAME, QUALIFIER_NAME);
                if (this.opts.filterAll) {
                    get.setFilter((Filter)new FilterAllFilter());
                }
                if (this.opts.multiGet > 0) {
                    this.gets.add(get);
                    if (this.gets.size() == this.opts.multiGet) {
                        long start = System.nanoTime();
                        this.table.get(this.gets);
                        if (this.opts.reportLatency) {
                            this.times[this.idx++] = (double)(System.nanoTime() - start) / 1000000.0;
                        }
                        this.gets.clear();
                    }
                } else {
                    long start = System.nanoTime();
                    this.table.get(get);
                    if (this.opts.reportLatency) {
                        this.times[this.idx++] = (double)(System.nanoTime() - start) / 1000000.0;
                    }
                }
            }
        }

        @Override
        protected int getReportingPeriod() {
            int period = this.opts.perClientRunRows / 100;
            return period == 0 ? this.opts.perClientRunRows : period;
        }

        @Override
        protected void testTakedown() throws IOException {
            if (this.gets != null && this.gets.size() > 0) {
                this.table.get(this.gets);
                this.gets.clear();
            }
            super.testTakedown();
            if (this.opts.reportLatency) {
                Arrays.sort(this.times);
                DescriptiveStatistics ds = new DescriptiveStatistics();
                for (double t : this.times) {
                    ds.addValue(t);
                }
                LOG.info((Object)("randomRead latency log (ms), on " + this.times.length + " measures"));
                LOG.info((Object)("99.9999% = " + ds.getPercentile(99.9999)));
                LOG.info((Object)(" 99.999% = " + ds.getPercentile(99.999)));
                LOG.info((Object)("  99.99% = " + ds.getPercentile(99.99)));
                LOG.info((Object)("   99.9% = " + ds.getPercentile(99.9)));
                LOG.info((Object)("     99% = " + ds.getPercentile(99.0)));
                LOG.info((Object)("     95% = " + ds.getPercentile(95.0)));
                LOG.info((Object)("     90% = " + ds.getPercentile(90.0)));
                LOG.info((Object)("     80% = " + ds.getPercentile(80.0)));
                LOG.info((Object)("Standard Deviation = " + ds.getStandardDeviation()));
                LOG.info((Object)("Mean = " + ds.getMean()));
            }
        }
    }

    static class RandomScanWithRange10000Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange10000Test(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(10000);
        }
    }

    static class RandomScanWithRange1000Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange1000Test(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(1000);
        }
    }

    static class RandomScanWithRange100Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange100Test(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(100);
        }
    }

    static class RandomScanWithRange10Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange10Test(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(10);
        }
    }

    static abstract class RandomScanWithRangeTest
    extends Test {
        RandomScanWithRangeTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            Result rr;
            Pair<byte[], byte[]> startAndStopRow = this.getStartAndStopRow();
            Scan scan = new Scan((byte[])startAndStopRow.getFirst(), (byte[])startAndStopRow.getSecond());
            if (this.opts.filterAll) {
                scan.setFilter((Filter)new FilterAllFilter());
            }
            scan.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            ResultScanner s = this.table.getScanner(scan);
            int count = 0;
            while ((rr = s.next()) != null) {
                ++count;
            }
            if (i % 100 == 0) {
                LOG.info((Object)String.format("Scan for key range %s - %s returned %s rows", Bytes.toString((byte[])((byte[])startAndStopRow.getFirst())), Bytes.toString((byte[])((byte[])startAndStopRow.getSecond())), count));
            }
            s.close();
        }

        protected abstract Pair<byte[], byte[]> getStartAndStopRow();

        protected Pair<byte[], byte[]> generateStartAndStopRows(int maxRange) {
            int start = this.rand.nextInt(Integer.MAX_VALUE) % this.opts.totalRows;
            int stop = start + maxRange;
            return new Pair((Object)PerformanceEvaluation.format(start), (Object)PerformanceEvaluation.format(stop));
        }

        @Override
        protected int getReportingPeriod() {
            int period = this.opts.perClientRunRows / 100;
            return period == 0 ? this.opts.perClientRunRows : period;
        }
    }

    static class RandomSeekScanTest
    extends Test {
        RandomSeekScanTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            Result rr;
            Scan scan = new Scan(PerformanceEvaluation.getRandomRow(this.rand, this.opts.totalRows));
            FilterList list = new FilterList(new Filter[0]);
            scan.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            if (this.opts.filterAll) {
                list.addFilter((Filter)new FilterAllFilter());
            }
            list.addFilter((Filter)new WhileMatchFilter((Filter)new PageFilter(120L)));
            scan.setFilter((Filter)list);
            ResultScanner s = this.table.getScanner(scan);
            while ((rr = s.next()) != null) {
            }
            s.close();
        }

        @Override
        protected int getReportingPeriod() {
            int period = this.opts.perClientRunRows / 100;
            return period == 0 ? this.opts.perClientRunRows : period;
        }
    }

    static abstract class Test {
        private static final Random randomSeed = new Random(System.currentTimeMillis());
        protected final Random rand = new Random(Test.nextRandomSeed());
        protected final Configuration conf;
        protected final TestOptions opts;
        private final Status status;
        protected HConnection connection;
        protected HTableInterface table;

        private static long nextRandomSeed() {
            return randomSeed.nextLong();
        }

        Test(Configuration conf, TestOptions options, Status status) {
            this.conf = conf;
            this.opts = options;
            this.status = status;
        }

        private String generateStatus(int sr, int i, int lr) {
            return sr + "/" + i + "/" + lr;
        }

        protected int getReportingPeriod() {
            int period = this.opts.perClientRunRows / 10;
            return period == 0 ? this.opts.perClientRunRows : period;
        }

        void testSetup() throws IOException {
            this.connection = HConnectionManager.createConnection((Configuration)this.conf);
            this.table = this.connection.getTable(this.opts.tableName);
            this.table.setAutoFlush(false, true);
        }

        void testTakedown() throws IOException {
            if (this.opts.flushCommits) {
                this.table.flushCommits();
            }
            this.table.close();
            this.connection.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long test() throws IOException {
            this.testSetup();
            LOG.info((Object)("Timed test starting in thread " + Thread.currentThread().getName()));
            long startTime = System.nanoTime();
            try {
                this.testTimed();
            }
            finally {
                this.testTakedown();
            }
            return (System.nanoTime() - startTime) / 1000000L;
        }

        void testTimed() throws IOException {
            int lastRow = this.opts.startRow + this.opts.perClientRunRows;
            for (int i = this.opts.startRow; i < lastRow; ++i) {
                this.testRow(i);
                if (this.status == null || i <= 0 || i % this.getReportingPeriod() != 0) continue;
                this.status.setStatus(this.generateStatus(this.opts.startRow, i, lastRow));
            }
        }

        abstract void testRow(int var1) throws IOException;
    }

    static class TestOptions {
        public boolean nomapred = false;
        public boolean filterAll = false;
        public int startRow = 0;
        public int perClientRunRows = 0x100000;
        public int numClientThreads = 1;
        public int totalRows = 0x100000;
        public float sampleRate = 1.0f;
        public String tableName = "TestTable";
        public boolean flushCommits = true;
        public boolean writeToWAL = true;
        public boolean useTags = false;
        public int noOfTags = 1;
        public boolean reportLatency = false;
        public int multiGet = 0;
        boolean inMemoryCF = false;
        int presplitRegions = 0;
        public Compression.Algorithm compression = Compression.Algorithm.NONE;
        public BloomType bloomType = BloomType.ROW;
        public DataBlockEncoding blockEncoding = DataBlockEncoding.NONE;

        public TestOptions() {
        }

        public TestOptions(TestOptions that) {
            this.nomapred = that.nomapred;
            this.startRow = that.startRow;
            this.perClientRunRows = that.perClientRunRows;
            this.numClientThreads = that.numClientThreads;
            this.totalRows = that.totalRows;
            this.sampleRate = that.sampleRate;
            this.tableName = that.tableName;
            this.flushCommits = that.flushCommits;
            this.writeToWAL = that.writeToWAL;
            this.useTags = that.useTags;
            this.noOfTags = that.noOfTags;
            this.reportLatency = that.reportLatency;
            this.multiGet = that.multiGet;
            this.inMemoryCF = that.inMemoryCF;
            this.presplitRegions = that.presplitRegions;
            this.compression = that.compression;
            this.blockEncoding = that.blockEncoding;
            this.filterAll = that.filterAll;
            this.bloomType = that.bloomType;
        }
    }

    static class CmdDescriptor {
        private Class<? extends Test> cmdClass;
        private String name;
        private String description;

        CmdDescriptor(Class<? extends Test> cmdClass, String name, String description) {
            this.cmdClass = cmdClass;
            this.name = name;
            this.description = description;
        }

        public Class<? extends Test> getCmdClass() {
            return this.cmdClass;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class EvaluationMapTask
    extends Mapper<LongWritable, Text, LongWritable, LongWritable> {
        public static final String CMD_KEY = "EvaluationMapTask.command";
        public static final String PE_KEY = "EvaluationMapTask.performanceEvalImpl";
        private Class<? extends Test> cmd;
        private PerformanceEvaluation pe;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.cmd = this.forName(context.getConfiguration().get(CMD_KEY), Test.class);
            Class<PerformanceEvaluation> peClass = this.forName(context.getConfiguration().get(PE_KEY), PerformanceEvaluation.class);
            try {
                this.pe = peClass.getConstructor(Configuration.class).newInstance(context.getConfiguration());
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not instantiate PE instance", e);
            }
        }

        private <Type> Class<? extends Type> forName(String className, Class<Type> type) {
            try {
                return Class.forName(className).asSubclass(type);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not find class for name: " + className, e);
            }
        }

        protected void map(LongWritable key, Text value, final Mapper.Context context) throws IOException, InterruptedException {
            Status status = new Status(){

                @Override
                public void setStatus(String msg) {
                    context.setStatus(msg);
                }
            };
            ObjectMapper mapper = new ObjectMapper();
            TestOptions opts = (TestOptions)mapper.readValue(value.toString(), TestOptions.class);
            Configuration conf = HBaseConfiguration.create((Configuration)context.getConfiguration());
            long elapsedTime = PerformanceEvaluation.runOneClient(this.cmd, conf, opts, status);
            context.getCounter((Enum)Counter.ELAPSED_TIME).increment(elapsedTime);
            context.getCounter((Enum)Counter.ROWS).increment((long)opts.perClientRunRows);
            context.write((Object)new LongWritable((long)opts.startRow), (Object)new LongWritable(elapsedTime));
            context.progress();
        }
    }

    static interface Status {
        public void setStatus(String var1) throws IOException;
    }

    protected static enum Counter {
        ELAPSED_TIME,
        ROWS;

    }
}

