/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcChannel;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.coprocessor.SingletonCoprocessorService;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.DummyRegionServerEndpointProtos;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionServerCoprocessorEndpoint {
    private static HBaseTestingUtility TEST_UTIL = null;
    private static Configuration CONF = null;
    private static final String DUMMY_VALUE = "val";

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        CONF = TEST_UTIL.getConfiguration();
        CONF.setStrings("hbase.coprocessor.regionserver.classes", new String[]{DummyRegionServerEndpoint.class.getName()});
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testEndpoint() throws Exception {
        ServerName serverName = TEST_UTIL.getHBaseCluster().getRegionServer(0).getServerName();
        ServerRpcController controller = new ServerRpcController();
        BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
        DummyRegionServerEndpointProtos.DummyService service = (DummyRegionServerEndpointProtos.DummyService)ProtobufUtil.newServiceStub(DummyRegionServerEndpointProtos.DummyService.class, (RpcChannel)new HBaseAdmin(CONF).coprocessorService(serverName));
        service.dummyCall((RpcController)controller, DummyRegionServerEndpointProtos.DummyRequest.getDefaultInstance(), (RpcCallback<DummyRegionServerEndpointProtos.DummyResponse>)rpcCallback);
        Assert.assertEquals((Object)DUMMY_VALUE, (Object)((DummyRegionServerEndpointProtos.DummyResponse)rpcCallback.get()).getValue());
        if (controller.failedOnException()) {
            throw controller.getFailedOn();
        }
    }

    static class DummyRegionServerEndpoint
    extends DummyRegionServerEndpointProtos.DummyService
    implements Coprocessor,
    SingletonCoprocessorService {
        DummyRegionServerEndpoint() {
        }

        public Service getService() {
            return this;
        }

        public void start(CoprocessorEnvironment env) throws IOException {
        }

        public void stop(CoprocessorEnvironment env) throws IOException {
        }

        @Override
        public void dummyCall(RpcController controller, DummyRegionServerEndpointProtos.DummyRequest request, RpcCallback<DummyRegionServerEndpointProtos.DummyResponse> callback) {
            callback.run((Object)DummyRegionServerEndpointProtos.DummyResponse.newBuilder().setValue(TestRegionServerCoprocessorEndpoint.DUMMY_VALUE).build());
        }
    }
}

