/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.LongComparator;
import org.apache.hadoop.hbase.filter.NullComparator;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSingleColumnValueFilter {
    private static final byte[] ROW = Bytes.toBytes((String)"test");
    private static final byte[] COLUMN_FAMILY = Bytes.toBytes((String)"test");
    private static final byte[] COLUMN_QUALIFIER = Bytes.toBytes((String)"foo");
    private static final byte[] VAL_1 = Bytes.toBytes((String)"a");
    private static final byte[] VAL_2 = Bytes.toBytes((String)"ab");
    private static final byte[] VAL_3 = Bytes.toBytes((String)"abc");
    private static final byte[] VAL_4 = Bytes.toBytes((String)"abcd");
    private static final byte[] FULLSTRING_1 = Bytes.toBytes((String)"The quick brown fox jumps over the lazy dog.");
    private static final byte[] FULLSTRING_2 = Bytes.toBytes((String)"The slow grey fox trips over the lazy dog.");
    private static final String QUICK_SUBSTR = "quick";
    private static final String QUICK_REGEX = ".+quick.+";
    private static final Pattern QUICK_PATTERN = Pattern.compile("QuIcK", 34);
    Filter basicFilter;
    Filter nullFilter;
    Filter substrFilter;
    Filter regexFilter;
    Filter regexPatternFilter;

    @Before
    public void setUp() throws Exception {
        this.basicFilter = this.basicFilterNew();
        this.nullFilter = this.nullFilterNew();
        this.substrFilter = this.substrFilterNew();
        this.regexFilter = this.regexFilterNew();
        this.regexPatternFilter = this.regexFilterNew(QUICK_PATTERN);
    }

    private Filter basicFilterNew() {
        return new SingleColumnValueFilter(COLUMN_FAMILY, COLUMN_QUALIFIER, CompareFilter.CompareOp.GREATER_OR_EQUAL, VAL_2);
    }

    private Filter nullFilterNew() {
        return new SingleColumnValueFilter(COLUMN_FAMILY, COLUMN_QUALIFIER, CompareFilter.CompareOp.NOT_EQUAL, (ByteArrayComparable)new NullComparator());
    }

    private Filter substrFilterNew() {
        return new SingleColumnValueFilter(COLUMN_FAMILY, COLUMN_QUALIFIER, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new SubstringComparator(QUICK_SUBSTR));
    }

    private Filter regexFilterNew() {
        return new SingleColumnValueFilter(COLUMN_FAMILY, COLUMN_QUALIFIER, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator(QUICK_REGEX));
    }

    private Filter regexFilterNew(Pattern pattern) {
        return new SingleColumnValueFilter(COLUMN_FAMILY, COLUMN_QUALIFIER, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator(pattern.pattern(), pattern.flags()));
    }

    @Test
    public void testLongComparator() throws IOException {
        SingleColumnValueFilter filter = new SingleColumnValueFilter(COLUMN_FAMILY, COLUMN_QUALIFIER, CompareFilter.CompareOp.GREATER, (ByteArrayComparable)new LongComparator(100L));
        KeyValue kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, Bytes.toBytes((long)1L));
        Assert.assertTrue((String)"less than", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.NEXT_ROW ? 1 : 0) != 0);
        filter.reset();
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, Bytes.toBytes((long)100L));
        Assert.assertTrue((String)"Equals 100", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.NEXT_ROW ? 1 : 0) != 0);
        filter.reset();
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, Bytes.toBytes((long)120L));
        Assert.assertTrue((String)"include 120", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
    }

    private void basicFilterTests(SingleColumnValueFilter filter) throws Exception {
        KeyValue kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_2);
        Assert.assertTrue((String)"basicFilter1", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_3);
        Assert.assertTrue((String)"basicFilter2", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_4);
        Assert.assertTrue((String)"basicFilter3", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        Assert.assertFalse((String)"basicFilterNotNull", (boolean)filter.filterRow());
        filter.reset();
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_1);
        Assert.assertTrue((String)"basicFilter4", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.NEXT_ROW ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_2);
        Assert.assertTrue((String)"basicFilter4", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.NEXT_ROW ? 1 : 0) != 0);
        Assert.assertFalse((String)"basicFilterAllRemaining", (boolean)filter.filterAllRemaining());
        Assert.assertTrue((String)"basicFilterNotNull", (boolean)filter.filterRow());
        filter.reset();
        filter.setLatestVersionOnly(false);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_1);
        Assert.assertTrue((String)"basicFilter5", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_2);
        Assert.assertTrue((String)"basicFilter5", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        Assert.assertFalse((String)"basicFilterNotNull", (boolean)filter.filterRow());
    }

    private void nullFilterTests(Filter filter) throws Exception {
        ((SingleColumnValueFilter)filter).setFilterIfMissing(true);
        KeyValue kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, FULLSTRING_1);
        Assert.assertTrue((String)"null1", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        Assert.assertFalse((String)"null1FilterRow", (boolean)filter.filterRow());
        filter.reset();
        kv = new KeyValue(ROW, COLUMN_FAMILY, Bytes.toBytes((String)"qual2"), FULLSTRING_2);
        Assert.assertTrue((String)"null2", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        Assert.assertTrue((String)"null2FilterRow", (boolean)filter.filterRow());
    }

    private void substrFilterTests(Filter filter) throws Exception {
        KeyValue kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, FULLSTRING_1);
        Assert.assertTrue((String)"substrTrue", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, FULLSTRING_2);
        Assert.assertTrue((String)"substrFalse", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        Assert.assertFalse((String)"substrFilterAllRemaining", (boolean)filter.filterAllRemaining());
        Assert.assertFalse((String)"substrFilterNotNull", (boolean)filter.filterRow());
    }

    private void regexFilterTests(Filter filter) throws Exception {
        KeyValue kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, FULLSTRING_1);
        Assert.assertTrue((String)"regexTrue", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, FULLSTRING_2);
        Assert.assertTrue((String)"regexFalse", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        Assert.assertFalse((String)"regexFilterAllRemaining", (boolean)filter.filterAllRemaining());
        Assert.assertFalse((String)"regexFilterNotNull", (boolean)filter.filterRow());
    }

    private void regexPatternFilterTests(Filter filter) throws Exception {
        KeyValue kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, FULLSTRING_1);
        Assert.assertTrue((String)"regexTrue", (filter.filterKeyValue((Cell)kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        Assert.assertFalse((String)"regexFilterAllRemaining", (boolean)filter.filterAllRemaining());
        Assert.assertFalse((String)"regexFilterNotNull", (boolean)filter.filterRow());
    }

    private Filter serializationTest(Filter filter) throws Exception {
        byte[] buffer = filter.toByteArray();
        SingleColumnValueFilter newFilter = SingleColumnValueFilter.parseFrom((byte[])buffer);
        return newFilter;
    }

    @Test
    public void testStop() throws Exception {
        this.basicFilterTests((SingleColumnValueFilter)this.basicFilter);
        this.nullFilterTests(this.nullFilter);
        this.substrFilterTests(this.substrFilter);
        this.regexFilterTests(this.regexFilter);
        this.regexPatternFilterTests(this.regexPatternFilter);
    }

    @Test
    public void testSerialization() throws Exception {
        Filter newFilter = this.serializationTest(this.basicFilter);
        this.basicFilterTests((SingleColumnValueFilter)newFilter);
        newFilter = this.serializationTest(this.nullFilter);
        this.nullFilterTests(newFilter);
        newFilter = this.serializationTest(this.substrFilter);
        this.substrFilterTests(newFilter);
        newFilter = this.serializationTest(this.regexFilter);
        this.regexFilterTests(newFilter);
        newFilter = this.serializationTest(this.regexPatternFilter);
        this.regexPatternFilterTests(newFilter);
    }
}

