/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.AbstractHFileWriter;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CorruptHFileException;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHFile
extends HBaseTestCase {
    static final Log LOG = LogFactory.getLog(TestHFile.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static String ROOT_DIR = TEST_UTIL.getDataTestDir("TestHFile").toString();
    private final int minBlockSize = 512;
    private static String localFormatter = "%010d";
    private static CacheConfig cacheConf = null;
    private Map<String, Long> startingMetrics;

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testEmptyHFile() throws IOException {
        if (cacheConf == null) {
            cacheConf = new CacheConfig(this.conf);
        }
        Path f = new Path(ROOT_DIR, this.getName());
        HFileContext context = new HFileContextBuilder().withIncludesTags(false).build();
        HFile.Writer w = HFile.getWriterFactory((Configuration)this.conf, (CacheConfig)cacheConf).withPath(this.fs, f).withFileContext(context).create();
        w.close();
        HFile.Reader r = HFile.createReader((FileSystem)this.fs, (Path)f, (CacheConfig)cacheConf, (Configuration)this.conf);
        r.loadFileInfo();
        TestHFile.assertNull((Object)r.getFirstKey());
        TestHFile.assertNull((Object)r.getLastKey());
    }

    public void testCorrupt0LengthHFile() throws IOException {
        if (cacheConf == null) {
            cacheConf = new CacheConfig(this.conf);
        }
        Path f = new Path(ROOT_DIR, this.getName());
        FSDataOutputStream fsos = this.fs.create(f);
        fsos.close();
        try {
            HFile.Reader r = HFile.createReader((FileSystem)this.fs, (Path)f, (CacheConfig)cacheConf, (Configuration)this.conf);
        }
        catch (CorruptHFileException che) {
            return;
        }
        TestHFile.fail((String)"Should have thrown exception");
    }

    public static void truncateFile(FileSystem fs, Path src, Path dst) throws IOException {
        FileStatus fst = fs.getFileStatus(src);
        long len = fst.getLen();
        FSDataOutputStream fdos = fs.create(dst);
        byte[] buf = new byte[(int)(len /= 2L)];
        FSDataInputStream fdis = fs.open(src);
        fdis.read(buf);
        fdos.write(buf);
        fdis.close();
        fdos.close();
    }

    public void testCorruptTruncatedHFile() throws IOException {
        if (cacheConf == null) {
            cacheConf = new CacheConfig(this.conf);
        }
        Path f = new Path(ROOT_DIR, this.getName());
        HFileContext context = new HFileContextBuilder().build();
        HFile.Writer w = HFile.getWriterFactory((Configuration)this.conf, (CacheConfig)cacheConf).withPath(this.fs, f).withFileContext(context).create();
        this.writeSomeRecords(w, 0, 100, false);
        w.close();
        Path trunc = new Path(f.getParent(), "trucated");
        TestHFile.truncateFile(this.fs, w.getPath(), trunc);
        try {
            HFile.Reader r = HFile.createReader((FileSystem)this.fs, (Path)trunc, (CacheConfig)cacheConf, (Configuration)this.conf);
        }
        catch (CorruptHFileException che) {
            return;
        }
        TestHFile.fail((String)"Should have thrown exception");
    }

    private int writeSomeRecords(HFile.Writer writer, int start, int n, boolean useTags) throws IOException {
        String value = "value";
        for (int i = start; i < start + n; ++i) {
            String key = String.format(localFormatter, i);
            if (useTags) {
                Tag t = new Tag(1, "myTag1");
                writer.append(Bytes.toBytes((String)key), Bytes.toBytes((String)(value + key)), t.getBuffer());
                continue;
            }
            writer.append(Bytes.toBytes((String)key), Bytes.toBytes((String)(value + key)));
        }
        return start + n;
    }

    private void readAllRecords(HFileScanner scanner) throws IOException {
        this.readAndCheckbytes(scanner, 0, 100);
    }

    private int readAndCheckbytes(HFileScanner scanner, int start, int n) throws IOException {
        int i;
        String value = "value";
        for (i = start; i < start + n; ++i) {
            ByteBuffer key = scanner.getKey();
            ByteBuffer val = scanner.getValue();
            String keyStr = String.format(localFormatter, i);
            String valStr = value + keyStr;
            byte[] keyBytes = Bytes.toBytes((ByteBuffer)key);
            TestHFile.assertTrue((String)("bytes for keys do not match " + keyStr + " " + Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)key))), (boolean)Arrays.equals(Bytes.toBytes((String)keyStr), keyBytes));
            byte[] valBytes = Bytes.toBytes((ByteBuffer)val);
            TestHFile.assertTrue((String)("bytes for vals do not match " + valStr + " " + Bytes.toString((byte[])valBytes)), (boolean)Arrays.equals(Bytes.toBytes((String)valStr), valBytes));
            if (!scanner.next()) break;
        }
        TestHFile.assertEquals((int)i, (int)(start + n - 1));
        return start + n;
    }

    private byte[] getSomeKey(int rowId) {
        return String.format(localFormatter, rowId).getBytes();
    }

    private void writeRecords(HFile.Writer writer, boolean useTags) throws IOException {
        this.writeSomeRecords(writer, 0, 100, useTags);
        writer.close();
    }

    private FSDataOutputStream createFSOutput(Path name) throws IOException {
        FSDataOutputStream fout = this.fs.create(name);
        return fout;
    }

    void basicWithSomeCodec(String codec, boolean useTags) throws IOException {
        if (useTags) {
            this.conf.setInt("hfile.format.version", 3);
        }
        if (cacheConf == null) {
            cacheConf = new CacheConfig(this.conf);
        }
        Path ncTFile = new Path(ROOT_DIR, "basic.hfile." + codec.toString() + useTags);
        FSDataOutputStream fout = this.createFSOutput(ncTFile);
        HFileContext meta = new HFileContextBuilder().withBlockSize(512).withCompression(AbstractHFileWriter.compressionByName((String)codec)).build();
        HFile.Writer writer = HFile.getWriterFactory((Configuration)this.conf, (CacheConfig)cacheConf).withOutputStream(fout).withFileContext(meta).withComparator((KeyValue.KVComparator)new KeyValue.RawBytesComparator()).create();
        LOG.info((Object)writer);
        this.writeRecords(writer, useTags);
        fout.close();
        FSDataInputStream fin = this.fs.open(ncTFile);
        HFile.Reader reader = HFile.createReaderFromStream((Path)ncTFile, (FSDataInputStream)this.fs.open(ncTFile), (long)this.fs.getFileStatus(ncTFile).getLen(), (CacheConfig)cacheConf, (Configuration)this.conf);
        System.out.println(cacheConf.toString());
        reader.loadFileInfo();
        HFileScanner scanner = reader.getScanner(true, false);
        scanner.seekTo();
        this.readAllRecords(scanner);
        scanner.seekTo(this.getSomeKey(50));
        TestHFile.assertTrue((String)"location lookup failed", (scanner.seekTo(this.getSomeKey(50)) == 0 ? 1 : 0) != 0);
        ByteBuffer readKey = scanner.getKey();
        TestHFile.assertTrue((String)"seeked key does not match", (boolean)Arrays.equals(this.getSomeKey(50), Bytes.toBytes((ByteBuffer)readKey)));
        scanner.seekTo(new byte[0]);
        ByteBuffer val1 = scanner.getValue();
        scanner.seekTo(new byte[0]);
        ByteBuffer val2 = scanner.getValue();
        TestHFile.assertTrue((boolean)Arrays.equals(Bytes.toBytes((ByteBuffer)val1), Bytes.toBytes((ByteBuffer)val2)));
        reader.close();
        fin.close();
        this.fs.delete(ncTFile, true);
    }

    public void testTFileFeatures() throws IOException {
        this.testTFilefeaturesInternals(false);
        this.testTFilefeaturesInternals(true);
    }

    protected void testTFilefeaturesInternals(boolean useTags) throws IOException {
        this.basicWithSomeCodec("none", useTags);
        this.basicWithSomeCodec("gz", useTags);
    }

    private void writeNumMetablocks(HFile.Writer writer, int n) {
        for (int i = 0; i < n; ++i) {
            writer.appendMetaBlock("HFileMeta" + i, new Writable(){
                private int val;

                public Writable setVal(int val) {
                    this.val = val;
                    return this;
                }

                public void write(DataOutput out) throws IOException {
                    out.write(("something to test" + this.val).getBytes());
                }

                public void readFields(DataInput in) throws IOException {
                }
            }.setVal(i));
        }
    }

    private void someTestingWithMetaBlock(HFile.Writer writer) {
        this.writeNumMetablocks(writer, 10);
    }

    private void readNumMetablocks(HFile.Reader reader, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            ByteBuffer actual = reader.getMetaBlock("HFileMeta" + i, false);
            ByteBuffer expected = ByteBuffer.wrap(("something to test" + i).getBytes());
            TestHFile.assertEquals((String)"failed to match metadata", (String)Bytes.toStringBinary((ByteBuffer)expected), (String)Bytes.toStringBinary((ByteBuffer)actual));
        }
    }

    private void someReadingWithMetaBlock(HFile.Reader reader) throws IOException {
        this.readNumMetablocks(reader, 10);
    }

    private void metablocks(String compress) throws Exception {
        if (cacheConf == null) {
            cacheConf = new CacheConfig(this.conf);
        }
        Path mFile = new Path(ROOT_DIR, "meta.hfile");
        FSDataOutputStream fout = this.createFSOutput(mFile);
        HFileContext meta = new HFileContextBuilder().withCompression(AbstractHFileWriter.compressionByName((String)compress)).withBlockSize(512).build();
        HFile.Writer writer = HFile.getWriterFactory((Configuration)this.conf, (CacheConfig)cacheConf).withOutputStream(fout).withFileContext(meta).create();
        this.someTestingWithMetaBlock(writer);
        writer.close();
        fout.close();
        FSDataInputStream fin = this.fs.open(mFile);
        HFile.Reader reader = HFile.createReaderFromStream((Path)mFile, (FSDataInputStream)this.fs.open(mFile), (long)this.fs.getFileStatus(mFile).getLen(), (CacheConfig)cacheConf, (Configuration)this.conf);
        reader.loadFileInfo();
        TestHFile.assertFalse((boolean)reader.getScanner(false, false).seekTo());
        this.someReadingWithMetaBlock(reader);
        this.fs.delete(mFile, true);
        reader.close();
        fin.close();
    }

    public void testMetaBlocks() throws Exception {
        this.metablocks("none");
        this.metablocks("gz");
    }

    public void testNullMetaBlocks() throws Exception {
        if (cacheConf == null) {
            cacheConf = new CacheConfig(this.conf);
        }
        for (Compression.Algorithm compressAlgo : HBaseTestingUtility.COMPRESSION_ALGORITHMS) {
            Path mFile = new Path(ROOT_DIR, "nometa_" + compressAlgo + ".hfile");
            FSDataOutputStream fout = this.createFSOutput(mFile);
            HFileContext meta = new HFileContextBuilder().withCompression(compressAlgo).withBlockSize(512).build();
            HFile.Writer writer = HFile.getWriterFactory((Configuration)this.conf, (CacheConfig)cacheConf).withOutputStream(fout).withFileContext(meta).create();
            writer.append("foo".getBytes(), "value".getBytes());
            writer.close();
            fout.close();
            HFile.Reader reader = HFile.createReader((FileSystem)this.fs, (Path)mFile, (CacheConfig)cacheConf, (Configuration)this.conf);
            reader.loadFileInfo();
            TestHFile.assertNull((Object)reader.getMetaBlock("non-existant", false));
        }
    }

    public void testCompressionOrdinance() {
        TestHFile.assertTrue((Compression.Algorithm.LZO.ordinal() == 0 ? 1 : 0) != 0);
        TestHFile.assertTrue((Compression.Algorithm.GZ.ordinal() == 1 ? 1 : 0) != 0);
        TestHFile.assertTrue((Compression.Algorithm.NONE.ordinal() == 2 ? 1 : 0) != 0);
        TestHFile.assertTrue((Compression.Algorithm.SNAPPY.ordinal() == 3 ? 1 : 0) != 0);
        TestHFile.assertTrue((Compression.Algorithm.LZ4.ordinal() == 4 ? 1 : 0) != 0);
    }
}

