/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.monitoring;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.monitoring.MemoryBoundedLogMessageBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMemoryBoundedLogMessageBuffer {
    private static final long TEN_KB = 10240L;
    private static final String JP_TEXT = "\u3053\u3093\u306b\u3061\u306f";

    @Test
    public void testBuffer() {
        MemoryBoundedLogMessageBuffer buf = new MemoryBoundedLogMessageBuffer(10240L);
        for (int i = 0; i < 1000; ++i) {
            buf.add("hello " + i);
        }
        Assert.assertTrue((String)("Usage too big: " + buf.estimateHeapUsage()), (buf.estimateHeapUsage() < 10240L ? 1 : 0) != 0);
        Assert.assertTrue((String)("Too many retained: " + buf.getMessages().size()), (buf.getMessages().size() < 100 ? 1 : 0) != 0);
        StringWriter sw = new StringWriter();
        buf.dumpTo(new PrintWriter(sw));
        String dump = sw.toString();
        String eol = System.getProperty("line.separator");
        Assert.assertFalse((String)"The early log messages should be evicted", (boolean)dump.contains("hello 1" + eol));
        Assert.assertTrue((String)"The late log messages should be retained", (boolean)dump.contains("hello 999" + eol));
    }

    @Test
    public void testNonAsciiEncoding() {
        MemoryBoundedLogMessageBuffer buf = new MemoryBoundedLogMessageBuffer(10240L);
        buf.add(JP_TEXT);
        StringWriter sw = new StringWriter();
        buf.dumpTo(new PrintWriter(sw));
        String dump = sw.toString();
        Assert.assertTrue((boolean)dump.contains(JP_TEXT));
    }
}

