/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHRegionInfo {
    @Test
    public void testPb() throws DeserializationException {
        HRegionInfo hri = HRegionInfo.FIRST_META_REGIONINFO;
        byte[] bytes = hri.toByteArray();
        HRegionInfo pbhri = HRegionInfo.parseFrom((byte[])bytes);
        Assert.assertTrue((boolean)hri.equals((Object)pbhri));
    }

    @Test
    public void testReadAndWriteHRegionInfoFile() throws IOException, InterruptedException {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        HRegionInfo hri = HRegionInfo.FIRST_META_REGIONINFO;
        Path basedir = htu.getDataTestDir();
        FSTableDescriptors fsTableDescriptors = new FSTableDescriptors(htu.getConfiguration());
        HRegion r = HRegion.createHRegion((HRegionInfo)hri, (Path)basedir, (Configuration)htu.getConfiguration(), (HTableDescriptor)fsTableDescriptors.get(TableName.META_TABLE_NAME));
        long modtime = this.getModTime(r);
        HRegion.closeHRegion((HRegion)r);
        Thread.sleep(1001L);
        r = HRegion.openHRegion((Path)basedir, (HRegionInfo)hri, (HTableDescriptor)fsTableDescriptors.get(TableName.META_TABLE_NAME), null, (Configuration)htu.getConfiguration());
        long modtime2 = this.getModTime(r);
        Assert.assertEquals((long)modtime, (long)modtime2);
        HRegionInfo deserializedHri = HRegionFileSystem.loadRegionInfoFileContent((FileSystem)r.getRegionFileSystem().getFileSystem(), (Path)r.getRegionFileSystem().getRegionDir());
        Assert.assertTrue((boolean)hri.equals((Object)deserializedHri));
    }

    long getModTime(HRegion r) throws IOException {
        FileStatus[] statuses = r.getRegionFileSystem().getFileSystem().listStatus(new Path(r.getRegionFileSystem().getRegionDir(), ".regioninfo"));
        Assert.assertTrue((statuses != null && statuses.length == 1 ? 1 : 0) != 0);
        return statuses[0].getModificationTime();
    }

    @Test
    public void testCreateHRegionInfoName() throws Exception {
        String tableName = "tablename";
        TableName tn = TableName.valueOf((String)tableName);
        String startKey = "startkey";
        byte[] sk = Bytes.toBytes((String)startKey);
        String id = "id";
        byte[] name = HRegionInfo.createRegionName((TableName)tn, (byte[])sk, (String)id, (boolean)false);
        String nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id), (Object)nameStr);
        String md5HashInHex = MD5Hash.getMD5AsHex((byte[])name);
        Assert.assertEquals((long)32L, (long)md5HashInHex.length());
        name = HRegionInfo.createRegionName((TableName)tn, (byte[])sk, (String)id, (boolean)true);
        nameStr = Bytes.toString((byte[])name);
        Assert.assertEquals((Object)(tableName + "," + startKey + "," + id + "." + md5HashInHex + "."), (Object)nameStr);
    }

    @Test
    public void testContainsRange() {
        HTableDescriptor tableDesc = new HTableDescriptor(TableName.valueOf((String)"testtable"));
        HRegionInfo hri = new HRegionInfo(tableDesc.getTableName(), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"g"));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"a")));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"c")));
        Assert.assertTrue((boolean)hri.containsRange(Bytes.toBytes((String)"c"), Bytes.toBytes((String)"c")));
        Assert.assertFalse((boolean)hri.containsRange(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"g")));
        Assert.assertFalse((boolean)hri.containsRange(Bytes.toBytes((String)"g"), Bytes.toBytes((String)"g")));
        Assert.assertFalse((boolean)hri.containsRange(Bytes.toBytes((String)"z"), Bytes.toBytes((String)"z")));
        try {
            hri.containsRange(Bytes.toBytes((String)"z"), Bytes.toBytes((String)"a"));
            Assert.fail((String)"Invalid range did not throw IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLastRegionCompare() {
        HRegionInfo hric;
        HTableDescriptor tableDesc = new HTableDescriptor(TableName.valueOf((String)"testtable"));
        HRegionInfo hrip = new HRegionInfo(tableDesc.getTableName(), Bytes.toBytes((String)"a"), new byte[0]);
        Assert.assertTrue((hrip.compareTo(hric = new HRegionInfo(tableDesc.getTableName(), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"))) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMetaTables() {
        Assert.assertTrue((boolean)HRegionInfo.FIRST_META_REGIONINFO.isMetaTable());
    }

    @Test
    public void testComparator() {
        HRegionInfo newer;
        byte[] empty;
        TableName tablename = TableName.valueOf((String)"comparatorTablename");
        HRegionInfo older = new HRegionInfo(tablename, empty = new byte[0], empty, false, 0L);
        Assert.assertTrue((older.compareTo(newer = new HRegionInfo(tablename, empty, empty, false, 1L)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((newer.compareTo(older) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((older.compareTo(older) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((newer.compareTo(newer) == 0 ? 1 : 0) != 0);
    }
}

