/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogFactory;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestLogRollingNoCluster {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] EMPTY_1K_ARRAY = new byte[1024];
    private static final int THREAD_COUNT = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContendedLogRolling() throws IOException, InterruptedException {
        int i;
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        Path dir = TEST_UTIL.getDataTestDir();
        HLog wal = HLogFactory.createHLog((FileSystem)fs, (Path)dir, (String)"logs", (Configuration)TEST_UTIL.getConfiguration());
        Appender[] appenders = null;
        int count = 100;
        appenders = new Appender[100];
        try {
            for (i = 0; i < 100; ++i) {
                appenders[i] = new Appender(wal, i, 100);
            }
            for (i = 0; i < 100; ++i) {
                appenders[i].start();
            }
            for (i = 0; i < 100; ++i) {
                appenders[i].join();
            }
        }
        finally {
            wal.close();
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertFalse((boolean)appenders[i].isException());
        }
    }

    static class Appender
    extends Thread {
        private final Log log;
        private final HLog wal;
        private final int count;
        private Exception e = null;

        Appender(HLog wal, int index, int count) {
            super("" + index);
            this.wal = wal;
            this.count = count;
            this.log = LogFactory.getLog((String)("Appender:" + this.getName()));
        }

        boolean isException() {
            return !this.isAlive() && this.e != null;
        }

        Exception getException() {
            return this.e;
        }

        @Override
        public void run() {
            this.log.info((Object)(this.getName() + " started"));
            AtomicLong sequenceId = new AtomicLong(1L);
            try {
                for (int i = 0; i < this.count; ++i) {
                    long now = System.currentTimeMillis();
                    if (i % 10 == 0 && ((FSHLog)this.wal).getNumEntries() > 0) {
                        this.wal.rollWriter();
                    }
                    WALEdit edit = new WALEdit();
                    byte[] bytes = Bytes.toBytes((int)i);
                    edit.add(new KeyValue(bytes, bytes, bytes, now, EMPTY_1K_ARRAY));
                    this.wal.append(HRegionInfo.FIRST_META_REGIONINFO, TableName.META_TABLE_NAME, edit, now, TEST_UTIL.getMetaTableDescriptor(), sequenceId);
                }
                String msg = this.getName() + " finished";
                if (this.isException()) {
                    this.log.info((Object)msg, (Throwable)this.getException());
                } else {
                    this.log.info((Object)msg);
                }
            }
            catch (Exception e) {
                this.e = e;
                this.log.info((Object)("Caught exception from Appender:" + this.getName()), (Throwable)e);
            }
        }
    }
}

