/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.TestTableName;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestAccessController2
extends SecureTestUtil {
    private static final byte[] TEST_ROW = Bytes.toBytes((String)"test");
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"f");
    private static final byte[] TEST_QUALIFIER = Bytes.toBytes((String)"q");
    private static final byte[] TEST_VALUE = Bytes.toBytes((String)"value");
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    @Rule
    public TestTableName TEST_TABLE = new TestTableName();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TestAccessController2.enableSecurity(conf);
        TestAccessController2.verifyConfiguration(conf);
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.waitTableEnabled(AccessControlLists.ACL_TABLE_NAME.getName());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCreateWithCorrectOwner() throws Exception {
        User testUser = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)"TestUser", (String[])new String[0]);
        SecureTestUtil.grantGlobal(TEST_UTIL, testUser.getShortName(), Permission.Action.CREATE);
        TestAccessController2.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTableDescriptor desc = new HTableDescriptor(TestAccessController2.this.TEST_TABLE.getTableName());
                desc.addFamily(new HColumnDescriptor(TEST_FAMILY));
                HBaseAdmin admin = new HBaseAdmin(conf);
                try {
                    admin.createTable(desc);
                }
                finally {
                    admin.close();
                }
                return null;
            }
        }, testUser);
        TEST_UTIL.waitTableEnabled(this.TEST_TABLE.getTableName().getName());
        List perms = AccessControlLists.getTablePermissions((Configuration)conf, (TableName)this.TEST_TABLE.getTableName()).get((Object)testUser.getShortName());
        Assert.assertNotNull((Object)perms);
        Assert.assertFalse((boolean)perms.isEmpty());
        Assert.assertTrue((boolean)((TablePermission)perms.get(0)).implies(Permission.Action.READ));
        Assert.assertTrue((boolean)((TablePermission)perms.get(0)).implies(Permission.Action.WRITE));
        Assert.assertTrue((boolean)((TablePermission)perms.get(0)).implies(Permission.Action.EXEC));
        Assert.assertTrue((boolean)((TablePermission)perms.get(0)).implies(Permission.Action.CREATE));
        Assert.assertTrue((boolean)((TablePermission)perms.get(0)).implies(Permission.Action.ADMIN));
    }

    @Test
    public void testACLTableAccess() throws Exception {
        final Configuration conf = TEST_UTIL.getConfiguration();
        User superUser = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        User globalRead = User.createUserForTesting((Configuration)conf, (String)"globalRead", (String[])new String[0]);
        User globalWrite = User.createUserForTesting((Configuration)conf, (String)"globalWrite", (String[])new String[0]);
        User globalCreate = User.createUserForTesting((Configuration)conf, (String)"globalCreate", (String[])new String[0]);
        User globalAdmin = User.createUserForTesting((Configuration)conf, (String)"globalAdmin", (String[])new String[0]);
        SecureTestUtil.grantGlobal(TEST_UTIL, globalRead.getShortName(), Permission.Action.READ);
        SecureTestUtil.grantGlobal(TEST_UTIL, globalWrite.getShortName(), Permission.Action.WRITE);
        SecureTestUtil.grantGlobal(TEST_UTIL, globalCreate.getShortName(), Permission.Action.CREATE);
        SecureTestUtil.grantGlobal(TEST_UTIL, globalAdmin.getShortName(), Permission.Action.ADMIN);
        User nsRead = User.createUserForTesting((Configuration)conf, (String)"nsRead", (String[])new String[0]);
        User nsWrite = User.createUserForTesting((Configuration)conf, (String)"nsWrite", (String[])new String[0]);
        User nsCreate = User.createUserForTesting((Configuration)conf, (String)"nsCreate", (String[])new String[0]);
        User nsAdmin = User.createUserForTesting((Configuration)conf, (String)"nsAdmin", (String[])new String[0]);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, nsRead.getShortName(), this.TEST_TABLE.getTableName().getNamespaceAsString(), Permission.Action.READ);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, nsWrite.getShortName(), this.TEST_TABLE.getTableName().getNamespaceAsString(), Permission.Action.WRITE);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, nsCreate.getShortName(), this.TEST_TABLE.getTableName().getNamespaceAsString(), Permission.Action.CREATE);
        SecureTestUtil.grantOnNamespace(TEST_UTIL, nsAdmin.getShortName(), this.TEST_TABLE.getTableName().getNamespaceAsString(), Permission.Action.ADMIN);
        User tableRead = User.createUserForTesting((Configuration)conf, (String)"tableRead", (String[])new String[0]);
        User tableWrite = User.createUserForTesting((Configuration)conf, (String)"tableWrite", (String[])new String[0]);
        User tableCreate = User.createUserForTesting((Configuration)conf, (String)"tableCreate", (String[])new String[0]);
        User tableAdmin = User.createUserForTesting((Configuration)conf, (String)"tableAdmin", (String[])new String[0]);
        SecureTestUtil.grantOnTable(TEST_UTIL, tableRead.getShortName(), this.TEST_TABLE.getTableName(), null, null, Permission.Action.READ);
        SecureTestUtil.grantOnTable(TEST_UTIL, tableWrite.getShortName(), this.TEST_TABLE.getTableName(), null, null, Permission.Action.WRITE);
        SecureTestUtil.grantOnTable(TEST_UTIL, tableCreate.getShortName(), this.TEST_TABLE.getTableName(), null, null, Permission.Action.CREATE);
        SecureTestUtil.grantOnTable(TEST_UTIL, tableAdmin.getShortName(), this.TEST_TABLE.getTableName(), null, null, Permission.Action.ADMIN);
        SecureTestUtil.AccessTestAction writeAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
                try {
                    t.put(new Put(TEST_ROW).add(AccessControlLists.ACL_LIST_FAMILY, TEST_QUALIFIER, TEST_VALUE));
                    Object var2_2 = null;
                    return var2_2;
                }
                finally {
                    t.close();
                }
            }
        };
        TestAccessController2.verifyDenied(writeAction, globalAdmin, globalCreate, globalRead);
        TestAccessController2.verifyDenied(writeAction, nsAdmin, nsCreate, nsRead, nsWrite);
        TestAccessController2.verifyDenied(writeAction, tableAdmin, tableCreate, tableRead, tableWrite);
        TestAccessController2.verifyAllowed(writeAction, superUser, globalWrite);
        SecureTestUtil.AccessTestAction scanAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                HTable t = new HTable(conf, AccessControlLists.ACL_TABLE_NAME);
                try {
                    ResultScanner s = t.getScanner(new Scan());
                    try {
                        Result r = s.next();
                        while (r != null) {
                            r = s.next();
                        }
                    }
                    finally {
                        s.close();
                    }
                    Object var3_3 = null;
                    return var3_3;
                }
                finally {
                    t.close();
                }
            }
        };
        TestAccessController2.verifyDenied(scanAction, globalAdmin, globalCreate, globalWrite);
        TestAccessController2.verifyDenied(scanAction, nsCreate, nsAdmin, nsRead, nsWrite);
        TestAccessController2.verifyDenied(scanAction, tableCreate, tableAdmin, tableRead, tableWrite);
        TestAccessController2.verifyAllowed(scanAction, superUser, globalRead);
    }
}

