/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import com.yammer.metrics.stats.Snapshot;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.ExactCounterMetric;
import org.apache.hadoop.hbase.metrics.MetricsRate;
import org.apache.hadoop.hbase.metrics.MetricsString;
import org.apache.hadoop.hbase.metrics.histogram.MetricsHistogram;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsDynamicMBeanBase;
import org.apache.hadoop.metrics.util.MetricsRegistry;

@Deprecated
@InterfaceAudience.Private
public class MetricsMBeanBase
extends MetricsDynamicMBeanBase {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hbase.metrics");
    protected final MetricsRegistry registry;
    protected final String description;
    protected int registryLength;
    protected Map<String, MetricsBase> extendedAttributes = new ConcurrentHashMap<String, MetricsBase>();
    protected MBeanInfo extendedInfo;

    protected MetricsMBeanBase(MetricsRegistry mr, String description) {
        super(MetricsMBeanBase.copyMinusHBaseMetrics(mr), description);
        this.registry = mr;
        this.description = description;
        this.init();
    }

    private static MetricsRegistry copyMinusHBaseMetrics(MetricsRegistry mr) {
        MetricsRegistry copy = new MetricsRegistry();
        for (MetricsBase metric : mr.getMetricsList()) {
            if (metric instanceof MetricsRate || metric instanceof MetricsString || metric instanceof MetricsHistogram || metric instanceof ExactCounterMetric) continue;
            copy.add(metric.getName(), metric);
        }
        return copy;
    }

    protected void init() {
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        MBeanInfo parentInfo = super.getMBeanInfo();
        ArrayList<String> parentAttributes = new ArrayList<String>();
        for (MBeanAttributeInfo attr : parentInfo.getAttributes()) {
            attributes.add(attr);
            parentAttributes.add(attr.getName());
        }
        this.registryLength = this.registry.getMetricsList().size();
        for (MetricsBase metric : this.registry.getMetricsList()) {
            if (metric.getName() == null || parentAttributes.contains(metric.getName())) continue;
            if (metric instanceof MetricsRate) {
                attributes.add(new MBeanAttributeInfo(metric.getName(), "java.lang.Float", metric.getDescription(), true, false, false));
                this.extendedAttributes.put(metric.getName(), metric);
                continue;
            }
            if (metric instanceof MetricsString) {
                attributes.add(new MBeanAttributeInfo(metric.getName(), "java.lang.String", metric.getDescription(), true, false, false));
                this.extendedAttributes.put(metric.getName(), metric);
                LOG.info((Object)("MetricsString added: " + metric.getName()));
                continue;
            }
            if (!(metric instanceof MetricsHistogram)) continue;
            String metricName = metric.getName() + "_num_ops";
            attributes.add(new MBeanAttributeInfo(metricName, "java.lang.Long", metric.getDescription(), true, false, false));
            this.extendedAttributes.put(metricName, metric);
            metricName = metric.getName() + "_min";
            attributes.add(new MBeanAttributeInfo(metricName, "java.lang.Long", metric.getDescription(), true, false, false));
            this.extendedAttributes.put(metricName, metric);
            metricName = metric.getName() + "_max";
            attributes.add(new MBeanAttributeInfo(metricName, "java.lang.Long", metric.getDescription(), true, false, false));
            this.extendedAttributes.put(metricName, metric);
            metricName = metric.getName() + "_mean";
            attributes.add(new MBeanAttributeInfo(metricName, "java.lang.Float", metric.getDescription(), true, false, false));
            this.extendedAttributes.put(metricName, metric);
            metricName = metric.getName() + "_std_dev";
            attributes.add(new MBeanAttributeInfo(metricName, "java.lang.Float", metric.getDescription(), true, false, false));
            this.extendedAttributes.put(metricName, metric);
            metricName = metric.getName() + "_median";
            attributes.add(new MBeanAttributeInfo(metricName, "java.lang.Float", metric.getDescription(), true, false, false));
            this.extendedAttributes.put(metricName, metric);
            metricName = metric.getName() + "_75th_percentile";
            attributes.add(new MBeanAttributeInfo(metricName, "java.lang.Float", metric.getDescription(), true, false, false));
            this.extendedAttributes.put(metricName, metric);
            metricName = metric.getName() + "_95th_percentile";
            attributes.add(new MBeanAttributeInfo(metricName, "java.lang.Float", metric.getDescription(), true, false, false));
            this.extendedAttributes.put(metricName, metric);
            metricName = metric.getName() + "_99th_percentile";
            attributes.add(new MBeanAttributeInfo(metricName, "java.lang.Float", metric.getDescription(), true, false, false));
            this.extendedAttributes.put(metricName, metric);
        }
        LOG.info((Object)"new MBeanInfo");
        this.extendedInfo = new MBeanInfo(((Object)((Object)this)).getClass().getName(), this.description, attributes.toArray(new MBeanAttributeInfo[attributes.size()]), parentInfo.getConstructors(), parentInfo.getOperations(), parentInfo.getNotifications());
    }

    private void checkAndUpdateAttributes() {
        if (this.registryLength != this.registry.getMetricsList().size()) {
            this.init();
        }
    }

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name is NULL");
        }
        try {
            return super.getAttribute(name);
        }
        catch (AttributeNotFoundException ex) {
            this.checkAndUpdateAttributes();
            MetricsBase metric = this.extendedAttributes.get(name);
            if (metric != null) {
                if (metric instanceof MetricsRate) {
                    return Float.valueOf(((MetricsRate)metric).getPreviousIntervalValue());
                }
                if (metric instanceof MetricsString) {
                    return ((MetricsString)metric).getValue();
                }
                if (metric instanceof MetricsHistogram) {
                    MetricsHistogram hist = (MetricsHistogram)metric;
                    if (name.endsWith("_num_ops")) {
                        return hist.getCount();
                    }
                    if (name.endsWith("_min")) {
                        return hist.getMin();
                    }
                    if (name.endsWith("_max")) {
                        return hist.getMax();
                    }
                    if (name.endsWith("_mean")) {
                        return Float.valueOf((float)hist.getMean());
                    }
                    if (name.endsWith("_std_dev")) {
                        return Float.valueOf((float)hist.getStdDev());
                    }
                    if (name.endsWith("_median")) {
                        Snapshot s = hist.getSnapshot();
                        return Float.valueOf((float)s.getMedian());
                    }
                    if (name.endsWith("_75th_percentile")) {
                        Snapshot s = hist.getSnapshot();
                        return Float.valueOf((float)s.get75thPercentile());
                    }
                    if (name.endsWith("_95th_percentile")) {
                        Snapshot s = hist.getSnapshot();
                        return Float.valueOf((float)s.get95thPercentile());
                    }
                    if (name.endsWith("_99th_percentile")) {
                        Snapshot s = hist.getSnapshot();
                        return Float.valueOf((float)s.get99thPercentile());
                    }
                } else {
                    LOG.warn((Object)String.format("unknown metrics type %s for attribute %s", metric.getClass().getName(), name));
                }
            }
            throw new AttributeNotFoundException();
        }
    }

    public MBeanInfo getMBeanInfo() {
        return this.extendedInfo;
    }
}

