/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.MockRegionServerServices;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.ChecksumUtil;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.mapreduce.MapreduceTestingShim;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.tool.Canary;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.zookeeper.EmptyWatcher;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HBaseTestingUtility
extends HBaseCommonTestingUtility {
    private MiniZooKeeperCluster zkCluster = null;
    public static final String REGIONS_PER_SERVER_KEY = "hbase.test.regions-per-server";
    public static final int DEFAULT_REGIONS_PER_SERVER = 5;
    private boolean passedZkCluster = false;
    private MiniDFSCluster dfsCluster = null;
    private volatile HBaseCluster hbaseCluster = null;
    private MiniMRCluster mrCluster = null;
    private volatile boolean miniClusterRunning;
    private String hadoopLogDir;
    private File clusterTestDir = null;
    private Path dataTestDirOnTestFS = null;
    private volatile Connection connection;
    @Deprecated
    private static final String TEST_DIRECTORY_KEY = "test.build.data";
    private static String FS_URI;
    private static final Set<Integer> takenRandomPorts;
    public static final List<Object[]> COMPRESSION_ALGORITHMS_PARAMETERIZED;
    public static final List<Object[]> BOOLEAN_PARAMETERIZED;
    public static final List<Object[]> MEMSTORETS_TAGS_PARAMETRIZED;
    public static final Compression.Algorithm[] COMPRESSION_ALGORITHMS;
    public static final Collection<Object[]> BLOOM_AND_COMPRESSION_COMBINATIONS;
    public static final byte[] fam1;
    public static final byte[] fam2;
    public static final byte[] fam3;
    public static final byte[][] COLUMNS;
    private static final int MAXVERSIONS = 3;
    public static final char FIRST_CHAR = 'a';
    public static final char LAST_CHAR = 'z';
    public static final byte[] START_KEY_BYTES;
    public static final String START_KEY;
    public static final byte[][] ROWS;
    public static final byte[][] KEYS;
    public static final byte[][] KEYS_FOR_HBA_CREATE_TABLE;
    private HBaseAdminForTests hbaseAdmin = null;
    private ZooKeeperWatcher zooKeeperWatcher;
    private static final int MIN_RANDOM_PORT = 49152;
    private static final int MAX_RANDOM_PORT = 65534;
    private static Random random;

    private static List<Object[]> bloomAndCompressionCombinations() {
        ArrayList<Object[]> configurations = new ArrayList<Object[]>();
        for (Compression.Algorithm comprAlgo : COMPRESSION_ALGORITHMS) {
            for (BloomType bloomType : BloomType.values()) {
                configurations.add(new Object[]{comprAlgo, bloomType});
            }
        }
        return Collections.unmodifiableList(configurations);
    }

    private static List<Object[]> memStoreTSAndTagsCombination() {
        ArrayList<Object[]> configurations = new ArrayList<Object[]>();
        configurations.add(new Object[]{false, false});
        configurations.add(new Object[]{false, true});
        configurations.add(new Object[]{true, false});
        configurations.add(new Object[]{true, true});
        return Collections.unmodifiableList(configurations);
    }

    public HBaseTestingUtility() {
        this(HBaseConfiguration.create());
    }

    public HBaseTestingUtility(Configuration conf) {
        super(conf);
        ChecksumUtil.generateExceptionForChecksumFailureForTest((boolean)true);
    }

    public static HBaseTestingUtility createLocalHTU() {
        Configuration c = HBaseConfiguration.create();
        return HBaseTestingUtility.createLocalHTU(c);
    }

    public static HBaseTestingUtility createLocalHTU(Configuration c) {
        HBaseTestingUtility htu = new HBaseTestingUtility(c);
        String dataTestDir = htu.getDataTestDir().toString();
        htu.getConfiguration().set("hbase.rootdir", dataTestDir);
        LOG.debug((Object)("Setting hbase.rootdir to " + dataTestDir));
        return htu;
    }

    public Configuration getConfiguration() {
        return super.getConfiguration();
    }

    public void setHBaseCluster(HBaseCluster hbaseCluster) {
        this.hbaseCluster = hbaseCluster;
    }

    protected Path setupDataTestDir() {
        Path testPath = super.setupDataTestDir();
        if (null == testPath) {
            return null;
        }
        this.createSubDirAndSystemProperty("hadoop.log.dir", testPath, "hadoop-log-dir");
        this.createSubDirAndSystemProperty("hadoop.tmp.dir", testPath, "hadoop-tmp-dir");
        this.createSubDir("mapreduce.cluster.local.dir", testPath, "mapred-local-dir");
        return testPath;
    }

    private void createSubDirAndSystemProperty(String propertyName, Path parent, String subDirName) {
        String sysValue = System.getProperty(propertyName);
        if (sysValue != null) {
            LOG.info((Object)("System.getProperty(\"" + propertyName + "\") already set to: " + sysValue + " so I do NOT create it in " + parent));
            String confValue = this.conf.get(propertyName);
            if (confValue != null && !confValue.endsWith(sysValue)) {
                LOG.warn((Object)(propertyName + " property value differs in configuration and system: " + "Configuration=" + confValue + " while System=" + sysValue + " Erasing configuration value by system value."));
            }
            this.conf.set(propertyName, sysValue);
        } else {
            this.createSubDir(propertyName, parent, subDirName);
            System.setProperty(propertyName, this.conf.get(propertyName));
        }
    }

    private Path getBaseTestDirOnTestFS() throws IOException {
        FileSystem fs = this.getTestFileSystem();
        return new Path(fs.getWorkingDirectory(), "test-data");
    }

    public HTableDescriptor getMetaTableDescriptor() {
        try {
            return new FSTableDescriptors(this.conf).get(TableName.META_TABLE_NAME);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create META table descriptor", e);
        }
    }

    Path getClusterTestDir() {
        if (this.clusterTestDir == null) {
            this.setupClusterTestDir();
        }
        return new Path(this.clusterTestDir.getAbsolutePath());
    }

    private void setupClusterTestDir() {
        if (this.clusterTestDir != null) {
            return;
        }
        Path testDir = this.getDataTestDir("dfscluster_" + UUID.randomUUID().toString());
        this.clusterTestDir = new File(testDir.toString()).getAbsoluteFile();
        boolean b = this.deleteOnExit();
        if (b) {
            this.clusterTestDir.deleteOnExit();
        }
        this.conf.set(TEST_DIRECTORY_KEY, this.clusterTestDir.getPath());
        LOG.info((Object)("Created new mini-cluster data directory: " + this.clusterTestDir + ", deleteOnExit=" + b));
    }

    public Path getDataTestDirOnTestFS() throws IOException {
        if (this.dataTestDirOnTestFS == null) {
            this.setupDataTestDirOnTestFS();
        }
        return this.dataTestDirOnTestFS;
    }

    public Path getDataTestDirOnTestFS(String subdirName) throws IOException {
        return new Path(this.getDataTestDirOnTestFS(), subdirName);
    }

    private void setupDataTestDirOnTestFS() throws IOException {
        if (this.dataTestDirOnTestFS != null) {
            LOG.warn((Object)("Data test on test fs dir already setup in " + this.dataTestDirOnTestFS.toString()));
            return;
        }
        this.dataTestDirOnTestFS = this.getNewDataTestDirOnTestFS();
    }

    private Path getNewDataTestDirOnTestFS() throws IOException {
        FileSystem fs = this.getTestFileSystem();
        Path newDataTestDir = null;
        if (fs.getUri().getScheme().equals(FileSystem.getLocal((Configuration)this.conf).getUri().getScheme())) {
            File dataTestDir = new File(this.getDataTestDir().toString());
            if (this.deleteOnExit()) {
                dataTestDir.deleteOnExit();
            }
            newDataTestDir = new Path(dataTestDir.getAbsolutePath());
        } else {
            Path base = this.getBaseTestDirOnTestFS();
            String randomStr = UUID.randomUUID().toString();
            newDataTestDir = new Path(base, randomStr);
            if (this.deleteOnExit()) {
                fs.deleteOnExit(newDataTestDir);
            }
        }
        return newDataTestDir;
    }

    public boolean cleanupDataTestDirOnTestFS() throws IOException {
        boolean ret = this.getTestFileSystem().delete(this.dataTestDirOnTestFS, true);
        if (ret) {
            this.dataTestDirOnTestFS = null;
        }
        return ret;
    }

    public boolean cleanupDataTestDirOnTestFS(String subdirName) throws IOException {
        Path cpath = this.getDataTestDirOnTestFS(subdirName);
        return this.getTestFileSystem().delete(cpath, true);
    }

    public MiniDFSCluster startMiniDFSCluster(int servers) throws Exception {
        return this.startMiniDFSCluster(servers, null);
    }

    public MiniDFSCluster startMiniDFSCluster(String[] hosts) throws Exception {
        if (hosts != null && hosts.length != 0) {
            return this.startMiniDFSCluster(hosts.length, hosts);
        }
        return this.startMiniDFSCluster(1, null);
    }

    public MiniDFSCluster startMiniDFSCluster(int servers, String[] hosts) throws Exception {
        this.createDirsAndSetProperties();
        EditLogFileOutputStream.setShouldSkipFsyncForTesting((boolean)true);
        Logger.getLogger(MBeans.class).setLevel(org.apache.log4j.Level.ERROR);
        Logger.getLogger(MetricsSystemImpl.class).setLevel(org.apache.log4j.Level.ERROR);
        this.dfsCluster = new MiniDFSCluster(0, this.conf, servers, true, true, true, null, null, hosts, null);
        DistributedFileSystem fs = this.dfsCluster.getFileSystem();
        FSUtils.setFsDefault((Configuration)this.conf, (Path)new Path(fs.getUri()));
        this.dfsCluster.waitClusterUp();
        this.dataTestDirOnTestFS = null;
        return this.dfsCluster;
    }

    public MiniDFSCluster startMiniDFSCluster(int servers, String[] racks, String[] hosts) throws Exception {
        this.createDirsAndSetProperties();
        this.dfsCluster = new MiniDFSCluster(0, this.conf, servers, true, true, true, null, racks, hosts, null);
        DistributedFileSystem fs = this.dfsCluster.getFileSystem();
        FSUtils.setFsDefault((Configuration)this.conf, (Path)new Path(fs.getUri()));
        this.dfsCluster.waitClusterUp();
        this.dataTestDirOnTestFS = null;
        return this.dfsCluster;
    }

    public MiniDFSCluster startMiniDFSClusterForTestWAL(int namenodePort) throws IOException {
        this.createDirsAndSetProperties();
        this.dfsCluster = new MiniDFSCluster(namenodePort, this.conf, 5, false, true, true, null, null, null, null);
        return this.dfsCluster;
    }

    private void createDirsAndSetProperties() throws IOException {
        this.setupClusterTestDir();
        System.setProperty(TEST_DIRECTORY_KEY, this.clusterTestDir.getPath());
        this.createDirAndSetProperty("cache_data", "test.cache.data");
        this.createDirAndSetProperty("hadoop_tmp", "hadoop.tmp.dir");
        this.hadoopLogDir = this.createDirAndSetProperty("hadoop_logs", "hadoop.log.dir");
        this.createDirAndSetProperty("mapred_local", "mapreduce.cluster.local.dir");
        this.createDirAndSetProperty("mapred_temp", "mapreduce.cluster.temp.dir");
        this.enableShortCircuit();
        Path root = this.getDataTestDirOnTestFS("hadoop");
        this.conf.set(MapreduceTestingShim.getMROutputDirProp(), new Path(root, "mapred-output-dir").toString());
        this.conf.set("mapreduce.jobtracker.system.dir", new Path(root, "mapred-system-dir").toString());
        this.conf.set("mapreduce.jobtracker.staging.root.dir", new Path(root, "mapreduce-jobtracker-staging-root-dir").toString());
        this.conf.set("mapreduce.job.working.dir", new Path(root, "mapred-working-dir").toString());
    }

    public boolean isReadShortCircuitOn() {
        String propName = "hbase.tests.use.shortcircuit.reads";
        String readOnProp = System.getProperty("hbase.tests.use.shortcircuit.reads");
        if (readOnProp != null) {
            return Boolean.parseBoolean(readOnProp);
        }
        return this.conf.getBoolean("hbase.tests.use.shortcircuit.reads", false);
    }

    private void enableShortCircuit() {
        if (this.isReadShortCircuitOn()) {
            String curUser = System.getProperty("user.name");
            LOG.info((Object)("read short circuit is ON for user " + curUser));
            this.conf.set("dfs.block.local-path-access.user", curUser);
            this.conf.setBoolean("dfs.client.read.shortcircuit", true);
            this.conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", true);
        } else {
            LOG.info((Object)"read short circuit is OFF");
        }
    }

    private String createDirAndSetProperty(String relPath, String property) {
        String path = this.getDataTestDir(relPath).toString();
        System.setProperty(property, path);
        this.conf.set(property, path);
        new File(path).mkdirs();
        LOG.info((Object)("Setting " + property + " to " + path + " in system properties and HBase conf"));
        return path;
    }

    public void shutdownMiniDFSCluster() throws IOException {
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
            this.dfsCluster = null;
            this.dataTestDirOnTestFS = null;
            FSUtils.setFsDefault((Configuration)this.conf, (Path)new Path("file:///"));
        }
    }

    public MiniZooKeeperCluster startMiniZKCluster() throws Exception {
        return this.startMiniZKCluster(1);
    }

    public MiniZooKeeperCluster startMiniZKCluster(int zooKeeperServerNum) throws Exception {
        this.setupClusterTestDir();
        return this.startMiniZKCluster(this.clusterTestDir, zooKeeperServerNum);
    }

    private MiniZooKeeperCluster startMiniZKCluster(File dir) throws Exception {
        return this.startMiniZKCluster(dir, 1);
    }

    private MiniZooKeeperCluster startMiniZKCluster(File dir, int zooKeeperServerNum) throws Exception {
        if (this.zkCluster != null) {
            throw new IOException("Cluster already running at " + dir);
        }
        this.passedZkCluster = false;
        this.zkCluster = new MiniZooKeeperCluster(this.getConfiguration());
        int defPort = this.conf.getInt("test.hbase.zookeeper.property.clientPort", 0);
        if (defPort > 0) {
            this.zkCluster.setDefaultClientPort(defPort);
        }
        int clientPort = this.zkCluster.startup(dir, zooKeeperServerNum);
        this.conf.set("hbase.zookeeper.property.clientPort", Integer.toString(clientPort));
        return this.zkCluster;
    }

    public void shutdownMiniZKCluster() throws IOException {
        if (this.zkCluster != null) {
            this.zkCluster.shutdown();
            this.zkCluster = null;
        }
    }

    public MiniHBaseCluster startMiniCluster() throws Exception {
        return this.startMiniCluster(1, 1);
    }

    public MiniHBaseCluster startMiniCluster(int numSlaves, boolean create) throws Exception {
        return this.startMiniCluster(1, numSlaves, create);
    }

    public MiniHBaseCluster startMiniCluster(int numSlaves) throws Exception {
        return this.startMiniCluster(1, numSlaves, false);
    }

    public MiniHBaseCluster startMiniCluster(int numMasters, int numSlaves, boolean create) throws Exception {
        return this.startMiniCluster(numMasters, numSlaves, null, create);
    }

    public MiniHBaseCluster startMiniCluster(int numMasters, int numSlaves) throws Exception {
        return this.startMiniCluster(numMasters, numSlaves, null, false);
    }

    public MiniHBaseCluster startMiniCluster(int numMasters, int numSlaves, String[] dataNodeHosts, boolean create) throws Exception {
        return this.startMiniCluster(numMasters, numSlaves, numSlaves, dataNodeHosts, null, null, create);
    }

    public MiniHBaseCluster startMiniCluster(int numMasters, int numSlaves, String[] dataNodeHosts) throws Exception {
        return this.startMiniCluster(numMasters, numSlaves, numSlaves, dataNodeHosts, null, null);
    }

    public MiniHBaseCluster startMiniCluster(int numMasters, int numSlaves, int numDataNodes) throws Exception {
        return this.startMiniCluster(numMasters, numSlaves, numDataNodes, null, null, null);
    }

    public MiniHBaseCluster startMiniCluster(int numMasters, int numSlaves, String[] dataNodeHosts, Class<? extends HMaster> masterClass, Class<? extends MiniHBaseCluster.MiniHBaseClusterRegionServer> regionserverClass) throws Exception {
        return this.startMiniCluster(numMasters, numSlaves, numSlaves, dataNodeHosts, masterClass, regionserverClass);
    }

    public MiniHBaseCluster startMiniCluster(int numMasters, int numSlaves, int numDataNodes, String[] dataNodeHosts, Class<? extends HMaster> masterClass, Class<? extends MiniHBaseCluster.MiniHBaseClusterRegionServer> regionserverClass) throws Exception {
        return this.startMiniCluster(numMasters, numSlaves, numDataNodes, dataNodeHosts, masterClass, regionserverClass, false);
    }

    public MiniHBaseCluster startMiniCluster(int numMasters, int numSlaves, int numDataNodes, String[] dataNodeHosts, Class<? extends HMaster> masterClass, Class<? extends MiniHBaseCluster.MiniHBaseClusterRegionServer> regionserverClass, boolean create) throws Exception {
        if (dataNodeHosts != null && dataNodeHosts.length != 0) {
            numDataNodes = dataNodeHosts.length;
        }
        LOG.info((Object)("Starting up minicluster with " + numMasters + " master(s) and " + numSlaves + " regionserver(s) and " + numDataNodes + " datanode(s)"));
        if (this.miniClusterRunning) {
            throw new IllegalStateException("A mini-cluster is already running");
        }
        this.miniClusterRunning = true;
        this.setupClusterTestDir();
        System.setProperty(TEST_DIRECTORY_KEY, this.clusterTestDir.getPath());
        this.startMiniDFSCluster(numDataNodes, dataNodeHosts);
        if (this.zkCluster == null) {
            this.startMiniZKCluster(this.clusterTestDir);
        }
        return this.startMiniHBaseCluster(numMasters, numSlaves, masterClass, regionserverClass, create);
    }

    public MiniHBaseCluster startMiniHBaseCluster(int numMasters, int numSlaves) throws IOException, InterruptedException {
        return this.startMiniHBaseCluster(numMasters, numSlaves, null, null, false);
    }

    public MiniHBaseCluster startMiniHBaseCluster(int numMasters, int numSlaves, Class<? extends HMaster> masterClass, Class<? extends MiniHBaseCluster.MiniHBaseClusterRegionServer> regionserverClass, boolean create) throws IOException, InterruptedException {
        this.createRootDir(create);
        if (this.conf.getInt("hbase.master.wait.on.regionservers.mintostart", -1) == -1) {
            this.conf.setInt("hbase.master.wait.on.regionservers.mintostart", numSlaves);
        }
        if (this.conf.getInt("hbase.master.wait.on.regionservers.maxtostart", -1) == -1) {
            this.conf.setInt("hbase.master.wait.on.regionservers.maxtostart", numSlaves);
        }
        Configuration c = new Configuration(this.conf);
        this.hbaseCluster = new MiniHBaseCluster(c, numMasters, numSlaves, masterClass, regionserverClass);
        HTable t = new HTable(c, TableName.META_TABLE_NAME);
        ResultScanner s = t.getScanner(new Scan());
        while (s.next() != null) {
        }
        s.close();
        t.close();
        this.getHBaseAdmin();
        LOG.info((Object)"Minicluster is up");
        return (MiniHBaseCluster)this.hbaseCluster;
    }

    public void restartHBaseCluster(int servers) throws IOException, InterruptedException {
        this.hbaseCluster = new MiniHBaseCluster(this.conf, servers);
        HTable t = new HTable(new Configuration(this.conf), TableName.META_TABLE_NAME);
        ResultScanner s = t.getScanner(new Scan());
        while (s.next() != null) {
        }
        LOG.info((Object)"HBase has been restarted");
        s.close();
        t.close();
    }

    public MiniHBaseCluster getMiniHBaseCluster() {
        if (this.hbaseCluster == null || this.hbaseCluster instanceof MiniHBaseCluster) {
            return (MiniHBaseCluster)this.hbaseCluster;
        }
        throw new RuntimeException(this.hbaseCluster + " not an instance of " + MiniHBaseCluster.class.getName());
    }

    public void shutdownMiniCluster() throws Exception {
        LOG.info((Object)"Shutting down minicluster");
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
            this.connection = null;
        }
        this.shutdownMiniHBaseCluster();
        if (!this.passedZkCluster) {
            this.shutdownMiniZKCluster();
        }
        this.shutdownMiniDFSCluster();
        this.cleanupTestDir();
        this.miniClusterRunning = false;
        LOG.info((Object)"Minicluster is down");
    }

    public boolean cleanupTestDir() throws IOException {
        boolean ret = super.cleanupTestDir();
        if (this.deleteDir(this.clusterTestDir)) {
            this.clusterTestDir = null;
            return ret & true;
        }
        return false;
    }

    public void shutdownMiniHBaseCluster() throws IOException {
        if (this.hbaseAdmin != null) {
            this.hbaseAdmin.close0();
            this.hbaseAdmin = null;
        }
        this.conf.setInt("hbase.master.wait.on.regionservers.mintostart", -1);
        this.conf.setInt("hbase.master.wait.on.regionservers.maxtostart", -1);
        if (this.hbaseCluster != null) {
            this.hbaseCluster.shutdown();
            this.hbaseCluster.waitUntilShutDown();
            this.hbaseCluster = null;
        }
        if (this.zooKeeperWatcher != null) {
            this.zooKeeperWatcher.close();
            this.zooKeeperWatcher = null;
        }
    }

    public Path getDefaultRootDirPath(boolean create) throws IOException {
        if (!create) {
            return this.getDataTestDirOnTestFS();
        }
        return this.getNewDataTestDirOnTestFS();
    }

    public Path getDefaultRootDirPath() throws IOException {
        return this.getDefaultRootDirPath(false);
    }

    public Path createRootDir(boolean create) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path hbaseRootdir = this.getDefaultRootDirPath(create);
        FSUtils.setRootDir((Configuration)this.conf, (Path)hbaseRootdir);
        fs.mkdirs(hbaseRootdir);
        FSUtils.setVersion((FileSystem)fs, (Path)hbaseRootdir);
        return hbaseRootdir;
    }

    public Path createRootDir() throws IOException {
        return this.createRootDir(false);
    }

    public void flush() throws IOException {
        this.getMiniHBaseCluster().flushcache();
    }

    public void flush(TableName tableName) throws IOException {
        this.getMiniHBaseCluster().flushcache(tableName);
    }

    public void compact(boolean major) throws IOException {
        this.getMiniHBaseCluster().compact(major);
    }

    public void compact(TableName tableName, boolean major) throws IOException {
        this.getMiniHBaseCluster().compact(tableName, major);
    }

    public Table createTable(TableName tableName, String family) throws IOException {
        return this.createTable(tableName, new String[]{family});
    }

    public HTable createTable(byte[] tableName, byte[] family) throws IOException {
        return this.createTable(TableName.valueOf((byte[])tableName), (byte[][])new byte[][]{family});
    }

    public Table createTable(TableName tableName, String[] families) throws IOException {
        ArrayList<byte[]> fams = new ArrayList<byte[]>(families.length);
        for (String family : families) {
            fams.add(Bytes.toBytes((String)family));
        }
        return this.createTable(tableName, (byte[][])fams.toArray((T[])new byte[0][]));
    }

    public HTable createTable(TableName tableName, byte[] family) throws IOException {
        return this.createTable(tableName, (byte[][])new byte[][]{family});
    }

    public HTable createTable(byte[] tableName, byte[][] families) throws IOException {
        return this.createTable(tableName, families, new Configuration(this.getConfiguration()));
    }

    public HTable createTable(TableName tableName, byte[][] families) throws IOException {
        return this.createTable(tableName, families, new Configuration(this.getConfiguration()));
    }

    public HTable createTable(byte[] tableName, byte[][] families, int numVersions, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        return this.createTable(TableName.valueOf((byte[])tableName), families, numVersions, startKey, endKey, numRegions);
    }

    public HTable createTable(String tableName, byte[][] families, int numVersions, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        return this.createTable(TableName.valueOf((String)tableName), families, numVersions, startKey, endKey, numRegions);
    }

    public HTable createTable(TableName tableName, byte[][] families, int numVersions, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family).setMaxVersions(numVersions);
            desc.addFamily(hcd);
        }
        this.getHBaseAdmin().createTable(desc, startKey, endKey, numRegions);
        this.waitUntilAllRegionsAssigned(tableName);
        return new HTable(this.getConfiguration(), tableName);
    }

    public HTable createTable(HTableDescriptor htd, byte[][] families, Configuration c) throws IOException {
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            hcd.setBloomFilterType(BloomType.NONE);
            htd.addFamily(hcd);
        }
        this.getHBaseAdmin().createTable(htd);
        this.waitUntilAllRegionsAssigned(htd.getTableName());
        return (HTable)this.getConnection().getTable(htd.getTableName());
    }

    public HTable createTable(HTableDescriptor htd, byte[][] splitRows) throws IOException {
        this.getHBaseAdmin().createTable(htd, splitRows);
        this.waitUntilAllRegionsAssigned(htd.getTableName());
        return new HTable(this.getConfiguration(), htd.getTableName());
    }

    public HTable createTable(TableName tableName, byte[][] families, Configuration c) throws IOException {
        return this.createTable(new HTableDescriptor(tableName), families, c);
    }

    public HTable createTable(byte[] tableName, byte[][] families, Configuration c) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            hcd.setBloomFilterType(BloomType.NONE);
            desc.addFamily(hcd);
        }
        this.getHBaseAdmin().createTable(desc);
        return new HTable(c, desc.getTableName());
    }

    public HTable createTable(TableName tableName, byte[][] families, Configuration c, int numVersions) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family).setMaxVersions(numVersions);
            desc.addFamily(hcd);
        }
        this.getHBaseAdmin().createTable(desc);
        this.waitUntilAllRegionsAssigned(tableName);
        return new HTable(c, tableName);
    }

    public HTable createTable(byte[] tableName, byte[][] families, Configuration c, int numVersions) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family).setMaxVersions(numVersions);
            desc.addFamily(hcd);
        }
        this.getHBaseAdmin().createTable(desc);
        return new HTable(c, desc.getTableName());
    }

    public HTable createTable(byte[] tableName, byte[] family, int numVersions) throws IOException {
        return this.createTable(tableName, (byte[][])new byte[][]{family}, numVersions);
    }

    public HTable createTable(TableName tableName, byte[] family, int numVersions) throws IOException {
        return this.createTable(tableName, (byte[][])new byte[][]{family}, numVersions);
    }

    public HTable createTable(byte[] tableName, byte[][] families, int numVersions) throws IOException {
        return this.createTable(TableName.valueOf((byte[])tableName), families, numVersions);
    }

    public HTable createTable(TableName tableName, byte[][] families, int numVersions) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family).setMaxVersions(numVersions);
            desc.addFamily(hcd);
        }
        this.getHBaseAdmin().createTable(desc);
        this.waitUntilAllRegionsAssigned(tableName);
        return new HTable(new Configuration(this.getConfiguration()), tableName);
    }

    public HTable createTable(byte[] tableName, byte[][] families, int numVersions, int blockSize) throws IOException {
        return this.createTable(TableName.valueOf((byte[])tableName), families, numVersions, blockSize);
    }

    public HTable createTable(TableName tableName, byte[][] families, int numVersions, int blockSize) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family).setMaxVersions(numVersions).setBlocksize(blockSize);
            desc.addFamily(hcd);
        }
        this.getHBaseAdmin().createTable(desc);
        this.waitUntilAllRegionsAssigned(tableName);
        return new HTable(new Configuration(this.getConfiguration()), tableName);
    }

    public HTable createTable(byte[] tableName, byte[][] families, int[] numVersions) throws IOException {
        return this.createTable(TableName.valueOf((byte[])tableName), families, numVersions);
    }

    public HTable createTable(TableName tableName, byte[][] families, int[] numVersions) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        int i = 0;
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family).setMaxVersions(numVersions[i]);
            desc.addFamily(hcd);
            ++i;
        }
        this.getHBaseAdmin().createTable(desc);
        this.waitUntilAllRegionsAssigned(tableName);
        return new HTable(new Configuration(this.getConfiguration()), tableName);
    }

    public HTable createTable(byte[] tableName, byte[] family, byte[][] splitRows) throws IOException {
        return this.createTable(TableName.valueOf((byte[])tableName), family, splitRows);
    }

    public HTable createTable(TableName tableName, byte[] family, byte[][] splitRows) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor(family);
        desc.addFamily(hcd);
        this.getHBaseAdmin().createTable(desc, splitRows);
        this.waitUntilAllRegionsAssigned(tableName);
        return new HTable(this.getConfiguration(), tableName);
    }

    public HTable createTable(byte[] tableName, byte[][] families, byte[][] splitRows) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            desc.addFamily(hcd);
        }
        this.getHBaseAdmin().createTable(desc, splitRows);
        this.waitUntilAllRegionsAssigned(desc.getTableName());
        return new HTable(this.getConfiguration(), desc.getTableName());
    }

    public static void modifyTableSync(Admin admin, HTableDescriptor desc) throws IOException, InterruptedException {
        admin.modifyTable(desc.getTableName(), desc);
        Pair status = new Pair<Integer, Integer>(){
            {
                this.setFirst(0);
                this.setSecond(0);
            }
        };
        for (int i = 0; (Integer)status.getFirst() != 0 && i < 500; ++i) {
            status = admin.getAlterStatus(desc.getTableName());
            if ((Integer)status.getSecond() == 0) {
                LOG.debug((Object)"All regions updated.");
                break;
            }
            LOG.debug((Object)((Integer)status.getSecond() - (Integer)status.getFirst() + "/" + status.getSecond() + " regions updated."));
            Thread.sleep(1000L);
        }
        if ((Integer)status.getSecond() != 0) {
            throw new IOException("Failed to update replica count after 500 seconds.");
        }
    }

    public static void setReplicas(Admin admin, TableName table, int replicaCount) throws IOException, InterruptedException {
        admin.disableTable(table);
        HTableDescriptor desc = admin.getTableDescriptor(table);
        desc.setRegionReplication(replicaCount);
        HBaseTestingUtility.modifyTableSync(admin, desc);
        admin.enableTable(table);
    }

    public void deleteTable(String tableName) throws IOException {
        this.deleteTable(TableName.valueOf((String)tableName));
    }

    public void deleteTable(byte[] tableName) throws IOException {
        this.deleteTable(TableName.valueOf((byte[])tableName));
    }

    public void deleteTable(TableName tableName) throws IOException {
        try {
            this.getHBaseAdmin().disableTable(tableName);
        }
        catch (TableNotEnabledException e) {
            LOG.debug((Object)("Table: " + tableName + " already disabled, so just deleting it."));
        }
        this.getHBaseAdmin().deleteTable(tableName);
    }

    public HTableDescriptor createTableDescriptor(String name, int minVersions, int versions, int ttl, KeepDeletedCells keepDeleted) {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)name));
        for (byte[] cfName : new byte[][]{fam1, fam2, fam3}) {
            htd.addFamily(new HColumnDescriptor(cfName).setMinVersions(minVersions).setMaxVersions(versions).setKeepDeletedCells(keepDeleted).setBlockCacheEnabled(false).setTimeToLive(ttl));
        }
        return htd;
    }

    public HTableDescriptor createTableDescriptor(String name) {
        return this.createTableDescriptor(name, 0, 3, Integer.MAX_VALUE, HColumnDescriptor.DEFAULT_KEEP_DELETED);
    }

    public HRegion createLocalHRegion(HTableDescriptor desc, byte[] startKey, byte[] endKey) throws IOException {
        HRegionInfo hri = new HRegionInfo(desc.getTableName(), startKey, endKey);
        return this.createLocalHRegion(hri, desc);
    }

    public HRegion createLocalHRegion(HRegionInfo info, HTableDescriptor desc) throws IOException {
        return HRegion.createHRegion((HRegionInfo)info, (Path)this.getDataTestDir(), (Configuration)this.getConfiguration(), (HTableDescriptor)desc);
    }

    public HRegion createLocalHRegion(HRegionInfo info, HTableDescriptor desc, WAL wal) throws IOException {
        return HRegion.createHRegion((HRegionInfo)info, (Path)this.getDataTestDir(), (Configuration)this.getConfiguration(), (HTableDescriptor)desc, (WAL)wal);
    }

    public HRegion createLocalHRegion(byte[] tableName, byte[] startKey, byte[] stopKey, String callingMethod, Configuration conf, boolean isReadOnly, Durability durability, WAL wal, byte[] ... families) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        htd.setReadOnly(isReadOnly);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            hcd.setMaxVersions(Integer.MAX_VALUE);
            htd.addFamily(hcd);
        }
        htd.setDurability(durability);
        HRegionInfo info = new HRegionInfo(htd.getTableName(), startKey, stopKey, false);
        return this.createLocalHRegion(info, htd, wal);
    }

    public HTable truncateTable(byte[] tableName) throws IOException {
        return this.truncateTable(TableName.valueOf((byte[])tableName));
    }

    public HTable truncateTable(TableName tableName) throws IOException {
        HTable table = new HTable(this.getConfiguration(), tableName);
        Scan scan = new Scan();
        ResultScanner resScan = table.getScanner(scan);
        for (Result res : resScan) {
            Delete del = new Delete(res.getRow());
            table.delete(del);
        }
        resScan = table.getScanner(scan);
        resScan.close();
        return table;
    }

    public int loadTable(Table t, byte[] f) throws IOException {
        return this.loadTable(t, new byte[][]{f});
    }

    public int loadTable(Table t, byte[] f, boolean writeToWAL) throws IOException {
        return this.loadTable(t, new byte[][]{f}, null, writeToWAL);
    }

    public int loadTable(Table t, byte[][] f) throws IOException {
        return this.loadTable(t, f, null);
    }

    public int loadTable(Table t, byte[][] f, byte[] value) throws IOException {
        return this.loadTable(t, f, value, true);
    }

    public int loadTable(Table t, byte[][] f, byte[] value, boolean writeToWAL) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (byte[] row : ROWS) {
            Put put = new Put(row);
            put.setDurability(writeToWAL ? Durability.USE_DEFAULT : Durability.SKIP_WAL);
            for (int i = 0; i < f.length; ++i) {
                put.add(f[i], null, value != null ? value : row);
            }
            puts.add(put);
        }
        t.put(puts);
        return puts.size();
    }

    public int loadRegion(HRegion r, byte[] f) throws IOException {
        return this.loadRegion(r, f, false);
    }

    public int loadRegion(HRegion r, byte[] f, boolean flush) throws IOException {
        byte[] k = new byte[3];
        int rowCount = 0;
        for (int b1 = 97; b1 <= 122; b1 = (int)((byte)(b1 + 1))) {
            for (int b2 = 97; b2 <= 122; b2 = (int)((byte)(b2 + 1))) {
                for (int b3 = 97; b3 <= 122; b3 = (int)((byte)(b3 + 1))) {
                    k[0] = b1;
                    k[1] = b2;
                    k[2] = b3;
                    Put put = new Put(k);
                    put.setDurability(Durability.SKIP_WAL);
                    put.add(f, null, k);
                    if (r.getWAL() == null) {
                        put.setDurability(Durability.SKIP_WAL);
                    }
                    int preRowCount = rowCount;
                    int pause = 10;
                    int maxPause = 1000;
                    while (rowCount == preRowCount) {
                        try {
                            r.put(put);
                            ++rowCount;
                        }
                        catch (RegionTooBusyException e) {
                            pause = pause * 2 >= maxPause ? maxPause : pause * 2;
                            Threads.sleep((long)pause);
                        }
                    }
                }
            }
            if (!flush) continue;
            r.flushcache();
        }
        return rowCount;
    }

    public void loadNumericRows(Table t, byte[] f, int startRow, int endRow) throws IOException {
        for (int i = startRow; i < endRow; ++i) {
            byte[] data = Bytes.toBytes((String)String.valueOf(i));
            Put put = new Put(data);
            put.add(f, null, data);
            t.put(put);
        }
    }

    public void deleteNumericRows(Table t, byte[] f, int startRow, int endRow) throws IOException {
        for (int i = startRow; i < endRow; ++i) {
            byte[] data = Bytes.toBytes((String)String.valueOf(i));
            Delete delete = new Delete(data);
            delete.deleteFamily(f);
            t.delete(delete);
        }
    }

    public int countRows(Table table) throws IOException {
        Scan scan = new Scan();
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            ++count;
        }
        results.close();
        return count;
    }

    public int countRows(Table table, byte[] ... families) throws IOException {
        Scan scan = new Scan();
        for (byte[] family : families) {
            scan.addFamily(family);
        }
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            ++count;
        }
        results.close();
        return count;
    }

    public String checksumRows(Table table) throws Exception {
        Scan scan = new Scan();
        ResultScanner results = table.getScanner(scan);
        MessageDigest digest = MessageDigest.getInstance("MD5");
        for (Result res : results) {
            digest.update(res.getRow());
        }
        results.close();
        return digest.toString();
    }

    public int createMultiRegions(HTable table, byte[] columnFamily) throws IOException {
        return this.createMultiRegions(this.getConfiguration(), table, columnFamily);
    }

    public int createMultiRegions(Configuration c, HTable table, byte[] columnFamily) throws IOException {
        return this.createMultiRegions(c, table, columnFamily, KEYS);
    }

    public int createMultiRegions(Configuration c, HTable table, byte[] family, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IOException("Must create at least 3 regions");
        }
        byte[] startKey = Bytes.toBytes((String)"aaaaa");
        byte[] endKey = Bytes.toBytes((String)"zzzzz");
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        byte[][] regionStartKeys = new byte[splitKeys.length + 1][];
        System.arraycopy(splitKeys, 0, regionStartKeys, 1, splitKeys.length);
        regionStartKeys[0] = HConstants.EMPTY_BYTE_ARRAY;
        return this.createMultiRegions(c, table, family, regionStartKeys);
    }

    public int createMultiRegions(Configuration c, HTable table, byte[] columnFamily, byte[][] startKeys) throws IOException {
        Arrays.sort(startKeys, Bytes.BYTES_COMPARATOR);
        HTable meta = new HTable(c, TableName.META_TABLE_NAME);
        HTableDescriptor htd = table.getTableDescriptor();
        if (!htd.hasFamily(columnFamily)) {
            HColumnDescriptor hcd = new HColumnDescriptor(columnFamily);
            htd.addFamily(hcd);
        }
        List<byte[]> rows = this.getMetaTableRows(htd.getTableName());
        String regionToDeleteInFS = ((HRegionLocation)table.getRegionsInRange(Bytes.toBytes((String)""), Bytes.toBytes((String)"")).get(0)).getRegionInfo().getEncodedName();
        ArrayList<HRegionInfo> newRegions = new ArrayList<HRegionInfo>(startKeys.length);
        int count = 0;
        for (int i = 0; i < startKeys.length; ++i) {
            int j = (i + 1) % startKeys.length;
            HRegionInfo hri = new HRegionInfo(table.getName(), startKeys[i], startKeys[j]);
            MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri);
            newRegions.add(hri);
            ++count;
        }
        for (byte[] row : rows) {
            LOG.info((Object)("createMultiRegions: deleting meta row -> " + Bytes.toStringBinary((byte[])row)));
            meta.delete(new Delete(row));
        }
        Path tableDir = new Path(this.getDefaultRootDirPath().toString() + System.getProperty("file.separator") + htd.getTableName() + System.getProperty("file.separator") + regionToDeleteInFS);
        FileSystem.get((Configuration)c).delete(tableDir, true);
        HConnection conn = table.getConnection();
        conn.clearRegionCache();
        HBaseAdmin admin = this.getHBaseAdmin();
        if (admin.isTableEnabled(table.getName())) {
            for (HRegionInfo hri : newRegions) {
                admin.assign(hri.getRegionName());
            }
        }
        meta.close();
        return count;
    }

    public List<HRegionInfo> createMultiRegionsInMeta(Configuration conf, HTableDescriptor htd, byte[][] startKeys) throws IOException {
        HTable meta = new HTable(conf, TableName.META_TABLE_NAME);
        Arrays.sort(startKeys, Bytes.BYTES_COMPARATOR);
        ArrayList<HRegionInfo> newRegions = new ArrayList<HRegionInfo>(startKeys.length);
        for (int i = 0; i < startKeys.length; ++i) {
            int j = (i + 1) % startKeys.length;
            HRegionInfo hri = new HRegionInfo(htd.getTableName(), startKeys[i], startKeys[j]);
            MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri);
            newRegions.add(hri);
        }
        meta.close();
        return newRegions;
    }

    public List<byte[]> getMetaTableRows() throws IOException {
        HTable t = new HTable(new Configuration(this.conf), TableName.META_TABLE_NAME);
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        ResultScanner s = t.getScanner(new Scan());
        for (Result result : s) {
            LOG.info((Object)("getMetaTableRows: row -> " + Bytes.toStringBinary((byte[])result.getRow())));
            rows.add(result.getRow());
        }
        s.close();
        t.close();
        return rows;
    }

    public List<byte[]> getMetaTableRows(TableName tableName) throws IOException {
        HTable t = new HTable(new Configuration(this.conf), TableName.META_TABLE_NAME);
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        ResultScanner s = t.getScanner(new Scan());
        for (Result result : s) {
            HRegionInfo info = HRegionInfo.getHRegionInfo((Result)result);
            if (info == null) {
                LOG.error((Object)("No region info for row " + Bytes.toString((byte[])result.getRow())));
                continue;
            }
            if (!info.getTable().equals((Object)tableName)) continue;
            LOG.info((Object)("getMetaTableRows: row -> " + Bytes.toStringBinary((byte[])result.getRow()) + info));
            rows.add(result.getRow());
        }
        s.close();
        t.close();
        return rows;
    }

    public HRegionServer getRSForFirstRegionInTable(TableName tableName) throws IOException, InterruptedException {
        List<byte[]> metaRows = this.getMetaTableRows(tableName);
        if (metaRows == null || metaRows.isEmpty()) {
            return null;
        }
        LOG.debug((Object)("Found " + metaRows.size() + " rows for table " + tableName));
        byte[] firstrow = metaRows.get(0);
        LOG.debug((Object)("FirstRow=" + Bytes.toString((byte[])firstrow)));
        long pause = this.getConfiguration().getLong("hbase.client.pause", 100L);
        int numRetries = this.getConfiguration().getInt("hbase.client.retries.number", 31);
        RetryCounter retrier = new RetryCounter(numRetries + 1, (long)((int)pause), TimeUnit.MICROSECONDS);
        while (retrier.shouldRetry()) {
            int index = this.getMiniHBaseCluster().getServerWith(firstrow);
            if (index != -1) {
                return this.getMiniHBaseCluster().getRegionServerThreads().get(index).getRegionServer();
            }
            retrier.sleepUntilNextRetry();
        }
        return null;
    }

    public MiniMRCluster startMiniMapReduceCluster() throws IOException {
        this.startMiniMapReduceCluster(2);
        return this.mrCluster;
    }

    private void forceChangeTaskLogDir() {
        try {
            Field logDirField = TaskLog.class.getDeclaredField("LOG_DIR");
            logDirField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(logDirField, logDirField.getModifiers() & 0xFFFFFFEF);
            logDirField.set(null, new File(this.hadoopLogDir, "userlogs"));
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void startMiniMapReduceCluster(int servers) throws IOException {
        String schedulerAddress;
        String historyAddress;
        if (this.mrCluster != null) {
            throw new IllegalStateException("MiniMRCluster is already running");
        }
        LOG.info((Object)"Starting mini mapreduce cluster...");
        this.setupClusterTestDir();
        this.createDirsAndSetProperties();
        this.forceChangeTaskLogDir();
        this.conf.setFloat("yarn.nodemanager.vmem-pmem-ratio", 8.0f);
        this.conf.setBoolean("mapreduce.map.speculative", false);
        this.conf.setBoolean("mapreduce.reduce.speculative", false);
        this.mrCluster = new MiniMRCluster(servers, FS_URI != null ? FS_URI : FileSystem.get((Configuration)this.conf).getUri().toString(), 1, null, null, new JobConf(this.conf));
        JobConf jobConf = MapreduceTestingShim.getJobConf(this.mrCluster);
        if (jobConf == null) {
            jobConf = this.mrCluster.createJobConf();
        }
        jobConf.set("mapreduce.cluster.local.dir", this.conf.get("mapreduce.cluster.local.dir"));
        LOG.info((Object)"Mini mapreduce cluster started");
        this.conf.set("mapreduce.jobtracker.address", jobConf.get("mapreduce.jobtracker.address"));
        this.conf.set("mapreduce.framework.name", "yarn");
        this.conf.setBoolean("yarn.is.minicluster", true);
        String rmAddress = jobConf.get("yarn.resourcemanager.address");
        if (rmAddress != null) {
            this.conf.set("yarn.resourcemanager.address", rmAddress);
        }
        if ((historyAddress = jobConf.get("mapreduce.jobhistory.address")) != null) {
            this.conf.set("mapreduce.jobhistory.address", historyAddress);
        }
        if ((schedulerAddress = jobConf.get("yarn.resourcemanager.scheduler.address")) != null) {
            this.conf.set("yarn.resourcemanager.scheduler.address", schedulerAddress);
        }
    }

    public void shutdownMiniMapReduceCluster() {
        if (this.mrCluster != null) {
            LOG.info((Object)"Stopping mini mapreduce cluster...");
            this.mrCluster.shutdown();
            this.mrCluster = null;
            LOG.info((Object)"Mini mapreduce cluster stopped");
        }
        this.conf.set("mapreduce.jobtracker.address", "local");
    }

    public RegionServerServices createMockRegionServerService() throws IOException {
        return this.createMockRegionServerService((ServerName)null);
    }

    public RegionServerServices createMockRegionServerService(RpcServerInterface rpc) throws IOException {
        MockRegionServerServices rss = new MockRegionServerServices(this.getZooKeeperWatcher());
        rss.setFileSystem(this.getTestFileSystem());
        rss.setRpcServer(rpc);
        return rss;
    }

    public RegionServerServices createMockRegionServerService(ServerName name) throws IOException {
        MockRegionServerServices rss = new MockRegionServerServices(this.getZooKeeperWatcher(), name);
        rss.setFileSystem(this.getTestFileSystem());
        return rss;
    }

    public void enableDebug(Class<?> clazz) {
        Log l = LogFactory.getLog(clazz);
        if (l instanceof Log4JLogger) {
            ((Log4JLogger)l).getLogger().setLevel(org.apache.log4j.Level.DEBUG);
        } else if (l instanceof Jdk14Logger) {
            ((Jdk14Logger)l).getLogger().setLevel(Level.ALL);
        }
    }

    public void expireMasterSession() throws Exception {
        HMaster master = this.getMiniHBaseCluster().getMaster();
        this.expireSession(master.getZooKeeper(), false);
    }

    public void expireRegionServerSession(int index) throws Exception {
        HRegionServer rs = this.getMiniHBaseCluster().getRegionServer(index);
        this.expireSession(rs.getZooKeeper(), false);
        this.decrementMinRegionServerCount();
    }

    private void decrementMinRegionServerCount() {
        this.decrementMinRegionServerCount(this.getConfiguration());
        for (JVMClusterUtil.MasterThread master : this.getHBaseCluster().getMasterThreads()) {
            this.decrementMinRegionServerCount(master.getMaster().getConfiguration());
        }
    }

    private void decrementMinRegionServerCount(Configuration conf) {
        int currentCount = conf.getInt("hbase.master.wait.on.regionservers.mintostart", -1);
        if (currentCount != -1) {
            conf.setInt("hbase.master.wait.on.regionservers.mintostart", Math.max(currentCount - 1, 1));
        }
    }

    public void expireSession(ZooKeeperWatcher nodeZK) throws Exception {
        this.expireSession(nodeZK, false);
    }

    @Deprecated
    public void expireSession(ZooKeeperWatcher nodeZK, Server server) throws Exception {
        this.expireSession(nodeZK, false);
    }

    public void expireSession(ZooKeeperWatcher nodeZK, boolean checkStatus) throws Exception {
        Configuration c = new Configuration(this.conf);
        String quorumServers = ZKConfig.getZKQuorumServersString((Configuration)c);
        ZooKeeper zk = nodeZK.getRecoverableZooKeeper().getZooKeeper();
        byte[] password = zk.getSessionPasswd();
        long sessionID = zk.getSessionId();
        ZooKeeper monitor = new ZooKeeper(quorumServers, 1000, new Watcher(){

            public void process(WatchedEvent watchedEvent) {
                HBaseCommonTestingUtility.LOG.info((Object)("Monitor ZKW received event=" + watchedEvent));
            }
        }, sessionID, password);
        ZooKeeper newZK = new ZooKeeper(quorumServers, 1000, (Watcher)EmptyWatcher.instance, sessionID, password);
        long start = System.currentTimeMillis();
        while (newZK.getState() != ZooKeeper.States.CONNECTED && System.currentTimeMillis() - start < 1000L) {
            Thread.sleep(1L);
        }
        newZK.close();
        LOG.info((Object)("ZK Closed Session 0x" + Long.toHexString(sessionID)));
        monitor.close();
        if (checkStatus) {
            new HTable(new Configuration(this.conf), TableName.META_TABLE_NAME).close();
        }
    }

    public MiniHBaseCluster getHBaseCluster() {
        return this.getMiniHBaseCluster();
    }

    public HBaseCluster getHBaseClusterInterface() {
        return this.hbaseCluster;
    }

    public Connection getConnection() throws IOException {
        if (this.connection == null) {
            this.connection = ConnectionFactory.createConnection((Configuration)this.conf);
        }
        return this.connection;
    }

    public synchronized HBaseAdmin getHBaseAdmin() throws IOException {
        if (this.hbaseAdmin == null) {
            this.hbaseAdmin = new HBaseAdminForTests(this.getConnection());
        }
        return this.hbaseAdmin;
    }

    public synchronized ZooKeeperWatcher getZooKeeperWatcher() throws IOException {
        if (this.zooKeeperWatcher == null) {
            this.zooKeeperWatcher = new ZooKeeperWatcher(this.conf, "testing utility", new Abortable(){

                public void abort(String why, Throwable e) {
                    throw new RuntimeException("Unexpected abort in HBaseTestingUtility:" + why, e);
                }

                public boolean isAborted() {
                    return false;
                }
            });
        }
        return this.zooKeeperWatcher;
    }

    public void closeRegion(String regionName) throws IOException {
        this.closeRegion(Bytes.toBytes((String)regionName));
    }

    public void closeRegion(byte[] regionName) throws IOException {
        this.getHBaseAdmin().closeRegion(regionName, null);
    }

    public void closeRegionByRow(String row, RegionLocator table) throws IOException {
        this.closeRegionByRow(Bytes.toBytes((String)row), table);
    }

    public void closeRegionByRow(byte[] row, RegionLocator table) throws IOException {
        HRegionLocation hrl = table.getRegionLocation(row);
        this.closeRegion(hrl.getRegionInfo().getRegionName());
    }

    public HRegion getSplittableRegion(TableName tableName, int maxAttempts) {
        List<HRegion> regions = this.getHBaseCluster().getRegions(tableName);
        int regCount = regions.size();
        HashSet<Integer> attempted = new HashSet<Integer>();
        int attempts = 0;
        do {
            if (regCount != (regions = this.getHBaseCluster().getRegions(tableName)).size()) {
                attempted.clear();
            }
            if ((regCount = regions.size()) > 0) {
                int idx = random.nextInt(regCount);
                if (attempted.contains(idx)) continue;
                try {
                    regions.get(idx).checkSplit();
                    return regions.get(idx);
                }
                catch (Exception ex) {
                    LOG.warn((Object)"Caught exception", (Throwable)ex);
                    attempted.add(idx);
                }
            }
            ++attempts;
        } while (maxAttempts == -1 || attempts < maxAttempts);
        return null;
    }

    public MiniZooKeeperCluster getZkCluster() {
        return this.zkCluster;
    }

    public void setZkCluster(MiniZooKeeperCluster zkCluster) {
        this.passedZkCluster = true;
        this.zkCluster = zkCluster;
        this.conf.setInt("hbase.zookeeper.property.clientPort", zkCluster.getClientPort());
    }

    public MiniDFSCluster getDFSCluster() {
        return this.dfsCluster;
    }

    public void setDFSCluster(MiniDFSCluster cluster) throws IOException {
        if (this.dfsCluster != null && this.dfsCluster.isClusterUp()) {
            throw new IOException("DFSCluster is already running! Shut it down first.");
        }
        this.dfsCluster = cluster;
    }

    public FileSystem getTestFileSystem() throws IOException {
        return HFileSystem.get((Configuration)this.conf);
    }

    public void waitTableAvailable(TableName table) throws InterruptedException, IOException {
        this.waitTableAvailable((Admin)this.getHBaseAdmin(), table.getName(), 30000L);
    }

    public void waitTableAvailable(Admin admin, byte[] table) throws InterruptedException, IOException {
        this.waitTableAvailable(admin, table, 30000L);
    }

    public void waitTableAvailable(byte[] table, long timeoutMillis) throws InterruptedException, IOException {
        this.waitTableAvailable((Admin)this.getHBaseAdmin(), table, timeoutMillis);
    }

    public void waitTableAvailable(Admin admin, byte[] table, long timeoutMillis) throws InterruptedException, IOException {
        long startWait = System.currentTimeMillis();
        while (!admin.isTableAvailable(TableName.valueOf((byte[])table))) {
            Assert.assertTrue((String)("Timed out waiting for table to become available " + Bytes.toStringBinary((byte[])table)), (System.currentTimeMillis() - startWait < timeoutMillis ? 1 : 0) != 0);
            Thread.sleep(200L);
        }
    }

    public void waitTableEnabled(TableName table) throws InterruptedException, IOException {
        this.waitTableEnabled((Admin)this.getHBaseAdmin(), table.getName(), 30000L);
    }

    public void waitTableEnabled(Admin admin, byte[] table) throws InterruptedException, IOException {
        this.waitTableEnabled(admin, table, 30000L);
    }

    public void waitTableEnabled(byte[] table, long timeoutMillis) throws InterruptedException, IOException {
        this.waitTableEnabled((Admin)this.getHBaseAdmin(), table, timeoutMillis);
    }

    public void waitTableEnabled(Admin admin, byte[] table, long timeoutMillis) throws InterruptedException, IOException {
        TableName tableName = TableName.valueOf((byte[])table);
        long startWait = System.currentTimeMillis();
        this.waitTableAvailable(admin, table, timeoutMillis);
        while (!admin.isTableEnabled(tableName)) {
            Assert.assertTrue((String)("Timed out waiting for table to become available and enabled " + Bytes.toStringBinary((byte[])table)), (System.currentTimeMillis() - startWait < timeoutMillis ? 1 : 0) != 0);
            Thread.sleep(200L);
        }
        try {
            Canary.sniff((Admin)admin, (TableName)tableName);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void waitTableDisabled(byte[] table) throws InterruptedException, IOException {
        this.waitTableDisabled((Admin)this.getHBaseAdmin(), table, 30000L);
    }

    public void waitTableDisabled(Admin admin, byte[] table) throws InterruptedException, IOException {
        this.waitTableDisabled(admin, table, 30000L);
    }

    public void waitTableDisabled(byte[] table, long timeoutMillis) throws InterruptedException, IOException {
        this.waitTableDisabled((Admin)this.getHBaseAdmin(), table, timeoutMillis);
    }

    public void waitTableDisabled(Admin admin, byte[] table, long timeoutMillis) throws InterruptedException, IOException {
        TableName tableName = TableName.valueOf((byte[])table);
        long startWait = System.currentTimeMillis();
        while (!admin.isTableDisabled(tableName)) {
            Assert.assertTrue((String)("Timed out waiting for table to become disabled " + Bytes.toStringBinary((byte[])table)), (System.currentTimeMillis() - startWait < timeoutMillis ? 1 : 0) != 0);
            Thread.sleep(200L);
        }
    }

    public boolean ensureSomeRegionServersAvailable(int num) throws IOException {
        boolean startedServer = false;
        MiniHBaseCluster hbaseCluster = this.getMiniHBaseCluster();
        for (int i = hbaseCluster.getLiveRegionServerThreads().size(); i < num; ++i) {
            LOG.info((Object)("Started new server=" + hbaseCluster.startRegionServer()));
            startedServer = true;
        }
        return startedServer;
    }

    public boolean ensureSomeNonStoppedRegionServersAvailable(int num) throws IOException {
        boolean startedServer = this.ensureSomeRegionServersAvailable(num);
        int nonStoppedServers = 0;
        for (JVMClusterUtil.RegionServerThread rst : this.getMiniHBaseCluster().getRegionServerThreads()) {
            HRegionServer hrs = rst.getRegionServer();
            if (hrs.isStopping() || hrs.isStopped()) {
                LOG.info((Object)("A region server is stopped or stopping:" + hrs));
                continue;
            }
            ++nonStoppedServers;
        }
        for (int i = nonStoppedServers; i < num; ++i) {
            LOG.info((Object)("Started new server=" + this.getMiniHBaseCluster().startRegionServer()));
            startedServer = true;
        }
        return startedServer;
    }

    public static User getDifferentUser(Configuration c, String differentiatingSuffix) throws IOException {
        FileSystem currentfs = FileSystem.get((Configuration)c);
        if (!(currentfs instanceof DistributedFileSystem)) {
            return User.getCurrent();
        }
        String username = User.getCurrent().getName() + differentiatingSuffix;
        User user = User.createUserForTesting((Configuration)c, (String)username, (String[])new String[]{"supergroup"});
        return user;
    }

    public static NavigableSet<String> getAllOnlineRegions(MiniHBaseCluster cluster) throws IOException {
        TreeSet<String> online = new TreeSet<String>();
        for (JVMClusterUtil.RegionServerThread rst : cluster.getLiveRegionServerThreads()) {
            try {
                for (HRegionInfo region : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rst.getRegionServer().getRSRpcServices())) {
                    online.add(region.getRegionNameAsString());
                }
            }
            catch (RegionServerStoppedException e) {
            }
        }
        for (JVMClusterUtil.MasterThread mt : cluster.getLiveMasterThreads()) {
            try {
                for (HRegionInfo region : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)mt.getMaster().getRSRpcServices())) {
                    online.add(region.getRegionNameAsString());
                }
            }
            catch (RegionServerStoppedException e) {
            }
            catch (ServerNotRunningYetException e) {
            }
        }
        return online;
    }

    public static void setMaxRecoveryErrorCount(OutputStream stream, int max) {
        try {
            Class<?>[] clazzes;
            for (Class<?> clazz : clazzes = DFSClient.class.getDeclaredClasses()) {
                String className = clazz.getSimpleName();
                if (!className.equals("DFSOutputStream") || !clazz.isInstance(stream)) continue;
                Field maxRecoveryErrorCountField = stream.getClass().getDeclaredField("maxRecoveryErrorCount");
                maxRecoveryErrorCountField.setAccessible(true);
                maxRecoveryErrorCountField.setInt(stream, max);
                break;
            }
        }
        catch (Exception e) {
            LOG.info((Object)"Could not set max recovery field", (Throwable)e);
        }
    }

    public void waitUntilAllRegionsAssigned(TableName tableName) throws IOException {
        this.waitUntilAllRegionsAssigned(tableName, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilAllRegionsAssigned(final TableName tableName, long timeout) throws IOException {
        try (HTable meta = new HTable(this.getConfiguration(), TableName.META_TABLE_NAME);){
            this.waitFor(timeout, 200L, true, new Waiter.Predicate<IOException>((Table)meta, tableName){
                final /* synthetic */ Table val$meta;
                final /* synthetic */ TableName val$tableName;
                {
                    this.val$meta = table;
                    this.val$tableName = tableName;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean evaluate() throws IOException {
                    boolean allRegionsAssigned = true;
                    Scan scan = new Scan();
                    scan.addFamily(HConstants.CATALOG_FAMILY);
                    try (ResultScanner s = this.val$meta.getScanner(scan);){
                        Result r;
                        while ((r = s.next()) != null) {
                            byte[] b = r.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                            HRegionInfo info = HRegionInfo.parseFromOrNull((byte[])b);
                            if (info == null || !info.getTable().equals((Object)this.val$tableName)) continue;
                            b = r.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                            allRegionsAssigned &= b != null;
                        }
                    }
                    return allRegionsAssigned;
                }
            });
        }
        if (!this.getHBaseClusterInterface().isDistributedCluster()) {
            HMaster master = this.getHBaseCluster().getMaster();
            final RegionStates states = master.getAssignmentManager().getRegionStates();
            this.waitFor(timeout, 200L, new Waiter.Predicate<IOException>(){

                public boolean evaluate() throws IOException {
                    List hris = states.getRegionsOfTable(tableName);
                    return hris != null && !hris.isEmpty();
                }
            });
        }
    }

    public static List<Cell> getFromStoreFile(HStore store, Get get) throws IOException {
        Cell kv;
        Scan scan = new Scan(get);
        InternalScanner scanner = (InternalScanner)store.getScanner(scan, (NavigableSet)scan.getFamilyMap().get(store.getFamily().getName()), 0L);
        ArrayList<Cell> result = new ArrayList<Cell>();
        scanner.next(result);
        if (!result.isEmpty() && !CellUtil.matchingRow((Cell)(kv = (Cell)result.get(0)), (byte[])get.getRow())) {
            result.clear();
        }
        scanner.close();
        return result;
    }

    public byte[][] getRegionSplitStartKeys(byte[] startKey, byte[] endKey, int numRegions) {
        Assert.assertTrue((numRegions > 3 ? 1 : 0) != 0);
        byte[][] tmpSplitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        byte[][] result = new byte[tmpSplitKeys.length + 1][];
        System.arraycopy(tmpSplitKeys, 0, result, 1, tmpSplitKeys.length);
        result[0] = HConstants.EMPTY_BYTE_ARRAY;
        return result;
    }

    public static List<Cell> getFromStoreFile(HStore store, byte[] row, NavigableSet<byte[]> columns) throws IOException {
        Get get = new Get(row);
        Map s = get.getFamilyMap();
        s.put(store.getFamily().getName(), columns);
        return HBaseTestingUtility.getFromStoreFile(store, get);
    }

    public static ZooKeeperWatcher getZooKeeperWatcher(HBaseTestingUtility TEST_UTIL) throws ZooKeeperConnectionException, IOException {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "unittest", new Abortable(){
            boolean aborted = false;

            public void abort(String why, Throwable e) {
                this.aborted = true;
                throw new RuntimeException("Fatal ZK error, why=" + why, e);
            }

            public boolean isAborted() {
                return this.aborted;
            }
        });
        return zkw;
    }

    public static ZooKeeperWatcher createAndForceNodeToOpenedState(HBaseTestingUtility TEST_UTIL, HRegion region, ServerName serverName) throws ZooKeeperConnectionException, IOException, KeeperException, KeeperException.NodeExistsException {
        ZooKeeperWatcher zkw = HBaseTestingUtility.getZooKeeperWatcher(TEST_UTIL);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region.getRegionInfo(), (ServerName)serverName);
        int version = ZKAssign.transitionNodeOpening((ZooKeeperWatcher)zkw, (HRegionInfo)region.getRegionInfo(), (ServerName)serverName);
        ZKAssign.transitionNodeOpened((ZooKeeperWatcher)zkw, (HRegionInfo)region.getRegionInfo(), (ServerName)serverName, (int)version);
        return zkw;
    }

    public static void assertKVListsEqual(String additionalMsg, List<? extends Cell> expected, List<? extends Cell> actual) {
        int i;
        int eLen = expected.size();
        int aLen = actual.size();
        int minLen = Math.min(eLen, aLen);
        for (i = 0; i < minLen && KeyValue.COMPARATOR.compare(expected.get(i), actual.get(i)) == 0; ++i) {
        }
        if (additionalMsg == null) {
            additionalMsg = "";
        }
        if (!additionalMsg.isEmpty()) {
            additionalMsg = ". " + additionalMsg;
        }
        if (eLen != aLen || i != minLen) {
            throw new AssertionError((Object)("Expected and actual KV arrays differ at position " + i + ": " + HBaseTestingUtility.safeGetAsStr(expected, i) + " (length " + eLen + ") vs. " + HBaseTestingUtility.safeGetAsStr(actual, i) + " (length " + aLen + ")" + additionalMsg));
        }
    }

    public static <T> String safeGetAsStr(List<T> lst, int i) {
        if (0 <= i && i < lst.size()) {
            return lst.get(i).toString();
        }
        return "<out_of_range>";
    }

    public String getClusterKey() {
        return this.conf.get("hbase.zookeeper.quorum") + ":" + this.conf.get("hbase.zookeeper.property.clientPort") + ":" + this.conf.get("zookeeper.znode.parent", "/hbase");
    }

    public HTable createRandomTable(String tableName, Collection<String> families, int maxVersions, int numColsPerRow, int numFlushes, int numRegions, int numRowsPerFlush) throws IOException, InterruptedException {
        LOG.info((Object)("\n\nCreating random table " + tableName + " with " + numRegions + " regions, " + numFlushes + " storefiles per region, " + numRowsPerFlush + " rows per flush, maxVersions=" + maxVersions + "\n"));
        Random rand = new Random((long)tableName.hashCode() * 17L + 12938197137L);
        int numCF = families.size();
        byte[][] cfBytes = new byte[numCF][];
        int cfIndex = 0;
        for (String cf : families) {
            cfBytes[cfIndex++] = Bytes.toBytes((String)cf);
        }
        boolean actualStartKey = false;
        int actualEndKey = Integer.MAX_VALUE;
        int keysPerRegion = Integer.MAX_VALUE / numRegions;
        int splitStartKey = 0 + keysPerRegion;
        int splitEndKey = Integer.MAX_VALUE - keysPerRegion;
        String keyFormat = "%08x";
        HTable table = this.createTable(tableName, (byte[][])cfBytes, maxVersions, Bytes.toBytes((String)String.format("%08x", splitStartKey)), Bytes.toBytes((String)String.format("%08x", splitEndKey)), numRegions);
        if (this.hbaseCluster != null) {
            this.getMiniHBaseCluster().flushcache(TableName.META_TABLE_NAME);
        }
        for (int iFlush = 0; iFlush < numFlushes; ++iFlush) {
            for (int iRow = 0; iRow < numRowsPerFlush; ++iRow) {
                byte[] row = Bytes.toBytes((String)String.format("%08x", 0 + rand.nextInt(Integer.MAX_VALUE)));
                Put put = new Put(row);
                Delete del = new Delete(row);
                for (int iCol = 0; iCol < numColsPerRow; ++iCol) {
                    byte[] cf = cfBytes[rand.nextInt(numCF)];
                    long ts = rand.nextInt();
                    byte[] qual = Bytes.toBytes((String)("col" + iCol));
                    if (rand.nextBoolean()) {
                        byte[] value = Bytes.toBytes((String)("value_for_row_" + iRow + "_cf_" + Bytes.toStringBinary((byte[])cf) + "_col_" + iCol + "_ts_" + ts + "_random_" + rand.nextLong()));
                        put.add(cf, qual, ts, value);
                        continue;
                    }
                    if (rand.nextDouble() < 0.8) {
                        del.deleteColumn(cf, qual, ts);
                        continue;
                    }
                    del.deleteColumns(cf, qual, ts);
                }
                if (!put.isEmpty()) {
                    table.put(put);
                }
                if (del.isEmpty()) continue;
                table.delete(del);
            }
            LOG.info((Object)("Initiating flush #" + iFlush + " for table " + tableName));
            table.flushCommits();
            if (this.hbaseCluster == null) continue;
            this.getMiniHBaseCluster().flushcache(table.getName());
        }
        return table;
    }

    public static int randomPort() {
        return 49152 + random.nextInt(16382);
    }

    public static int randomFreePort() {
        int port = 0;
        do {
            if (takenRandomPorts.contains(port = HBaseTestingUtility.randomPort())) continue;
            takenRandomPorts.add(port);
            try {
                ServerSocket sock = new ServerSocket(port);
                sock.close();
            }
            catch (IOException ex) {
                port = 0;
            }
        } while (port == 0);
        return port;
    }

    public static String randomMultiCastAddress() {
        return "226.1.1." + random.nextInt(254);
    }

    public static void waitForHostPort(String host, int port) throws IOException {
        int maxTimeMs = 10000;
        int maxNumAttempts = 50;
        IOException savedException = null;
        LOG.info((Object)("Waiting for server at " + host + ":" + port));
        for (int attempt = 0; attempt < 50; ++attempt) {
            try {
                Socket sock = new Socket(InetAddress.getByName(host), port);
                sock.close();
                savedException = null;
                LOG.info((Object)("Server at " + host + ":" + port + " is available"));
                break;
            }
            catch (UnknownHostException e) {
                throw new IOException("Failed to look up " + host, e);
            }
            catch (IOException e) {
                savedException = e;
                Threads.sleepWithoutInterrupt((long)200L);
                continue;
            }
        }
        if (savedException != null) {
            throw savedException;
        }
    }

    public static int createPreSplitLoadTestTable(Configuration conf, TableName tableName, byte[] columnFamily, Compression.Algorithm compression, DataBlockEncoding dataBlockEncoding) throws IOException {
        return HBaseTestingUtility.createPreSplitLoadTestTable(conf, tableName, columnFamily, compression, dataBlockEncoding, 5, 1, Durability.USE_DEFAULT);
    }

    public static int createPreSplitLoadTestTable(Configuration conf, TableName tableName, byte[] columnFamily, Compression.Algorithm compression, DataBlockEncoding dataBlockEncoding, int numRegionsPerServer, int regionReplication, Durability durability) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.setDurability(durability);
        desc.setRegionReplication(regionReplication);
        HColumnDescriptor hcd = new HColumnDescriptor(columnFamily);
        hcd.setDataBlockEncoding(dataBlockEncoding);
        hcd.setCompressionType(compression);
        return HBaseTestingUtility.createPreSplitLoadTestTable(conf, desc, hcd, numRegionsPerServer);
    }

    public static int createPreSplitLoadTestTable(Configuration conf, HTableDescriptor desc, HColumnDescriptor hcd) throws IOException {
        return HBaseTestingUtility.createPreSplitLoadTestTable(conf, desc, hcd, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int createPreSplitLoadTestTable(Configuration conf, HTableDescriptor desc, HColumnDescriptor hcd, int numRegionsPerServer) throws IOException {
        if (!desc.hasFamily(hcd.getName())) {
            desc.addFamily(hcd);
        }
        int totalNumberOfRegions = 0;
        Connection unmanagedConnection = ConnectionFactory.createConnection((Configuration)conf);
        Admin admin = unmanagedConnection.getAdmin();
        try {
            int numberOfServers = admin.getClusterStatus().getServers().size();
            if (numberOfServers == 0) {
                throw new IllegalStateException("No live regionservers");
            }
            totalNumberOfRegions = numberOfServers * numRegionsPerServer;
            LOG.info((Object)("Number of live regionservers: " + numberOfServers + ", " + "pre-splitting table into " + totalNumberOfRegions + " regions " + "(regions per server: " + numRegionsPerServer + ")"));
            byte[][] splits = new RegionSplitter.HexStringSplit().split(totalNumberOfRegions);
            admin.createTable(desc, splits);
        }
        catch (MasterNotRunningException e) {
            LOG.error((Object)"Master not running", (Throwable)e);
            throw new IOException(e);
        }
        catch (TableExistsException e) {
            LOG.warn((Object)("Table " + desc.getTableName() + " already exists, continuing"));
        }
        finally {
            admin.close();
            unmanagedConnection.close();
        }
        return totalNumberOfRegions;
    }

    public static int getMetaRSPort(Configuration conf) throws IOException {
        HTable table = new HTable(conf, TableName.META_TABLE_NAME);
        HRegionLocation hloc = table.getRegionLocation(Bytes.toBytes((String)""));
        table.close();
        return hloc.getPort();
    }

    public void assertRegionOnServer(HRegionInfo hri, ServerName server, long timeout) throws IOException, InterruptedException {
        long timeoutTime = System.currentTimeMillis() + timeout;
        while (true) {
            List regions;
            if ((regions = this.getHBaseAdmin().getOnlineRegions(server)).contains(hri)) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now > timeoutTime) break;
            Thread.sleep(10L);
        }
        Assert.fail((String)("Could not find region " + hri.getRegionNameAsString() + " on server " + server));
    }

    public void assertRegionOnlyOnServer(HRegionInfo hri, ServerName server, long timeout) throws IOException, InterruptedException {
        long timeoutTime = System.currentTimeMillis() + timeout;
        while (true) {
            List regions;
            if ((regions = this.getHBaseAdmin().getOnlineRegions(server)).contains(hri)) {
                List<JVMClusterUtil.RegionServerThread> rsThreads = this.getHBaseCluster().getLiveRegionServerThreads();
                for (JVMClusterUtil.RegionServerThread rsThread : rsThreads) {
                    HRegionServer rs = rsThread.getRegionServer();
                    if (server.equals((Object)rs.getServerName())) continue;
                    Collection hrs = rs.getOnlineRegionsLocalContext();
                    for (HRegion r : hrs) {
                        Assert.assertTrue((String)"Region should not be double assigned", (r.getRegionId() != hri.getRegionId() ? 1 : 0) != 0);
                    }
                }
                return;
            }
            long now = System.currentTimeMillis();
            if (now > timeoutTime) break;
            Thread.sleep(10L);
        }
        Assert.fail((String)("Could not find region " + hri.getRegionNameAsString() + " on server " + server));
    }

    public HRegion createTestRegion(String tableName, HColumnDescriptor hcd) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)tableName));
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(TableName.valueOf((String)tableName), null, null, false);
        HRegion region = HRegion.createHRegion((HRegionInfo)info, (Path)this.getDataTestDir(), (Configuration)this.getConfiguration(), (HTableDescriptor)htd);
        return region;
    }

    public void setFileSystemURI(String fsURI) {
        FS_URI = fsURI;
    }

    public <E extends Exception> long waitFor(long timeout, Waiter.Predicate<E> predicate) throws E {
        return Waiter.waitFor((Configuration)this.conf, (long)timeout, predicate);
    }

    public <E extends Exception> long waitFor(long timeout, long interval, Waiter.Predicate<E> predicate) throws E {
        return Waiter.waitFor((Configuration)this.conf, (long)timeout, (long)interval, predicate);
    }

    public <E extends Exception> long waitFor(long timeout, long interval, boolean failIfTimeout, Waiter.Predicate<E> predicate) throws E {
        return Waiter.waitFor((Configuration)this.conf, (long)timeout, (long)interval, (boolean)failIfTimeout, predicate);
    }

    public Waiter.Predicate<Exception> predicateNoRegionsInTransition() {
        return new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                RegionStates regionStates = HBaseTestingUtility.this.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
                return !regionStates.isRegionsInTransition();
            }
        };
    }

    public Waiter.Predicate<Exception> predicateTableEnabled(final TableName tableName) {
        return new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return HBaseTestingUtility.this.getHBaseAdmin().isTableEnabled(tableName);
            }
        };
    }

    public static List<HColumnDescriptor> generateColumnDescriptors() {
        return HBaseTestingUtility.generateColumnDescriptors("");
    }

    public static List<HColumnDescriptor> generateColumnDescriptors(String prefix) {
        ArrayList<HColumnDescriptor> htds = new ArrayList<HColumnDescriptor>();
        long familyId = 0L;
        for (Compression.Algorithm compressionType : HBaseTestingUtility.getSupportedCompressionAlgorithms()) {
            for (DataBlockEncoding encodingType : DataBlockEncoding.values()) {
                for (BloomType bloomType : BloomType.values()) {
                    String name = String.format("%s-cf-!@#&-%d!@#", prefix, familyId);
                    HColumnDescriptor htd = new HColumnDescriptor(name);
                    htd.setCompressionType(compressionType);
                    htd.setDataBlockEncoding(encodingType);
                    htd.setBloomFilterType(bloomType);
                    htds.add(htd);
                    ++familyId;
                }
            }
        }
        return htds;
    }

    public static Compression.Algorithm[] getSupportedCompressionAlgorithms() {
        String[] allAlgos = HFile.getSupportedCompressionAlgorithms();
        ArrayList<Compression.Algorithm> supportedAlgos = new ArrayList<Compression.Algorithm>();
        for (String algoName : allAlgos) {
            try {
                Compression.Algorithm algo = Compression.getCompressionAlgorithmByName((String)algoName);
                algo.getCompressor();
                supportedAlgos.add(algo);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return supportedAlgos.toArray(new Compression.Algorithm[supportedAlgos.size()]);
    }

    public void waitUntilNoRegionsInTransition(long timeout) throws Exception {
        this.waitFor(timeout, this.predicateNoRegionsInTransition());
    }

    static {
        takenRandomPorts = new HashSet<Integer>();
        COMPRESSION_ALGORITHMS_PARAMETERIZED = Arrays.asList({Compression.Algorithm.NONE}, {Compression.Algorithm.GZ});
        BOOLEAN_PARAMETERIZED = Arrays.asList({new Boolean(false)}, {new Boolean(true)});
        MEMSTORETS_TAGS_PARAMETRIZED = HBaseTestingUtility.memStoreTSAndTagsCombination();
        COMPRESSION_ALGORITHMS = new Compression.Algorithm[]{Compression.Algorithm.NONE, Compression.Algorithm.GZ};
        BLOOM_AND_COMPRESSION_COMBINATIONS = HBaseTestingUtility.bloomAndCompressionCombinations();
        fam1 = Bytes.toBytes((String)"colfamily11");
        fam2 = Bytes.toBytes((String)"colfamily21");
        fam3 = Bytes.toBytes((String)"colfamily31");
        COLUMNS = new byte[][]{fam1, fam2, fam3};
        START_KEY_BYTES = new byte[]{97, 97, 97};
        START_KEY = new String(START_KEY_BYTES, HConstants.UTF8_CHARSET);
        ROWS = new byte[(int)Math.pow(26.0, 3.0)][3];
        int i = 0;
        for (int b1 = 97; b1 <= 122; b1 = (int)((byte)(b1 + 1))) {
            for (int b2 = 97; b2 <= 122; b2 = (int)((byte)(b2 + 1))) {
                for (int b3 = 97; b3 <= 122; b3 = (int)((byte)(b3 + 1))) {
                    HBaseTestingUtility.ROWS[i][0] = b1;
                    HBaseTestingUtility.ROWS[i][1] = b2;
                    HBaseTestingUtility.ROWS[i][2] = b3;
                    ++i;
                }
            }
        }
        KEYS = new byte[][]{HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"hhh"), Bytes.toBytes((String)"iii"), Bytes.toBytes((String)"jjj"), Bytes.toBytes((String)"kkk"), Bytes.toBytes((String)"lll"), Bytes.toBytes((String)"mmm"), Bytes.toBytes((String)"nnn"), Bytes.toBytes((String)"ooo"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"qqq"), Bytes.toBytes((String)"rrr"), Bytes.toBytes((String)"sss"), Bytes.toBytes((String)"ttt"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"vvv"), Bytes.toBytes((String)"www"), Bytes.toBytes((String)"xxx"), Bytes.toBytes((String)"yyy")};
        KEYS_FOR_HBA_CREATE_TABLE = new byte[][]{Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"hhh"), Bytes.toBytes((String)"iii"), Bytes.toBytes((String)"jjj"), Bytes.toBytes((String)"kkk"), Bytes.toBytes((String)"lll"), Bytes.toBytes((String)"mmm"), Bytes.toBytes((String)"nnn"), Bytes.toBytes((String)"ooo"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"qqq"), Bytes.toBytes((String)"rrr"), Bytes.toBytes((String)"sss"), Bytes.toBytes((String)"ttt"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"vvv"), Bytes.toBytes((String)"www"), Bytes.toBytes((String)"xxx"), Bytes.toBytes((String)"yyy"), Bytes.toBytes((String)"zzz")};
        random = new Random();
    }

    private static class HBaseAdminForTests
    extends HBaseAdmin {
        public HBaseAdminForTests(Connection connection) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
            super(connection);
        }

        public synchronized void close() throws IOException {
            HBaseCommonTestingUtility.LOG.warn((Object)"close() called on HBaseAdmin instance returned from HBaseTestingUtility.getHBaseAdmin()");
        }

        private synchronized void close0() throws IOException {
            super.close();
        }
    }

    public static class SeenRowTracker {
        int dim = 26;
        int[][][] seenRows = new int[this.dim][this.dim][this.dim];
        byte[] startRow;
        byte[] stopRow;

        public SeenRowTracker(byte[] startRow, byte[] stopRow) {
            this.startRow = startRow;
            this.stopRow = stopRow;
        }

        void reset() {
            for (byte[] row : ROWS) {
                this.seenRows[this.i((byte)row[0])][this.i((byte)row[1])][this.i((byte)row[2])] = 0;
            }
        }

        int i(byte b) {
            return b - 97;
        }

        public void addRow(byte[] row) {
            int[] nArray = this.seenRows[this.i(row[0])][this.i(row[1])];
            int n = this.i(row[2]);
            nArray[n] = nArray[n] + 1;
        }

        public void validate() {
            for (byte b1 = 97; b1 <= 122; b1 = (byte)((byte)(b1 + 1))) {
                for (byte b2 = 97; b2 <= 122; b2 = (byte)((byte)(b2 + 1))) {
                    for (byte b3 = 97; b3 <= 122; b3 = (byte)(b3 + 1)) {
                        int count = this.seenRows[this.i(b1)][this.i(b2)][this.i(b3)];
                        int expectedCount = 0;
                        if (Bytes.compareTo((byte[])new byte[]{b1, b2, b3}, (byte[])this.startRow) >= 0 && Bytes.compareTo((byte[])new byte[]{b1, b2, b3}, (byte[])this.stopRow) < 0) {
                            expectedCount = 1;
                        }
                        if (count == expectedCount) continue;
                        String row = new String(new byte[]{b1, b2, b3});
                        throw new RuntimeException("Row:" + row + " has a seen count of " + count + " instead of " + expectedCount);
                    }
                }
            }
        }
    }
}

