/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionObserverScannerOpenHook {
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    static final Path DIR = UTIL.getDataTestDir();

    HRegion initHRegion(byte[] tableName, String callingMethod, Configuration conf, byte[] ... families) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        for (byte[] family : families) {
            htd.addFamily(new HColumnDescriptor(family));
        }
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        Path path = new Path(DIR + callingMethod);
        HRegion r = HRegion.createHRegion((HRegionInfo)info, (Path)path, (Configuration)conf, (HTableDescriptor)htd);
        RegionCoprocessorHost host = new RegionCoprocessorHost(r, null, conf);
        r.setCoprocessorHost(host);
        return r;
    }

    @Test
    public void testRegionObserverScanTimeStacking() throws Exception {
        byte[] ROW = Bytes.toBytes((String)"testRow");
        byte[] TABLE = Bytes.toBytes((String)this.getClass().getName());
        byte[] A = Bytes.toBytes((String)"A");
        byte[][] FAMILIES = new byte[][]{A};
        Configuration conf = HBaseConfiguration.create();
        HRegion region = this.initHRegion(TABLE, this.getClass().getName(), conf, FAMILIES);
        RegionCoprocessorHost h = region.getCoprocessorHost();
        h.load(NoDataFromScan.class, 0, conf);
        h.load(EmptyRegionObsever.class, 0x3FFFFFFF, conf);
        Put put = new Put(ROW);
        put.add(A, A, A);
        region.put(put);
        Get get = new Get(ROW);
        Result r = region.get(get);
        Assert.assertNull((String)("Got an unexpected number of rows - no data should be returned with the NoDataFromScan coprocessor. Found: " + r), (Object)r.listCells());
    }

    @Test
    public void testRegionObserverFlushTimeStacking() throws Exception {
        byte[] ROW = Bytes.toBytes((String)"testRow");
        byte[] TABLE = Bytes.toBytes((String)this.getClass().getName());
        byte[] A = Bytes.toBytes((String)"A");
        byte[][] FAMILIES = new byte[][]{A};
        Configuration conf = HBaseConfiguration.create();
        HRegion region = this.initHRegion(TABLE, this.getClass().getName(), conf, FAMILIES);
        RegionCoprocessorHost h = region.getCoprocessorHost();
        h.load(NoDataFromFlush.class, 0, conf);
        h.load(EmptyRegionObsever.class, 0x3FFFFFFF, conf);
        Put put = new Put(ROW);
        put.add(A, A, A);
        region.put(put);
        region.flushcache();
        Get get = new Get(ROW);
        Result r = region.get(get);
        Assert.assertNull((String)("Got an unexpected number of rows - no data should be returned with the NoDataFromScan coprocessor. Found: " + r), (Object)r.listCells());
    }

    @Test
    public void testRegionObserverCompactionTimeStacking() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setClass("hbase.hregion.impl", CompactionCompletionNotifyingRegion.class, HRegion.class);
        conf.setInt("hbase.hstore.compaction.min", 2);
        UTIL.startMiniCluster();
        String tableName = "testRegionObserverCompactionTimeStacking";
        byte[] ROW = Bytes.toBytes((String)"testRow");
        byte[] A = Bytes.toBytes((String)"A");
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)tableName));
        desc.addFamily(new HColumnDescriptor(A));
        desc.addCoprocessor(EmptyRegionObsever.class.getName(), null, 0x3FFFFFFF, null);
        desc.addCoprocessor(NoDataFromCompaction.class.getName(), null, 0, null);
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        admin.createTable(desc);
        HTable table = new HTable(conf, desc.getTableName());
        Put put = new Put(ROW);
        put.add(A, A, A);
        table.put(put);
        HRegionServer rs = UTIL.getRSForFirstRegionInTable(desc.getTableName());
        List regions = rs.getOnlineRegions(desc.getTableName());
        Assert.assertEquals((String)"More than 1 region serving test table with 1 row", (long)1L, (long)regions.size());
        HRegion region = (HRegion)regions.get(0);
        admin.flushRegion(region.getRegionName());
        CountDownLatch latch = ((CompactionCompletionNotifyingRegion)region).getCompactionStateChangeLatch();
        put = new Put(Bytes.toBytes((String)"anotherrow"));
        put.add(A, A, A);
        table.put(put);
        admin.flushRegion(region.getRegionName());
        latch.await();
        Get get = new Get(ROW);
        Result r = table.get(get);
        Assert.assertNull((String)("Got an unexpected number of rows - no data should be returned with the NoDataFromScan coprocessor. Found: " + r), (Object)r.listCells());
        get = new Get(Bytes.toBytes((String)"anotherrow"));
        r = table.get(get);
        Assert.assertNull((String)("Got an unexpected number of rows - no data should be returned with the NoDataFromScan coprocessor Found: " + r), (Object)r.listCells());
        table.close();
        UTIL.shutdownMiniCluster();
    }

    public static class CompactionCompletionNotifyingRegion
    extends HRegion {
        private static volatile CountDownLatch compactionStateChangeLatch = null;

        public CompactionCompletionNotifyingRegion(Path tableDir, WAL log, FileSystem fs, Configuration confParam, HRegionInfo info, HTableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, log, fs, confParam, info, htd, rsServices);
        }

        public CountDownLatch getCompactionStateChangeLatch() {
            if (compactionStateChangeLatch == null) {
                compactionStateChangeLatch = new CountDownLatch(1);
            }
            return compactionStateChangeLatch;
        }

        public boolean compact(CompactionContext compaction, Store store) throws IOException {
            boolean ret = super.compact(compaction, store);
            if (ret) {
                compactionStateChangeLatch.countDown();
            }
            return ret;
        }
    }

    public static class NoDataFromCompaction
    extends BaseRegionObserver {
        public InternalScanner preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends KeyValueScanner> scanners, ScanType scanType, long earliestPutTs, InternalScanner s) throws IOException {
            Scan scan = new Scan();
            scan.setFilter((Filter)new NoDataFilter());
            return new StoreScanner(store, store.getScanInfo(), scan, scanners, ScanType.COMPACT_RETAIN_DELETES, store.getSmallestReadPoint(), Long.MIN_VALUE);
        }
    }

    public static class NoDataFromFlush
    extends BaseRegionObserver {
        public InternalScanner preFlushScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, KeyValueScanner memstoreScanner, InternalScanner s) throws IOException {
            Scan scan = new Scan();
            scan.setFilter((Filter)new NoDataFilter());
            return new StoreScanner(store, store.getScanInfo(), scan, Collections.singletonList(memstoreScanner), ScanType.COMPACT_RETAIN_DELETES, store.getSmallestReadPoint(), Long.MIN_VALUE);
        }
    }

    public static class NoDataFromScan
    extends BaseRegionObserver {
        public KeyValueScanner preStoreScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, Scan scan, NavigableSet<byte[]> targetCols, KeyValueScanner s) throws IOException {
            scan.setFilter((Filter)new NoDataFilter());
            return new StoreScanner(store, store.getScanInfo(), scan, targetCols, ((HStore)store).getHRegion().getReadpoint(IsolationLevel.READ_COMMITTED));
        }
    }

    public static class EmptyRegionObsever
    extends BaseRegionObserver {
    }

    public static class NoDataFilter
    extends FilterBase {
        public Filter.ReturnCode filterKeyValue(Cell ignored) throws IOException {
            return Filter.ReturnCode.SKIP;
        }

        public boolean filterAllRemaining() throws IOException {
            return true;
        }

        public boolean filterRow() throws IOException {
            return true;
        }
    }
}

