/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

@Category(value={MediumTests.class})
public class TestZKBasedOpenCloseRegion {
    private static final Log LOG = LogFactory.getLog(TestZKBasedOpenCloseRegion.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLENAME = TableName.valueOf((String)"TestZKBasedOpenCloseRegion");
    private static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
    private static int countOfRegions;

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        Configuration c = TEST_UTIL.getConfiguration();
        c.setBoolean("hbase.assignment.usezk", true);
        c.setBoolean("dfs.support.append", true);
        c.setInt("hbase.regionserver.info.port", 0);
        TEST_UTIL.startMiniCluster(2);
        TEST_UTIL.createTable(TABLENAME, FAMILIES);
        HTable t = new HTable(TEST_UTIL.getConfiguration(), TABLENAME);
        countOfRegions = TEST_UTIL.createMultiRegions(t, TestZKBasedOpenCloseRegion.getTestFamily());
        TestZKBasedOpenCloseRegion.waitUntilAllRegionsAssigned();
        TestZKBasedOpenCloseRegion.addToEachStartKey(countOfRegions);
        t.close();
        TestZKBasedOpenCloseRegion.TEST_UTIL.getHBaseCluster().getMaster().assignmentManager.initializeHandlerTrackers();
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException {
        if (TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads().size() < 2) {
            LOG.info((Object)("Started new server=" + TEST_UTIL.getHBaseCluster().startRegionServer()));
        }
        TestZKBasedOpenCloseRegion.waitUntilAllRegionsAssigned();
        this.waitOnRIT();
    }

    @Test(timeout=300000L)
    public void testReOpenRegion() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        LOG.info((Object)("Number of region servers = " + cluster.getLiveRegionServerThreads().size()));
        int rsIdx = 0;
        HRegionServer regionServer = TEST_UTIL.getHBaseCluster().getRegionServer(rsIdx);
        HRegionInfo hri = this.getNonMetaRegion(ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)regionServer.getRSRpcServices()));
        LOG.debug((Object)("Asking RS to close region " + hri.getRegionNameAsString()));
        LOG.info((Object)("Unassign " + hri.getRegionNameAsString()));
        cluster.getMaster().assignmentManager.unassign(hri);
        while (!cluster.getMaster().assignmentManager.wasClosedHandlerCalled(hri)) {
            Threads.sleep((long)100L);
        }
        while (!cluster.getMaster().assignmentManager.wasOpenedHandlerCalled(hri)) {
            Threads.sleep((long)100L);
        }
        LOG.info((Object)"Done with testReOpenRegion");
    }

    private HRegionInfo getNonMetaRegion(Collection<HRegionInfo> regions) {
        HRegionInfo hri = null;
        for (HRegionInfo i : regions) {
            LOG.info((Object)i.getRegionNameAsString());
            if (i.isMetaRegion()) continue;
            hri = i;
            break;
        }
        return hri;
    }

    @Test
    public void testRSAlreadyProcessingRegion() throws Exception {
        LOG.info((Object)"starting testRSAlreadyProcessingRegion");
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HRegionServer hr0 = cluster.getLiveRegionServerThreads().get(0).getRegionServer();
        HRegionServer hr1 = cluster.getLiveRegionServerThreads().get(1).getRegionServer();
        HRegionInfo hri = this.getNonMetaRegion(ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hr0.getRSRpcServices()));
        hr1.getRegionsInTransitionInRS().putIfAbsent(hri.getEncodedNameAsBytes(), true);
        TEST_UTIL.getHBaseAdmin().move(hri.getEncodedNameAsBytes(), Bytes.toBytes((String)hr1.getServerName().toString()));
        Assert.assertEquals((Object)hr1.getOnlineRegion(hri.getEncodedNameAsBytes()), null);
        hr1.getRegionsInTransitionInRS().remove(hri.getEncodedNameAsBytes());
        hri = this.getNonMetaRegion(ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hr1.getRSRpcServices()));
        TEST_UTIL.getHBaseAdmin().move(hri.getEncodedNameAsBytes(), Bytes.toBytes((String)hr0.getServerName().toString()));
        while (!cluster.getMaster().assignmentManager.wasOpenedHandlerCalled(hri)) {
            Threads.sleep((long)100L);
        }
        Assert.assertTrue((hr1.getOnlineRegion(hri.getEncodedNameAsBytes()) == null ? 1 : 0) != 0);
    }

    private void waitOnRIT() {
        while (TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().isRegionsInTransition()) {
            LOG.info((Object)("Waiting on regions in transition: " + TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionsInTransition()));
            Threads.sleep((long)10L);
        }
    }

    @Test
    public void testRegionOpenFailsDueToIOException() throws Exception {
        HRegionInfo REGIONINFO = new HRegionInfo(TableName.valueOf((String)"t"), HConstants.EMPTY_START_ROW, HConstants.EMPTY_START_ROW);
        HRegionServer regionServer = TEST_UTIL.getHBaseCluster().getRegionServer(0);
        TableDescriptors htd = (TableDescriptors)Mockito.mock(TableDescriptors.class);
        Object orizinalState = Whitebox.getInternalState((Object)regionServer, (String)"tableDescriptors");
        Whitebox.setInternalState((Object)regionServer, (String)"tableDescriptors", (Object)htd);
        ((TableDescriptors)Mockito.doThrow((Throwable)new IOException()).when((Object)htd)).get((TableName)Mockito.any());
        try {
            ProtobufUtil.openRegion((AdminProtos.AdminService.BlockingInterface)regionServer.getRSRpcServices(), (ServerName)regionServer.getServerName(), (HRegionInfo)REGIONINFO);
            Assert.fail((String)"It should throw IOException ");
        }
        catch (IOException e) {
            // empty catch block
        }
        Whitebox.setInternalState((Object)regionServer, (String)"tableDescriptors", (Object)orizinalState);
        Assert.assertFalse((String)"Region should not be in RIT", (boolean)regionServer.getRegionsInTransitionInRS().containsKey(REGIONINFO.getEncodedNameAsBytes()));
    }

    private static void waitUntilAllRegionsAssigned() throws IOException {
        HTable meta = new HTable(TEST_UTIL.getConfiguration(), TableName.META_TABLE_NAME);
        while (true) {
            byte[] b;
            int rows = 0;
            Scan scan = new Scan();
            scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
            ResultScanner s = meta.getScanner(scan);
            Result r = null;
            while ((r = s.next()) != null && (b = r.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER)) != null && b.length > 0) {
                ++rows;
            }
            s.close();
            if (rows >= countOfRegions) break;
            LOG.info((Object)("Found=" + rows));
            Threads.sleep((long)1000L);
        }
        meta.close();
    }

    private static int addToEachStartKey(int expected) throws IOException {
        HRegionInfo hri;
        HTable t = new HTable(TEST_UTIL.getConfiguration(), TABLENAME);
        HTable meta = new HTable(TEST_UTIL.getConfiguration(), TableName.META_TABLE_NAME);
        int rows = 0;
        Scan scan = new Scan();
        scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        ResultScanner s = meta.getScanner(scan);
        Result r = null;
        while ((r = s.next()) != null && (hri = HRegionInfo.getHRegionInfo((Result)r)) != null) {
            if (!hri.getTable().equals((Object)TABLENAME)) continue;
            byte[] row = TestZKBasedOpenCloseRegion.getStartKey(hri);
            Put p = new Put(row);
            p.setDurability(Durability.SKIP_WAL);
            p.add(TestZKBasedOpenCloseRegion.getTestFamily(), TestZKBasedOpenCloseRegion.getTestQualifier(), row);
            t.put(p);
            ++rows;
        }
        s.close();
        Assert.assertEquals((long)expected, (long)rows);
        t.close();
        meta.close();
        return rows;
    }

    private static byte[] getStartKey(HRegionInfo hri) {
        return Bytes.equals((byte[])HConstants.EMPTY_START_ROW, (byte[])hri.getStartKey()) ? Bytes.toBytes((String)"aaa") : hri.getStartKey();
    }

    private static byte[] getTestFamily() {
        return FAMILIES[0];
    }

    private static byte[] getTestQualifier() {
        return TestZKBasedOpenCloseRegion.getTestFamily();
    }
}

