/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestEncryptionKeyRotation {
    private static final Log LOG = LogFactory.getLog(TestEncryptionKeyRotation.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Configuration conf = TEST_UTIL.getConfiguration();
    private static final Key initialCFKey;
    private static final Key secondCFKey;

    @BeforeClass
    public static void setUp() throws Exception {
        conf.setInt("hfile.format.version", 3);
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        conf.set("hbase.crypto.master.key.name", "hbase");
        conf.setBoolean("hbase.online.schema.update.enable", true);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCFKeyRotation() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"default", (String)"testCFKeyRotation"));
        HColumnDescriptor hcd = new HColumnDescriptor("cf");
        hcd.setEncryptionType("AES");
        hcd.setEncryptionKey(EncryptionUtil.wrapKey((Configuration)conf, (String)"hbase", (Key)initialCFKey));
        htd.addFamily(hcd);
        this.createTableAndFlush(htd);
        final List<Path> initialPaths = TestEncryptionKeyRotation.findStorefilePaths(htd.getTableName());
        Assert.assertTrue((initialPaths.size() > 0 ? 1 : 0) != 0);
        for (Path path : initialPaths) {
            Assert.assertTrue((String)("Store file " + path + " has incorrect key"), (boolean)Bytes.equals((byte[])initialCFKey.getEncoded(), (byte[])TestEncryptionKeyRotation.extractHFileKey(path)));
        }
        hcd = htd.getFamily(Bytes.toBytes((String)"cf"));
        hcd.setEncryptionKey(EncryptionUtil.wrapKey((Configuration)conf, (String)conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName()), (Key)secondCFKey));
        TEST_UTIL.getHBaseAdmin().modifyColumn(htd.getTableName(), hcd);
        Thread.sleep(5000L);
        TEST_UTIL.getHBaseAdmin().majorCompact(htd.getTableName());
        TEST_UTIL.waitFor(30000L, 1000L, true, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                boolean found = false;
                for (Path path : initialPaths) {
                    found = TEST_UTIL.getTestFileSystem().exists(path);
                    if (!found) continue;
                    LOG.info((Object)("Found " + path));
                    break;
                }
                return !found;
            }
        });
        List<Path> pathsAfterCompaction = TestEncryptionKeyRotation.findStorefilePaths(htd.getTableName());
        Assert.assertTrue((pathsAfterCompaction.size() > 0 ? 1 : 0) != 0);
        for (Path path : pathsAfterCompaction) {
            Assert.assertFalse((String)("Store file " + path + " retains initial key"), (boolean)Bytes.equals((byte[])initialCFKey.getEncoded(), (byte[])TestEncryptionKeyRotation.extractHFileKey(path)));
            Assert.assertTrue((String)("Store file " + path + " has incorrect key"), (boolean)Bytes.equals((byte[])secondCFKey.getEncoded(), (byte[])TestEncryptionKeyRotation.extractHFileKey(path)));
        }
    }

    @Test
    public void testMasterKeyRotation() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"default", (String)"testMasterKeyRotation"));
        HColumnDescriptor hcd = new HColumnDescriptor("cf");
        hcd.setEncryptionType("AES");
        hcd.setEncryptionKey(EncryptionUtil.wrapKey((Configuration)conf, (String)"hbase", (Key)initialCFKey));
        htd.addFamily(hcd);
        this.createTableAndFlush(htd);
        List<Path> storeFilePaths = TestEncryptionKeyRotation.findStorefilePaths(htd.getTableName());
        Assert.assertTrue((storeFilePaths.size() > 0 ? 1 : 0) != 0);
        for (Path path : storeFilePaths) {
            Assert.assertTrue((String)("Store file " + path + " has incorrect key"), (boolean)Bytes.equals((byte[])initialCFKey.getEncoded(), (byte[])TestEncryptionKeyRotation.extractHFileKey(path)));
        }
        TEST_UTIL.shutdownMiniHBaseCluster();
        conf.set("hbase.crypto.master.key.name", "other");
        conf.set("hbase.crypto.master.alternate.key.name", "hbase");
        TEST_UTIL.startMiniHBaseCluster(1, 1);
        TEST_UTIL.waitTableAvailable(htd.getName(), 5000L);
        storeFilePaths = TestEncryptionKeyRotation.findStorefilePaths(htd.getTableName());
        Assert.assertTrue((storeFilePaths.size() > 0 ? 1 : 0) != 0);
        for (Path path : storeFilePaths) {
            Assert.assertTrue((String)("Store file " + path + " has incorrect key"), (boolean)Bytes.equals((byte[])initialCFKey.getEncoded(), (byte[])TestEncryptionKeyRotation.extractHFileKey(path)));
        }
    }

    private static List<Path> findStorefilePaths(TableName tableName) throws Exception {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (HRegion region : TEST_UTIL.getRSForFirstRegionInTable(tableName).getOnlineRegions(tableName)) {
            for (Store store : region.getStores().values()) {
                for (StoreFile storefile : store.getStorefiles()) {
                    paths.add(storefile.getPath());
                }
            }
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableAndFlush(HTableDescriptor htd) throws Exception {
        HColumnDescriptor hcd = (HColumnDescriptor)htd.getFamilies().iterator().next();
        TEST_UTIL.getHBaseAdmin().createTable(htd);
        TEST_UTIL.waitTableAvailable(htd.getName(), 5000L);
        try (HTable table = new HTable(conf, htd.getTableName());){
            table.put(new Put(Bytes.toBytes((String)"testrow")).add(hcd.getName(), Bytes.toBytes((String)"q"), Bytes.toBytes((String)"value")));
        }
        TEST_UTIL.getHBaseAdmin().flush(htd.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] extractHFileKey(Path path) throws Exception {
        try (HFile.Reader reader = HFile.createReader((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)path, (CacheConfig)new CacheConfig(conf), (Configuration)conf);){
            reader.loadFileInfo();
            Encryption.Context cryptoContext = reader.getFileContext().getEncryptionContext();
            Assert.assertNotNull((String)"Reader has a null crypto context", (Object)cryptoContext);
            Key key = cryptoContext.getKey();
            Assert.assertNotNull((String)"Crypto context has no key", (Object)key);
            byte[] byArray = key.getEncoded();
            return byArray;
        }
    }

    static {
        SecureRandom rng = new SecureRandom();
        byte[] keyBytes = new byte[16];
        rng.nextBytes(keyBytes);
        initialCFKey = new SecretKeySpec(keyBytes, "AES");
        rng.nextBytes(keyBytes);
        secondCFKey = new SecretKeySpec(keyBytes, "AES");
    }
}

