/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TestMetaTableAccessor;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.TestRegionServerNoMaster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.StringUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionReplicas {
    private static final Log LOG = LogFactory.getLog(TestRegionReplicas.class);
    private static final int NB_SERVERS = 1;
    private static HTable table;
    private static final byte[] row;
    private static HRegionInfo hriPrimary;
    private static HRegionInfo hriSecondary;
    private static final HBaseTestingUtility HTU;
    private static final byte[] f;

    @BeforeClass
    public static void before() throws Exception {
        HTU.getConfiguration().setInt("dfs.blocksize", 8192);
        HTU.getConfiguration().setInt("dfs.client.read.prefetch.size", 1);
        HTU.getConfiguration().setInt("hbase.hregion.memstore.flush.size", 0x8000000);
        HTU.startMiniCluster(1);
        TableName tableName = TableName.valueOf((String)TestRegionReplicas.class.getSimpleName());
        table = HTU.createTable(tableName, f);
        hriPrimary = table.getRegionLocation(row, false).getRegionInfo();
        hriSecondary = new HRegionInfo(hriPrimary.getTable(), hriPrimary.getStartKey(), hriPrimary.getEndKey(), hriPrimary.isSplit(), hriPrimary.getRegionId(), 1);
        TestRegionServerNoMaster.stopMasterAndAssignMeta(HTU);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        table.close();
        HTU.shutdownMiniCluster();
    }

    @After
    public void after() throws Exception {
        ZKAssign.deleteNodeFailSilent((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hriPrimary);
    }

    private HRegionServer getRS() {
        return HTU.getMiniHBaseCluster().getRegionServer(0);
    }

    private void openRegion(HRegionInfo hri) throws Exception {
        ZKAssign.createNodeOffline((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)this.getRS().getServerName());
        AdminProtos.OpenRegionRequest orr = RequestConverter.buildOpenRegionRequest((ServerName)this.getRS().getServerName(), (HRegionInfo)hri, (int)0, null, null);
        AdminProtos.OpenRegionResponse responseOpen = this.getRS().getRSRpcServices().openRegion(null, orr);
        Assert.assertTrue((responseOpen.getOpeningStateCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)responseOpen.getOpeningState(0).equals((Object)AdminProtos.OpenRegionResponse.RegionOpeningState.OPENED));
        this.checkRegionIsOpened(hri.getEncodedName());
    }

    private void closeRegion(HRegionInfo hri) throws Exception {
        ZKAssign.createNodeClosing((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (HRegionInfo)hri, (ServerName)this.getRS().getServerName());
        AdminProtos.CloseRegionRequest crr = RequestConverter.buildCloseRegionRequest((ServerName)this.getRS().getServerName(), (String)hri.getEncodedName(), (boolean)true);
        AdminProtos.CloseRegionResponse responseClose = this.getRS().getRSRpcServices().closeRegion(null, crr);
        Assert.assertTrue((boolean)responseClose.getClosed());
        this.checkRegionIsClosed(hri.getEncodedName());
        ZKAssign.deleteClosedNode((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (String)hri.getEncodedName(), (ServerName)this.getRS().getServerName());
    }

    private void checkRegionIsOpened(String encodedRegionName) throws Exception {
        while (!this.getRS().getRegionsInTransitionInRS().isEmpty()) {
            Thread.sleep(1L);
        }
        Assert.assertTrue((boolean)this.getRS().getRegionByEncodedName(encodedRegionName).isAvailable());
        Assert.assertTrue((boolean)ZKAssign.deleteOpenedNode((ZooKeeperWatcher)HTU.getZooKeeperWatcher(), (String)encodedRegionName, (ServerName)this.getRS().getServerName()));
    }

    private void checkRegionIsClosed(String encodedRegionName) throws Exception {
        while (!this.getRS().getRegionsInTransitionInRS().isEmpty()) {
            Thread.sleep(1L);
        }
        try {
            Assert.assertFalse((boolean)this.getRS().getRegionByEncodedName(encodedRegionName).isAvailable());
        }
        catch (NotServingRegionException notServingRegionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testOpenRegionReplica() throws Exception {
        this.openRegion(hriSecondary);
        try {
            HTU.loadNumericRows((Table)table, f, 0, 1000);
            Assert.assertEquals((long)1000L, (long)HTU.countRows((Table)table));
        }
        finally {
            HTU.deleteNumericRows((Table)table, f, 0, 1000);
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testRegionReplicaUpdatesMetaLocation() throws Exception {
        this.openRegion(hriSecondary);
        HTable meta = null;
        try {
            meta = new HTable(HTU.getConfiguration(), TableName.META_TABLE_NAME);
            TestMetaTableAccessor.assertMetaLocation((Table)meta, hriPrimary.getRegionName(), this.getRS().getServerName(), -1L, 1, false);
        }
        finally {
            if (meta != null) {
                meta.close();
            }
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testRegionReplicaGets() throws Exception {
        try {
            HTU.loadNumericRows((Table)table, f, 0, 1000);
            Assert.assertEquals((long)1000L, (long)HTU.countRows((Table)table));
            this.getRS().getRegionByEncodedName(hriPrimary.getEncodedName()).flushcache();
            this.openRegion(hriSecondary);
            HRegion region = this.getRS().getFromOnlineRegions(hriSecondary.getEncodedName());
            this.assertGet(region, 42, true);
            this.assertGetRpc(hriSecondary, 42, true);
        }
        finally {
            HTU.deleteNumericRows((Table)table, HConstants.CATALOG_FAMILY, 0, 1000);
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testGetOnTargetRegionReplica() throws Exception {
        try {
            HTU.loadNumericRows((Table)table, f, 0, 1000);
            Assert.assertEquals((long)1000L, (long)HTU.countRows((Table)table));
            this.getRS().getRegionByEncodedName(hriPrimary.getEncodedName()).flushcache();
            this.openRegion(hriSecondary);
            byte[] row = Bytes.toBytes((String)String.valueOf(42));
            Get get = new Get(row);
            get.setConsistency(Consistency.TIMELINE);
            get.setReplicaId(1);
            Result result = table.get(get);
            Assert.assertArrayEquals((byte[])row, (byte[])result.getValue(f, null));
        }
        finally {
            HTU.deleteNumericRows((Table)table, HConstants.CATALOG_FAMILY, 0, 1000);
            this.closeRegion(hriSecondary);
        }
    }

    private void assertGet(HRegion region, int value, boolean expect) throws IOException {
        byte[] row = Bytes.toBytes((String)String.valueOf(value));
        Get get = new Get(row);
        Result result = region.get(get);
        if (expect) {
            Assert.assertArrayEquals((byte[])row, (byte[])result.getValue(f, null));
        } else {
            result.isEmpty();
        }
    }

    private void assertGetRpc(HRegionInfo info, int value, boolean expect) throws IOException, ServiceException {
        byte[] row = Bytes.toBytes((String)String.valueOf(value));
        Get get = new Get(row);
        ClientProtos.GetRequest getReq = RequestConverter.buildGetRequest((byte[])info.getRegionName(), (Get)get);
        ClientProtos.GetResponse getResp = this.getRS().getRSRpcServices().get(null, getReq);
        Result result = ProtobufUtil.toResult((ClientProtos.Result)getResp.getResult());
        if (expect) {
            Assert.assertArrayEquals((byte[])row, (byte[])result.getValue(f, null));
        } else {
            result.isEmpty();
        }
    }

    private void restartRegionServer() throws Exception {
        TestRegionReplicas.afterClass();
        TestRegionReplicas.before();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testRefreshStoreFiles() throws Exception {
        int refreshPeriod = 2000;
        HTU.getConfiguration().setInt("hbase.hstore.compactionThreshold", 100);
        HTU.getConfiguration().setInt("hbase.regionserver.storefile.refresh.period", 2000);
        this.restartRegionServer();
        try {
            LOG.info((Object)("Opening the secondary region " + hriSecondary.getEncodedName()));
            this.openRegion(hriSecondary);
            LOG.info((Object)"Loading data to primary region");
            HTU.loadNumericRows((Table)table, f, 0, 1000);
            Assert.assertEquals((long)1000L, (long)HTU.countRows((Table)table));
            LOG.info((Object)"Flushing primary region");
            this.getRS().getRegionByEncodedName(hriPrimary.getEncodedName()).flushcache();
            LOG.info((Object)"Sleeping for 8000");
            Threads.sleep((long)8000L);
            LOG.info((Object)"Checking results from secondary region replica");
            HRegion secondaryRegion = this.getRS().getFromOnlineRegions(hriSecondary.getEncodedName());
            Assert.assertEquals((long)1L, (long)secondaryRegion.getStore(f).getStorefilesCount());
            this.assertGet(secondaryRegion, 42, true);
            this.assertGetRpc(hriSecondary, 42, true);
            this.assertGetRpc(hriSecondary, 1042, false);
            HTU.loadNumericRows((Table)table, f, 1000, 1100);
            this.getRS().getRegionByEncodedName(hriPrimary.getEncodedName()).flushcache();
            HTU.loadNumericRows((Table)table, f, 2000, 2100);
            this.getRS().getRegionByEncodedName(hriPrimary.getEncodedName()).flushcache();
            Threads.sleep((long)8000L);
            this.assertGetRpc(hriSecondary, 42, true);
            this.assertGetRpc(hriSecondary, 1042, true);
            this.assertGetRpc(hriSecondary, 2042, true);
            Assert.assertEquals((long)3L, (long)secondaryRegion.getStore(f).getStorefilesCount());
            HTU.compact(table.getName(), true);
            long wakeUpTime = System.currentTimeMillis() + 8000L;
            while (System.currentTimeMillis() < wakeUpTime) {
                this.assertGetRpc(hriSecondary, 42, true);
                this.assertGetRpc(hriSecondary, 1042, true);
                this.assertGetRpc(hriSecondary, 2042, true);
                Threads.sleep((long)10L);
            }
            Assert.assertEquals((long)1L, (long)secondaryRegion.getStore(f).getStorefilesCount());
        }
        finally {
            HTU.deleteNumericRows((Table)table, HConstants.CATALOG_FAMILY, 0, 1000);
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testFlushAndCompactionsInPrimary() throws Exception {
        long runtime = 30000L;
        int refreshPeriod = 100;
        HTU.getConfiguration().setInt("hbase.hstore.compactionThreshold", 3);
        HTU.getConfiguration().setInt("hbase.regionserver.storefile.refresh.period", 100);
        this.restartRegionServer();
        boolean startKey = false;
        int endKey = 1000;
        try {
            this.openRegion(hriSecondary);
            HTU.loadNumericRows((Table)table, f, 0, 1000);
            TestRegionServerNoMaster.flushRegion(HTU, hriPrimary);
            Threads.sleep((long)200L);
            final AtomicBoolean running = new AtomicBoolean(true);
            final AtomicReference[] exceptions = new AtomicReference[3];
            for (int i = 0; i < exceptions.length; ++i) {
                exceptions[i] = new AtomicReference();
            }
            Runnable writer = new Runnable(){
                int key = 0;

                @Override
                public void run() {
                    try {
                        while (running.get()) {
                            byte[] data = Bytes.toBytes((String)String.valueOf(this.key));
                            Put put = new Put(data);
                            put.add(f, null, data);
                            table.put(put);
                            ++this.key;
                            if (this.key != 1000) continue;
                            this.key = 0;
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)ex);
                        exceptions[0].compareAndSet(null, ex);
                    }
                }
            };
            Runnable flusherCompactor = new Runnable(){
                Random random = new Random();

                @Override
                public void run() {
                    try {
                        while (running.get()) {
                            if (this.random.nextBoolean()) {
                                TestRegionServerNoMaster.flushRegion(HTU, hriPrimary);
                                continue;
                            }
                            HTU.compact(table.getName(), this.random.nextBoolean());
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)ex);
                        exceptions[1].compareAndSet(null, ex);
                    }
                }
            };
            Runnable reader = new Runnable(){
                Random random = new Random();

                @Override
                public void run() {
                    try {
                        while (running.get()) {
                            if (this.random.nextInt(10) == 0) {
                                try {
                                    TestRegionReplicas.this.closeRegion(hriSecondary);
                                }
                                catch (Exception ex) {
                                    LOG.warn((Object)("Failed closing the region " + hriSecondary + " " + StringUtils.stringifyException((Throwable)ex)));
                                    exceptions[2].compareAndSet(null, ex);
                                }
                                try {
                                    TestRegionReplicas.this.openRegion(hriSecondary);
                                }
                                catch (Exception ex) {
                                    LOG.warn((Object)("Failed opening the region " + hriSecondary + " " + StringUtils.stringifyException((Throwable)ex)));
                                    exceptions[2].compareAndSet(null, ex);
                                }
                            }
                            int key = this.random.nextInt(1000) + 0;
                            TestRegionReplicas.this.assertGetRpc(hriSecondary, key, true);
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)("Failed getting the value in the region " + hriSecondary + " " + StringUtils.stringifyException((Throwable)ex)));
                        exceptions[2].compareAndSet(null, ex);
                    }
                }
            };
            LOG.info((Object)"Starting writer and reader");
            ExecutorService executor = Executors.newFixedThreadPool(3);
            executor.submit(writer);
            executor.submit(flusherCompactor);
            executor.submit(reader);
            Threads.sleep((long)runtime);
            running.set(false);
            executor.shutdown();
            executor.awaitTermination(30L, TimeUnit.SECONDS);
            for (AtomicReference exRef : exceptions) {
                Assert.assertNull(exRef.get());
            }
        }
        finally {
            HTU.deleteNumericRows((Table)table, HConstants.CATALOG_FAMILY, 0, 1000);
            this.closeRegion(hriSecondary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testVerifySecondaryAbilityToReadWithOnFiles() throws Exception {
        HTU.getConfiguration().setInt("hbase.regionserver.storefile.refresh.period", 0);
        this.restartRegionServer();
        try {
            LOG.info((Object)("Opening the secondary region " + hriSecondary.getEncodedName()));
            this.openRegion(hriSecondary);
            LOG.info((Object)"Loading data to primary region");
            for (int i = 0; i < 3; ++i) {
                HTU.loadNumericRows((Table)table, f, i * 1000, (i + 1) * 1000);
                this.getRS().getRegionByEncodedName(hriPrimary.getEncodedName()).flushcache();
            }
            HRegion primaryRegion = this.getRS().getFromOnlineRegions(hriPrimary.getEncodedName());
            Assert.assertEquals((long)3L, (long)primaryRegion.getStore(f).getStorefilesCount());
            HRegion secondaryRegion = this.getRS().getFromOnlineRegions(hriSecondary.getEncodedName());
            secondaryRegion.getStore(f).refreshStoreFiles();
            Assert.assertEquals((long)3L, (long)secondaryRegion.getStore(f).getStorefilesCount());
            LOG.info((Object)("Force Major compaction on primary region " + hriPrimary));
            primaryRegion.compactStores(true);
            Assert.assertEquals((long)1L, (long)primaryRegion.getStore(f).getStorefilesCount());
            int keys = 0;
            int sum = 0;
            for (StoreFile sf : secondaryRegion.getStore(f).getStorefiles()) {
                LOG.debug((Object)this.getRS().getFileSystem().exists(sf.getPath()));
                Assert.assertFalse((boolean)this.getRS().getFileSystem().exists(sf.getPath()));
                HFileScanner scanner = sf.getReader().getScanner(false, false);
                scanner.seekTo();
                do {
                    ++keys;
                    Cell cell = scanner.getKeyValue();
                    sum += Integer.parseInt(Bytes.toString((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()));
                } while (scanner.next());
            }
            Assert.assertEquals((long)3000L, (long)keys);
            Assert.assertEquals((long)0x44A444L, (long)sum);
        }
        finally {
            HTU.deleteNumericRows((Table)table, HConstants.CATALOG_FAMILY, 0, 1000);
            this.closeRegion(hriSecondary);
        }
    }

    static {
        row = "TestRegionReplicas".getBytes();
        HTU = new HBaseTestingUtility();
        f = HConstants.CATALOG_FAMILY;
    }
}

