/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlFilter;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.TestTableName;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestCellACLWithMultipleVersions
extends SecureTestUtil {
    private static final Log LOG = LogFactory.getLog(TestCellACLWithMultipleVersions.class);
    @Rule
    public TestTableName TEST_TABLE = new TestTableName();
    private static final HBaseTestingUtility TEST_UTIL;
    private static final byte[] TEST_FAMILY1;
    private static final byte[] TEST_FAMILY2;
    private static final byte[] TEST_ROW;
    private static final byte[] TEST_Q1;
    private static final byte[] TEST_Q2;
    private static final byte[] ZERO;
    private static final byte[] ONE;
    private static final byte[] TWO;
    private static Configuration conf;
    private static User USER_OWNER;
    private static User USER_OTHER;
    private static User USER_OTHER2;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TestCellACLWithMultipleVersions.enableSecurity(conf);
        TestCellACLWithMultipleVersions.verifyConfiguration(conf);
        conf.setBoolean("hbase.security.access.early_out", false);
        TEST_UTIL.startMiniCluster();
        MasterCoprocessorHost cpHost = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterCoprocessorHost();
        cpHost.load(AccessController.class, 0, conf);
        AccessController ac = (AccessController)cpHost.findCoprocessor(AccessController.class.getName());
        cpHost.createEnvironment(AccessController.class, (Coprocessor)ac, 0, 1, conf);
        RegionServerCoprocessorHost rsHost = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getRegionServerCoprocessorHost();
        rsHost.createEnvironment(AccessController.class, (Coprocessor)ac, 0, 1, conf);
        TEST_UTIL.waitTableEnabled(AccessControlLists.ACL_TABLE_NAME);
        USER_OWNER = User.createUserForTesting((Configuration)conf, (String)"owner", (String[])new String[0]);
        USER_OTHER = User.createUserForTesting((Configuration)conf, (String)"other", (String[])new String[0]);
        USER_OTHER2 = User.createUserForTesting((Configuration)conf, (String)"other2", (String[])new String[0]);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(this.TEST_TABLE.getTableName());
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY1);
        hcd.setMaxVersions(4);
        htd.setOwner(USER_OWNER);
        htd.addFamily(hcd);
        hcd = new HColumnDescriptor(TEST_FAMILY2);
        hcd.setMaxVersions(4);
        htd.setOwner(USER_OWNER);
        htd.addFamily(hcd);
        try (Connection connection = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
             Admin admin = connection.getAdmin();){
            admin.createTable(htd, (byte[][])new byte[][]{Bytes.toBytes((String)"s")});
        }
        TEST_UTIL.waitTableEnabled(this.TEST_TABLE.getTableName());
        LOG.info((Object)"Sleeping a second because of HBASE-12581");
        Threads.sleep((long)1000L);
    }

    @Test
    public void testCellPermissionwithVersions() throws Exception {
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                try (HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    Put p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.WRITE}));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ}));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.WRITE}));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ}));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.WRITE}));
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        SecureTestUtil.AccessTestAction getQ1 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Get get = new Get(TEST_ROW);
                get.setMaxVersions(10);
                try (HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    List list = t.get(get).listCells();
                    return list;
                }
            }
        };
        SecureTestUtil.AccessTestAction get2 = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Get get = new Get(TEST_ROW);
                get.setMaxVersions(10);
                try (HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    List list = t.get(get).listCells();
                    return list;
                }
            }
        };
        TestCellACLWithMultipleVersions.verifyAllowed(USER_OTHER, getQ1, 2);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                try (HTable t = new HTable(conf, TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    Put p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.WRITE}));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ}));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.WRITE}));
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        TestCellACLWithMultipleVersions.verifyAllowed(USER_OTHER, get2, 1);
    }

    @Test
    public void testCellPermissionsWithDeleteMutipleVersions() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] TEST_ROW2 = Bytes.toBytes((String)"r2");
        final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
        final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, ZERO);
                    p.setACL(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                    p = new Put(TEST_ROW2);
                    p.add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, ZERO);
                    p.setACL(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, ZERO);
                    HashMap<String, Permission> perms = new HashMap<String, Permission>();
                    perms.put(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    perms.put(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    p.setACL(perms);
                    t.put(p);
                    p = new Put(TEST_ROW2);
                    p.add(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, ZERO);
                    p.setACL(perms);
                    t.put(p);
                }
                return null;
            }
        }, user1);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    Delete d = new Delete(TEST_ROW1);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q1);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q2);
                    t.delete(d);
                }
                return null;
            }
        });
        user2.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
                    try (Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                        Delete d = new Delete(TEST_ROW2);
                        d.deleteColumns(TEST_FAMILY1, TEST_Q1);
                        d.deleteColumns(TEST_FAMILY1, TEST_Q2);
                        t.delete(d);
                        Assert.fail((String)"user2 should not be allowed to delete the row");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    Delete d = new Delete(TEST_ROW2);
                    d.deleteFamily(TEST_FAMILY1);
                    t.delete(d);
                }
                return null;
            }
        });
    }

    @Test
    public void testDeleteWithFutureTimestamp() throws Exception {
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    Put p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q2, ONE);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                    LOG.info((Object)"Stored at current time");
                    p = new Put(TEST_ROW).add(TEST_FAMILY1, TEST_Q1, EnvironmentEdgeManager.currentTime() + 1000000L, ZERO);
                    p.setACL(USER_OTHER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ}));
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        SecureTestUtil.AccessTestAction getQ1 = new SecureTestUtil.AccessTestAction(){

            /*
             * Exception decompiling
             */
            @Override
            public Object run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        SecureTestUtil.AccessTestAction getQ2 = new SecureTestUtil.AccessTestAction(){

            /*
             * Exception decompiling
             */
            @Override
            public Object run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        TestCellACLWithMultipleVersions.verifyAllowed(getQ1, USER_OWNER, USER_OTHER);
        TestCellACLWithMultipleVersions.verifyAllowed(getQ2, USER_OWNER, USER_OTHER);
        SecureTestUtil.AccessTestAction deleteFamily = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Delete delete = new Delete(TEST_ROW).deleteFamily(TEST_FAMILY1);
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    t.delete(delete);
                }
                return null;
            }
        };
        TestCellACLWithMultipleVersions.verifyAllowed(deleteFamily, USER_OTHER);
        TestCellACLWithMultipleVersions.verifyAllowed(getQ1, USER_OWNER, USER_OTHER);
        TestCellACLWithMultipleVersions.verifyDenied(getQ2, USER_OTHER);
    }

    @Test
    public void testCellPermissionsWithDeleteWithUserTs() throws Exception {
        USER_OWNER.runAs((PrivilegedExceptionAction)new SecureTestUtil.AccessTestAction(){

            /*
             * Exception decompiling
             */
            @Override
            public Object run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        USER_OTHER2.runAs((PrivilegedExceptionAction)new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    Delete d = new Delete(TEST_ROW, 124L);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q1);
                    t.delete(d);
                }
                return null;
            }
        });
        USER_OTHER2.runAs((PrivilegedExceptionAction)new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    Delete d = new Delete(TEST_ROW);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q2, 124L);
                    t.delete(d);
                }
                return null;
            }
        });
    }

    @Test
    public void testCellPermissionsWithDeleteExactVersion() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
        final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    HashMap<String, Permission> permsU1andOwner = new HashMap<String, Permission>();
                    permsU1andOwner.put(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU1andOwner.put(USER_OWNER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    HashMap<String, Permission> permsU2andOwner = new HashMap<String, Permission>();
                    permsU2andOwner.put(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU2andOwner.put(USER_OWNER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 123L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 123L, ZERO);
                    p.setACL(permsU2andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY2, TEST_Q1, 123L, ZERO);
                    p.add(TEST_FAMILY2, TEST_Q2, 123L, ZERO);
                    p.setACL(permsU2andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY2, TEST_Q1, 125L, ZERO);
                    p.add(TEST_FAMILY2, TEST_Q2, 125L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 127L, ZERO);
                    p.setACL(permsU2andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 127L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY2, TEST_Q1, 129L, ZERO);
                    p.add(TEST_FAMILY2, TEST_Q2, 129L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    Delete d = new Delete(TEST_ROW1);
                    d.deleteColumn(TEST_FAMILY1, TEST_Q1, 123L);
                    d.deleteColumn(TEST_FAMILY1, TEST_Q2);
                    d.deleteFamilyVersion(TEST_FAMILY2, 125L);
                    t.delete(d);
                }
                return null;
            }
        });
        user2.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
                    try (Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                        Delete d = new Delete(TEST_ROW1, 127L);
                        d.deleteColumns(TEST_FAMILY1, TEST_Q1);
                        d.deleteColumns(TEST_FAMILY1, TEST_Q2);
                        d.deleteFamily(TEST_FAMILY2, 129L);
                        t.delete(d);
                        Assert.fail((String)"user2 can not do the delete");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
    }

    @Test
    public void testCellPermissionsForIncrementWithMultipleVersions() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
        final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    HashMap<String, Permission> permsU1andOwner = new HashMap<String, Permission>();
                    permsU1andOwner.put(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU1andOwner.put(USER_OWNER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    HashMap<String, Permission> permsU2andOwner = new HashMap<String, Permission>();
                    permsU2andOwner.put(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU2andOwner.put(USER_OWNER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 123L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 123L, ZERO);
                    p.setACL(permsU2andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 127L, ZERO);
                    p.setACL(permsU2andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 127L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    Increment inc = new Increment(TEST_ROW1);
                    inc.setTimeRange(0L, 123L);
                    inc.addColumn(TEST_FAMILY1, TEST_Q1, 2L);
                    t.increment(inc);
                    t.incrementColumnValue(TEST_ROW1, TEST_FAMILY1, TEST_Q2, 1L);
                }
                return null;
            }
        });
        user2.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
                    try (Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                        Increment inc = new Increment(TEST_ROW1);
                        inc.setTimeRange(0L, 127L);
                        inc.addColumn(TEST_FAMILY1, TEST_Q2, 2L);
                        t.increment(inc);
                        Assert.fail();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
    }

    @Test
    public void testCellPermissionsForPutWithMultipleVersions() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
        final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    HashMap<String, Permission> permsU1andOwner = new HashMap<String, Permission>();
                    permsU1andOwner.put(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU1andOwner.put(USER_OWNER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    HashMap<String, Permission> permsU2andOwner = new HashMap<String, Permission>();
                    permsU2andOwner.put(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU2andOwner.put(USER_OWNER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 123L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 123L, ZERO);
                    p.setACL(permsU2andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 127L, ZERO);
                    p.setACL(permsU2andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 127L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 125L, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, ZERO);
                    p.setACL(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                }
                return null;
            }
        });
        user2.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
                    try (Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                        Put p = new Put(TEST_ROW1);
                        p.add(TEST_FAMILY1, TEST_Q1, 124L, ZERO);
                        p.add(TEST_FAMILY1, TEST_Q2, ZERO);
                        t.put(p);
                        Assert.fail();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
    }

    @Test
    public void testCellPermissionsForCheckAndDelete() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    HashMap<String, Permission> permsU1andOwner = new HashMap<String, Permission>();
                    permsU1andOwner.put(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU1andOwner.put(USER_OWNER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    HashMap<String, Permission> permsU1andU2andOwner = new HashMap<String, Permission>();
                    permsU1andU2andOwner.put(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU1andU2andOwner.put(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU1andU2andOwner.put(USER_OWNER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    HashMap<String, Permission> permsU1andU2 = new HashMap<String, Permission>();
                    permsU1andU2.put(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU1andU2.put(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    Put p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 120L, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, 120L, ZERO);
                    p.setACL(permsU1andU2andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 123L, ZERO);
                    p.add(TEST_FAMILY1, TEST_Q2, 123L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q1, 127L, ZERO);
                    p.setACL(permsU1andU2);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.add(TEST_FAMILY1, TEST_Q2, 127L, ZERO);
                    p.setACL(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ}));
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    Delete d = new Delete(TEST_ROW1);
                    d.deleteColumns(TEST_FAMILY1, TEST_Q1, 120L);
                    t.checkAndDelete(TEST_ROW1, TEST_FAMILY1, TEST_Q1, ZERO, d);
                }
                return null;
            }
        });
        user2.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
                    try (Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                        Delete d = new Delete(TEST_ROW1);
                        d.deleteColumns(TEST_FAMILY1, TEST_Q1);
                        t.checkAndDelete(TEST_ROW1, TEST_FAMILY1, TEST_Q1, ZERO, d);
                        Assert.fail((String)"user2 should not be allowed to do checkAndDelete");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
        user2.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.TEST_TABLE.getTableName());){
                    Delete d = new Delete(TEST_ROW1);
                    d.deleteColumn(TEST_FAMILY1, TEST_Q2, 120L);
                    t.checkAndDelete(TEST_ROW1, TEST_FAMILY1, TEST_Q2, ZERO, d);
                }
                return null;
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        try {
            TEST_UTIL.deleteTable(this.TEST_TABLE.getTableName());
        }
        catch (TableNotFoundException ex) {
            LOG.info((Object)("Test deleted table " + this.TEST_TABLE.getTableName()));
        }
        Assert.assertEquals((long)0L, (long)AccessControlLists.getTablePermissions((Configuration)conf, (TableName)this.TEST_TABLE.getTableName()).size());
    }

    static /* synthetic */ User access$900() {
        return USER_OTHER2;
    }

    static /* synthetic */ byte[] access$1000() {
        return TWO;
    }

    static {
        Logger.getLogger(AccessController.class).setLevel(Level.TRACE);
        Logger.getLogger(AccessControlFilter.class).setLevel(Level.TRACE);
        Logger.getLogger(TableAuthManager.class).setLevel(Level.TRACE);
        TEST_UTIL = new HBaseTestingUtility();
        TEST_FAMILY1 = Bytes.toBytes((String)"f1");
        TEST_FAMILY2 = Bytes.toBytes((String)"f2");
        TEST_ROW = Bytes.toBytes((String)"cellpermtest");
        TEST_Q1 = Bytes.toBytes((String)"q1");
        TEST_Q2 = Bytes.toBytes((String)"q2");
        ZERO = Bytes.toBytes((long)0L);
        ONE = Bytes.toBytes((long)1L);
        TWO = Bytes.toBytes((long)2L);
    }
}

