/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.TagUsage;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSeekTo
extends HBaseTestCase {
    static boolean switchKVs = false;

    static KeyValue toKV(String row, TagUsage tagUsage) {
        if (tagUsage == TagUsage.NO_TAG) {
            return new KeyValue(Bytes.toBytes((String)row), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qualifier"), Bytes.toBytes((String)"value"));
        }
        if (tagUsage == TagUsage.ONLY_TAG) {
            Tag t = new Tag(1, "myTag1");
            Tag[] tags = new Tag[]{t};
            return new KeyValue(Bytes.toBytes((String)row), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qualifier"), Long.MAX_VALUE, Bytes.toBytes((String)"value"), tags);
        }
        if (!switchKVs) {
            switchKVs = true;
            return new KeyValue(Bytes.toBytes((String)row), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qualifier"), Bytes.toBytes((String)"value"));
        }
        switchKVs = false;
        Tag t = new Tag(1, "myTag1");
        Tag[] tags = new Tag[]{t};
        return new KeyValue(Bytes.toBytes((String)row), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qualifier"), Long.MAX_VALUE, Bytes.toBytes((String)"value"), tags);
    }

    static String toRowStr(Cell kv) {
        return Bytes.toString((byte[])KeyValueUtil.ensureKeyValue((Cell)kv).getRow());
    }

    Path makeNewFile(TagUsage tagUsage) throws IOException {
        Path ncTFile = new Path(testDir, "basic.hfile");
        if (tagUsage != TagUsage.NO_TAG) {
            this.conf.setInt("hfile.format.version", 3);
        } else {
            this.conf.setInt("hfile.format.version", 2);
        }
        FSDataOutputStream fout = this.fs.create(ncTFile);
        int blocksize = TestSeekTo.toKV("a", tagUsage).getLength() * 3;
        HFileContext context = new HFileContextBuilder().withBlockSize(blocksize).withIncludesTags(true).build();
        HFile.Writer writer = HFile.getWriterFactoryNoCache((Configuration)this.conf).withOutputStream(fout).withFileContext(context).withComparator(KeyValue.COMPARATOR).create();
        writer.append((Cell)TestSeekTo.toKV("c", tagUsage));
        writer.append((Cell)TestSeekTo.toKV("e", tagUsage));
        writer.append((Cell)TestSeekTo.toKV("g", tagUsage));
        writer.append((Cell)TestSeekTo.toKV("i", tagUsage));
        writer.append((Cell)TestSeekTo.toKV("k", tagUsage));
        writer.close();
        fout.close();
        return ncTFile;
    }

    public void testSeekBefore() throws Exception {
        this.testSeekBeforeInternals(TagUsage.NO_TAG);
        this.testSeekBeforeInternals(TagUsage.ONLY_TAG);
        this.testSeekBeforeInternals(TagUsage.PARTIAL_TAG);
    }

    protected void testSeekBeforeInternals(TagUsage tagUsage) throws IOException {
        Path p = this.makeNewFile(tagUsage);
        HFile.Reader reader = HFile.createReader((FileSystem)this.fs, (Path)p, (CacheConfig)new CacheConfig(this.conf), (Configuration)this.conf);
        reader.loadFileInfo();
        HFileScanner scanner = reader.getScanner(false, true);
        TestSeekTo.assertEquals((boolean)false, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("a", tagUsage)));
        TestSeekTo.assertEquals((boolean)false, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("c", tagUsage)));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("d", tagUsage)));
        TestSeekTo.assertEquals((String)"c", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("e", tagUsage)));
        TestSeekTo.assertEquals((String)"c", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("f", tagUsage)));
        TestSeekTo.assertEquals((String)"e", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("g", tagUsage)));
        TestSeekTo.assertEquals((String)"e", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("h", tagUsage)));
        TestSeekTo.assertEquals((String)"g", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("i", tagUsage)));
        TestSeekTo.assertEquals((String)"g", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("j", tagUsage)));
        TestSeekTo.assertEquals((String)"i", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("k", tagUsage)));
        TestSeekTo.assertEquals((String)"i", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("l", tagUsage)));
        TestSeekTo.assertEquals((String)"k", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        reader.close();
    }

    public void testSeekBeforeWithReSeekTo() throws Exception {
        this.testSeekBeforeWithReSeekToInternals(TagUsage.NO_TAG);
        this.testSeekBeforeWithReSeekToInternals(TagUsage.ONLY_TAG);
        this.testSeekBeforeWithReSeekToInternals(TagUsage.PARTIAL_TAG);
    }

    protected void testSeekBeforeWithReSeekToInternals(TagUsage tagUsage) throws IOException {
        Path p = this.makeNewFile(tagUsage);
        HFile.Reader reader = HFile.createReader((FileSystem)this.fs, (Path)p, (CacheConfig)new CacheConfig(this.conf), (Configuration)this.conf);
        reader.loadFileInfo();
        HFileScanner scanner = reader.getScanner(false, true);
        TestSeekTo.assertEquals((boolean)false, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("a", tagUsage)));
        TestSeekTo.assertEquals((boolean)false, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("b", tagUsage)));
        TestSeekTo.assertEquals((boolean)false, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("c", tagUsage)));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("d", tagUsage)));
        TestSeekTo.assertEquals((String)"c", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((int)0, (int)scanner.reseekTo((Cell)TestSeekTo.toKV("c", tagUsage)));
        TestSeekTo.assertEquals((String)"c", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((int)0, (int)scanner.reseekTo((Cell)TestSeekTo.toKV("g", tagUsage)));
        TestSeekTo.assertEquals((String)"g", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("e", tagUsage)));
        TestSeekTo.assertEquals((String)"c", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((int)0, (int)scanner.reseekTo((Cell)TestSeekTo.toKV("e", tagUsage)));
        TestSeekTo.assertEquals((String)"e", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((int)0, (int)scanner.reseekTo((Cell)TestSeekTo.toKV("g", tagUsage)));
        TestSeekTo.assertEquals((String)"g", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("f", tagUsage)));
        TestSeekTo.assertEquals((String)"e", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((int)0, (int)scanner.reseekTo((Cell)TestSeekTo.toKV("e", tagUsage)));
        TestSeekTo.assertEquals((String)"e", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((int)0, (int)scanner.reseekTo((Cell)TestSeekTo.toKV("g", tagUsage)));
        TestSeekTo.assertEquals((String)"g", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("g", tagUsage)));
        TestSeekTo.assertEquals((String)"e", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((int)0, (int)scanner.reseekTo((Cell)TestSeekTo.toKV("e", tagUsage)));
        TestSeekTo.assertEquals((String)"e", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((int)0, (int)scanner.reseekTo((Cell)TestSeekTo.toKV("g", tagUsage)));
        TestSeekTo.assertEquals((String)"g", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("h", tagUsage)));
        TestSeekTo.assertEquals((String)"g", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((int)0, (int)scanner.reseekTo((Cell)TestSeekTo.toKV("g", tagUsage)));
        TestSeekTo.assertEquals((String)"g", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("i", tagUsage)));
        TestSeekTo.assertEquals((String)"g", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((int)0, (int)scanner.reseekTo((Cell)TestSeekTo.toKV("g", tagUsage)));
        TestSeekTo.assertEquals((String)"g", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("j", tagUsage)));
        TestSeekTo.assertEquals((String)"i", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((int)0, (int)scanner.reseekTo((Cell)TestSeekTo.toKV("i", tagUsage)));
        TestSeekTo.assertEquals((String)"i", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("k", tagUsage)));
        TestSeekTo.assertEquals((String)"i", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((int)0, (int)scanner.reseekTo((Cell)TestSeekTo.toKV("i", tagUsage)));
        TestSeekTo.assertEquals((String)"i", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((int)0, (int)scanner.reseekTo((Cell)TestSeekTo.toKV("k", tagUsage)));
        TestSeekTo.assertEquals((String)"k", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore((Cell)TestSeekTo.toKV("l", tagUsage)));
        TestSeekTo.assertEquals((String)"k", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((int)0, (int)scanner.reseekTo((Cell)TestSeekTo.toKV("k", tagUsage)));
        TestSeekTo.assertEquals((String)"k", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
    }

    public void testSeekTo() throws Exception {
        this.testSeekToInternals(TagUsage.NO_TAG);
        this.testSeekToInternals(TagUsage.ONLY_TAG);
        this.testSeekToInternals(TagUsage.PARTIAL_TAG);
    }

    protected void testSeekToInternals(TagUsage tagUsage) throws IOException {
        Path p = this.makeNewFile(tagUsage);
        HFile.Reader reader = HFile.createReader((FileSystem)this.fs, (Path)p, (CacheConfig)new CacheConfig(this.conf), (Configuration)this.conf);
        reader.loadFileInfo();
        TestSeekTo.assertEquals((int)2, (int)reader.getDataBlockIndexReader().getRootBlockCount());
        HFileScanner scanner = reader.getScanner(false, true);
        TestSeekTo.assertEquals((int)-1, (int)scanner.seekTo((Cell)TestSeekTo.toKV("a", tagUsage)));
        TestSeekTo.assertEquals((int)1, (int)scanner.seekTo((Cell)TestSeekTo.toKV("d", tagUsage)));
        TestSeekTo.assertEquals((String)"c", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((int)0, (int)scanner.seekTo((Cell)TestSeekTo.toKV("i", tagUsage)));
        TestSeekTo.assertEquals((String)"i", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((int)1, (int)scanner.seekTo((Cell)TestSeekTo.toKV("l", tagUsage)));
        TestSeekTo.assertEquals((String)"k", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        reader.close();
    }

    public void testBlockContainingKey() throws Exception {
        this.testBlockContainingKeyInternals(TagUsage.NO_TAG);
        this.testBlockContainingKeyInternals(TagUsage.ONLY_TAG);
        this.testBlockContainingKeyInternals(TagUsage.PARTIAL_TAG);
    }

    protected void testBlockContainingKeyInternals(TagUsage tagUsage) throws IOException {
        Path p = this.makeNewFile(tagUsage);
        HFile.Reader reader = HFile.createReader((FileSystem)this.fs, (Path)p, (CacheConfig)new CacheConfig(this.conf), (Configuration)this.conf);
        reader.loadFileInfo();
        HFileBlockIndex.BlockIndexReader blockIndexReader = reader.getDataBlockIndexReader();
        System.out.println(blockIndexReader.toString());
        TestSeekTo.assertEquals((int)-1, (int)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("a", tagUsage)));
        TestSeekTo.assertEquals((int)0, (int)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("c", tagUsage)));
        TestSeekTo.assertEquals((int)0, (int)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("d", tagUsage)));
        TestSeekTo.assertEquals((int)0, (int)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("e", tagUsage)));
        TestSeekTo.assertEquals((int)0, (int)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("g", tagUsage)));
        TestSeekTo.assertEquals((int)1, (int)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("h", tagUsage)));
        TestSeekTo.assertEquals((int)1, (int)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("i", tagUsage)));
        TestSeekTo.assertEquals((int)1, (int)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("j", tagUsage)));
        TestSeekTo.assertEquals((int)1, (int)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("k", tagUsage)));
        TestSeekTo.assertEquals((int)1, (int)blockIndexReader.rootBlockContainingKey((Cell)TestSeekTo.toKV("l", tagUsage)));
        reader.close();
    }
}

