/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestEnableTableHandler {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestEnableTableHandler.class);
    private static final byte[] FAMILYNAME = Bytes.toBytes((String)"fam");

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.balancer.tablesOnMaster", "hbase:meta");
        TEST_UTIL.startMiniCluster(1);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=300000L)
    public void testEnableTableWithNoRegionServers() throws Exception {
        TableName tableName = TableName.valueOf((String)"testEnableTableWithNoRegionServers");
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILYNAME));
        admin.createTable(desc);
        admin.disableTable(tableName);
        TEST_UTIL.waitTableDisabled(tableName.getName());
        admin.enableTable(tableName);
        TEST_UTIL.waitTableEnabled(tableName);
        admin.disableTable(tableName);
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        JVMClusterUtil.RegionServerThread rs = cluster.getRegionServerThreads().get(0);
        rs.getRegionServer().stop("stop");
        cluster.waitForRegionServerToStop(rs.getRegionServer().getServerName(), 10000L);
        TEST_UTIL.waitUntilAllRegionsAssigned(TableName.META_TABLE_NAME);
        admin.enableTable(tableName);
        Assert.assertTrue((boolean)admin.isTableEnabled(tableName));
        JVMClusterUtil.RegionServerThread rs2 = cluster.startRegionServer();
        m.getAssignmentManager().assign(admin.getTableRegions(tableName));
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
        List onlineRegions = admin.getOnlineRegions(rs2.getRegionServer().getServerName());
        Assert.assertEquals((long)2L, (long)onlineRegions.size());
        Assert.assertEquals((Object)tableName, (Object)((HRegionInfo)onlineRegions.get(1)).getTable());
    }

    @Test(timeout=300000L)
    public void testDisableTableAndRestart() throws Exception {
        TableName tableName = TableName.valueOf((String)"testDisableTableAndRestart");
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILYNAME));
        admin.createTable(desc);
        admin.disableTable(tableName);
        TEST_UTIL.waitTableDisabled(tableName.getName());
        TEST_UTIL.getHBaseCluster().shutdown();
        TEST_UTIL.getHBaseCluster().waitUntilShutDown();
        TEST_UTIL.restartHBaseCluster(2);
        admin.enableTable(tableName);
        TEST_UTIL.waitTableEnabled(tableName);
    }

    @Test(timeout=60000L)
    public void testDeleteForSureClearsAllTableRowsFromMeta() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)"testDeleteForSureClearsAllTableRowsFromMeta");
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(FAMILYNAME));
        admin.createTable(desc, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        Scan metaScannerForMyTable = MetaTableAccessor.getScanForTableName((TableName)tableName);
        try (Table metaTable = TEST_UTIL.getConnection().getTable(TableName.META_TABLE_NAME);){
            try (ResultScanner scanner = metaTable.getScanner(metaScannerForMyTable);){
                Iterator i$ = scanner.iterator();
                if (i$.hasNext()) {
                    Result result = (Result)i$.next();
                    Delete d = new Delete(result.getRow());
                    d.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                    metaTable.delete(d);
                }
            }
            admin.disableTable(tableName);
            TEST_UTIL.waitTableDisabled(tableName.getName());
            admin.deleteTable(tableName);
            int rowCount = 0;
            try (ResultScanner scanner = metaTable.getScanner(metaScannerForMyTable);){
                for (Result result : scanner) {
                    ++rowCount;
                }
            }
            Assert.assertEquals((long)0L, (long)rowCount);
        }
    }
}

