/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import com.google.common.collect.Lists;
import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.BlockingService;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.TestDelayedRpc;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestDelayedRpcProtos;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestSecureRPC {
    public static RpcServerInterface rpcServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRpcCallWithEnabledKerberosSaslAuth() throws Exception {
        Assume.assumeTrue((boolean)HBaseKerberosUtils.isKerberosPropertySetted());
        String krbKeytab = HBaseKerberosUtils.getKeytabFileForTesting();
        String krbPrincipal = HBaseKerberosUtils.getPrincipalForTesting();
        Configuration cnf = new Configuration();
        cnf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)cnf);
        UserGroupInformation.loginUserFromKeytab((String)krbPrincipal, (String)krbKeytab);
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        UserGroupInformation ugi2 = UserGroupInformation.getCurrentUser();
        Assert.assertSame((Object)ugi, (Object)ugi2);
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)ugi.getAuthenticationMethod());
        Assert.assertEquals((Object)krbPrincipal, (Object)ugi.getUserName());
        Configuration conf = HBaseKerberosUtils.getSecuredConfiguration();
        SecurityInfo securityInfoMock = (SecurityInfo)Mockito.mock(SecurityInfo.class);
        Mockito.when((Object)securityInfoMock.getServerPrincipal()).thenReturn((Object)"hbase.regionserver.kerberos.principal");
        SecurityInfo.addInfo((String)"TestDelayedService", (SecurityInfo)securityInfoMock);
        boolean delayReturnValue = false;
        InetSocketAddress isa = new InetSocketAddress("localhost", 0);
        TestDelayedRpc.TestDelayedImplementation instance = new TestDelayedRpc.TestDelayedImplementation(delayReturnValue);
        BlockingService service = TestDelayedRpcProtos.TestDelayedService.newReflectiveBlockingService(instance);
        rpcServer = new RpcServer(null, "testSecuredDelayedRpc", (List)Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(service, null)}), isa, conf, (RpcScheduler)new FifoRpcScheduler(conf, 1));
        rpcServer.start();
        try (RpcClient rpcClient = RpcClientFactory.createClient((Configuration)conf, (String)HConstants.DEFAULT_CLUSTER_ID.toString());){
            BlockingRpcChannel channel = rpcClient.createBlockingRpcChannel(ServerName.valueOf((String)rpcServer.getListenerAddress().getHostName(), (int)rpcServer.getListenerAddress().getPort(), (long)System.currentTimeMillis()), User.getCurrent(), 1000);
            TestDelayedRpcProtos.TestDelayedService.BlockingInterface stub = TestDelayedRpcProtos.TestDelayedService.newBlockingStub(channel);
            ArrayList<Integer> results = new ArrayList<Integer>();
            TestDelayedRpc.TestThread th1 = new TestDelayedRpc.TestThread(stub, true, results);
            th1.start();
            Thread.sleep(100L);
            th1.join();
            Assert.assertEquals((long)-559038737L, (long)((Integer)results.get(0)).intValue());
        }
    }
}

