/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.collect.Multimap;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.hfile.TestHFile;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.regionserver.TestEndToEndSplitTransaction;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.HBaseFsckRepair;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.hbck.HFileCorruptionChecker;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestHBaseFsck {
    static final int POOL_SIZE = 7;
    static final Log LOG = LogFactory.getLog(TestHBaseFsck.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Configuration conf = TEST_UTIL.getConfiguration();
    private static final String FAM_STR = "fam";
    private static final byte[] FAM = Bytes.toBytes((String)"fam");
    private static final int REGION_ONLINE_TIMEOUT = 800;
    private static RegionStates regionStates;
    private static ExecutorService tableExecutorService;
    private static ScheduledThreadPoolExecutor hbfsckExecutorService;
    private static ClusterConnection connection;
    private static Admin admin;
    private HTable tbl;
    private static final byte[][] SPLITS;
    private static final byte[][] ROWKEYS;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf.setInt("hbase.regionserver.handler.count", 2);
        conf.setInt("hbase.regionserver.metahandler.count", 2);
        conf.setInt("hbase.htable.threads.max", 7);
        conf.setInt("hbase.hconnection.threads.max", 14);
        conf.setInt("hbase.hconnection.threads.core", 7);
        conf.setInt("hbase.hbck.close.timeout", 1600);
        TEST_UTIL.startMiniCluster(3);
        tableExecutorService = new ThreadPoolExecutor(1, 7, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Threads.newDaemonThreadFactory((String)"testhbck"));
        hbfsckExecutorService = new ScheduledThreadPoolExecutor(7);
        AssignmentManager assignmentManager = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager();
        regionStates = assignmentManager.getRegionStates();
        connection = (ClusterConnection)TEST_UTIL.getConnection();
        admin = connection.getAdmin();
        admin.setBalancerRunning(false, true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        tableExecutorService.shutdown();
        hbfsckExecutorService.shutdown();
        admin.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() {
        EnvironmentEdgeManager.reset();
    }

    @Test(timeout=180000L)
    public void testHBaseFsck() throws Exception {
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        TableName table = TableName.valueOf((String)"tableBadMetaAssign");
        TEST_UTIL.createTable(table, FAM);
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        HTableInterface meta = connection.getTable(TableName.META_TABLE_NAME, tableExecutorService);
        Scan scan = new Scan();
        scan.setStartRow(Bytes.toBytes((String)(table + ",,")));
        ResultScanner scanner = meta.getScanner(scan);
        HRegionInfo hri = null;
        Result res = scanner.next();
        ServerName currServer = ServerName.parseFrom((byte[])res.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER));
        long startCode = Bytes.toLong((byte[])res.getValue(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER));
        for (JVMClusterUtil.RegionServerThread rs : TEST_UTIL.getHBaseCluster().getRegionServerThreads()) {
            ServerName sn = rs.getRegionServer().getServerName();
            if (currServer.getHostAndPort().equals(sn.getHostAndPort()) && startCode == sn.getStartcode()) continue;
            Put put = new Put(res.getRow());
            put.setDurability(Durability.SKIP_WAL);
            put.add(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)sn.getHostAndPort()));
            put.add(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes((long)sn.getStartcode()));
            meta.put(put);
            hri = MetaTableAccessor.getHRegionInfo((Result)res);
            break;
        }
        HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(conf, true), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.SERVER_DOES_NOT_MATCH_META});
        TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hri);
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        HTableInterface t = connection.getTable(table, tableExecutorService);
        ResultScanner s = t.getScanner(new Scan());
        s.close();
        t.close();
        scanner.close();
        meta.close();
    }

    @Test(timeout=180000L)
    public void testFixAssignmentsWhenMETAinTransition() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        admin.closeRegion(cluster.getServerHoldingMeta(), HRegionInfo.FIRST_META_REGIONINFO);
        regionStates.regionOffline(HRegionInfo.FIRST_META_REGIONINFO);
        new MetaTableLocator().deleteMetaLocation(cluster.getMaster().getZooKeeper());
        Assert.assertFalse((boolean)regionStates.isRegionOnline(HRegionInfo.FIRST_META_REGIONINFO));
        HBaseFsck hbck = HbckTestingUtil.doFsck(conf, true);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.UNKNOWN, HBaseFsck.ErrorReporter.ERROR_CODE.NO_META_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.NULL_META_REGION});
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
    }

    private HRegionInfo createRegion(HTableDescriptor htd, byte[] startKey, byte[] endKey) throws IOException {
        HTableInterface meta = connection.getTable(TableName.META_TABLE_NAME, tableExecutorService);
        HRegionInfo hri = new HRegionInfo(htd.getTableName(), startKey, endKey);
        MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri);
        meta.close();
        return hri;
    }

    private void dumpMeta(TableName tableName) throws IOException {
        List<byte[]> metaRows = TEST_UTIL.getMetaTableRows(tableName);
        for (byte[] row : metaRows) {
            LOG.info((Object)Bytes.toString((byte[])row));
        }
    }

    private void undeployRegion(Connection conn, ServerName sn, HRegionInfo hri) throws IOException, InterruptedException {
        try {
            HBaseFsckRepair.closeRegionSilentlyAndWait((HConnection)((HConnection)conn), (ServerName)sn, (HRegionInfo)hri);
            if (!hri.isMetaTable()) {
                admin.offline(hri.getRegionName());
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Got exception when attempting to offline region " + Bytes.toString((byte[])hri.getRegionName())), (Throwable)ioe);
        }
    }

    private void deleteRegion(Configuration conf, HTableDescriptor htd, byte[] startKey, byte[] endKey, boolean unassign, boolean metaRow, boolean hdfs) throws IOException, InterruptedException {
        this.deleteRegion(conf, htd, startKey, endKey, unassign, metaRow, hdfs, false);
    }

    private void deleteRegion(Configuration conf, HTableDescriptor htd, byte[] startKey, byte[] endKey, boolean unassign, boolean metaRow, boolean hdfs, boolean regionInfoOnly) throws IOException, InterruptedException {
        LOG.info((Object)"** Before delete:");
        this.dumpMeta(htd.getTableName());
        List locations = this.tbl.getAllRegionLocations();
        for (HRegionLocation location : locations) {
            HRegionInfo hri = location.getRegionInfo();
            ServerName hsa = location.getServerName();
            if (Bytes.compareTo((byte[])hri.getStartKey(), (byte[])startKey) == 0 && Bytes.compareTo((byte[])hri.getEndKey(), (byte[])endKey) == 0) {
                Path p;
                FileSystem fs;
                Path rootDir;
                LOG.info((Object)("RegionName: " + hri.getRegionNameAsString()));
                byte[] deleteRow = hri.getRegionName();
                if (unassign) {
                    LOG.info((Object)("Undeploying region " + hri + " from server " + hsa));
                    this.undeployRegion((Connection)connection, hsa, hri);
                }
                if (regionInfoOnly) {
                    LOG.info((Object)("deleting hdfs .regioninfo data: " + hri.toString() + hsa.toString()));
                    rootDir = FSUtils.getRootDir((Configuration)conf);
                    fs = rootDir.getFileSystem(conf);
                    p = new Path(FSUtils.getTableDir((Path)rootDir, (TableName)htd.getTableName()), hri.getEncodedName());
                    Path hriPath = new Path(p, ".regioninfo");
                    fs.delete(hriPath, true);
                }
                if (hdfs) {
                    LOG.info((Object)("deleting hdfs data: " + hri.toString() + hsa.toString()));
                    rootDir = FSUtils.getRootDir((Configuration)conf);
                    fs = rootDir.getFileSystem(conf);
                    p = new Path(FSUtils.getTableDir((Path)rootDir, (TableName)htd.getTableName()), hri.getEncodedName());
                    HBaseFsck.debugLsr((Configuration)conf, (Path)p);
                    boolean success = fs.delete(p, true);
                    LOG.info((Object)("Deleted " + p + " sucessfully? " + success));
                    HBaseFsck.debugLsr((Configuration)conf, (Path)p);
                }
                if (metaRow) {
                    try (HTableInterface meta = connection.getTable(TableName.META_TABLE_NAME, tableExecutorService);){
                        Delete delete = new Delete(deleteRow);
                        meta.delete(delete);
                    }
                }
            }
            LOG.info((Object)(hri.toString() + hsa.toString()));
        }
        TEST_UTIL.getMetaTableRows(htd.getTableName());
        LOG.info((Object)"*** After delete:");
        this.dumpMeta(htd.getTableName());
    }

    void setupTable(TableName tablename) throws Exception {
        this.setupTableWithRegionReplica(tablename, 1);
    }

    void setupTableWithRegionReplica(TableName tablename, int replicaCount) throws Exception {
        HTableDescriptor desc = new HTableDescriptor(tablename);
        desc.setRegionReplication(replicaCount);
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toString((byte[])FAM));
        desc.addFamily(hcd);
        admin.createTable(desc, SPLITS);
        this.tbl = (HTable)connection.getTable(tablename, tableExecutorService);
        ArrayList<Put> puts = new ArrayList<Put>();
        for (byte[] row : ROWKEYS) {
            Put p = new Put(row);
            p.add(FAM, Bytes.toBytes((String)"val"), row);
            puts.add(p);
        }
        this.tbl.put(puts);
        this.tbl.flushCommits();
    }

    int countRows() throws IOException {
        Scan s = new Scan();
        ResultScanner rs = this.tbl.getScanner(s);
        int i = 0;
        while (rs.next() != null) {
            ++i;
        }
        return i;
    }

    void cleanupTable(TableName tablename) throws IOException {
        if (this.tbl != null) {
            this.tbl.close();
            this.tbl = null;
        }
        connection.clearRegionCache();
        TEST_UTIL.deleteTable(tablename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testHBaseFsckClean() throws Exception {
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        TableName table = TableName.valueOf((String)"tableClean");
        try {
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck);
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck);
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testHbckThreadpooling() throws Exception {
        TableName table = TableName.valueOf((String)"tableDupeStartKey");
        try {
            this.setupTable(table);
            Configuration newconf = new Configuration(conf);
            newconf.setInt("hbasefsck.numthreads", 1);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(newconf, false));
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testHbckFixOrphanTable() throws Exception {
        TableName table = TableName.valueOf((String)"tableInfo");
        FileSystem fs = null;
        Path tableinfo = null;
        try {
            this.setupTable(table);
            Path hbaseTableDir = FSUtils.getTableDir((Path)FSUtils.getRootDir((Configuration)conf), (TableName)table);
            fs = hbaseTableDir.getFileSystem(conf);
            FileStatus status = FSTableDescriptors.getTableInfoPath((FileSystem)fs, (Path)hbaseTableDir);
            tableinfo = status.getPath();
            fs.rename(tableinfo, new Path("/.tableinfo"));
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NO_TABLEINFO_FILE});
            hbck = HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(hbck);
            status = null;
            status = FSTableDescriptors.getTableInfoPath((FileSystem)fs, (Path)hbaseTableDir);
            Assert.assertNotNull((Object)status);
            HTableDescriptor htd = admin.getTableDescriptor(table);
            htd.setValue("NOT_DEFAULT", "true");
            admin.disableTable(table);
            admin.modifyTable(table, htd);
            admin.enableTable(table);
            fs.delete(status.getPath(), true);
            htd = admin.getTableDescriptor(table);
            hbck = HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(hbck);
            status = FSTableDescriptors.getTableInfoPath((FileSystem)fs, (Path)hbaseTableDir);
            Assert.assertNotNull((Object)status);
            htd = admin.getTableDescriptor(table);
            Assert.assertEquals((Object)htd.getValue("NOT_DEFAULT"), (Object)"true");
        }
        catch (Throwable throwable) {
            fs.rename(new Path("/.tableinfo"), tableinfo);
            this.cleanupTable(table);
            throw throwable;
        }
        fs.rename(new Path("/.tableinfo"), tableinfo);
        this.cleanupTable(table);
    }

    @Test(timeout=180000L)
    public void testParallelHbck() throws Exception {
        ExecutorService service = Executors.newFixedThreadPool(2);
        class RunHbck
        implements Callable<HBaseFsck> {
            boolean fail = true;

            RunHbck() {
            }

            @Override
            public HBaseFsck call() {
                try {
                    return HbckTestingUtil.doFsck(conf, false);
                }
                catch (Exception e) {
                    if (e.getMessage().contains("Duplicate hbck")) {
                        this.fail = false;
                    }
                    if (this.fail) {
                        Assert.fail();
                    }
                    return null;
                }
            }
        }
        Future<HBaseFsck> hbck1 = service.submit(new RunHbck());
        Future<HBaseFsck> hbck2 = service.submit(new RunHbck());
        service.shutdown();
        service.awaitTermination(15L, TimeUnit.SECONDS);
        HBaseFsck h1 = hbck1.get();
        HBaseFsck h2 = hbck2.get();
        assert (h1 == null || h2 == null);
        if (h1 != null) assert (h1.getRetCode() >= 0);
        if (h2 != null) assert (h2.getRetCode() >= 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testDupeStartKey() throws Exception {
        TableName table = TableName.valueOf((String)"tableDupeStartKey");
        try {
            this.setupTable(table);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HRegionInfo hriDupe = this.createRegion(this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"A2"));
            TEST_UTIL.getHBaseCluster().getMaster().assignRegion(hriDupe);
            TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hriDupe);
            ServerName server = regionStates.getRegionServerOfRegion(hriDupe);
            TEST_UTIL.assertRegionOnServer(hriDupe, server, 800L);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS});
            Assert.assertEquals((long)2L, (long)hbck.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HbckTestingUtil.doFsck(conf, true);
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck2);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testHbckWithRegionReplica() throws Exception {
        TableName table = TableName.valueOf((String)"tableWithReplica");
        try {
            this.setupTableWithRegionReplica(table, 2);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(table);
        }
    }

    Map<ServerName, List<String>> getDeployedHRIs(HBaseAdmin admin) throws IOException {
        ClusterStatus status = admin.getClusterStatus();
        Collection regionServers = status.getServers();
        HashMap<ServerName, List<String>> mm = new HashMap<ServerName, List<String>>();
        for (ServerName hsi : regionServers) {
            AdminProtos.AdminService.BlockingInterface server = connection.getAdmin(hsi);
            List regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server);
            ArrayList<String> regionNames = new ArrayList<String>();
            for (HRegionInfo hri : regions) {
                regionNames.add(hri.getRegionNameAsString());
            }
            mm.put(hsi, regionNames);
        }
        return mm;
    }

    ServerName findDeployedHSI(Map<ServerName, List<String>> mm, HRegionInfo hri) {
        for (Map.Entry<ServerName, List<String>> e : mm.entrySet()) {
            if (!e.getValue().contains(hri.getRegionNameAsString())) continue;
            return e.getKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testDupeRegion() throws Exception {
        TableName table = TableName.valueOf((String)"tableDupeRegion");
        try {
            this.setupTable(table);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HRegionInfo hriDupe = this.createRegion(this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"));
            TEST_UTIL.getHBaseCluster().getMaster().assignRegion(hriDupe);
            TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hriDupe);
            ServerName server = regionStates.getRegionServerOfRegion(hriDupe);
            TEST_UTIL.assertRegionOnServer(hriDupe, server, 800L);
            while (this.findDeployedHSI(this.getDeployedHRIs((HBaseAdmin)admin), hriDupe) == null) {
                Thread.sleep(250L);
            }
            LOG.debug((Object)"Finished assignment of dupe region");
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS});
            Assert.assertEquals((long)2L, (long)hbck.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HbckTestingUtil.doFsck(conf, true);
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck2);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testDegenerateRegions() throws Exception {
        TableName table = TableName.valueOf((String)"tableDegenerateRegions");
        try {
            this.setupTable(table);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HRegionInfo hriDupe = this.createRegion(this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"B"));
            TEST_UTIL.getHBaseCluster().getMaster().assignRegion(hriDupe);
            TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hriDupe);
            ServerName server = regionStates.getRegionServerOfRegion(hriDupe);
            TEST_UTIL.assertRegionOnServer(hriDupe, server, 800L);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.DEGENERATE_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS});
            Assert.assertEquals((long)2L, (long)hbck.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HbckTestingUtil.doFsck(conf, true);
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck2);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testContainedRegionOverlap() throws Exception {
        TableName table = TableName.valueOf((String)"tableContainedRegionOverlap");
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HRegionInfo hriOverlap = this.createRegion(this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A2"), Bytes.toBytes((String)"B"));
            TEST_UTIL.getHBaseCluster().getMaster().assignRegion(hriOverlap);
            TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hriOverlap);
            ServerName server = regionStates.getRegionServerOfRegion(hriOverlap);
            TEST_UTIL.assertRegionOnServer(hriOverlap, server, 800L);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.OVERLAP_IN_REGION_CHAIN});
            Assert.assertEquals((long)2L, (long)hbck.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HbckTestingUtil.doFsck(conf, true);
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck2);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testSidelineOverlapRegion() throws Exception {
        TableName table = TableName.valueOf((String)"testSidelineOverlapRegion");
        try {
            Object hbi2;
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
            HMaster master = cluster.getMaster();
            HRegionInfo hriOverlap1 = this.createRegion(this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"AB"));
            master.assignRegion(hriOverlap1);
            master.getAssignmentManager().waitForAssignment(hriOverlap1);
            HRegionInfo hriOverlap2 = this.createRegion(this.tbl.getTableDescriptor(), Bytes.toBytes((String)"AB"), Bytes.toBytes((String)"B"));
            master.assignRegion(hriOverlap2);
            master.getAssignmentManager().waitForAssignment(hriOverlap2);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.OVERLAP_IN_REGION_CHAIN});
            Assert.assertEquals((long)3L, (long)hbck.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            Multimap overlapGroups = hbck.getOverlapGroups(table);
            ServerName serverName = null;
            byte[] regionName = null;
            for (Object hbi2 : overlapGroups.values()) {
                if (!"A".equals(Bytes.toString((byte[])hbi2.getStartKey())) || !"B".equals(Bytes.toString((byte[])hbi2.getEndKey()))) continue;
                regionName = hbi2.getRegionName();
                int k = cluster.getServerWith(regionName);
                for (int i = 0; i < 3; ++i) {
                    if (i == k) continue;
                    HRegionServer rs = cluster.getRegionServer(i);
                    serverName = rs.getServerName();
                    break;
                }
                HBaseFsckRepair.closeRegionSilentlyAndWait((HConnection)connection, (ServerName)cluster.getRegionServer(k).getServerName(), (HRegionInfo)hbi2.getHdfsHRI());
                admin.offline(regionName);
                break;
            }
            Assert.assertNotNull(regionName);
            Assert.assertNotNull(serverName);
            HTableInterface meta = connection.getTable(TableName.META_TABLE_NAME, tableExecutorService);
            hbi2 = null;
            try {
                Put put = new Put(regionName);
                put.add(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)serverName.getHostAndPort()));
                meta.put(put);
            }
            catch (Throwable throwable) {
                hbi2 = throwable;
                throw throwable;
            }
            finally {
                if (meta != null) {
                    if (hbi2 != null) {
                        try {
                            meta.close();
                        }
                        catch (Throwable x2) {
                            ((Throwable)hbi2).addSuppressed(x2);
                        }
                    } else {
                        meta.close();
                    }
                }
            }
            HBaseFsck fsck = new HBaseFsck(conf, (ExecutorService)hbfsckExecutorService);
            fsck.connect();
            fsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setFixAssignments(true);
            fsck.setFixMeta(true);
            fsck.setFixHdfsHoles(true);
            fsck.setFixHdfsOverlaps(true);
            fsck.setFixHdfsOrphans(true);
            fsck.setFixVersionFile(true);
            fsck.setSidelineBigOverlaps(true);
            fsck.setMaxMerge(2);
            fsck.onlineHbck();
            fsck.close();
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck2);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(table).size());
            Assert.assertTrue((ROWKEYS.length > this.countRows() ? 1 : 0) != 0);
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testOverlapAndOrphan() throws Exception {
        TableName table = TableName.valueOf((String)"tableOverlapAndOrphan");
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.disableTable(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), true, true, false, true);
            admin.enableTable(table);
            HRegionInfo hriOverlap = this.createRegion(this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A2"), Bytes.toBytes((String)"B"));
            TEST_UTIL.getHBaseCluster().getMaster().assignRegion(hriOverlap);
            TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hriOverlap);
            ServerName server = regionStates.getRegionServerOfRegion(hriOverlap);
            TEST_UTIL.assertRegionOnServer(hriOverlap, server, 800L);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.ORPHAN_HDFS_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            HbckTestingUtil.doFsck(conf, true);
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck2);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testCoveredStartKey() throws Exception {
        TableName table = TableName.valueOf((String)"tableCoveredStartKey");
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HRegionInfo hriOverlap = this.createRegion(this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A2"), Bytes.toBytes((String)"B2"));
            TEST_UTIL.getHBaseCluster().getMaster().assignRegion(hriOverlap);
            TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hriOverlap);
            ServerName server = regionStates.getRegionServerOfRegion(hriOverlap);
            TEST_UTIL.assertRegionOnServer(hriOverlap, server, 800L);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.OVERLAP_IN_REGION_CHAIN, HBaseFsck.ErrorReporter.ERROR_CODE.OVERLAP_IN_REGION_CHAIN});
            Assert.assertEquals((long)3L, (long)hbck.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HbckTestingUtil.doFsck(conf, true);
            HBaseFsck hbck2 = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck2, new HBaseFsck.ErrorReporter.ERROR_CODE[0]);
            Assert.assertEquals((long)0L, (long)hbck2.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testRegionHole() throws Exception {
        TableName table = TableName.valueOf((String)"tableRegionHole");
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.disableTable(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), true, true, true);
            admin.enableTable(table);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)(ROWKEYS.length - 2), (long)this.countRows());
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testHDFSRegioninfoMissing() throws Exception {
        TableName table = TableName.valueOf((String)"tableHDFSRegioninfoMissing");
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.disableTable(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), true, true, false, true);
            admin.enableTable(table);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.ORPHAN_HDFS_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testNotInMetaOrDeployedHole() throws Exception {
        TableName table = TableName.valueOf((String)"tableNotInMetaOrDeployedHole");
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.disableTable(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), true, true, false);
            admin.enableTable(table);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
            HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(conf, true), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testNotInMetaHole() throws Exception {
        TableName table = TableName.valueOf((String)"tableNotInMetaHole");
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.disableTable(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), false, true, false);
            admin.enableTable(table);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
            HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(conf, true), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testNotInHdfs() throws Exception {
        TableName table = TableName.valueOf((String)"tableNotInHdfs");
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.flush(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), false, false, true);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS});
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)(ROWKEYS.length - 2), (long)this.countRows());
        }
        finally {
            this.cleanupTable(table);
        }
    }

    @Test(timeout=180000L)
    public void testNoHdfsTable() throws Exception {
        TableName table = TableName.valueOf((String)"NoHdfsTable");
        this.setupTable(table);
        Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        admin.flush(table);
        this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)""), Bytes.toBytes((String)"A"), false, false, true);
        this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), false, false, true);
        this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), false, false, true);
        this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"C"), Bytes.toBytes((String)""), false, false, true);
        this.deleteTableDir(table);
        HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS});
        Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
        HbckTestingUtil.doFsck(conf, true);
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        Assert.assertFalse((String)("Table " + table + " should have been deleted"), (boolean)admin.tableExists(table));
    }

    public void deleteTableDir(TableName table) throws IOException {
        Path rootDir = FSUtils.getRootDir((Configuration)conf);
        FileSystem fs = rootDir.getFileSystem(conf);
        Path p = FSUtils.getTableDir((Path)rootDir, (TableName)table);
        HBaseFsck.debugLsr((Configuration)conf, (Path)p);
        boolean success = fs.delete(p, true);
        LOG.info((Object)("Deleted " + p + " sucessfully? " + success));
    }

    @Test(timeout=180000L)
    public void testNoVersionFile() throws Exception {
        Path rootDir = FSUtils.getRootDir((Configuration)conf);
        FileSystem fs = rootDir.getFileSystem(conf);
        Path versionFile = new Path(rootDir, "hbase.version");
        fs.delete(versionFile, true);
        HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NO_VERSION_FILE});
        HbckTestingUtil.doFsck(conf, true);
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testRegionShouldNotBeDeployed() throws Exception {
        TableName table = TableName.valueOf((String)"tableRegionShouldNotBeDeployed");
        try {
            LOG.info((Object)"Starting testRegionShouldNotBeDeployed.");
            MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
            Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
            byte[][] SPLIT_KEYS = new byte[][]{new byte[0], Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd")};
            HTableDescriptor htdDisabled = new HTableDescriptor(table);
            htdDisabled.addFamily(new HColumnDescriptor(FAM));
            FSTableDescriptors fstd = new FSTableDescriptors(conf);
            fstd.createTableDescriptor(htdDisabled);
            List<HRegionInfo> disabledRegions = TEST_UTIL.createMultiRegionsInMeta(conf, htdDisabled, SPLIT_KEYS);
            HRegionServer hrs = cluster.getRegionServer(0);
            admin.disableTable(table);
            admin.enableTable(table);
            admin.disableTable(table);
            HRegionInfo region = disabledRegions.remove(0);
            byte[] regionName = region.getRegionName();
            Assert.assertTrue((cluster.getServerWith(regionName) == -1 ? 1 : 0) != 0);
            HRegion r = HRegion.openHRegion((HRegionInfo)region, (HTableDescriptor)htdDisabled, (WAL)hrs.getWAL(region), (Configuration)conf);
            hrs.addToOnlineRegions(r);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.SHOULD_NOT_BE_DEPLOYED});
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        finally {
            admin.enableTable(table);
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testFixByTable() throws Exception {
        TableName table1 = TableName.valueOf((String)"testFixByTable1");
        TableName table2 = TableName.valueOf((String)"testFixByTable2");
        try {
            this.setupTable(table1);
            admin.flush(table1);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), false, false, true);
            this.setupTable(table2);
            admin.flush(table2);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), false, false, true);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS});
            HbckTestingUtil.doFsck(conf, true, table1);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false, table1));
            HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(conf, false, table2), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS});
            HbckTestingUtil.doFsck(conf, true, table2);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)(ROWKEYS.length - 2), (long)this.countRows());
        }
        finally {
            this.cleanupTable(table1);
            this.cleanupTable(table2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testLingeringSplitParent() throws Exception {
        TableName table = TableName.valueOf((String)"testLingeringSplitParent");
        HTableInterface meta = null;
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.flush(table);
            HRegionLocation location = this.tbl.getRegionLocation("B");
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), true, true, false);
            meta = connection.getTable(TableName.META_TABLE_NAME, tableExecutorService);
            HRegionInfo hri = location.getRegionInfo();
            HRegionInfo a = new HRegionInfo(this.tbl.getName(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"BM"));
            HRegionInfo b = new HRegionInfo(this.tbl.getName(), Bytes.toBytes((String)"BM"), Bytes.toBytes((String)"C"));
            hri.setOffline(true);
            hri.setSplit(true);
            MetaTableAccessor.addRegionToMeta((Table)meta, (HRegionInfo)hri, (HRegionInfo)a, (HRegionInfo)b);
            meta.close();
            admin.flush(TableName.META_TABLE_NAME);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.LINGERING_SPLIT_PARENT, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            hbck = HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.LINGERING_SPLIT_PARENT, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            Assert.assertFalse((boolean)hbck.shouldRerun());
            hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.LINGERING_SPLIT_PARENT, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            hbck = new HBaseFsck(conf, (ExecutorService)hbfsckExecutorService);
            hbck.connect();
            hbck.setDisplayFullReport();
            hbck.setTimeLag(0L);
            hbck.setFixSplitParents(true);
            hbck.onlineHbck();
            Assert.assertTrue((boolean)hbck.shouldRerun());
            hbck.close();
            Get get = new Get(hri.getRegionName());
            Result result = meta.get(get);
            Assert.assertTrue((boolean)result.getColumnCells(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER).isEmpty());
            Assert.assertTrue((boolean)result.getColumnCells(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER).isEmpty());
            admin.flush(TableName.META_TABLE_NAME);
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        catch (Throwable throwable) {
            this.cleanupTable(table);
            IOUtils.closeQuietly(meta);
            throw throwable;
        }
        this.cleanupTable(table);
        IOUtils.closeQuietly((Closeable)meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testValidLingeringSplitParent() throws Exception {
        TableName table = TableName.valueOf((String)"testLingeringSplitParent");
        HTableInterface meta = null;
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.flush(table);
            HRegionLocation location = this.tbl.getRegionLocation(Bytes.toBytes((String)"B"));
            meta = connection.getTable(TableName.META_TABLE_NAME, tableExecutorService);
            HRegionInfo hri = location.getRegionInfo();
            byte[] regionName = location.getRegionInfo().getRegionName();
            admin.splitRegion(location.getRegionInfo().getRegionName(), Bytes.toBytes((String)"BM"));
            TestEndToEndSplitTransaction.blockUntilRegionSplit(conf, 60000L, regionName, true);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, true, true, false, false, false, true, true, true, false, false, false, null);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[0]);
            Get get = new Get(hri.getRegionName());
            Result result = meta.get(get);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull((Object)MetaTableAccessor.getHRegionInfo((Result)result));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            Assert.assertEquals((long)this.tbl.getStartKeys().length, (long)(SPLITS.length + 1 + 1));
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        catch (Throwable throwable) {
            this.cleanupTable(table);
            IOUtils.closeQuietly(meta);
            throw throwable;
        }
        this.cleanupTable(table);
        IOUtils.closeQuietly((Closeable)meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=75000L)
    public void testSplitDaughtersNotInMeta() throws Exception {
        TableName table = TableName.valueOf((String)"testSplitdaughtersNotInMeta");
        HTableInterface meta = connection.getTable(TableName.META_TABLE_NAME, tableExecutorService);
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.flush(table);
            HRegionLocation location = this.tbl.getRegionLocation(Bytes.toBytes((String)"B"));
            HRegionInfo hri = location.getRegionInfo();
            byte[] regionName = location.getRegionInfo().getRegionName();
            admin.splitRegion(location.getRegionInfo().getRegionName(), Bytes.toBytes((String)"BM"));
            TestEndToEndSplitTransaction.blockUntilRegionSplit(conf, 60000L, regionName, true);
            PairOfSameType daughters = MetaTableAccessor.getDaughterRegions((Result)meta.get(new Get(regionName)));
            NavigableMap hris = this.tbl.getRegionLocations();
            this.undeployRegion((Connection)connection, (ServerName)hris.get(daughters.getFirst()), (HRegionInfo)daughters.getFirst());
            this.undeployRegion((Connection)connection, (ServerName)hris.get(daughters.getSecond()), (HRegionInfo)daughters.getSecond());
            ArrayList<Delete> deletes = new ArrayList<Delete>();
            deletes.add(new Delete(((HRegionInfo)daughters.getFirst()).getRegionName()));
            deletes.add(new Delete(((HRegionInfo)daughters.getSecond()).getRegionName()));
            meta.delete(deletes);
            RegionStates regionStates = TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
            regionStates.deleteRegion((HRegionInfo)daughters.getFirst());
            regionStates.deleteRegion((HRegionInfo)daughters.getSecond());
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            hbck = HbckTestingUtil.doFsck(conf, true, true, false, false, false, false, false, false, false, false, false, null);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            Get get = new Get(hri.getRegionName());
            Result result = meta.get(get);
            Assert.assertNotNull((Object)result);
            Assert.assertNotNull((Object)MetaTableAccessor.getHRegionInfo((Result)result));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            Assert.assertEquals((long)this.tbl.getStartKeys().length, (long)(SPLITS.length + 1 + 1));
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        finally {
            meta.close();
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testMissingFirstRegion() throws Exception {
        TableName table = TableName.valueOf((String)"testMissingFirstRegion");
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.disableTable(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)""), Bytes.toBytes((String)"A"), true, true, true);
            admin.enableTable(table);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.FIRST_REGION_STARTKEY_NOT_EMPTY});
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testRegionDeployedNotInHdfs() throws Exception {
        TableName table = TableName.valueOf((String)"testSingleRegionDeployedNotInHdfs");
        try {
            this.setupTable(table);
            admin.flush(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"A"), false, false, true);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS});
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testMissingLastRegion() throws Exception {
        TableName table = TableName.valueOf((String)"testMissingLastRegion");
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.disableTable(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"C"), Bytes.toBytes((String)""), true, true, true);
            admin.enableTable(table);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.LAST_REGION_ENDKEY_NOT_EMPTY});
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testFixAssignmentsAndNoHdfsChecking() throws Exception {
        TableName table = TableName.valueOf((String)"testFixAssignmentsAndNoHdfsChecking");
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), true, false, false, false);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            HBaseFsck fsck = new HBaseFsck(conf, (ExecutorService)hbfsckExecutorService);
            fsck.connect();
            fsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setCheckHdfs(false);
            fsck.onlineHbck();
            HbckTestingUtil.assertErrors(fsck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            fsck.close();
            fsck = new HBaseFsck(conf, (ExecutorService)hbfsckExecutorService);
            fsck.connect();
            fsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setCheckHdfs(false);
            fsck.setFixAssignments(true);
            fsck.onlineHbck();
            Assert.assertTrue((boolean)fsck.shouldRerun());
            fsck.onlineHbck();
            HbckTestingUtil.assertNoErrors(fsck);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            fsck.close();
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testFixMetaNotWorkingWithNoHdfsChecking() throws Exception {
        TableName table = TableName.valueOf((String)"testFixMetaNotWorkingWithNoHdfsChecking");
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), false, true, false, false);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            HBaseFsck fsck = new HBaseFsck(conf, (ExecutorService)hbfsckExecutorService);
            fsck.connect();
            fsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setCheckHdfs(false);
            fsck.onlineHbck();
            HbckTestingUtil.assertErrors(fsck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            fsck.close();
            fsck = new HBaseFsck(conf, (ExecutorService)hbfsckExecutorService);
            fsck.connect();
            fsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setCheckHdfs(false);
            fsck.setFixAssignments(true);
            fsck.setFixMeta(true);
            fsck.onlineHbck();
            Assert.assertFalse((boolean)fsck.shouldRerun());
            HbckTestingUtil.assertErrors(fsck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            fsck.close();
            fsck = HbckTestingUtil.doFsck(conf, true);
            Assert.assertTrue((boolean)fsck.shouldRerun());
            fsck = HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(fsck);
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testFixHdfsHolesNotWorkingWithNoHdfsChecking() throws Exception {
        TableName table = TableName.valueOf((String)"testFixHdfsHolesNotWorkingWithNoHdfsChecking");
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.disableTable(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), true, true, false, true);
            admin.enableTable(table);
            HRegionInfo hriOverlap = this.createRegion(this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A2"), Bytes.toBytes((String)"B"));
            TEST_UTIL.getHBaseCluster().getMaster().assignRegion(hriOverlap);
            TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hriOverlap);
            ServerName server = regionStates.getRegionServerOfRegion(hriOverlap);
            TEST_UTIL.assertRegionOnServer(hriOverlap, server, 800L);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.ORPHAN_HDFS_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            HBaseFsck fsck = new HBaseFsck(conf, (ExecutorService)hbfsckExecutorService);
            fsck.connect();
            fsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setCheckHdfs(false);
            fsck.onlineHbck();
            HbckTestingUtil.assertErrors(fsck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            fsck.close();
            fsck = new HBaseFsck(conf, (ExecutorService)hbfsckExecutorService);
            fsck.connect();
            fsck.setDisplayFullReport();
            fsck.setTimeLag(0L);
            fsck.setCheckHdfs(false);
            fsck.setFixHdfsHoles(true);
            fsck.setFixHdfsOverlaps(true);
            fsck.setFixHdfsOrphans(true);
            fsck.onlineHbck();
            Assert.assertFalse((boolean)fsck.shouldRerun());
            HbckTestingUtil.assertErrors(fsck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            fsck.close();
        }
        finally {
            if (admin.isTableDisabled(table)) {
                admin.enableTable(table);
            }
            this.cleanupTable(table);
        }
    }

    /*
     * Unable to fully structure code
     */
    Path getFlushedHFile(FileSystem fs, TableName table) throws IOException {
        tableDir = FSUtils.getTableDir((Path)FSUtils.getRootDir((Configuration)TestHBaseFsck.conf), (TableName)table);
        regionDir = (Path)FSUtils.getRegionDirs((FileSystem)fs, (Path)tableDir).get(0);
        famDir = new Path(regionDir, "fam");
        block0: while (true) {
            if ((hfFss = fs.listStatus(famDir)).length == 0) {
                continue;
            }
            arr$ = hfFss;
            len$ = arr$.length;
            i$ = 0;
            while (true) {
                if (i$ < len$) ** break;
                continue block0;
                hfs = arr$[i$];
                if (!hfs.isDirectory()) {
                    return hfs.getPath();
                }
                ++i$;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testQuarantineCorruptHFile() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.flush(table);
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path hfile = this.getFlushedHFile(fs, table);
            admin.disableTable(table);
            Path corrupt = new Path(hfile.getParent(), "deadbeef");
            TestHFile.truncateFile(fs, hfile, corrupt);
            LOG.info((Object)("Created corrupted file " + corrupt));
            HBaseFsck.debugLsr((Configuration)conf, (Path)FSUtils.getRootDir((Configuration)conf));
            HBaseFsck res = HbckTestingUtil.doHFileQuarantine(conf, table);
            Assert.assertEquals((long)res.getRetCode(), (long)0L);
            HFileCorruptionChecker hfcc = res.getHFilecorruptionChecker();
            Assert.assertEquals((long)hfcc.getHFilesChecked(), (long)5L);
            Assert.assertEquals((long)hfcc.getCorrupted().size(), (long)1L);
            Assert.assertEquals((long)hfcc.getFailures().size(), (long)0L);
            Assert.assertEquals((long)hfcc.getQuarantined().size(), (long)1L);
            Assert.assertEquals((long)hfcc.getMissing().size(), (long)0L);
            admin.enableTable(table);
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQuarantineTest(TableName table, HBaseFsck hbck, int check, int corrupt, int fail, int quar, int missing) throws Exception {
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.flush(table);
            admin.disableTable(table);
            String[] args = new String[]{"-sidelineCorruptHFiles", "-repairHoles", "-ignorePreCheckPermission", table.getNameAsString()};
            HBaseFsck res = hbck.exec((ExecutorService)hbfsckExecutorService, args);
            HFileCorruptionChecker hfcc = res.getHFilecorruptionChecker();
            Assert.assertEquals((long)hfcc.getHFilesChecked(), (long)check);
            Assert.assertEquals((long)hfcc.getCorrupted().size(), (long)corrupt);
            Assert.assertEquals((long)hfcc.getFailures().size(), (long)fail);
            Assert.assertEquals((long)hfcc.getQuarantined().size(), (long)quar);
            Assert.assertEquals((long)hfcc.getMissing().size(), (long)missing);
            admin.enableTableAsync(table);
            while (!admin.isTableEnabled(table)) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Assert.fail((String)("Interrupted when trying to enable table " + table));
                }
            }
        }
        finally {
            this.cleanupTable(table);
        }
    }

    @Test(timeout=180000L)
    public void testQuarantineMissingHFile() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        final FileSystem fs = FileSystem.get((Configuration)conf);
        HBaseFsck hbck = new HBaseFsck(conf, hbfsckExecutorService){

            public HFileCorruptionChecker createHFileCorruptionChecker(boolean sidelineCorruptHFiles) throws IOException {
                return new HFileCorruptionChecker(conf, this.executor, sidelineCorruptHFiles){
                    AtomicBoolean attemptedFirstHFile;
                    {
                        this.attemptedFirstHFile = new AtomicBoolean(false);
                    }

                    protected void checkHFile(Path p) throws IOException {
                        if (this.attemptedFirstHFile.compareAndSet(false, true)) {
                            Assert.assertTrue((boolean)fs.delete(p, true));
                        }
                        super.checkHFile(p);
                    }
                };
            }
        };
        this.doQuarantineTest(table, hbck, 4, 0, 0, 0, 1);
        hbck.close();
    }

    @Ignore
    @Test(timeout=180000L)
    public void testQuarantineMissingFamdir() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        final FileSystem fs = FileSystem.get((Configuration)conf);
        HBaseFsck hbck = new HBaseFsck(conf, hbfsckExecutorService){

            public HFileCorruptionChecker createHFileCorruptionChecker(boolean sidelineCorruptHFiles) throws IOException {
                return new HFileCorruptionChecker(conf, this.executor, sidelineCorruptHFiles){
                    AtomicBoolean attemptedFirstHFile;
                    {
                        this.attemptedFirstHFile = new AtomicBoolean(false);
                    }

                    protected void checkColFamDir(Path p) throws IOException {
                        if (this.attemptedFirstHFile.compareAndSet(false, true)) {
                            Assert.assertTrue((boolean)fs.delete(p, true));
                        }
                        super.checkColFamDir(p);
                    }
                };
            }
        };
        this.doQuarantineTest(table, hbck, 3, 0, 0, 0, 1);
        hbck.close();
    }

    @Test(timeout=180000L)
    public void testQuarantineMissingRegionDir() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        final FileSystem fs = FileSystem.get((Configuration)conf);
        HBaseFsck hbck = new HBaseFsck(conf, hbfsckExecutorService){

            public HFileCorruptionChecker createHFileCorruptionChecker(boolean sidelineCorruptHFiles) throws IOException {
                return new HFileCorruptionChecker(conf, this.executor, sidelineCorruptHFiles){
                    AtomicBoolean attemptedFirstHFile;
                    {
                        this.attemptedFirstHFile = new AtomicBoolean(false);
                    }

                    protected void checkRegionDir(Path p) throws IOException {
                        if (this.attemptedFirstHFile.compareAndSet(false, true)) {
                            Assert.assertTrue((boolean)fs.delete(p, true));
                        }
                        super.checkRegionDir(p);
                    }
                };
            }
        };
        this.doQuarantineTest(table, hbck, 3, 0, 0, 0, 1);
        hbck.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testLingeringReferenceFile() throws Exception {
        TableName table = TableName.valueOf((String)"testLingeringReferenceFile");
        try {
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path tableDir = FSUtils.getTableDir((Path)FSUtils.getRootDir((Configuration)conf), (TableName)table);
            Path regionDir = (Path)FSUtils.getRegionDirs((FileSystem)fs, (Path)tableDir).get(0);
            Path famDir = new Path(regionDir, FAM_STR);
            Path fakeReferenceFile = new Path(famDir, "fbce357483ceea.12144538");
            fs.create(fakeReferenceFile);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.LINGERING_REFERENCE_HFILE});
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testMissingRegionInfoQualifier() throws Exception {
        Connection connection = ConnectionFactory.createConnection((Configuration)conf);
        TableName table = TableName.valueOf((String)"testMissingRegionInfoQualifier");
        try {
            this.setupTable(table);
            final LinkedList deletes = new LinkedList();
            Table meta = connection.getTable(TableName.META_TABLE_NAME, (ExecutorService)hbfsckExecutorService);
            MetaScanner.metaScan((Connection)connection, (MetaScanner.MetaScannerVisitor)new MetaScanner.MetaScannerVisitor(){

                public boolean processRow(Result rowResult) throws IOException {
                    HRegionInfo hri = MetaTableAccessor.getHRegionInfo((Result)rowResult);
                    if (hri != null && !hri.getTable().isSystemTable()) {
                        Delete delete = new Delete(rowResult.getRow());
                        delete.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                        deletes.add(delete);
                    }
                    return true;
                }

                public void close() throws IOException {
                }
            });
            meta.delete(deletes);
            meta.put(new Put(Bytes.toBytes((String)(table + ",,1361911384013.810e28f59a57da91c66"))).add(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)"node1:60020")));
            meta.put(new Put(Bytes.toBytes((String)(table + ",,1361911384013.810e28f59a57da91c66"))).add(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes((long)1362150791183L)));
            meta.close();
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            Assert.assertTrue((boolean)hbck.getErrors().getErrorList().contains(HBaseFsck.ErrorReporter.ERROR_CODE.EMPTY_META_CELL));
            hbck = HbckTestingUtil.doFsck(conf, true);
            Assert.assertFalse((boolean)hbck.getErrors().getErrorList().contains(HBaseFsck.ErrorReporter.ERROR_CODE.EMPTY_META_CELL));
        }
        finally {
            this.cleanupTable(table);
        }
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testErrorReporter() throws Exception {
        try {
            MockErrorReporter.calledCount = 0;
            HbckTestingUtil.doFsck(conf, false);
            Assert.assertEquals((long)MockErrorReporter.calledCount, (long)0L);
            conf.set("hbasefsck.errorreporter", MockErrorReporter.class.getName());
            HbckTestingUtil.doFsck(conf, false);
            Assert.assertTrue((MockErrorReporter.calledCount > 20 ? 1 : 0) != 0);
        }
        finally {
            conf.set("hbasefsck.errorreporter", HBaseFsck.PrintingErrorReporter.class.getName());
            MockErrorReporter.calledCount = 0;
        }
    }

    @Test(timeout=180000L)
    public void testCheckTableLocks() throws Exception {
        IncrementingEnvironmentEdge edge = new IncrementingEnvironmentEdge(0L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
        HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertNoErrors(hbck);
        ServerName mockName = ServerName.valueOf((String)"localhost", (int)60000, (long)1L);
        final TableLockManager tableLockManager = TableLockManager.createTableLockManager((Configuration)conf, (ZooKeeperWatcher)TEST_UTIL.getZooKeeperWatcher(), (ServerName)mockName);
        TableLockManager.TableLock writeLock = tableLockManager.writeLock(TableName.valueOf((String)"foo"), "testCheckTableLocks");
        writeLock.acquire();
        hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertNoErrors(hbck);
        edge.incrementTime(conf.getLong("hbase.table.lock.expire.ms", 600000L));
        hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.EXPIRED_TABLE_LOCK});
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                TableLockManager.TableLock readLock = tableLockManager.writeLock(TableName.valueOf((String)"foo"), "testCheckTableLocks");
                try {
                    latch.countDown();
                    readLock.acquire();
                }
                catch (IOException ex) {
                    Assert.fail();
                }
                catch (IllegalStateException ex) {
                    return;
                }
                Assert.fail((String)"should not have come here");
            }
        }.start();
        latch.await();
        Threads.sleep((long)300L);
        hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.EXPIRED_TABLE_LOCK});
        edge.incrementTime(conf.getLong("hbase.table.lock.expire.ms", 600000L));
        hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.EXPIRED_TABLE_LOCK, HBaseFsck.ErrorReporter.ERROR_CODE.EXPIRED_TABLE_LOCK});
        conf.setLong("hbase.table.lock.expire.ms", 1L);
        Threads.sleep((long)10L);
        hbck = HbckTestingUtil.doFsck(conf, true);
        hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertNoErrors(hbck);
        writeLock = tableLockManager.writeLock(TableName.valueOf((String)"foo"), "should acquire without blocking");
        writeLock.acquire();
        writeLock.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrphanedTableZNode() throws Exception {
        TableName table = TableName.valueOf((String)"testOrphanedZKTableEntry");
        try {
            TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getTableStateManager().setTableState(table, ZooKeeperProtos.Table.State.ENABLING);
            try {
                this.setupTable(table);
                Assert.fail((String)"Create table should fail when its ZNode has already existed with ENABLING state.");
            }
            catch (TableExistsException t) {
                // empty catch block
            }
            try {
                this.cleanupTable(table);
            }
            catch (IOException e) {
                // empty catch block
            }
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            Assert.assertTrue((boolean)hbck.getErrors().getErrorList().contains(HBaseFsck.ErrorReporter.ERROR_CODE.ORPHANED_ZK_TABLE_ENTRY));
            hbck = HbckTestingUtil.doFsck(conf, true);
            hbck = HbckTestingUtil.doFsck(conf, false);
            Assert.assertFalse((boolean)hbck.getErrors().getErrorList().contains(HBaseFsck.ErrorReporter.ERROR_CODE.ORPHANED_ZK_TABLE_ENTRY));
            this.setupTable(table);
        }
        finally {
            try {
                this.cleanupTable(table);
            }
            catch (IOException iOException) {}
        }
    }

    @Test(timeout=180000L)
    public void testMetaOffline() throws Exception {
        HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertNoErrors(hbck);
        this.deleteMetaRegion(conf, true, false, false);
        hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NO_META_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.UNKNOWN});
        hbck = HbckTestingUtil.doFsck(conf, true);
        HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NO_META_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.UNKNOWN});
        hbck = HbckTestingUtil.doFsck(conf, false);
        HbckTestingUtil.assertNoErrors(hbck);
    }

    private void deleteMetaRegion(Configuration conf, boolean unassign, boolean hdfs, boolean regionInfoOnly) throws IOException, InterruptedException {
        Path p;
        FileSystem fs;
        Path rootDir;
        HRegionLocation metaLocation = connection.getRegionLocator(TableName.META_TABLE_NAME).getRegionLocation(HConstants.EMPTY_START_ROW);
        ServerName hsa = metaLocation.getServerName();
        HRegionInfo hri = metaLocation.getRegionInfo();
        if (unassign) {
            LOG.info((Object)("Undeploying meta region " + hri + " from server " + hsa));
            try (Connection unmanagedConnection = ConnectionFactory.createConnection((Configuration)conf);){
                this.undeployRegion(unmanagedConnection, hsa, hri);
            }
        }
        if (regionInfoOnly) {
            LOG.info((Object)("deleting hdfs .regioninfo data: " + hri.toString() + hsa.toString()));
            rootDir = FSUtils.getRootDir((Configuration)conf);
            fs = rootDir.getFileSystem(conf);
            p = new Path(rootDir + "/" + TableName.META_TABLE_NAME.getNameAsString(), hri.getEncodedName());
            Path hriPath = new Path(p, ".regioninfo");
            fs.delete(hriPath, true);
        }
        if (hdfs) {
            LOG.info((Object)("deleting hdfs data: " + hri.toString() + hsa.toString()));
            rootDir = FSUtils.getRootDir((Configuration)conf);
            fs = rootDir.getFileSystem(conf);
            p = new Path(rootDir + "/" + TableName.META_TABLE_NAME.getNameAsString(), hri.getEncodedName());
            HBaseFsck.debugLsr((Configuration)conf, (Path)p);
            boolean success = fs.delete(p, true);
            LOG.info((Object)("Deleted " + p + " sucessfully? " + success));
            HBaseFsck.debugLsr((Configuration)conf, (Path)p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testTableWithNoRegions() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        try {
            HTableDescriptor desc = new HTableDescriptor(table);
            HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toString((byte[])FAM));
            desc.addFamily(hcd);
            admin.createTable(desc);
            this.tbl = (HTable)connection.getTable(table, tableExecutorService);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, false, true);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS});
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        finally {
            this.cleanupTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testHbckAfterRegionMerge() throws Exception {
        TableName table = TableName.valueOf((String)"testMergeRegionFilesInHdfs");
        Closeable meta = null;
        try {
            TEST_UTIL.getHBaseCluster().getMaster().setCatalogJanitorEnabled(false);
            this.setupTable(table);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.flush(table);
            HRegionInfo region1 = this.tbl.getRegionLocation(Bytes.toBytes((String)"A")).getRegionInfo();
            HRegionInfo region2 = this.tbl.getRegionLocation(Bytes.toBytes((String)"B")).getRegionInfo();
            int regionCountBeforeMerge = this.tbl.getRegionLocations().size();
            Assert.assertNotEquals((Object)region1, (Object)region2);
            admin.mergeRegions(region1.getEncodedNameAsBytes(), region2.getEncodedNameAsBytes(), false);
            long timeout = System.currentTimeMillis() + 30000L;
            while (this.tbl.getRegionLocations().size() >= regionCountBeforeMerge) {
                if (System.currentTimeMillis() > timeout) {
                    Assert.fail((String)("Time out waiting on region " + region1.getEncodedName() + " and " + region2.getEncodedName() + " be merged"));
                }
                Thread.sleep(10L);
            }
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck);
        }
        finally {
            TEST_UTIL.getHBaseCluster().getMaster().setCatalogJanitorEnabled(true);
            this.cleanupTable(table);
            IOUtils.closeQuietly(meta);
        }
    }

    @Test(timeout=180000L)
    public void testRegionBoundariesCheck() throws Exception {
        block2: {
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck);
            try {
                hbck.checkRegionBoundaries();
            }
            catch (IllegalArgumentException e) {
                if (!e.getMessage().endsWith("not a valid DFS filename.")) break block2;
                Assert.fail((String)("Table directory path is not valid." + e.getMessage()));
            }
        }
    }

    @Test(timeout=180000L)
    public void testReadOnlyProperty() throws Exception {
        HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
        Assert.assertEquals((String)"shouldIgnorePreCheckPermission", (Object)true, (Object)hbck.shouldIgnorePreCheckPermission());
        hbck = HbckTestingUtil.doFsck(conf, true);
        Assert.assertEquals((String)"shouldIgnorePreCheckPermission", (Object)false, (Object)hbck.shouldIgnorePreCheckPermission());
        hbck = HbckTestingUtil.doFsck(conf, true);
        hbck.setIgnorePreCheckPermission(true);
        Assert.assertEquals((String)"shouldIgnorePreCheckPermission", (Object)true, (Object)hbck.shouldIgnorePreCheckPermission());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testCleanUpDaughtersNotInMetaAfterFailedSplit() throws Exception {
        TableName table = TableName.valueOf((String)"testCleanUpDaughtersNotInMetaAfterFailedSplit");
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        try {
            HTableDescriptor desc = new HTableDescriptor(table);
            desc.addFamily(new HColumnDescriptor(Bytes.toBytes((String)"f")));
            admin.createTable(desc);
            this.tbl = new HTable(cluster.getConfiguration(), desc.getTableName());
            for (int i = 0; i < 5; ++i) {
                Put p1 = new Put(("r" + i).getBytes());
                p1.add(Bytes.toBytes((String)"f"), "q1".getBytes(), "v".getBytes());
                this.tbl.put(p1);
            }
            admin.flush(desc.getTableName());
            List<HRegion> regions = cluster.getRegions(desc.getTableName());
            int serverWith = cluster.getServerWith(regions.get(0).getRegionName());
            HRegionServer regionServer = cluster.getRegionServer(serverWith);
            cluster.getServerWith(regions.get(0).getRegionName());
            SplitTransaction st = new SplitTransaction(regions.get(0), Bytes.toBytes((String)"r3"));
            st.prepare();
            st.stepsBeforePONR((Server)regionServer, (RegionServerServices)regionServer, false);
            AssignmentManager am = cluster.getMaster().getAssignmentManager();
            Map regionsInTransition = am.getRegionStates().getRegionsInTransition();
            for (RegionState state : regionsInTransition.values()) {
                am.regionOffline(state.getRegion());
            }
            ZKAssign.deleteNodeFailSilent((ZooKeeperWatcher)regionServer.getZooKeeper(), (HRegionInfo)regions.get(0).getRegionInfo());
            HashMap<HRegionInfo, ServerName> regionsMap = new HashMap<HRegionInfo, ServerName>();
            regionsMap.put(regions.get(0).getRegionInfo(), regionServer.getServerName());
            am.assign(regionsMap);
            am.waitForAssignment(regions.get(0).getRegionInfo());
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED});
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
            HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(conf, false, true, false, false, false, false, false, false, false, false, false, null), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED});
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)5L, (long)this.countRows());
        }
        finally {
            if (this.tbl != null) {
                this.tbl.close();
                this.tbl = null;
            }
            this.cleanupTable(table);
        }
    }

    static {
        SPLITS = new byte[][]{Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C")};
        ROWKEYS = new byte[][]{Bytes.toBytes((String)"00"), Bytes.toBytes((String)"50"), Bytes.toBytes((String)"A0"), Bytes.toBytes((String)"A5"), Bytes.toBytes((String)"B0"), Bytes.toBytes((String)"B5"), Bytes.toBytes((String)"C0"), Bytes.toBytes((String)"C5")};
    }

    static class MockErrorReporter
    implements HBaseFsck.ErrorReporter {
        static int calledCount = 0;

        MockErrorReporter() {
        }

        public void clear() {
            ++calledCount;
        }

        public void report(String message) {
            ++calledCount;
        }

        public void reportError(String message) {
            ++calledCount;
        }

        public void reportError(HBaseFsck.ErrorReporter.ERROR_CODE errorCode, String message) {
            ++calledCount;
        }

        public void reportError(HBaseFsck.ErrorReporter.ERROR_CODE errorCode, String message, HBaseFsck.TableInfo table) {
            ++calledCount;
        }

        public void reportError(HBaseFsck.ErrorReporter.ERROR_CODE errorCode, String message, HBaseFsck.TableInfo table, HBaseFsck.HbckInfo info) {
            ++calledCount;
        }

        public void reportError(HBaseFsck.ErrorReporter.ERROR_CODE errorCode, String message, HBaseFsck.TableInfo table, HBaseFsck.HbckInfo info1, HBaseFsck.HbckInfo info2) {
            ++calledCount;
        }

        public int summarize() {
            return ++calledCount;
        }

        public void detail(String details) {
            ++calledCount;
        }

        public ArrayList<HBaseFsck.ErrorReporter.ERROR_CODE> getErrorList() {
            ++calledCount;
            return new ArrayList<HBaseFsck.ErrorReporter.ERROR_CODE>();
        }

        public void progress() {
            ++calledCount;
        }

        public void print(String message) {
            ++calledCount;
        }

        public void resetErrors() {
            ++calledCount;
        }

        public boolean tableHasErrors(HBaseFsck.TableInfo table) {
            ++calledCount;
            return false;
        }
    }
}

