/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ipc.FailedServers;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestHBaseClient {
    @Test
    public void testFailedServer() {
        ManualEnvironmentEdge ee = new ManualEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)ee);
        FailedServers fs = new FailedServers(new Configuration());
        Throwable testThrowable = new Throwable();
        Address ia = Address.fromParts((String)"bad", (int)12);
        Address ia2 = Address.fromParts((String)"bad", (int)12);
        Address ia3 = Address.fromParts((String)"badtoo", (int)12);
        Address ia4 = Address.fromParts((String)"badtoo", (int)13);
        Assert.assertFalse((boolean)fs.isFailedServer(ia));
        fs.addToFailedServers(ia, testThrowable);
        Assert.assertTrue((boolean)fs.isFailedServer(ia));
        Assert.assertTrue((boolean)fs.isFailedServer(ia2));
        ee.incValue(1L);
        Assert.assertTrue((boolean)fs.isFailedServer(ia));
        Assert.assertTrue((boolean)fs.isFailedServer(ia2));
        ee.incValue(2001L);
        Assert.assertFalse((boolean)fs.isFailedServer(ia));
        Assert.assertFalse((boolean)fs.isFailedServer(ia2));
        fs.addToFailedServers(ia, testThrowable);
        fs.addToFailedServers(ia3, testThrowable);
        fs.addToFailedServers(ia4, testThrowable);
        Assert.assertTrue((boolean)fs.isFailedServer(ia));
        Assert.assertTrue((boolean)fs.isFailedServer(ia2));
        Assert.assertTrue((boolean)fs.isFailedServer(ia3));
        Assert.assertTrue((boolean)fs.isFailedServer(ia4));
        ee.incValue(2001L);
        Assert.assertFalse((boolean)fs.isFailedServer(ia));
        Assert.assertFalse((boolean)fs.isFailedServer(ia2));
        Assert.assertFalse((boolean)fs.isFailedServer(ia3));
        Assert.assertFalse((boolean)fs.isFailedServer(ia4));
        fs.addToFailedServers(ia3, testThrowable);
        Assert.assertFalse((boolean)fs.isFailedServer(ia4));
    }
}

