/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.normalizer.MergeNormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.SimpleRegionNormalizer;
import org.apache.hadoop.hbase.master.normalizer.SplitNormalizationPlan;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestSimpleRegionNormalizer {
    private static final Log LOG = LogFactory.getLog(TestSimpleRegionNormalizer.class);
    private static SimpleRegionNormalizer normalizer;
    private static Configuration conf;
    private static MasterServices masterServices;
    private static MasterRpcServices masterRpcServices;
    @Rule
    public TestName name = new TestName();

    @Before
    public void before() {
        conf = HBaseConfiguration.create();
    }

    @Test
    public void testNoNormalizationForMetaTable() throws HBaseIOException {
        TableName testTable = TableName.META_TABLE_NAME;
        ArrayList<HRegionInfo> hris = new ArrayList<HRegionInfo>();
        HashMap<byte[], Integer> regionSizes = new HashMap<byte[], Integer>();
        this.setupMocksForNormalizer(regionSizes, hris);
        List plans = normalizer.computePlansForTable(testTable);
        Assert.assertTrue((boolean)plans.isEmpty());
    }

    @Test
    public void testNoNormalizationIfTooFewRegions() throws HBaseIOException {
        TableName testTable = TableName.valueOf((String)this.name.getMethodName());
        List<HRegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(testTable, 2);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 10, 15);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        List plans = normalizer.computePlansForTable(testTable);
        Assert.assertTrue((boolean)plans.isEmpty());
    }

    @Test
    public void testNoNormalizationOnNormalizedCluster() throws HBaseIOException {
        TableName testTable = TableName.valueOf((String)this.name.getMethodName());
        List<HRegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(testTable, 4);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 10, 15, 8, 10);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        List plans = normalizer.computePlansForTable(testTable);
        Assert.assertTrue((boolean)plans.isEmpty());
    }

    @Test
    public void testMergeOfSmallRegions() throws HBaseIOException {
        TableName testTable = TableName.valueOf((String)this.name.getMethodName());
        List<HRegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(testTable, 5);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 15, 5, 5, 15, 16);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        List plans = normalizer.computePlansForTable(testTable);
        NormalizationPlan plan = (NormalizationPlan)plans.get(0);
        Assert.assertTrue((boolean)(plan instanceof MergeNormalizationPlan));
        Assert.assertEquals((Object)regionInfos.get(1), (Object)((MergeNormalizationPlan)plan).getFirstRegion());
        Assert.assertEquals((Object)regionInfos.get(2), (Object)((MergeNormalizationPlan)plan).getSecondRegion());
    }

    @Test
    public void testMergeOfSecondSmallestRegions() throws HBaseIOException {
        TableName testTable = TableName.valueOf((String)this.name.getMethodName());
        List<HRegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(testTable, 6);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 1, 10000, 10000, 10000, 2700, 2700);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        List plans = normalizer.computePlansForTable(testTable);
        NormalizationPlan plan = (NormalizationPlan)plans.get(0);
        Assert.assertTrue((boolean)(plan instanceof MergeNormalizationPlan));
        Assert.assertEquals((Object)regionInfos.get(4), (Object)((MergeNormalizationPlan)plan).getFirstRegion());
        Assert.assertEquals((Object)regionInfos.get(5), (Object)((MergeNormalizationPlan)plan).getSecondRegion());
    }

    @Test
    public void testMergeOfSmallNonAdjacentRegions() throws HBaseIOException {
        TableName testTable = TableName.valueOf((String)this.name.getMethodName());
        List<HRegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(testTable, 5);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 15, 5, 16, 15, 5);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        List plans = normalizer.computePlansForTable(testTable);
        Assert.assertTrue((boolean)plans.isEmpty());
    }

    @Test
    public void testSplitOfLargeRegion() throws HBaseIOException {
        TableName testTable = TableName.valueOf((String)this.name.getMethodName());
        List<HRegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(testTable, 4);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 8, 6, 10, 30);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        List plans = normalizer.computePlansForTable(testTable);
        NormalizationPlan plan = (NormalizationPlan)plans.get(0);
        Assert.assertTrue((boolean)(plan instanceof SplitNormalizationPlan));
        Assert.assertEquals((Object)regionInfos.get(3), (Object)((SplitNormalizationPlan)plan).getRegionInfo());
    }

    @Test
    public void testSplitWithTargetRegionCount() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        List<HRegionInfo> regionInfo = TestSimpleRegionNormalizer.createRegionInfos(tableName, 6);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfo, 20, 40, 60, 80, 100, 120);
        this.setupMocksForNormalizer(regionSizes, regionInfo);
        Mockito.when((Object)masterServices.getTableDescriptors().get((TableName)Matchers.any()).getNormalizerTargetRegionSize()).thenReturn((Object)20L);
        List plans = normalizer.computePlansForTable(tableName);
        Assert.assertEquals((long)4L, (long)plans.size());
        for (NormalizationPlan plan : plans) {
            Assert.assertTrue((boolean)(plan instanceof SplitNormalizationPlan));
        }
        Mockito.when((Object)masterServices.getTableDescriptors().get((TableName)Matchers.any()).getNormalizerTargetRegionSize()).thenReturn((Object)200L);
        plans = normalizer.computePlansForTable(tableName);
        Assert.assertEquals((long)2L, (long)plans.size());
        NormalizationPlan plan = (NormalizationPlan)plans.get(0);
        Assert.assertTrue((boolean)(plan instanceof MergeNormalizationPlan));
        Assert.assertEquals((Object)regionInfo.get(0), (Object)((MergeNormalizationPlan)plan).getFirstRegion());
        Assert.assertEquals((Object)regionInfo.get(1), (Object)((MergeNormalizationPlan)plan).getSecondRegion());
    }

    @Test
    public void testSplitWithTargetRegionSize() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        List<HRegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 4);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 20, 40, 60, 80);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        Mockito.when((Object)masterServices.getTableDescriptors().get((TableName)Matchers.any()).getNormalizerTargetRegionCount()).thenReturn((Object)8);
        List plans = normalizer.computePlansForTable(tableName);
        Assert.assertEquals((long)2L, (long)plans.size());
        for (NormalizationPlan plan : plans) {
            Assert.assertTrue((boolean)(plan instanceof SplitNormalizationPlan));
        }
        Mockito.when((Object)masterServices.getTableDescriptors().get((TableName)Matchers.any()).getNormalizerTargetRegionCount()).thenReturn((Object)3);
        plans = normalizer.computePlansForTable(tableName);
        Assert.assertEquals((long)1L, (long)plans.size());
        NormalizationPlan plan = (NormalizationPlan)plans.get(0);
        Assert.assertTrue((boolean)(plan instanceof MergeNormalizationPlan));
        Assert.assertEquals((Object)regionInfos.get(0), (Object)((MergeNormalizationPlan)plan).getFirstRegion());
        Assert.assertEquals((Object)regionInfos.get(1), (Object)((MergeNormalizationPlan)plan).getSecondRegion());
    }

    @Test
    public void testHonorsSplitEnabled() throws HBaseIOException {
        conf.setBoolean("hbase.normalizer.split.enabled", true);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        List<HRegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 5);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 5, 5, 20, 5, 5);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        List plans = normalizer.computePlansForTable(tableName);
        boolean present = false;
        for (NormalizationPlan plan : plans) {
            if (!(plan instanceof SplitNormalizationPlan)) continue;
            present = true;
            break;
        }
        Assert.assertTrue((boolean)present);
        conf.setBoolean("hbase.normalizer.split.enabled", false);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        plans = normalizer.computePlansForTable(tableName);
        Assert.assertTrue((boolean)plans.isEmpty());
    }

    @Test
    public void testHonorsMergeEnabled() throws HBaseIOException {
        conf.setBoolean("hbase.normalizer.merge.enabled", true);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        List<HRegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 5);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 20, 5, 5, 20, 20);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        List plans = normalizer.computePlansForTable(tableName);
        boolean present = false;
        for (NormalizationPlan plan : plans) {
            if (!(plan instanceof MergeNormalizationPlan)) continue;
            present = true;
            break;
        }
        Assert.assertTrue((boolean)present);
        conf.setBoolean("hbase.normalizer.merge.enabled", false);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        plans = normalizer.computePlansForTable(tableName);
        Assert.assertTrue((boolean)plans.isEmpty());
    }

    @Test
    public void testHonorsMinimumRegionCount() throws HBaseIOException {
        conf.setInt("hbase.normalizer.min.region.count", 1);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        List<HRegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 3);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 1, 1, 10);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        List plans = normalizer.computePlansForTable(tableName);
        boolean splitPlanPresent = false;
        boolean mergePlanPresent = false;
        for (NormalizationPlan plan : plans) {
            if (plan instanceof MergeNormalizationPlan) {
                mergePlanPresent = true;
                break;
            }
            if (!(plan instanceof SplitNormalizationPlan)) continue;
            splitPlanPresent = true;
        }
        Assert.assertTrue((splitPlanPresent && mergePlanPresent ? 1 : 0) != 0);
        SplitNormalizationPlan splitPlan = (SplitNormalizationPlan)plans.get(0);
        Assert.assertEquals((Object)regionInfos.get(2), (Object)splitPlan.getRegionInfo());
        MergeNormalizationPlan mergePlan = (MergeNormalizationPlan)plans.get(1);
        Assert.assertEquals((Object)regionInfos.get(0), (Object)mergePlan.getFirstRegion());
        Assert.assertEquals((Object)regionInfos.get(1), (Object)mergePlan.getSecondRegion());
        conf.setInt("hbase.normalizer.min.region.count", 4);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        plans = normalizer.computePlansForTable(tableName);
        splitPlanPresent = false;
        for (NormalizationPlan plan : plans) {
            if (!(plan instanceof SplitNormalizationPlan)) continue;
            splitPlanPresent = true;
            break;
        }
        Assert.assertTrue((boolean)splitPlanPresent);
        splitPlan = (SplitNormalizationPlan)plans.get(0);
        Assert.assertEquals((Object)regionInfos.get(2), (Object)splitPlan.getRegionInfo());
    }

    @Test
    public void testHonorsMergeMinRegionAge() throws HBaseIOException {
        conf.setInt("hbase.normalizer.merge.min_region_age.days", 7);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        List<HRegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 4);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 1, 1, 10, 10);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        Assert.assertEquals((long)7L, (long)normalizer.getMergeMinRegionAge());
        List plans = normalizer.computePlansForTable(tableName);
        for (NormalizationPlan plan : plans) {
            Assert.assertFalse((boolean)(plan instanceof MergeNormalizationPlan));
        }
        conf.unset("hbase.normalizer.merge.min_region_age.days");
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        Assert.assertEquals((long)3L, (long)normalizer.getMergeMinRegionAge());
        List plans1 = normalizer.computePlansForTable(tableName);
        Assert.assertTrue((!plans1.isEmpty() ? 1 : 0) != 0);
        for (NormalizationPlan plan : plans) {
            Assert.assertTrue((boolean)(plan instanceof MergeNormalizationPlan));
        }
    }

    @Test
    public void testHonorsMergeMinRegionSize() throws HBaseIOException {
        conf.setBoolean("hbase.normalizer.split.enabled", false);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        List<HRegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, 5);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 1, 2, 0, 10, 10);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        Assert.assertFalse((boolean)normalizer.isSplitEnabled());
        Assert.assertEquals((long)1L, (long)normalizer.getMergeMinRegionSizeMb());
        List plans = normalizer.computePlansForTable(tableName);
        for (NormalizationPlan plan : plans) {
            Assert.assertTrue((boolean)(plan instanceof MergeNormalizationPlan));
        }
        Assert.assertEquals((long)plans.size(), (long)1L);
        MergeNormalizationPlan plan = (MergeNormalizationPlan)plans.get(0);
        Assert.assertEquals((Object)regionInfos.get(0), (Object)plan.getFirstRegion());
        Assert.assertEquals((Object)regionInfos.get(1), (Object)plan.getSecondRegion());
        conf.setInt("hbase.normalizer.merge.min_region_size.mb", 3);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        Assert.assertEquals((long)3L, (long)normalizer.getMergeMinRegionSizeMb());
        Assert.assertTrue((boolean)normalizer.computePlansForTable(tableName).isEmpty());
    }

    @Test
    public void testNormalizerCannotMergeNonAdjacentRegions() throws HBaseIOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] keys = new byte[][]{null, Bytes.toBytes((String)"aa"), Bytes.toBytes((String)"aa1!"), Bytes.toBytes((String)"aa1"), Bytes.toBytes((String)"aa2"), null};
        List<HRegionInfo> regionInfos = TestSimpleRegionNormalizer.createRegionInfos(tableName, keys);
        Map<byte[], Integer> regionSizes = TestSimpleRegionNormalizer.createRegionSizesMap(regionInfos, 3, 1, 1, 3, 5);
        this.setupMocksForNormalizer(regionSizes, regionInfos);
        List plans = normalizer.computePlansForTable(tableName);
        Assert.assertTrue((boolean)plans.isEmpty());
    }

    protected void setupMocksForNormalizer(Map<byte[], Integer> regionSizes, List<HRegionInfo> hris) {
        masterServices = (MasterServices)Mockito.mock(MasterServices.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        masterRpcServices = (MasterRpcServices)Mockito.mock(MasterRpcServices.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ServerName sn = ServerName.valueOf((String)"localhost", (int)0, (long)1L);
        Mockito.when((Object)masterServices.getAssignmentManager().getRegionStates().getRegionsOfTable((TableName)Matchers.any(TableName.class))).thenReturn(hris);
        Mockito.when((Object)masterServices.getAssignmentManager().getRegionStates().getRegionServerOfRegion((HRegionInfo)Matchers.any(HRegionInfo.class))).thenReturn((Object)sn);
        Mockito.when((Object)masterServices.getAssignmentManager().getRegionStates().isRegionInState((HRegionInfo)Matchers.any(HRegionInfo.class), new RegionState.State[]{(RegionState.State)Matchers.any(RegionState.State.class)})).thenReturn((Object)true);
        for (Map.Entry<byte[], Integer> region : regionSizes.entrySet()) {
            RegionLoad regionLoad = (RegionLoad)Mockito.mock(RegionLoad.class);
            Mockito.when((Object)regionLoad.getName()).thenReturn((Object)region.getKey());
            Mockito.when((Object)regionLoad.getStorefileSizeMB()).thenReturn((Object)region.getValue());
            Mockito.when(masterServices.getServerManager().getLoad(sn).getRegionsLoad().get(region.getKey())).thenReturn((Object)regionLoad);
        }
        try {
            Mockito.when((Object)masterRpcServices.isSplitOrMergeEnabled((RpcController)Matchers.any(RpcController.class), (MasterProtos.IsSplitOrMergeEnabledRequest)Matchers.any(MasterProtos.IsSplitOrMergeEnabledRequest.class))).thenReturn((Object)MasterProtos.IsSplitOrMergeEnabledResponse.newBuilder().setEnabled(true).build());
        }
        catch (ServiceException se) {
            LOG.debug((Object)"error setting isSplitOrMergeEnabled switch", (Throwable)se);
        }
        normalizer = new SimpleRegionNormalizer();
        normalizer.setMasterServices(masterServices);
        normalizer.setMasterRpcServices(masterRpcServices);
        normalizer.setConf(conf);
    }

    private static List<HRegionInfo> createRegionInfos(TableName tableName, int length) {
        if (length < 1) {
            throw new IllegalStateException("length must be greater than or equal to 1.");
        }
        byte[] startKey = Bytes.toBytes((String)"aaaaa");
        byte[] endKey = Bytes.toBytes((String)"zzzzz");
        if (length == 1) {
            return Collections.singletonList(TestSimpleRegionNormalizer.createRegionInfo(tableName, startKey, endKey));
        }
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(length - 1));
        ArrayList<HRegionInfo> ret = new ArrayList<HRegionInfo>(length);
        for (int i = 0; i < splitKeys.length - 1; ++i) {
            ret.add(TestSimpleRegionNormalizer.createRegionInfo(tableName, splitKeys[i], splitKeys[i + 1]));
        }
        return ret;
    }

    private static HRegionInfo createRegionInfo(TableName tableName, byte[] startKey, byte[] endKey) {
        return new HRegionInfo(tableName, startKey, endKey, false, TestSimpleRegionNormalizer.generateRegionId());
    }

    private static long generateRegionId() {
        Timestamp currentTime = new Timestamp(EnvironmentEdgeManager.currentTime());
        return new Timestamp(currentTime.getTime() - TimeUnit.DAYS.toMillis(4L)).getTime();
    }

    private static List<HRegionInfo> createRegionInfos(TableName tableName, byte[][] splitKeys) {
        ArrayList<HRegionInfo> ret = new ArrayList<HRegionInfo>(splitKeys.length);
        for (int i = 0; i < splitKeys.length - 1; ++i) {
            ret.add(TestSimpleRegionNormalizer.createRegionInfo(tableName, splitKeys[i], splitKeys[i + 1]));
        }
        return ret;
    }

    private static Map<byte[], Integer> createRegionSizesMap(List<HRegionInfo> regionInfos, int ... sizes) {
        if (regionInfos.size() != sizes.length) {
            throw new IllegalStateException("Parameter lengths must match.");
        }
        HashMap<byte[], Integer> ret = new HashMap<byte[], Integer>(regionInfos.size());
        for (int i = 0; i < regionInfos.size(); ++i) {
            ret.put(regionInfos.get(i).getRegionName(), sizes[i]);
        }
        return ret;
    }
}

