/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanFixture;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestStoreScanner
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestStoreScanner.class);
    private static final String CF_STR = "cf";
    static final byte[] CF = Bytes.toBytes((String)"cf");
    static Configuration CONF = HBaseConfiguration.create();
    private ScanInfo scanInfo = new ScanInfo(CONF, CF, 0, Integer.MAX_VALUE, Long.MAX_VALUE, KeepDeletedCells.FALSE, 0L, KeyValue.COMPARATOR);
    private ScanType scanType = ScanType.USER_SCAN;
    private static final byte[] ZERO = new byte[]{48};
    private static final byte[] ZERO_POINT_ZERO = new byte[]{48, 46, 48};
    private static final byte[] ONE = new byte[]{49};
    private static final byte[] TWO = new byte[]{50};
    private static final byte[] TWO_POINT_TWO = new byte[]{50, 46, 50};
    private static final byte[] THREE = new byte[]{51};
    private static final byte[] FOUR = new byte[]{52};
    private static final byte[] FIVE = new byte[]{53};
    private static final byte[] VALUE = new byte[]{118};
    private static final int CELL_GRID_BLOCK2_BOUNDARY = 4;
    private static final int CELL_GRID_BLOCK3_BOUNDARY = 11;
    private static final int CELL_GRID_BLOCK4_BOUNDARY = 15;
    private static final int CELL_GRID_BLOCK5_BOUNDARY = 19;
    private static final KeyValue[] CELL_GRID = new KeyValue[]{new KeyValue(ONE, CF, ONE, 1L, KeyValue.Type.Put, VALUE), new KeyValue(ONE, CF, TWO, 1L, KeyValue.Type.Put, VALUE), new KeyValue(ONE, CF, THREE, 1L, KeyValue.Type.Put, VALUE), new KeyValue(ONE, CF, FOUR, 1L, KeyValue.Type.Put, VALUE), new KeyValue(TWO, CF, ONE, 1L, KeyValue.Type.Put, VALUE), new KeyValue(TWO, CF, TWO, 1L, KeyValue.Type.Put, VALUE), new KeyValue(TWO, CF, THREE, 1L, KeyValue.Type.Put, VALUE), new KeyValue(TWO, CF, FOUR, 1L, KeyValue.Type.Put, VALUE), new KeyValue(TWO_POINT_TWO, CF, ZERO, 1L, KeyValue.Type.Put, VALUE), new KeyValue(TWO_POINT_TWO, CF, ZERO_POINT_ZERO, 1L, KeyValue.Type.Put, VALUE), new KeyValue(TWO_POINT_TWO, CF, FIVE, 1L, KeyValue.Type.Put, VALUE), new KeyValue(THREE, CF, ONE, 1L, KeyValue.Type.Put, VALUE), new KeyValue(THREE, CF, TWO, 1L, KeyValue.Type.Put, VALUE), new KeyValue(THREE, CF, THREE, 1L, KeyValue.Type.Put, VALUE), new KeyValue(THREE, CF, FOUR, 1L, KeyValue.Type.Put, VALUE), new KeyValue(FOUR, CF, ONE, 1L, KeyValue.Type.Put, VALUE), new KeyValue(FOUR, CF, TWO, 1L, KeyValue.Type.Put, VALUE), new KeyValue(FOUR, CF, THREE, 1L, KeyValue.Type.Put, VALUE), new KeyValue(FOUR, CF, FOUR, 1L, KeyValue.Type.Put, VALUE), new KeyValue(FOUR, CF, FIVE, 1L, KeyValue.Type.Put, VALUE), new KeyValue(FIVE, CF, ZERO, 1L, KeyValue.Type.Put, VALUE)};
    private static final int CELL_WITH_VERSIONS_BLOCK2_BOUNDARY = 4;
    private static final KeyValue[] CELL_WITH_VERSIONS = new KeyValue[]{new KeyValue(ONE, CF, ONE, 2L, KeyValue.Type.Put, VALUE), new KeyValue(ONE, CF, ONE, 1L, KeyValue.Type.Put, VALUE), new KeyValue(ONE, CF, TWO, 2L, KeyValue.Type.Put, VALUE), new KeyValue(ONE, CF, TWO, 1L, KeyValue.Type.Put, VALUE), new KeyValue(TWO, CF, ONE, 1L, KeyValue.Type.Put, VALUE), new KeyValue(TWO, CF, TWO, 1L, KeyValue.Type.Put, VALUE)};
    private static final KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"a", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"b", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"c", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"d", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"e", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"f", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"g", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"h", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)"cf", (String)"i", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)"cf", (String)"a", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};

    public void setUp() throws Exception {
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithColumnCountGetFilter() throws Exception {
        Get get = new Get(ONE);
        get.setMaxVersions();
        get.addFamily(CF);
        get.setFilter((Filter)new ColumnCountGetFilter(2));
        try (CellWithVersionsNoOptimizeStoreScanner scannerNoOptimize = new CellWithVersionsNoOptimizeStoreScanner(new Scan(get), this.scanInfo, this.scanType);){
            ArrayList results = new ArrayList();
            while (scannerNoOptimize.next(results)) {
            }
            TestStoreScanner.assertEquals((int)2, (int)results.size());
            TestStoreScanner.assertTrue((boolean)CellUtil.matchingColumn((Cell)((Cell)results.get(0)), (Cell)CELL_WITH_VERSIONS[0]));
            TestStoreScanner.assertTrue((boolean)CellUtil.matchingColumn((Cell)((Cell)results.get(1)), (Cell)CELL_WITH_VERSIONS[2]));
            TestStoreScanner.assertTrue((String)"Optimize should do some optimizations", (scannerNoOptimize.optimization.get() == 0 ? 1 : 0) != 0);
        }
        get.setFilter((Filter)new ColumnCountGetFilter(2));
        try (CellWithVersionsStoreScanner scanner = new CellWithVersionsStoreScanner(new Scan(get), this.scanInfo, this.scanType);){
            ArrayList results = new ArrayList();
            while (scanner.next(results)) {
            }
            TestStoreScanner.assertEquals((int)2, (int)results.size());
            TestStoreScanner.assertTrue((boolean)CellUtil.matchingColumn((Cell)((Cell)results.get(0)), (Cell)CELL_WITH_VERSIONS[0]));
            TestStoreScanner.assertTrue((boolean)CellUtil.matchingColumn((Cell)((Cell)results.get(1)), (Cell)CELL_WITH_VERSIONS[2]));
            TestStoreScanner.assertTrue((String)"Optimize should do some optimizations", (scanner.optimization.get() > 0 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFullRowGetDoesNotOverreadWhenRowInsideOneBlock() throws IOException {
        Get get = new Get(TWO);
        Scan scan = new Scan(get);
        try (CellGridStoreScanner scanner = new CellGridStoreScanner(scan, this.scanInfo, this.scanType);){
            ArrayList results = new ArrayList();
            while (scanner.next(results)) {
            }
            TestStoreScanner.assertEquals((int)4, (int)results.size());
            TestStoreScanner.assertEquals((int)5, (int)scanner.count.get());
            TestStoreScanner.assertEquals((int)0, (int)scanner.optimization.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFullRowSpansBlocks() throws IOException {
        Get get = new Get(FOUR);
        Scan scan = new Scan(get);
        try (CellGridStoreScanner scanner = new CellGridStoreScanner(scan, this.scanInfo, this.scanType);){
            ArrayList results = new ArrayList();
            while (scanner.next(results)) {
            }
            TestStoreScanner.assertEquals((int)5, (int)results.size());
            TestStoreScanner.assertEquals((int)6, (int)scanner.count.get());
            TestStoreScanner.assertEquals((int)0, (int)scanner.optimization.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptimize() throws IOException {
        Scan scan = new Scan();
        scan.addColumn(CF, ONE);
        try (CellGridStoreScanner scanner = new CellGridStoreScanner(scan, this.scanInfo, this.scanType);){
            ArrayList results = new ArrayList();
            while (scanner.next(results)) {
            }
            TestStoreScanner.assertEquals((int)4, (int)results.size());
            for (Cell cell : results) {
                TestStoreScanner.assertTrue((boolean)Bytes.equals((byte[])ONE, (int)0, (int)ONE.length, (byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()));
            }
            TestStoreScanner.assertTrue((String)"Optimize should do some optimizations", (scanner.optimization.get() > 0 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptimizeAndGet() throws IOException {
        Get get = new Get(TWO);
        get.addColumn(CF, TWO);
        get.addColumn(CF, THREE);
        Scan scan = new Scan(get);
        try (CellGridStoreScanner scanner = new CellGridStoreScanner(scan, this.scanInfo, this.scanType);){
            ArrayList results = new ArrayList();
            TestStoreScanner.assertEquals((boolean)false, (boolean)scanner.next(results));
            TestStoreScanner.assertEquals((int)2, (int)results.size());
            TestStoreScanner.assertEquals((String)"First qcode is SEEK_NEXT_COL and second INCLUDE_AND_SEEK_NEXT_ROW", (int)3, (int)scanner.count.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptimizeAndGetWithFakedNextBlockIndexStart() throws IOException {
        Get get = new Get(THREE);
        get.addColumn(CF, TWO);
        Scan scan = new Scan(get);
        try (CellGridStoreScanner scanner = new CellGridStoreScanner(scan, this.scanInfo, this.scanType);){
            ArrayList results = new ArrayList();
            TestStoreScanner.assertEquals((boolean)false, (boolean)scanner.next(results));
            TestStoreScanner.assertEquals((int)1, (int)results.size());
            TestStoreScanner.assertEquals((String)"First qcode is SEEK_NEXT_COL and second INCLUDE_AND_SEEK_NEXT_ROW", (int)2, (int)scanner.count.get());
        }
    }

    NavigableSet<byte[]> getCols(String ... strCols) {
        TreeSet<byte[]> cols = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (String col : strCols) {
            byte[] bytes = Bytes.toBytes((String)col);
            cols.add(bytes);
        }
        return cols;
    }

    public void testScanTimeRange() throws IOException {
        String r1 = "R1";
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)r1, (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)r1, (String)CF_STR, (String)"a", (long)2L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)r1, (String)CF_STR, (String)"a", (long)3L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)r1, (String)CF_STR, (String)"a", (long)4L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)r1, (String)CF_STR, (String)"a", (long)5L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = Arrays.asList(new KeyValueScanner[]{new KeyValueScanFixture(KeyValue.COMPARATOR, kvs)});
        Scan scanSpec = new Scan(Bytes.toBytes((String)r1));
        scanSpec.setTimeRange(0L, 6L);
        scanSpec.setMaxVersions();
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)5, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[kvs.length - 1], results.get(0));
        scanSpec = new Scan(Bytes.toBytes((String)r1));
        scanSpec.setTimeRange(1L, 3L);
        scanSpec.setMaxVersions();
        scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)2, (int)results.size());
        scanSpec = new Scan(Bytes.toBytes((String)r1));
        scanSpec.setTimeRange(5L, 10L);
        scanSpec.setMaxVersions();
        scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        scanSpec = new Scan(Bytes.toBytes((String)r1));
        scanSpec.setTimeRange(0L, 10L);
        scanSpec.setMaxVersions(3);
        scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)3, (int)results.size());
    }

    public void testScanSameTimestamp() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = Arrays.asList(new KeyValueScanner[]{new KeyValueScanFixture(KeyValue.COMPARATOR, kvs)});
        Scan scanSpec = new Scan(Bytes.toBytes((String)"R1"));
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[0], results.get(0));
    }

    public void testWontNextToNext() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)2L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scanSpec = new Scan(Bytes.toBytes((String)"R1"));
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList results = new ArrayList();
        scan.next(results);
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[0], results.get(0));
        results.clear();
        scan.next(results);
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[2], results.get(0));
        results.clear();
        scan.next(results);
        TestStoreScanner.assertEquals((int)0, (int)results.size());
    }

    public void testDeleteVersionSameTimestamp() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scanSpec = new Scan(Bytes.toBytes((String)"R1"));
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertFalse((boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)0, (int)results.size());
    }

    public void testDeletedRowThenGoodRow() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"a", (long)20L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scanSpec = new Scan(Bytes.toBytes((String)"R1"));
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)0, (int)results.size());
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[2], results.get(0));
        TestStoreScanner.assertEquals((boolean)false, (boolean)scan.next(results));
    }

    public void testDeleteVersionMaskingMultiplePuts() throws IOException {
        long now = System.currentTimeMillis();
        KeyValue[] kvs1 = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care")};
        KeyValue[] kvs2 = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 500L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 100L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(kvs1, kvs2);
        StoreScanner scan = new StoreScanner(new Scan(Bytes.toBytes((String)"R1")), this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs2[1], results.get(0));
    }

    public void testDeleteVersionsMixedAndMultipleVersionReturn() throws IOException {
        long now = System.currentTimeMillis();
        KeyValue[] kvs1 = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care")};
        KeyValue[] kvs2 = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 500L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now + 500L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"z", (long)now, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(kvs1, kvs2);
        Scan scanSpec = new Scan(Bytes.toBytes((String)"R1")).setMaxVersions(2);
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)2, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs2[1], results.get(0));
        TestStoreScanner.assertEquals((Object)kvs2[0], results.get(1));
    }

    public void testWildCardOneVersionScan() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)2L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        StoreScanner scan = new StoreScanner(new Scan(Bytes.toBytes((String)"R1")), this.scanInfo, this.scanType, null, scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)2, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[0], results.get(0));
        TestStoreScanner.assertEquals((Object)kvs[1], results.get(1));
    }

    public void testWildCardScannerUnderDeletes() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)2L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)2L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)10L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)10L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)9L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)10L, (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)9L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)8L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        StoreScanner scan = new StoreScanner(new Scan().setMaxVersions(2), this.scanInfo, this.scanType, null, scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)5, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[0], results.get(0));
        TestStoreScanner.assertEquals((Object)kvs[2], results.get(1));
        TestStoreScanner.assertEquals((Object)kvs[3], results.get(2));
        TestStoreScanner.assertEquals((Object)kvs[6], results.get(3));
        TestStoreScanner.assertEquals((Object)kvs[7], results.get(4));
    }

    public void testDeleteFamily() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)100L, (KeyValue.Type)KeyValue.Type.DeleteFamily, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"e", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"e", (long)11L, (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"f", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"g", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"g", (long)11L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"h", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"i", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"a", (long)11L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        StoreScanner scan = new StoreScanner(new Scan().setMaxVersions(Integer.MAX_VALUE), this.scanInfo, this.scanType, null, scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)0, (int)results.size());
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[kvs.length - 1], results.get(0));
        TestStoreScanner.assertEquals((boolean)false, (boolean)scan.next(results));
    }

    public void testDeleteColumn() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)10L, (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)9L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)8L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)5L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        StoreScanner scan = new StoreScanner(new Scan(), this.scanInfo, this.scanType, null, scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[3], results.get(0));
    }

    public void testSkipColumn() throws IOException {
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        StoreScanner scan = new StoreScanner(new Scan(), this.scanInfo, this.scanType, this.getCols("a", "d"), scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)2, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[0], results.get(0));
        TestStoreScanner.assertEquals((Object)kvs[3], results.get(1));
        results.clear();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scan.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[kvs.length - 1], results.get(0));
        results.clear();
        TestStoreScanner.assertEquals((boolean)false, (boolean)scan.next(results));
    }

    public void testWildCardTtlScan() throws IOException {
        long now = System.currentTimeMillis();
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 1000L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)(now - 10L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)(now - 200L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)(now - 10000L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"a", (long)now, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"b", (long)(now - 10L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"c", (long)(now - 200L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R2", (String)CF_STR, (String)"c", (long)(now - 1000L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scan = new Scan();
        scan.setMaxVersions(1);
        ScanInfo scanInfo = new ScanInfo(CONF, CF, 0, 1, 500L, KeepDeletedCells.FALSE, 0L, KeyValue.COMPARATOR);
        ScanType scanType = ScanType.USER_SCAN;
        StoreScanner scanner = new StoreScanner(scan, scanInfo, scanType, null, scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scanner.next(results));
        TestStoreScanner.assertEquals((int)2, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[1], results.get(0));
        TestStoreScanner.assertEquals((Object)kvs[2], results.get(1));
        results.clear();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scanner.next(results));
        TestStoreScanner.assertEquals((int)3, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[4], results.get(0));
        TestStoreScanner.assertEquals((Object)kvs[5], results.get(1));
        TestStoreScanner.assertEquals((Object)kvs[6], results.get(2));
        results.clear();
        TestStoreScanner.assertEquals((boolean)false, (boolean)scanner.next(results));
    }

    public void testScannerReseekDoesntNPE() throws Exception {
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        StoreScanner scan = new StoreScanner(new Scan(), this.scanInfo, this.scanType, this.getCols("a", "d"), scanners);
        scan.updateReaders(Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        scan.updateReaders(Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        scan.peek();
    }

    public void SKIP_testPeek() throws Exception {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)1L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scanSpec = new Scan(Bytes.toBytes((String)"R1"));
        StoreScanner scan = new StoreScanner(scanSpec, this.scanInfo, this.scanType, this.getCols("a"), scanners);
        TestStoreScanner.assertNull((Object)scan.peek());
    }

    public void testExpiredDeleteFamily() throws Exception {
        long now = System.currentTimeMillis();
        KeyValue[] kvs = new KeyValue[]{new KeyValue(Bytes.toBytes((String)"R1"), Bytes.toBytes((String)CF_STR), null, now - 1000L, KeyValue.Type.DeleteFamily), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 10L), (KeyValue.Type)KeyValue.Type.Put, (String)"dont-care")};
        List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
        Scan scan = new Scan();
        scan.setMaxVersions(1);
        ScanInfo scanInfo = new ScanInfo(CONF, CF, 0, 1, 500L, KeepDeletedCells.FALSE, 0L, KeyValue.COMPARATOR);
        ScanType scanType = ScanType.USER_SCAN;
        StoreScanner scanner = new StoreScanner(scan, scanInfo, scanType, null, scanners);
        ArrayList results = new ArrayList();
        TestStoreScanner.assertEquals((boolean)true, (boolean)scanner.next(results));
        TestStoreScanner.assertEquals((int)1, (int)results.size());
        TestStoreScanner.assertEquals((Object)kvs[1], results.get(0));
        results.clear();
        TestStoreScanner.assertEquals((boolean)false, (boolean)scanner.next(results));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteMarkerLongevity() throws Exception {
        try {
            final long now = System.currentTimeMillis();
            EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new EnvironmentEdge(){

                public long currentTime() {
                    return now;
                }
            });
            KeyValue[] kvs = new KeyValue[]{new KeyValue(Bytes.toBytes((String)"R1"), Bytes.toBytes((String)CF_STR), null, now - 100L, KeyValue.Type.DeleteFamily), new KeyValue(Bytes.toBytes((String)"R1"), Bytes.toBytes((String)CF_STR), null, now - 1000L, KeyValue.Type.DeleteFamily), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 50L), (KeyValue.Type)KeyValue.Type.Put, (String)"v3"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 55L), (KeyValue.Type)KeyValue.Type.Delete, (String)"dontcare"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 55L), (KeyValue.Type)KeyValue.Type.Put, (String)"deleted-version v2"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 60L), (KeyValue.Type)KeyValue.Type.Put, (String)"v1"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 65L), (KeyValue.Type)KeyValue.Type.Put, (String)"v0"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"a", (long)(now - 100L), (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)(now - 600L), (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)(now - 70L), (KeyValue.Type)KeyValue.Type.Put, (String)"v2"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"b", (long)(now - 750L), (KeyValue.Type)KeyValue.Type.Put, (String)"v1"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)(now - 500L), (KeyValue.Type)KeyValue.Type.Delete, (String)"dontcare"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)(now - 600L), (KeyValue.Type)KeyValue.Type.Put, (String)"v1"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"c", (long)(now - 1000L), (KeyValue.Type)KeyValue.Type.Delete, (String)"dontcare"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)(now - 60L), (KeyValue.Type)KeyValue.Type.Put, (String)"expired put"), KeyValueTestUtil.create((String)"R1", (String)CF_STR, (String)"d", (long)(now - 100L), (KeyValue.Type)KeyValue.Type.Delete, (String)"not-expired delete")};
            List<KeyValueScanner> scanners = KeyValueScanFixture.scanFixture(new KeyValue[][]{kvs});
            Scan scan = new Scan();
            scan.setMaxVersions(2);
            ScanInfo scanInfo = new ScanInfo(CONF, Bytes.toBytes((String)CF_STR), 0, 2, 500L, KeepDeletedCells.FALSE, 200L, KeyValue.COMPARATOR);
            StoreScanner scanner = new StoreScanner(scan, scanInfo, ScanType.COMPACT_DROP_DELETES, null, scanners, Long.MIN_VALUE);
            ArrayList results = new ArrayList();
            results = new ArrayList();
            TestStoreScanner.assertEquals((boolean)true, (boolean)scanner.next(results));
            TestStoreScanner.assertEquals((Object)kvs[0], results.get(0));
            TestStoreScanner.assertEquals((Object)kvs[2], results.get(1));
            TestStoreScanner.assertEquals((Object)kvs[3], results.get(2));
            TestStoreScanner.assertEquals((Object)kvs[5], results.get(3));
            TestStoreScanner.assertEquals((Object)kvs[9], results.get(4));
            TestStoreScanner.assertEquals((Object)kvs[14], results.get(5));
            TestStoreScanner.assertEquals((Object)kvs[15], results.get(6));
            TestStoreScanner.assertEquals((int)7, (int)results.size());
            scanner.close();
        }
        finally {
            EnvironmentEdgeManagerTestHelper.reset();
        }
    }

    private static class CellWithVersionsNoOptimizeStoreScanner
    extends StoreScanner {
        final AtomicInteger optimization = new AtomicInteger(0);

        CellWithVersionsNoOptimizeStoreScanner(Scan scan, ScanInfo scanInfo, ScanType scanType) throws IOException {
            super(scan, scanInfo, scanType, (NavigableSet)scan.getFamilyMap().get(CF), Arrays.asList(new KeyValueScanner[]{new KeyValueScanFixture(KeyValue.COMPARATOR, CELL_WITH_VERSIONS)}));
        }

        protected boolean trySkipToNextColumn(Cell cell) throws IOException {
            boolean optimized = super.trySkipToNextColumn(cell);
            LOG.info((Object)("Cell=" + cell + ", nextIndex=" + CellUtil.toString((Cell)this.getNextIndexedKey(), (boolean)false) + ", optimized=" + optimized));
            if (optimized) {
                this.optimization.incrementAndGet();
            }
            return optimized;
        }

        public Cell getNextIndexedKey() {
            return null;
        }
    }

    private static class CellWithVersionsStoreScanner
    extends StoreScanner {
        final AtomicInteger optimization = new AtomicInteger(0);

        CellWithVersionsStoreScanner(Scan scan, ScanInfo scanInfo, ScanType scanType) throws IOException {
            super(scan, scanInfo, scanType, (NavigableSet)scan.getFamilyMap().get(CF), Arrays.asList(new KeyValueScanner[]{new KeyValueScanFixture(KeyValue.COMPARATOR, CELL_WITH_VERSIONS)}));
        }

        protected boolean trySkipToNextColumn(Cell cell) throws IOException {
            boolean optimized = super.trySkipToNextColumn(cell);
            LOG.info((Object)("Cell=" + cell + ", nextIndex=" + CellUtil.toString((Cell)this.getNextIndexedKey(), (boolean)false) + ", optimized=" + optimized));
            if (optimized) {
                this.optimization.incrementAndGet();
            }
            return optimized;
        }

        public Cell getNextIndexedKey() {
            return KeyValueUtil.createFirstOnRow((byte[])CELL_WITH_VERSIONS[4].getRow());
        }
    }

    private static class CellGridStoreScanner
    extends StoreScanner {
        AtomicInteger count;
        final AtomicInteger optimization = new AtomicInteger(0);

        CellGridStoreScanner(Scan scan, ScanInfo scanInfo, ScanType scanType) throws IOException {
            super(scan, scanInfo, scanType, (NavigableSet)scan.getFamilyMap().get(CF), Arrays.asList(new KeyValueScanner[]{new KeyValueScanFixture(KeyValue.COMPARATOR, CELL_GRID)}));
        }

        protected void resetKVHeap(List<? extends KeyValueScanner> scanners, KeyValue.KVComparator comparator) throws IOException {
            if (this.count == null) {
                this.count = new AtomicInteger(0);
            }
            this.heap = new KeyValueHeapWithCount(scanners, comparator, this.count);
        }

        protected boolean trySkipToNextRow(Cell cell) throws IOException {
            boolean optimized = super.trySkipToNextRow(cell);
            LOG.info((Object)("Cell=" + cell + ", nextIndex=" + CellUtil.toString((Cell)this.getNextIndexedKey(), (boolean)false) + ", optimized=" + optimized));
            if (optimized) {
                this.optimization.incrementAndGet();
            }
            return optimized;
        }

        protected boolean trySkipToNextColumn(Cell cell) throws IOException {
            boolean optimized = super.trySkipToNextColumn(cell);
            LOG.info((Object)("Cell=" + cell + ", nextIndex=" + CellUtil.toString((Cell)this.getNextIndexedKey(), (boolean)false) + ", optimized=" + optimized));
            if (optimized) {
                this.optimization.incrementAndGet();
            }
            return optimized;
        }

        public Cell getNextIndexedKey() {
            return this.count.get() > 15 ? KeyValueUtil.createFirstOnRow((byte[])CELL_GRID[19].getRow()) : (this.count.get() > 11 ? KeyValueUtil.createFirstOnRow((byte[])CELL_GRID[15].getRow()) : (this.count.get() > 4 ? KeyValueUtil.createFirstOnRow((byte[])CELL_GRID[11].getRow()) : KeyValueUtil.createFirstOnRow((byte[])CELL_GRID[4].getRow())));
        }
    }

    private static class KeyValueHeapWithCount
    extends KeyValueHeap {
        final AtomicInteger count;

        public KeyValueHeapWithCount(List<? extends KeyValueScanner> scanners, KeyValue.KVComparator comparator, AtomicInteger count) throws IOException {
            super(scanners, comparator);
            this.count = count;
        }

        public Cell peek() {
            this.count.incrementAndGet();
            return super.peek();
        }
    }
}

