/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.HTestConst;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestGlobalReplicationThrottler {
    private static final Log LOG = LogFactory.getLog(TestGlobalReplicationThrottler.class);
    private static final int REPLICATION_SOURCE_QUOTA = 200;
    private static int numOfPeer = 0;
    private static Configuration conf1;
    private static Configuration conf2;
    private static HBaseTestingUtility utility1;
    private static HBaseTestingUtility utility2;
    private static final byte[] famName;
    private static final byte[] VALUE;
    private static final byte[] ROW;
    private static final byte[][] ROWS;
    private volatile boolean testQuotaPass = false;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf1 = HBaseConfiguration.create();
        conf1.set("zookeeper.znode.parent", "/1");
        conf1.setLong("replication.source.sleepforretries", 100L);
        conf1.setInt("replication.total.buffer.quota", 200);
        conf1.setLong("replication.source.per.peer.node.bandwidth", 100L);
        utility1 = new HBaseTestingUtility(conf1);
        utility1.startMiniZKCluster();
        MiniZooKeeperCluster miniZK = utility1.getZkCluster();
        new ZooKeeperWatcher(conf1, "cluster1", null, true);
        conf2 = new Configuration(conf1);
        conf2.set("zookeeper.znode.parent", "/2");
        utility2 = new HBaseTestingUtility(conf2);
        utility2.setZkCluster(miniZK);
        new ZooKeeperWatcher(conf2, "cluster2", null, true);
        ReplicationAdmin admin1 = new ReplicationAdmin(conf1);
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey(utility2.getClusterKey());
        admin1.addPeer("peer1", rpc, null);
        admin1.addPeer("peer2", rpc, null);
        admin1.addPeer("peer3", rpc, null);
        numOfPeer = admin1.getPeersCount();
        utility1.startMiniCluster(1, 1);
        utility2.startMiniCluster(1, 1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utility2.shutdownMiniCluster();
        utility1.shutdownMiniCluster();
    }

    @Test
    public void testQuota() throws IOException {
        TableName tableName = TableName.valueOf((String)"testQuota");
        HTableDescriptor table = new HTableDescriptor(tableName);
        HColumnDescriptor fam = new HColumnDescriptor(famName);
        fam.setScope(0);
        table.addFamily(fam);
        utility1.getHBaseAdmin().createTable(table);
        utility2.getHBaseAdmin().createTable(table);
        Thread watcher = new Thread(new Runnable(){

            @Override
            public void run() {
                Replication replication = (Replication)utility1.getMiniHBaseCluster().getRegionServer(0).getReplicationSourceService();
                AtomicLong bufferUsed = replication.getReplicationManager().getTotalBufferUsed();
                TestGlobalReplicationThrottler.this.testQuotaPass = true;
                while (!Thread.interrupted()) {
                    long size = bufferUsed.get();
                    if (size > (long)(200 * (numOfPeer + 1))) {
                        TestGlobalReplicationThrottler.this.testQuotaPass = false;
                    }
                    Threads.sleep((long)50L);
                }
            }
        });
        watcher.start();
        try (Table t1 = utility1.getConnection().getTable(tableName);
             Table t2 = utility2.getConnection().getTable(tableName);){
            for (int i = 0; i < 50; ++i) {
                Put put = new Put(ROWS[i]);
                put.addColumn(famName, VALUE, VALUE);
                t1.put(put);
            }
            long start = EnvironmentEdgeManager.currentTime();
            while (EnvironmentEdgeManager.currentTime() - start < 180000L) {
                Scan scan = new Scan();
                scan.setCaching(50);
                int count = 0;
                try (ResultScanner results = t2.getScanner(scan);){
                    for (Result result : results) {
                        ++count;
                    }
                }
                if (count < 50) {
                    LOG.info((Object)("Waiting all logs pushed to slave. Expected 50 , actual " + count));
                    Threads.sleep((long)200L);
                    continue;
                }
                break;
            }
        }
        watcher.interrupt();
        Assert.assertTrue((boolean)this.testQuotaPass);
    }

    static {
        famName = Bytes.toBytes((String)"f");
        VALUE = Bytes.toBytes((String)"v");
        ROW = Bytes.toBytes((String)"r");
        ROWS = HTestConst.makeNAscii(ROW, 100);
    }
}

