/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.SingletonCoprocessorService;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SecurityTests.class, MediumTests.class})
public class TestAdminOnlyOperations {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    private static User USER_ADMIN;
    private static User USER_NON_ADMIN;
    private static final String GROUP_ADMIN = "admin_group";
    private static User USER_GROUP_ADMIN;

    private static void enableSecurity(Configuration conf) throws IOException {
        conf.set("hadoop.security.authorization", "false");
        conf.set("hadoop.security.authentication", "simple");
        conf.set("hbase.coprocessor.master.classes", AccessController.class.getName() + "," + DummyCpService.class.getName());
        conf.set("hbase.coprocessor.region.classes", AccessController.class.getName());
        conf.set("hbase.coprocessor.regionserver.classes", AccessController.class.getName() + "," + DummyCpService.class.getName());
        conf.set("hbase.security.authorization", "true");
        SecureTestUtil.configureSuperuser(conf);
    }

    @BeforeClass
    public static void setup() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TestAdminOnlyOperations.enableSecurity(conf);
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.waitUntilAllRegionsAssigned(AccessControlLists.ACL_TABLE_NAME);
        USER_ADMIN = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[0]);
        USER_NON_ADMIN = User.createUserForTesting((Configuration)conf, (String)"non_admin", (String[])new String[0]);
        USER_GROUP_ADMIN = User.createUserForTesting((Configuration)conf, (String)"user_group_admin", (String[])new String[]{GROUP_ADMIN});
        SecureTestUtil.grantGlobal(TEST_UTIL, USER_ADMIN.getShortName(), Permission.Action.ADMIN);
        SecureTestUtil.grantGlobal(TEST_UTIL, AuthUtil.toGroupEntry((String)GROUP_ADMIN), Permission.Action.ADMIN);
    }

    private void verifyAllowed(User user, final Action action) throws Exception {
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Admin admin = conn.getAdmin();){
                    action.run(admin);
                }
                catch (IOException e) {
                    Assert.fail((String)e.toString());
                }
                return null;
            }
        });
    }

    private void verifyDenied(User user, final Action action) throws Exception {
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                boolean accessDenied = false;
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                     Admin admin = conn.getAdmin();){
                    action.run(admin);
                }
                catch (AccessDeniedException e) {
                    accessDenied = true;
                }
                Assert.assertTrue((String)"Expected access to be denied", (boolean)accessDenied);
                return null;
            }
        });
    }

    private void verifiedDeniedServiceException(User user, final Action action) throws Exception {
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                boolean accessDenied;
                block26: {
                    accessDenied = false;
                    try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                         Admin admin = conn.getAdmin();){
                        action.run(admin);
                    }
                    catch (ServiceException e) {
                        if (!(e.getCause() instanceof AccessDeniedException)) break block26;
                        accessDenied = true;
                    }
                }
                Assert.assertTrue((String)"Expected access to be denied", (boolean)accessDenied);
                return null;
            }
        });
    }

    private void verifyAdminCheckForAction(Action action) throws Exception {
        this.verifyAllowed(USER_ADMIN, action);
        this.verifyAllowed(USER_GROUP_ADMIN, action);
        this.verifyDenied(USER_NON_ADMIN, action);
    }

    @Test
    public void testEnableCatalogJanitor() throws Exception {
        this.verifyAdminCheckForAction(new Action(){

            @Override
            public void run(Admin admin) throws Exception {
                admin.enableCatalogJanitor(true);
            }
        });
    }

    @Test
    public void testRunCatalogScan() throws Exception {
        this.verifyAdminCheckForAction(new Action(){

            @Override
            public void run(Admin admin) throws Exception {
                admin.runCatalogScan();
            }
        });
    }

    @Test
    public void testRunCleanerChore() throws Exception {
        this.verifyAdminCheckForAction(new Action(){

            @Override
            public void run(Admin admin) throws Exception {
                admin.runCleanerChore();
            }
        });
    }

    @Test
    public void testSetCleanerChoreRunning() throws Exception {
        this.verifyAdminCheckForAction(new Action(){

            @Override
            public void run(Admin admin) throws Exception {
                admin.setCleanerChoreRunning(true);
            }
        });
    }

    @Test
    public void testExecProcedure() throws Exception {
        this.verifyAdminCheckForAction(new Action(){

            @Override
            public void run(Admin admin) throws Exception {
                admin.execProcedure("flush-table-proc", TableName.META_TABLE_NAME.getNameAsString(), new HashMap());
            }
        });
    }

    @Test
    public void testExecService() throws Exception {
        Action action = new Action(){

            @Override
            public void run(Admin admin) throws Exception {
                TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface service = TestRpcServiceProtos.TestProtobufRpcProto.newBlockingStub((BlockingRpcChannel)admin.coprocessorService());
                service.ping(null, TestProtos.EmptyRequestProto.getDefaultInstance());
            }
        };
        this.verifyAllowed(USER_ADMIN, action);
        this.verifyAllowed(USER_GROUP_ADMIN, action);
        this.verifiedDeniedServiceException(USER_NON_ADMIN, action);
    }

    @Test
    public void testExecProcedureWithRet() throws Exception {
        this.verifyAdminCheckForAction(new Action(){

            @Override
            public void run(Admin admin) throws Exception {
                admin.execProcedureWithRet("flush-table-proc", TableName.META_TABLE_NAME.getNameAsString(), new HashMap());
            }
        });
    }

    @Test
    public void testNormalize() throws Exception {
        this.verifyAdminCheckForAction(new Action(){

            @Override
            public void run(Admin admin) throws Exception {
                admin.normalize();
            }
        });
    }

    @Test
    public void testSetNormalizerRunning() throws Exception {
        this.verifyAdminCheckForAction(new Action(){

            @Override
            public void run(Admin admin) throws Exception {
                admin.setNormalizerRunning(true);
            }
        });
    }

    @Test
    public void testExecRegionServerService() throws Exception {
        Action action = new Action(){

            @Override
            public void run(Admin admin) throws Exception {
                ServerName serverName = TEST_UTIL.getHBaseCluster().getRegionServer(0).getServerName();
                TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface service = TestRpcServiceProtos.TestProtobufRpcProto.newBlockingStub((BlockingRpcChannel)admin.coprocessorService(serverName));
                service.ping(null, TestProtos.EmptyRequestProto.getDefaultInstance());
            }
        };
        this.verifyAllowed(USER_ADMIN, action);
        this.verifyAllowed(USER_GROUP_ADMIN, action);
        this.verifiedDeniedServiceException(USER_NON_ADMIN, action);
    }

    static interface Action {
        public void run(Admin var1) throws Exception;
    }

    public static class DummyCpService
    implements Coprocessor,
    CoprocessorService,
    SingletonCoprocessorService {
        public void start(CoprocessorEnvironment env) {
        }

        public void stop(CoprocessorEnvironment env) {
        }

        public Service getService() {
            return (Service)Mockito.mock(TestRpcServiceProtos.TestProtobufRpcProto.class);
        }
    }
}

