/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestWALSplitWithDeletedTableData {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setup() throws Exception {
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testWALSplitWithDeletedTableData() throws Exception {
        byte[][] rks;
        byte[] CFNAME = Bytes.toBytes((String)"f1");
        byte[] QNAME = Bytes.toBytes((String)"q1");
        byte[] VALUE = Bytes.toBytes((String)"v1");
        TableName t1 = TableName.valueOf((String)"t1");
        TableName t2 = TableName.valueOf((String)"t2");
        byte[][] splitRows = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d")};
        HTableDescriptor htd = new HTableDescriptor(t1);
        htd.addFamily(new HColumnDescriptor(CFNAME));
        HTable tab1 = TEST_UTIL.createTable(htd, (byte[][])splitRows);
        HTableDescriptor htd2 = new HTableDescriptor(t2);
        htd2.addFamily(new HColumnDescriptor(CFNAME));
        HTable tab2 = TEST_UTIL.createTable(htd2, (byte[][])splitRows);
        ArrayList<Put> puts = new ArrayList<Put>(4);
        for (byte[] rk : rks = new byte[][]{Bytes.toBytes((String)"ac"), Bytes.toBytes((String)"ba"), Bytes.toBytes((String)"ca"), Bytes.toBytes((String)"dd")}) {
            puts.add(new Put(rk).addColumn(CFNAME, QNAME, VALUE));
        }
        tab1.put(puts);
        tab2.put(puts);
        MiniHBaseCluster cluster = TEST_UTIL.getMiniHBaseCluster();
        TEST_UTIL.deleteTable(t1);
        Path tableDir = CommonFSUtils.getWALTableDir((Configuration)TEST_UTIL.getConfiguration(), (TableName)t1);
        Assert.assertFalse((boolean)TEST_UTIL.getDFSCluster().getFileSystem().exists(tableDir));
        ServerName rs1 = cluster.getRegionServer(1).getServerName();
        cluster.killRegionServer(rs1);
        cluster.waitForRegionServerToStop(rs1, 60000L);
        Assert.assertEquals((long)1L, (long)cluster.hbaseCluster.getLiveRegionServers().size());
        Thread.sleep(1000L);
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        Assert.assertFalse((boolean)TEST_UTIL.getDFSCluster().getFileSystem().exists(tableDir));
        for (byte[] rk : rks) {
            Result result = tab2.get(new Get(rk));
            Assert.assertFalse((boolean)result.isEmpty());
            Cell cell = result.getColumnLatestCell(CFNAME, QNAME);
            Assert.assertNotNull((Object)cell);
            Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)cell, (byte[])VALUE));
        }
    }
}

