/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class AuthFailingZooKeeper
extends ZooKeeper {
    private static final KeeperException.AuthFailedException AUTH_FAILED_EXCEPTION = new KeeperException.AuthFailedException();
    private final AtomicBoolean FAILURE_LATCH = new AtomicBoolean(false);
    private final AtomicBoolean IS_AUTH_FAILED = new AtomicBoolean(false);

    public AuthFailingZooKeeper(String connectString, int sessionTimeout, Watcher watcher) throws IOException {
        super(connectString, sessionTimeout, watcher);
    }

    public void triggerAuthFailed() {
        this.FAILURE_LATCH.set(true);
    }

    void check() throws KeeperException {
        if (this.IS_AUTH_FAILED.get()) {
            throw AUTH_FAILED_EXCEPTION;
        }
        if (!this.FAILURE_LATCH.get()) {
            return;
        }
        this.IS_AUTH_FAILED.set(true);
        throw AUTH_FAILED_EXCEPTION;
    }

    public byte[] getData(String path, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        this.check();
        return super.getData(path, watcher, stat);
    }

    public String create(String path, byte[] data, List<ACL> acl, CreateMode cmode) throws KeeperException, InterruptedException {
        this.check();
        return super.create(path, data, acl, cmode);
    }

    public Stat exists(String path, boolean watch) throws KeeperException, InterruptedException {
        this.check();
        return super.exists(path, watch);
    }

    public Stat exists(String path, Watcher watcher) throws KeeperException, InterruptedException {
        this.check();
        return super.exists(path, watcher);
    }

    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        this.check();
        return super.getChildren(path, watch);
    }
}

